/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

class MacOSXPreferencesFile {
    private static HashMap<String, WeakReference<MacOSXPreferencesFile>> cachedFiles;
    private static HashSet<MacOSXPreferencesFile> changedFiles;
    private static Timer timer;
    private static FlushTask flushTimerTask;
    private static long flushDelay;
    private static long syncInterval;
    private String appName;
    private long user;
    private long host;
    private static long cfCurrentUser;
    private static long cfAnyUser;
    private static long cfCurrentHost;
    private static long cfAnyHost;

    String name() {
        return this.appName;
    }

    long user() {
        return this.user;
    }

    long host() {
        return this.host;
    }

    private MacOSXPreferencesFile(String string, long l, long l2) {
        this.appName = string;
        this.user = l;
        this.host = l2;
    }

    static synchronized MacOSXPreferencesFile getFile(String string, boolean bl) {
        String string2;
        WeakReference<MacOSXPreferencesFile> weakReference;
        MacOSXPreferencesFile macOSXPreferencesFile = null;
        if (cachedFiles == null) {
            cachedFiles = new HashMap();
        }
        if ((weakReference = cachedFiles.get(string2 = string + String.valueOf(bl))) != null) {
            macOSXPreferencesFile = (MacOSXPreferencesFile)weakReference.get();
        }
        if (macOSXPreferencesFile == null) {
            macOSXPreferencesFile = new MacOSXPreferencesFile(string, bl ? cfCurrentUser : cfAnyUser, bl ? cfAnyHost : cfCurrentHost);
            cachedFiles.put(string2, new WeakReference<MacOSXPreferencesFile>(macOSXPreferencesFile));
        }
        MacOSXPreferencesFile.initSyncTimerIfNeeded();
        return macOSXPreferencesFile;
    }

    static synchronized boolean syncWorld() {
        boolean bl = true;
        if (cachedFiles != null && !cachedFiles.isEmpty()) {
            Iterator<WeakReference<MacOSXPreferencesFile>> iterator = cachedFiles.values().iterator();
            while (iterator.hasNext()) {
                WeakReference<MacOSXPreferencesFile> weakReference = iterator.next();
                MacOSXPreferencesFile macOSXPreferencesFile = (MacOSXPreferencesFile)weakReference.get();
                if (macOSXPreferencesFile != null) {
                    if (macOSXPreferencesFile.synchronize()) continue;
                    bl = false;
                    continue;
                }
                iterator.remove();
            }
        }
        if (flushTimerTask != null) {
            flushTimerTask.cancel();
            flushTimerTask = null;
        }
        if (changedFiles != null) {
            changedFiles.clear();
        }
        return bl;
    }

    static synchronized boolean syncUser() {
        Object object;
        Iterator<Object> iterator;
        boolean bl = true;
        if (cachedFiles != null && !cachedFiles.isEmpty()) {
            iterator = cachedFiles.values().iterator();
            while (iterator.hasNext()) {
                object = (WeakReference)iterator.next();
                MacOSXPreferencesFile macOSXPreferencesFile = (MacOSXPreferencesFile)((Reference)object).get();
                if (macOSXPreferencesFile != null && macOSXPreferencesFile.user == cfCurrentUser) {
                    if (macOSXPreferencesFile.synchronize()) continue;
                    bl = false;
                    continue;
                }
                iterator.remove();
            }
        }
        if (changedFiles != null) {
            iterator = changedFiles.iterator();
            while (iterator.hasNext()) {
                object = (MacOSXPreferencesFile)iterator.next();
                if (object == null || ((MacOSXPreferencesFile)object).user != cfCurrentUser) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    static synchronized boolean flushUser() {
        boolean bl = true;
        if (changedFiles != null && !changedFiles.isEmpty()) {
            Iterator<MacOSXPreferencesFile> iterator = changedFiles.iterator();
            while (iterator.hasNext()) {
                MacOSXPreferencesFile macOSXPreferencesFile = iterator.next();
                if (macOSXPreferencesFile.user != cfCurrentUser) continue;
                if (!macOSXPreferencesFile.synchronize()) {
                    bl = false;
                    continue;
                }
                iterator.remove();
            }
        }
        return bl;
    }

    static synchronized boolean flushWorld() {
        boolean bl = true;
        if (changedFiles != null && !changedFiles.isEmpty()) {
            for (MacOSXPreferencesFile macOSXPreferencesFile : changedFiles) {
                if (macOSXPreferencesFile.synchronize()) continue;
                bl = false;
            }
            changedFiles.clear();
        }
        if (flushTimerTask != null) {
            flushTimerTask.cancel();
            flushTimerTask = null;
        }
        return bl;
    }

    private void markChanged() {
        if (changedFiles == null) {
            changedFiles = new HashSet();
        }
        changedFiles.add(this);
        if (flushTimerTask == null) {
            flushTimerTask = new FlushTask();
            MacOSXPreferencesFile.timer().schedule((TimerTask)flushTimerTask, MacOSXPreferencesFile.flushDelay() * 1000L);
        }
    }

    private static synchronized long flushDelay() {
        if (flushDelay == -1L) {
            try {
                flushDelay = Math.max(5, Integer.parseInt(System.getProperty("java.util.prefs.flushDelay", "60")));
            }
            catch (NumberFormatException numberFormatException) {
                flushDelay = 60L;
            }
        }
        return flushDelay;
    }

    private static synchronized void initSyncTimerIfNeeded() {
        if (syncInterval == -1L) {
            try {
                syncInterval = Integer.parseInt(System.getProperty("java.util.prefs.syncInterval", "-2"));
                syncInterval = syncInterval >= 0L ? Math.max(5L, syncInterval) : -2L;
            }
            catch (NumberFormatException numberFormatException) {
                syncInterval = -2L;
            }
            if (syncInterval > 0L) {
                MacOSXPreferencesFile.timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        MacOSXPreferencesFile.syncWorld();
                    }
                }, syncInterval * 1000L, syncInterval * 1000L);
            }
        }
    }

    private static synchronized Timer timer() {
        if (timer == null) {
            timer = new Timer(true);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    MacOSXPreferencesFile.flushWorld();
                }
            };
            thread.setContextClassLoader(null);
            Runtime.getRuntime().addShutdownHook(thread);
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addNode(String string) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return MacOSXPreferencesFile.addNode(string, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNode(String string) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.removeNode(string, this.appName, this.user, this.host);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addChildToNode(String string, String string2) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MacOSXPreferencesFile.addChildToNode(string, string2 + "/", this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildFromNode(String string, String string2) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.removeChildFromNode(string, string2 + "/", this.appName, this.user, this.host);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKeyToNode(String string, String string2, String string3) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.addKeyToNode(string, string2, string3, this.appName, this.user, this.host);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKeyFromNode(String string, String string2) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.removeKeyFromNode(string, string2, this.appName, this.user, this.host);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getKeyFromNode(String string, String string2) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MacOSXPreferencesFile.getKeyFromNode(string, string2, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getChildrenForNode(String string) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return MacOSXPreferencesFile.getChildrenForNode(string, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getKeysForNode(String string) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return MacOSXPreferencesFile.getKeysForNode(string, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean synchronize() {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MacOSXPreferencesFile.synchronize(this.appName, this.user, this.host);
        }
    }

    private static final native boolean addNode(String var0, String var1, long var2, long var4);

    private static final native void removeNode(String var0, String var1, long var2, long var4);

    private static final native boolean addChildToNode(String var0, String var1, String var2, long var3, long var5);

    private static final native void removeChildFromNode(String var0, String var1, String var2, long var3, long var5);

    private static final native void addKeyToNode(String var0, String var1, String var2, String var3, long var4, long var6);

    private static final native void removeKeyFromNode(String var0, String var1, String var2, long var3, long var5);

    private static final native String getKeyFromNode(String var0, String var1, String var2, long var3, long var5);

    private static final native String[] getChildrenForNode(String var0, String var1, long var2, long var4);

    private static final native String[] getKeysForNode(String var0, String var1, long var2, long var4);

    private static final native boolean synchronize(String var0, long var1, long var3);

    private static final native long currentUser();

    private static final native long anyUser();

    private static final native long currentHost();

    private static final native long anyHost();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osx");
                return null;
            }
        });
        timer = null;
        flushTimerTask = null;
        flushDelay = -1L;
        syncInterval = -1L;
        cfCurrentUser = MacOSXPreferencesFile.currentUser();
        cfAnyUser = MacOSXPreferencesFile.anyUser();
        cfCurrentHost = MacOSXPreferencesFile.currentHost();
        cfAnyHost = MacOSXPreferencesFile.anyHost();
    }

    private class SyncTask
    extends TimerTask {
        private SyncTask() {
        }

        @Override
        public void run() {
            MacOSXPreferencesFile.syncWorld();
        }
    }

    private class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            MacOSXPreferencesFile.flushWorld();
        }
    }
}

