/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintWriter;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.internal.tool.EventPrintWriter;

final class JSONWriter
extends EventPrintWriter {
    private boolean first = true;

    public JSONWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    @Override
    protected void printBegin() {
        this.printObjectBegin();
        this.printDataStructureName("recording");
        this.printObjectBegin();
        this.printDataStructureName("events");
        this.printArrayBegin();
    }

    @Override
    protected void print(List<RecordedEvent> list) {
        for (RecordedEvent recordedEvent : list) {
            this.printNewDataStructure(this.first, true, null);
            this.printEvent(recordedEvent);
            this.flush(false);
            this.first = false;
        }
    }

    @Override
    protected void printEnd() {
        this.printArrayEnd();
        this.printObjectEnd();
        this.printObjectEnd();
    }

    private void printEvent(RecordedEvent recordedEvent) {
        this.printObjectBegin();
        EventType eventType = recordedEvent.getEventType();
        this.printValue(true, false, "type", eventType.getName());
        this.printNewDataStructure(false, false, "values");
        this.printObjectBegin();
        boolean bl = true;
        for (ValueDescriptor valueDescriptor : recordedEvent.getFields()) {
            this.printValueDescriptor(bl, false, valueDescriptor, this.getValue(recordedEvent, valueDescriptor));
            bl = false;
        }
        this.printObjectEnd();
        this.printObjectEnd();
    }

    void printValue(boolean bl, boolean bl2, String string, Object object) {
        this.printNewDataStructure(bl, bl2, string);
        if (!this.printIfNull(object)) {
            if (object instanceof Boolean) {
                this.printAsString(object);
                return;
            }
            if (object instanceof Double) {
                Double d = (Double)object;
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    this.printNull();
                    return;
                }
                this.printAsString(object);
                return;
            }
            if (object instanceof Float) {
                Float f = (Float)object;
                if (Float.isNaN(f.floatValue()) || Float.isInfinite(f.floatValue())) {
                    this.printNull();
                    return;
                }
                this.printAsString(object);
                return;
            }
            if (object instanceof Number) {
                this.printAsString(object);
                return;
            }
            this.print("\"");
            this.printEscaped(String.valueOf(object));
            this.print("\"");
        }
    }

    public void printObject(RecordedObject recordedObject) {
        this.printObjectBegin();
        boolean bl = true;
        for (ValueDescriptor valueDescriptor : recordedObject.getFields()) {
            this.printValueDescriptor(bl, false, valueDescriptor, this.getValue(recordedObject, valueDescriptor));
            bl = false;
        }
        this.printObjectEnd();
    }

    private void printArray(ValueDescriptor valueDescriptor, Object[] objectArray) {
        this.printArrayBegin();
        boolean bl = true;
        int n = 0;
        for (Object object : objectArray) {
            if (!(object instanceof RecordedFrame) || n < this.getStackDepth()) {
                this.printValueDescriptor(bl, true, valueDescriptor, object);
            }
            ++n;
            bl = false;
        }
        this.printArrayEnd();
    }

    private void printValueDescriptor(boolean bl, boolean bl2, ValueDescriptor valueDescriptor, Object object) {
        if (valueDescriptor.isArray() && !bl2) {
            this.printNewDataStructure(bl, bl2, valueDescriptor.getName());
            if (!this.printIfNull(object)) {
                this.printArray(valueDescriptor, (Object[])object);
            }
            return;
        }
        if (!valueDescriptor.getFields().isEmpty()) {
            this.printNewDataStructure(bl, bl2, valueDescriptor.getName());
            if (!this.printIfNull(object)) {
                this.printObject((RecordedObject)object);
            }
            return;
        }
        this.printValue(bl, bl2, valueDescriptor.getName(), object);
    }

    private void printNewDataStructure(boolean bl, boolean bl2, String string) {
        if (!bl) {
            this.print(", ");
            if (!bl2) {
                this.println();
            }
        }
        if (!bl2) {
            this.printDataStructureName(string);
        }
    }

    private boolean printIfNull(Object object) {
        if (object == null) {
            this.printNull();
            return true;
        }
        return false;
    }

    private void printNull() {
        this.print("null");
    }

    private void printDataStructureName(String string) {
        this.printIndent();
        this.print("\"");
        this.print(string);
        this.print("\": ");
    }

    private void printObjectEnd() {
        this.retract();
        this.println();
        this.printIndent();
        this.print("}");
    }

    private void printObjectBegin() {
        this.println("{");
        this.indent();
    }

    private void printArrayEnd() {
        this.print("]");
    }

    private void printArrayBegin() {
        this.print("[");
    }

    private void printEscaped(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.printEscaped(string.charAt(i));
        }
    }

    private void printEscaped(char c) {
        if (c == '\b') {
            this.print("\\b");
            return;
        }
        if (c == '\n') {
            this.print("\\n");
            return;
        }
        if (c == '\t') {
            this.print("\\t");
            return;
        }
        if (c == '\f') {
            this.print("\\f");
            return;
        }
        if (c == '\r') {
            this.print("\\r");
            return;
        }
        if (c == '\"') {
            this.print("\\\"");
            return;
        }
        if (c == '\\') {
            this.print("\\\\");
            return;
        }
        if (c == '/') {
            this.print("\\/");
            return;
        }
        if (c > '\u007f' || c < ' ') {
            this.print("\\u");
            this.print(Integer.toHexString(65536 + c).substring(1));
            return;
        }
        this.print(c);
    }
}

