/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;

public class DetectionFilter
implements Serializable {
    public static final long serialVersionUID = 100010201110001L;
    private int[] num_required = new int[NUM_OF_GROUPS];
    private static int NUM_OF_GROUPS = 2;
    private boolean both;
    private int[] group_membership;

    public DetectionFilter(String[] stringArray) {
        this.group_membership = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.group_membership[i] = 0;
        }
        this.set_num_required(0, 1);
        this.set_num_required(1, 1);
        this.both = false;
    }

    public int get_num_required(int n) {
        return this.num_required[n];
    }

    public int get_group_membership(int n) {
        return this.group_membership[n];
    }

    public boolean get_both() {
        return this.both;
    }

    public void set_num_required(int n, int n2) {
        this.num_required[n] = n2;
    }

    public void set_group_membership(int n, int n2) {
        this.group_membership[n2] = n;
    }

    public void set_both(boolean bl) {
        this.both = bl;
    }

    public boolean keep_gene(String[] stringArray) {
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("P")) continue;
            int n = this.get_group_membership(i);
            nArray[n] = nArray[n] + 1;
        }
        if (this.get_both()) {
            return nArray[0] >= this.get_num_required(0) && nArray[1] >= this.get_num_required(1);
        }
        return nArray[0] >= this.get_num_required(0) || nArray[1] >= this.get_num_required(1);
    }

    public String toString() {
        String string = "Num Required Grp 1:" + this.get_num_required(0);
        string = string + "\nNum Required Grp 2:" + this.get_num_required(1);
        for (int i = 0; i < this.group_membership.length; ++i) {
            string = string + "\nsample: " + i + " is in group: " + this.get_group_membership(i);
        }
        return string;
    }
}

