/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class HistoryViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 100010201080001L;
    private JTextArea content;
    private JPopupMenu menu;

    public HistoryViewer() {
        this.initContent();
        this.addHistory("Open Multiple Array Viewer");
        this.initMenu();
        this.content.addMouseListener(new HistoryListener());
    }

    private void initContent() {
        this.content = new JTextArea();
        this.content.setEditable(false);
        this.content.setMargin(new Insets(10, 10, 10, 10));
        this.content.setBackground(new Color(252, 255, 168));
    }

    private void initMenu() {
        this.menu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save History to File", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand("save");
        jMenuItem.addActionListener(new HistoryListener());
        this.menu.add(jMenuItem);
    }

    public void addHistory(String string) {
        this.content.append(this.getDateStamp() + string + "\n\n");
    }

    private String getDateStamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date) + " -- ";
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.content.getText());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = (String)objectInputStream.readObject();
        this.initContent();
        this.content.append(string);
        this.addHistory("Load Analysis From File");
        this.initMenu();
        this.content.addMouseListener(new HistoryListener());
    }

    private void saveHistory() {
        String string = System.getProperty("file.separator");
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile("data/"));
        if (jFileChooser.showSaveDialog(this.content) == 0) {
            try {
                File file = jFileChooser.getSelectedFile();
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                StringTokenizer stringTokenizer = new StringTokenizer(this.content.getText(), "\n\n");
                while (stringTokenizer.hasMoreTokens()) {
                    printWriter.println(stringTokenizer.nextToken());
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                JOptionPane.showMessageDialog(this.content, "An error occurred while saving history. \nMessage: " + string2, "Error Saving History", 2);
            }
        }
    }

    public class HistoryListener
    extends MouseAdapter
    implements ActionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                HistoryViewer.this.menu.show(HistoryViewer.this.content, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                HistoryViewer.this.menu.show(HistoryViewer.this.content, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("save")) {
                HistoryViewer.this.saveHistory();
            }
        }
    }
}

