/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.ResultTree;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SearchResultDialog
extends AlgorithmDialog {
    private int result = 2;
    private IFramework framework;
    private JTree nodeTree;
    private JList expViewNodeList;
    private JList tableViewNodeList;
    private Hashtable expViewHash;
    private Hashtable tableViewHash;
    private int[] indices;
    private boolean geneResult;
    private ResultTable resultTable;
    private boolean noViewers = false;
    private AlgorithmData searchCriteria;
    private String[] inputIds;
    private boolean isListImportResult = false;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public SearchResultDialog(IFramework iFramework, AlgorithmData algorithmData, JTree jTree, Hashtable hashtable, Hashtable hashtable2, int[] nArray) {
        super(iFramework.getFrame(), "Search Result", false);
        this.framework = iFramework;
        this.nodeTree = jTree;
        this.indices = nArray;
        this.searchCriteria = algorithmData;
        this.geneResult = algorithmData.getParams().getBoolean("gene-search");
        TreeListener treeListener = new TreeListener();
        this.nodeTree.addTreeSelectionListener(treeListener);
        this.expViewHash = hashtable;
        this.tableViewHash = hashtable2;
        if (jTree.getModel().getRoot() == null || ((TreeNode)jTree.getModel().getRoot()).getChildCount() < 1) {
            this.initElementOnlyResult();
        } else {
            this.initFullResult();
            this.expViewNodeList.addListSelectionListener(treeListener);
            this.tableViewNodeList.addListSelectionListener(treeListener);
        }
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDialog.this.result = 2;
                SearchResultDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SearchResultDialog.this), "Search Result Dialog");
                SearchResultDialog.this.result = 2;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
            }
        });
        this.resetButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.pack();
        this.setSize(550, 500);
    }

    public SearchResultDialog(IFramework iFramework, AlgorithmData algorithmData, int[] nArray) {
        super(iFramework.getFrame(), "Search Result", false);
        this.framework = iFramework;
        this.indices = nArray;
        this.geneResult = algorithmData.getParams().getBoolean("gene-search");
        this.noViewers = true;
        this.initElementOnlyResult();
        this.expViewHash = null;
        this.tableViewHash = null;
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDialog.this.result = 2;
                SearchResultDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SearchResultDialog.this), "Search Result Dialog");
                SearchResultDialog.this.result = 2;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
            }
        });
        this.resetButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.pack();
        this.setSize(550, 400);
    }

    public SearchResultDialog(IFramework iFramework, int[] nArray, String[] stringArray, boolean[] blArray, boolean bl) {
        super(iFramework.getFrame(), "Import Results", true);
        this.framework = iFramework;
        this.isListImportResult = true;
        this.indices = nArray;
        this.inputIds = stringArray;
        this.geneResult = bl;
        this.noViewers = true;
        this.initListImportResult(stringArray, blArray);
        this.expViewHash = null;
        this.tableViewHash = null;
        this.resetButton.setVisible(false);
        this.okButton.setText("Store Cluster");
        this.okButton.setSize(100, 30);
        this.okButton.setPreferredSize(new Dimension(100, 30));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDialog.this.result = 0;
                SearchResultDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDialog.this.result = 2;
                SearchResultDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SearchResultDialog.this), "Import Result Dialog");
                helpWindow.setTitle("Identifier List Import Result");
                SearchResultDialog.this.result = 2;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
            }
        });
        super.validate();
        this.pack();
        this.setSize(550, 500);
    }

    private void initFullResult() {
        this.expViewNodeList = new JList(new Vector());
        this.tableViewNodeList = new JList(new Vector());
        JScrollPane jScrollPane = new JScrollPane(this.nodeTree);
        JScrollPane jScrollPane2 = new JScrollPane(this.expViewNodeList);
        JScrollPane jScrollPane3 = new JScrollPane(this.tableViewNodeList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ParameterPanel parameterPanel = new ParameterPanel("Expression Viewers");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)jScrollPane2, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ParameterPanel parameterPanel2 = new ParameterPanel("Table Viewers");
        parameterPanel2.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel2.add((Component)jScrollPane3, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.resultTable = this.geneResult ? new ResultTable("Genes Found", this.framework.getData(), this.indices, this.geneResult, false) : new ResultTable("Samples Found", this.framework.getData(), this.indices, this.geneResult, false);
        ParameterPanel parameterPanel3 = new ParameterPanel("Viewer Shortcuts");
        parameterPanel3.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel3.add((Component)jPanel2, (Object)new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel3.add((Component)parameterPanel, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel3.add((Component)parameterPanel2, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)((Object)this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void initListImportResult(String[] stringArray, boolean[] blArray) {
        this.expViewNodeList = new JList(new Vector());
        this.tableViewNodeList = new JList(new Vector());
        JScrollPane jScrollPane = new JScrollPane(this.nodeTree);
        JScrollPane jScrollPane2 = new JScrollPane(this.expViewNodeList);
        JScrollPane jScrollPane3 = new JScrollPane(this.tableViewNodeList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                vector.addElement(stringArray[i]);
                continue;
            }
            vector2.addElement(stringArray[i]);
        }
        String string = "<html><center>" + String.valueOf(vector.size()) + " of " + String.valueOf(stringArray.length) + " input IDs were matched.<br>" + String.valueOf("(List length = " + this.indices.length + ")</center><html>");
        if (this.geneResult) {
            this.resultTable = new ResultTable("Genes Matched", this.framework.getData(), this.indices, this.geneResult, true);
            this.resultTable.setResultText(string);
        } else {
            this.resultTable = new ResultTable("Samples Matched", this.framework.getData(), this.indices, this.geneResult, true);
            this.resultTable.setResultText(string);
        }
        ParameterPanel parameterPanel = new ParameterPanel("Matching Results");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel("IDs Found (" + vector.size() + " of " + stringArray.length + ")");
        JScrollPane jScrollPane4 = new JScrollPane(new JList(vector));
        JLabel jLabel2 = new JLabel("IDs Not Found (" + vector2.size() + " of " + stringArray.length + ")");
        JScrollPane jScrollPane5 = new JScrollPane(new JList(vector2));
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 0, 15), 0, 0));
        parameterPanel.add((Component)jLabel2, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        parameterPanel.add((Component)jScrollPane4, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 15), 0, 0));
        parameterPanel.add((Component)jScrollPane5, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        jPanel.add((Component)((Object)this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
    }

    private void initElementOnlyResult() {
        this.expViewNodeList = new JList(new Vector());
        this.tableViewNodeList = new JList(new Vector());
        JScrollPane jScrollPane = new JScrollPane(this.nodeTree);
        JScrollPane jScrollPane2 = new JScrollPane(this.expViewNodeList);
        JScrollPane jScrollPane3 = new JScrollPane(this.tableViewNodeList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        ParameterPanel parameterPanel = new ParameterPanel("Viewers");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = this.geneResult ? new JLabel("<html><body><center>No expression or table viewers were found<br>containing the matching genes.</center></body></html>") : new JLabel("<html><body><center>No expression or table viewers were found<br>containing the matching samples.</center></body></html>");
        jLabel.setOpaque(false);
        jLabel.setHorizontalAlignment(0);
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.resultTable = this.geneResult ? new ResultTable("Genes Found", this.framework.getData(), this.indices, this.geneResult, false) : new ResultTable("Samples Found", this.framework.getData(), this.indices, this.geneResult, false);
        jPanel.add((Component)((Object)this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 400);
        jFrame.setVisible(true);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Analysis Results");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("KMC - genes(1)");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("SOM - genes(2)");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Cluster 2");
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Cluster 8");
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        vector.add(defaultMutableTreeNode4);
        vector.add(defaultMutableTreeNode5);
        Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>> hashtable = new Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>>();
        hashtable.put(defaultMutableTreeNode2, vector);
        hashtable.put(defaultMutableTreeNode3, vector);
        Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>> hashtable2 = new Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>>();
        hashtable2.put(defaultMutableTreeNode2, vector);
        hashtable2.put(defaultMutableTreeNode3, vector);
        ResultTree resultTree = new ResultTree(defaultMutableTreeNode);
    }

    private void updateLists(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector vector = (Vector)this.expViewHash.get(defaultMutableTreeNode);
        if (vector == null) {
            vector = new Vector();
        }
        this.expViewNodeList.setListData(vector);
        Vector vector2 = (Vector)this.tableViewHash.get(defaultMutableTreeNode);
        if (vector2 == null) {
            vector2 = new Vector();
        }
        this.tableViewNodeList.setListData(vector2);
    }

    private void updateViewerResults(int[] nArray) {
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No element indices are selected in the table as a basis for viewer update.", "Empty Element List", 1);
            return;
        }
        if (nArray.length == this.indices.length) {
            this.repaint();
            return;
        }
        ResultTree resultTree = this.framework.getResultTree();
        Vector vector = resultTree.findViewerCollection(nArray, this.geneResult);
        if (vector != null) {
            Vector vector2 = (Vector)vector.elementAt(0);
            Hashtable hashtable = (Hashtable)vector.elementAt(1);
            Hashtable hashtable2 = (Hashtable)vector.elementAt(2);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Analysis Results");
            for (int i = 0; i < vector2.size(); ++i) {
                defaultMutableTreeNode.add((DefaultMutableTreeNode)vector2.elementAt(i));
            }
            JTree jTree = new JTree(defaultMutableTreeNode);
            SearchResultDialog searchResultDialog = new SearchResultDialog(this.framework, this.searchCriteria, jTree, hashtable, hashtable2, nArray);
            searchResultDialog.showModal();
        }
    }

    private void storeCluster() {
        if (this.geneResult) {
            this.framework.storeOperationCluster("Search Result", "Selected Genes", this.resultTable.getSelectedIndices(), this.geneResult);
        } else {
            this.framework.storeOperationCluster("Search Result", "Selected Samples", this.resultTable.getSelectedIndices(), this.geneResult);
        }
        this.repaint();
    }

    public int[] getSelectedIndices() {
        return this.resultTable.getSelectedIndices();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ResultTable
    extends ParameterPanel {
        private JTable table;
        private ResultDataModel model;
        private JLabel elementLabel;
        private JButton updateViewerListsButton;
        private JButton saveClusterButton;

        public ResultTable(String string, IData iData, int[] nArray, boolean bl, boolean bl2) {
            super(string);
            String[] stringArray;
            this.setLayout(new GridBagLayout());
            if (bl) {
                String[] stringArray2 = iData.getFieldNames();
                stringArray = new String[stringArray2.length + 3];
                stringArray[0] = "Selected";
                stringArray[1] = "File Index";
                stringArray[2] = "Color";
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[i + 3] = stringArray2[i];
                }
            } else {
                Vector vector = this.getSlideNameKeyVectorUnion(iData);
                stringArray = new String[vector.size() + 3];
                stringArray[0] = "Selected";
                stringArray[1] = "File Index";
                stringArray[2] = "Color";
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray[i + 3] = (String)vector.elementAt(i);
                }
            }
            this.model = new ResultDataModel(iData, nArray, stringArray, bl);
            this.table = new JTable(this.model);
            this.table.setCellSelectionEnabled(true);
            this.table.getColumn("Color").setCellRenderer(new SearchTableCellRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.table);
            jScrollPane.setColumnHeaderView(this.table.getTableHeader());
            this.elementLabel = !bl2 ? (bl ? new JLabel("Number of genes matching the search: " + nArray.length) : new JLabel("Number of samples matching the search: " + nArray.length)) : (bl ? new JLabel("<html>Number of genes matching the " + SearchResultDialog.this.inputIds.length + " input ids : " + nArray.length + "<br>(Note that replicates for an id may exist)</html>") : new JLabel("<html>Number of samples matching the " + SearchResultDialog.this.inputIds.length + " input ids : " + nArray.length));
            this.elementLabel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.elementLabel.setOpaque(true);
            this.elementLabel.setBackground(Color.lightGray);
            this.elementLabel.setHorizontalAlignment(0);
            ButtonListener buttonListener = new ButtonListener();
            JButton jButton = new JButton("Clear");
            jButton.setActionCommand("clear-all-command");
            jButton.addActionListener(buttonListener);
            jButton.setFocusPainted(false);
            jButton.setPreferredSize(new Dimension(80, 30));
            jButton.setSize(80, 30);
            JButton jButton2 = new JButton("Select All");
            jButton2.setActionCommand("select-all-command");
            jButton2.addActionListener(buttonListener);
            jButton2.setFocusPainted(false);
            jButton2.setPreferredSize(new Dimension(80, 30));
            jButton2.setSize(80, 30);
            if (!bl2) {
                this.saveClusterButton = new JButton("Store Cluster");
                this.saveClusterButton.setActionCommand("store-cluster-command");
                this.saveClusterButton.addActionListener(buttonListener);
                this.saveClusterButton.setFocusPainted(false);
                this.saveClusterButton.setPreferredSize(new Dimension(100, 30));
                this.saveClusterButton.setSize(100, 30);
                this.updateViewerListsButton = new JButton("Update Shortcuts");
                this.updateViewerListsButton.setEnabled(false);
                this.updateViewerListsButton.setActionCommand("update-viewer-lists-command");
                this.updateViewerListsButton.addActionListener(buttonListener);
                this.updateViewerListsButton.setFocusPainted(false);
                this.updateViewerListsButton.setPreferredSize(new Dimension(100, 30));
                this.updateViewerListsButton.setSize(100, 30);
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            if (!bl2) {
                jPanel.add((Component)jButton2, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                jPanel.add((Component)this.saveClusterButton, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
                jPanel.add((Component)this.updateViewerListsButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 30, 0, 0), 0, 0));
                this.add(this.elementLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
                this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.add(jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.setPreferredSize(new Dimension(450, 150));
                this.setSize(450, 150);
            } else {
                jPanel.add((Component)jButton2, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 25, 0, 15), 0, 0));
                jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 15, 0, 25), 0, 0));
                this.add(this.elementLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
                this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.add(jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.setPreferredSize(new Dimension(450, 200));
                this.setSize(450, 200);
            }
        }

        public void setResultText(String string) {
            this.elementLabel.setText(string);
            this.validate();
        }

        public Vector getSlideNameKeyVectorUnion(IData iData) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < iData.getFeaturesCount(); ++i) {
                Vector vector2 = iData.getFeature(i).getSlideDataKeys();
                for (int j = 0; j < vector2.size(); ++j) {
                    String string = (String)vector2.elementAt(j);
                    if (vector.contains(string)) continue;
                    vector.addElement(string);
                }
            }
            return vector;
        }

        private int[] getSelectedIndices() {
            return this.model.getSelectedIndices();
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("select-all-command")) {
                    ResultTable.this.model.selectAll();
                    if (!SearchResultDialog.this.isListImportResult) {
                        ResultTable.this.updateViewerListsButton.setEnabled(true);
                    }
                } else if (string.equals("clear-all-command")) {
                    ResultTable.this.model.clearAll();
                    if (!SearchResultDialog.this.isListImportResult) {
                        ResultTable.this.updateViewerListsButton.setEnabled(false);
                    }
                } else if (string.equals("update-viewer-lists-command")) {
                    SearchResultDialog.this.updateViewerResults(ResultTable.this.model.getSelectedIndices());
                } else if (string.equals("store-cluster-command")) {
                    SearchResultDialog.this.storeCluster();
                }
            }
        }

        private class SearchTableCellRenderer
        implements TableCellRenderer {
            JPanel colorPanel = new JPanel();

            public SearchTableCellRenderer() {
                this.colorPanel.setBackground(Color.white);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.colorPanel.setBackground((Color)object);
                return this.colorPanel;
            }
        }

        private class ResultDataModel
        extends AbstractTableModel {
            private IData data;
            private int[] indices;
            private boolean[] selected;
            private String[] headerNames;
            private int columnCount;
            private int rowCount;
            private String value;
            private boolean geneResult;
            private JCheckBox checkBox;
            private JLabel colorLabel;

            public ResultDataModel(IData iData, int[] nArray, String[] stringArray, boolean bl) {
                this.data = iData;
                this.indices = nArray;
                this.headerNames = stringArray;
                this.geneResult = bl;
                this.checkBox = new JCheckBox();
                this.colorLabel = new JLabel();
                this.colorLabel.setOpaque(true);
                this.columnCount = stringArray.length;
                this.rowCount = nArray.length;
                this.selected = new boolean[this.rowCount];
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = true;
                }
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return new Boolean(this.selected[n]);
                }
                if (n2 == 1) {
                    return Integer.toString(this.indices[n]);
                }
                if (n2 == 2) {
                    Color color = this.data.getProbeColor(this.indices[n]);
                    if (color != null) {
                        return color;
                    }
                    return Color.white;
                }
                this.value = this.geneResult ? this.data.getElementAttribute(this.indices[n], n2 - 3) : (String)this.data.getFeature(this.indices[n]).getSlideDataLabels().get(this.headerNames[n2]);
                if (this.value == null) {
                    this.value = " ";
                }
                return this.value;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 0) {
                    this.selected[n] = (Boolean)object;
                    if (!SearchResultDialog.this.isListImportResult) {
                        ResultTable.this.updateViewerListsButton.setEnabled(true);
                    }
                }
            }

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = SearchResultDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                return class$java$lang$String == null ? (class$java$lang$String = SearchResultDialog.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            public int getColumnCount() {
                return this.columnCount;
            }

            public int getRowCount() {
                return this.rowCount;
            }

            public String getColumnName(int n) {
                return this.headerNames[n];
            }

            public void selectAll() {
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = true;
                }
                ResultTable.this.table.repaint();
            }

            public void clearAll() {
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = false;
                }
                ResultTable.this.table.repaint();
            }

            public int[] getSelectedIndices() {
                Vector<Integer> vector = new Vector<Integer>();
                for (int i = 0; i < this.selected.length; ++i) {
                    if (!this.selected[i]) continue;
                    vector.add(new Integer((String)ResultTable.this.model.getValueAt(i, 1)));
                }
                int[] nArray = new int[vector.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)vector.elementAt(i);
                }
                return nArray;
            }
        }
    }

    private class TreeListener
    implements TreeSelectionListener,
    ListSelectionListener {
        private TreeListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SearchResultDialog.this.nodeTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            SearchResultDialog.this.updateLists(defaultMutableTreeNode);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            if (jList == SearchResultDialog.this.expViewNodeList) {
                SearchResultDialog.this.tableViewNodeList.clearSelection();
            } else {
                SearchResultDialog.this.expViewNodeList.clearSelection();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jList.getSelectedValue();
            if (defaultMutableTreeNode != null && SearchResultDialog.this.framework != null) {
                SearchResultDialog.this.framework.setTreeNode(defaultMutableTreeNode);
            }
        }
    }
}

