/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class ShowThrowableDialog
extends JDialog {
    private JComponent message;
    private JComponent stack;
    private JPanel mainPanel;

    public ShowThrowableDialog(Frame frame, String string, boolean bl, int n, Throwable throwable) {
        super(frame, string, bl);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.message = this.createMessageContent(n, throwable);
        this.stack = this.createStackContent(throwable);
        this.mainPanel = this.createMainPanel();
        this.mainPanel.add((Component)this.message, "Center");
        JPanel jPanel = this.createBtnsPanel(listener);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.pack();
    }

    public static void show(Frame frame, String string, Throwable throwable) {
        ShowThrowableDialog.show(frame, string, true, throwable);
    }

    public static void show(Frame frame, String string, boolean bl, Throwable throwable) {
        ShowThrowableDialog.show(frame, string, bl, 0, throwable);
    }

    public static void show(Frame frame, String string, boolean bl, int n, Throwable throwable) {
        ShowThrowableDialog showThrowableDialog = new ShowThrowableDialog(frame, string, bl, n, throwable);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        showThrowableDialog.setLocation((dimension.width - showThrowableDialog.getSize().width) / 2, (dimension.height - showThrowableDialog.getSize().height) / 2);
        showThrowableDialog.show();
    }

    private Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private JComponent createMessageContent(int n, Throwable throwable) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(this.getIconForType(n)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 20;
        jPanel.add((Component)new JLabel(throwable.getMessage()), gridBagConstraints);
        return jPanel;
    }

    private String getTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    private JComponent createStackContent(Throwable throwable) {
        JTextArea jTextArea = new JTextArea(this.getTrace(throwable));
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(250, 150));
        return jScrollPane;
    }

    private void setContent(JComponent jComponent) {
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)jComponent, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new BevelBorder(0));
        jPanel.setPreferredSize(new Dimension(400, 100));
        return jPanel;
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        GridLayout gridLayout = new GridLayout();
        JPanel jPanel = new JPanel(gridLayout);
        JButton jButton = new JButton("OK");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        JToggleButton jToggleButton = new JToggleButton("Stack");
        jToggleButton.setActionCommand("stack-command");
        jToggleButton.addActionListener(actionListener);
        gridLayout.setHgap(4);
        jPanel.add(jToggleButton);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private void onStackTrace(boolean bl) {
        if (bl) {
            this.setContent(this.stack);
        } else {
            this.setContent(this.message);
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                ShowThrowableDialog.this.dispose();
            } else if (string.equals("stack-command")) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ShowThrowableDialog.this.onStackTrace(abstractButton.isSelected());
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            ShowThrowableDialog.this.dispose();
        }
    }
}

