/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.TMEVAlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.gui.IGUIFactory;
import org.tigr.util.ConfMap;
import org.tigr.util.awt.ImageScreen;

public class TMEV {
    public static final String VERSION = "3.1";
    public static final int SYSTEM = 1000;
    public static final int DB_AVAILABLE = 1001;
    public static final int DB_LOGIN = 1002;
    public static final int DATA_AVAILABLE = 1003;
    public static final int SPOTFIRE_AVAILABLE = 1004;
    public static final int DATA_TYPE_TWO_DYE = 1;
    public static final int DATA_TYPE_AFFY = 2;
    public static final int ANALYSIS_LOADED = 101;
    private static Connection connection;
    private static Hashtable properties;
    private static AlgorithmFactory algorithmFactory;
    private static IGUIFactory guiFactory;
    private static int coordinatePairCount;
    private static int intensityCount;
    private static int headerRowCount;
    private static int headerColumnCount;
    private static int uniqueIDIndex;
    private static int nameIndex;
    private static boolean indicesAdjusted;
    private static String[] fieldNames;
    private static String[] databases;
    public static boolean permitSavePrompt;
    private static String dataPath;
    private static int dataType;
    private static String os;
    public static boolean activeSave;
    static /* synthetic */ Class class$org$tigr$microarray$mev$TMEV;

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            String string3;
            InformationPanel informationPanel;
            System.out.println("TIGR MultiExperimentViewer (1109887083829) - version 3.1 - " + System.getProperty("os.name"));
            try {
                informationPanel = new InformationPanel();
                string3 = informationPanel.getJava3DRunTimeEnvironment();
                string2 = informationPanel.getJava3DVendor();
                string = informationPanel.getJava3DVersion();
            }
            catch (Exception exception) {
                string3 = "not installed";
                string2 = "not available";
                string = "not available";
            }
            os = System.getProperty("os.name");
            System.out.println(System.currentTimeMillis());
            System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
            System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
            System.out.println("Java Virtual Machine name: " + System.getProperty("java.vm.name"));
            System.out.println("Java Virtual Machine version: " + System.getProperty("java.vm.version"));
            System.out.println("Java Virtual Machine vendor: " + System.getProperty("java.vm.vendor"));
            System.out.println("Java 3D Runtime Environment: " + string3);
            System.out.println("Java 3D Runtime Environment vendor: " + string2);
            System.out.println("Java 3D Runtime Environment version:" + string);
            System.out.println("Operating System name: " + os);
            System.out.println("Operating System version: " + System.getProperty("os.version"));
            System.out.println("Operating System architecture: " + System.getProperty("os.arch"));
            TMEV.configure();
            informationPanel = new ImageScreen();
            informationPanel.showImageScreen(1500L);
            Manager manager = new Manager();
            if (os.indexOf("Apple") != -1 || os.indexOf("Mac") != -1) {
                manager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            Manager.createNewMultipleArrayViewer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean readPreferencesFile(File file) {
        String string;
        StringTokenizer stringTokenizer;
        String string2;
        BufferedReader bufferedReader = null;
        boolean bl = true;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        try {
            properties = new Hashtable();
            indicesAdjusted = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2.trim();
                if (string2.startsWith("//") || string2.length() == 0) continue;
                stringTokenizer = new StringTokenizer(string2, "\t");
                string = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    properties.put(string, stringTokenizer.nextToken());
                    continue;
                }
                properties.put(string, new String(""));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string2 = TMEV.getSettingForOption("Element Info");
            stringTokenizer = new StringTokenizer(string2, ":");
            coordinatePairCount = Integer.parseInt(stringTokenizer.nextToken());
            intensityCount = Integer.parseInt(stringTokenizer.nextToken());
            string = TMEV.getSettingForOption("Headers");
            stringTokenizer = new StringTokenizer(string, ":");
            headerRowCount = Integer.parseInt(stringTokenizer.nextToken());
            headerColumnCount = Integer.parseInt(stringTokenizer.nextToken());
            String string3 = TMEV.getSettingForOption("Unique ID");
            uniqueIDIndex = Integer.parseInt(string3);
            String string4 = TMEV.getSettingForOption("Spot Name");
            nameIndex = Integer.parseInt(string4);
            String string5 = TMEV.getSettingForOption("Database Names");
            stringTokenizer = new StringTokenizer(string5, ":");
            databases = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                TMEV.databases[n] = stringTokenizer.nextToken();
                ++n;
            }
            String string6 = TMEV.getSettingForOption("Additional Fields");
            stringTokenizer = new StringTokenizer(string6, ":");
            if (stringTokenizer.countTokens() > 0) {
                fieldNames = new String[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    TMEV.fieldNames[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
            } else {
                fieldNames = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static String getSettingForOption(String string) {
        String string2 = "";
        try {
            string2 = (String)properties.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static boolean connect(String string, String string2) {
        try {
            Object object;
            System.err.println("jdbc.drivers " + System.getProperty("jdbc.drivers"));
            Object object2 = DriverManager.getDrivers();
            while (object2.hasMoreElements()) {
                System.err.println("jdbc.driver " + object2.nextElement());
            }
            object2 = System.getProperty("jdbc.drivers");
            if (object2 != null) {
                object = new StringTokenizer((String)object2, ":");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        Class.forName(((StringTokenizer)object).nextToken());
                    }
                    catch (Exception exception) {}
                }
            }
            object = new String(TMEV.getSettingForOption("Database Server Name"));
            Properties properties = new Properties();
            properties.put("user", string);
            properties.put("password", string2);
            properties.put("APPLICATIONNAME", "TIGR MultiExperimentViewer");
            DriverManager.setLoginTimeout(2200);
            connection = DriverManager.getConnection((String)object, properties);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception (TMEV.connect()): " + exception);
            return false;
        }
    }

    public static int getCoordinatePairCount() {
        return coordinatePairCount;
    }

    public static int getIntensityCount() {
        return intensityCount;
    }

    public static int getHeaderRowCount() {
        return headerRowCount;
    }

    public static int getHeaderColumnCount() {
        return headerColumnCount;
    }

    public static String[] getFieldNames() {
        if (fieldNames == null) {
            return new String[0];
        }
        return fieldNames;
    }

    public static String[] getDatabases() {
        return databases;
    }

    public static int getUniqueIDIndex() {
        return uniqueIDIndex;
    }

    public static int getNameIndex() {
        return nameIndex;
    }

    public static Connection getConnection() {
        return connection;
    }

    public static int getDataType() {
        return dataType;
    }

    public static void setDataType(int n) {
        dataType = n;
    }

    public static void setIndicesAdjusted(boolean bl) {
        indicesAdjusted = bl;
    }

    public static boolean indicesAdjusted() {
        return indicesAdjusted;
    }

    public static void setUniqueIDIndex(int n) {
        uniqueIDIndex = n < 0 ? 0 : n;
    }

    public static void setNameIndex(int n) {
        nameIndex = n < 0 ? 0 : n;
    }

    public static void setFieldNames(String[] stringArray) {
        fieldNames = stringArray;
    }

    public static void appendFieldNames(String[] stringArray) {
        if (fieldNames == null || stringArray == null) {
            fieldNames = stringArray;
        } else {
            String[] stringArray2 = new String[fieldNames.length + stringArray.length];
            System.arraycopy(fieldNames, 0, stringArray2, 0, fieldNames.length);
            System.arraycopy(stringArray, 0, stringArray2, fieldNames.length, stringArray.length);
            fieldNames = stringArray2;
        }
    }

    public static void clearFieldNames() {
        fieldNames = null;
    }

    public static void setPermitPrompt(boolean bl) {
        boolean bl2 = false;
        if (permitSavePrompt != bl) {
            String string = String.valueOf(bl);
            String string2 = System.getProperty("line.separator");
            if (string2 == null) {
                string2 = "\n";
            }
            String string3 = "tmev.cfg";
            String string4 = new String("");
            try {
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
                while ((string5 = bufferedReader.readLine()) != null) {
                    if (string5.indexOf("prompt-for-save") != -1) {
                        bl2 = true;
                        string5 = string5.substring(0, string5.lastIndexOf(" "));
                        string5 = string5 + " " + string;
                    }
                    string4 = string4 + string5 + string2;
                }
                if (!bl2) {
                    string4 = string4 + string2 + "# Prompt save state" + string2 + "prompt-for-save " + String.valueOf(bl);
                }
                bufferedReader.close();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string3));
                bufferedWriter.write(string4);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            permitSavePrompt = bl;
        }
    }

    public static void configure() {
        String string = "config/tmev.cfg";
        ConfMap confMap = new ConfMap();
        try {
            Object object;
            Object object2;
            try {
                object2 = (class$org$tigr$microarray$mev$TMEV == null ? (class$org$tigr$microarray$mev$TMEV = TMEV.class$("org.tigr.microarray.mev.TMEV")) : class$org$tigr$microarray$mev$TMEV).getClassLoader().getResourceAsStream(string);
                object = (class$org$tigr$microarray$mev$TMEV == null ? (class$org$tigr$microarray$mev$TMEV = TMEV.class$("org.tigr.microarray.mev.TMEV")) : class$org$tigr$microarray$mev$TMEV).getClassLoader().getResource(string);
                if (object2 != null) {
                    confMap.load((InputStream)object2);
                }
            }
            catch (SecurityException securityException) {
                System.out.println("resource configuration file " + securityException);
            }
            catch (IOException iOException) {
                System.out.println("Error to load configuration file.");
                iOException.printStackTrace();
            }
            try {
                confMap.load((InputStream)new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("local configuration file " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println("Error to load configuration file.");
                iOException.printStackTrace();
            }
            object2 = confMap.getString("gui.factory.class");
            if (object2 == null || ((String)object2).equals("null")) {
                throw new Exception("GUI factory class name not found, check the 'gui.factory.class' key in " + string + " file.");
            }
            object = Class.forName((String)object2);
            guiFactory = (IGUIFactory)((Class)object).newInstance();
            algorithmFactory = new TMEVAlgorithmFactory(confMap);
            permitSavePrompt = confMap.getBoolean("prompt-for-save", true);
            object = confMap.getProperty("current-data-path");
            if (object != null) {
                String string2 = System.getProperty("file.separator");
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "/");
                object = new String();
                while (stringTokenizer.hasMoreTokens()) {
                    object = (String)object + stringTokenizer.nextToken() + string2;
                }
                dataPath = object;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getDataPath() {
        return dataPath;
    }

    public static void updateDataPath(String string) {
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("line.separator");
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(TMEV.getFile("config/tmev.cfg")));
            String string4 = new String();
            while ((string3 = bufferedReader.readLine()) != null && !string3.equals("#DATA PATH")) {
                string4 = string4 + string3 + string2;
            }
            if (string3 == null) {
                string4 = string4 + string2;
                string4 = string4 + "#DATA PATH" + string2;
                string4 = string4 + "current-data-path " + string + string2;
            } else {
                bufferedReader.readLine();
                string4 = string4 + "#DATA PATH" + string2;
                string4 = string4 + "current-data-path " + string + string2;
                while ((string3 = bufferedReader.readLine()) != null) {
                    string4 = string4 + string3 + string2;
                }
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(TMEV.getFile("config/tmev.cfg")));
            bufferedWriter.write(string4);
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error updating data path in tmev.cfg file.");
        }
    }

    public static void setDataPath(String string) {
        dataPath = string;
    }

    public static AlgorithmFactory getAlgorithmFactory() {
        return algorithmFactory;
    }

    public static IGUIFactory getGUIFactory() {
        return guiFactory;
    }

    public static void quit() {
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public static File getConfigurationFile(String string) {
        return new File("config/" + string);
    }

    public static File getFile(String string) {
        return new File(string);
    }

    public static String getOSName() {
        return os;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        indicesAdjusted = false;
        permitSavePrompt = true;
        dataType = 1;
        os = "";
        activeSave = false;
    }
}

