/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterWorker;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ClusterTable
extends JPanel
implements IViewer {
    private JTable table;
    private JPopupMenu menu;
    private JScrollPane pane;
    private ClusterRepository repository;
    private ClusterTableModel model;
    private IFramework framework;
    private boolean geneClusterTable;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public ClusterTable(ClusterRepository clusterRepository, IFramework iFramework) {
        super(new GridBagLayout());
        this.framework = iFramework;
        this.repository = clusterRepository;
        this.geneClusterTable = clusterRepository.isGeneClusterRepository();
        this.setBackground(Color.white);
        MenuListener menuListener = new MenuListener();
        this.initializeTable();
        this.initializeMenu(menuListener);
    }

    private void initializeTable() {
        Vector<String> vector = new Vector<String>();
        vector.add("Serial #");
        vector.add("Source");
        vector.add("Algorithm Node");
        vector.add("Cluster Node");
        vector.add("Cluster Label");
        vector.add("Remarks");
        vector.add("Size");
        vector.add("Color");
        vector.add("Show Color");
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList clusterList = this.repository.getClusterList(i);
            for (int j = 0; j < clusterList.size(); ++j) {
                Cluster cluster = clusterList.getClusterAt(j);
                vector2.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
                vector2.add(new JLabel(String.valueOf(cluster.getSource())));
                vector2.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
                vector2.add(new JLabel(String.valueOf(cluster.getClusterID())));
                vector2.add(cluster.getClusterLabel());
                vector2.add(cluster.getClusterDescription());
                vector2.add(new JLabel(String.valueOf(cluster.getSize())));
                vector2.add(cluster.getClusterColor());
                vector2.add(new Boolean(cluster.showColor()));
                ++n;
            }
        }
        this.model = new ClusterTableModel(vector, vector2);
        this.table = new JTable(this.model);
        ClusterCellRenderer clusterCellRenderer = new ClusterCellRenderer();
        this.table.setDefaultRenderer(class$java$awt$Color == null ? (class$java$awt$Color = ClusterTable.class$("java.awt.Color")) : class$java$awt$Color, clusterCellRenderer);
        this.table.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = ClusterTable.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, clusterCellRenderer);
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 175));
        this.table.addMouseListener(new TableListener());
        this.table.setBackground(Color.white);
        this.table.setRowHeight(this.table.getRowHeight() + 10);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(2);
        this.setInitialColumnWidths();
        this.model.addTableModelListener(new TableListener());
        this.table.setRowHeight(30);
        this.pane = new JScrollPane(this.table);
        this.pane.setBackground(Color.white);
        this.add((Component)this.pane, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
    }

    public void removeRow(int n) {
        this.model.removeRow(n);
    }

    public void addCluster(Cluster cluster) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
        vector.add(new JLabel(String.valueOf(cluster.getSource())));
        vector.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
        vector.add(new JLabel(String.valueOf(cluster.getClusterID())));
        vector.add(cluster.getClusterLabel());
        JLabel jLabel = new JLabel();
        vector.add(cluster.getClusterDescription());
        vector.add(new JLabel(String.valueOf(cluster.getSize())));
        vector.add(cluster.getClusterColor());
        vector.add(new Boolean(cluster.showColor()));
        this.model.addRow(vector);
    }

    private void initializeMenu(MenuListener menuListener) {
        this.menu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Modify Attributes", GUIFactory.getIcon((String)"empty16.gif"));
        jMenuItem.setActionCommand("modify-command");
        jMenuItem.addActionListener(menuListener);
        this.menu.add(jMenuItem);
        this.menu.addSeparator();
        this.menu.add(this.initializeOpenMenu(menuListener));
        this.menu.addSeparator();
        this.menu.add(this.initializeClusterOperationsMenu(menuListener));
        this.menu.addSeparator();
        this.menu.add(this.initializeSortMenu(menuListener));
        this.menu.addSeparator();
        this.menu.add(this.initializeHideMenu(menuListener));
        this.menu.addSeparator();
        jMenuItem = new JMenuItem("Delete Selected", GUIFactory.getIcon((String)"delete16.gif"));
        jMenuItem.setActionCommand("delete-command");
        jMenuItem.addActionListener(menuListener);
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete All", GUIFactory.getIcon((String)"delete16.gif"));
        jMenuItem.setActionCommand("delete-all-command");
        jMenuItem.addActionListener(menuListener);
        this.menu.add(jMenuItem);
        this.menu.addSeparator();
        jMenuItem = new JMenuItem("Save Cluster", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand("save-cluster-command");
        jMenuItem.addActionListener(menuListener);
        this.menu.add(jMenuItem);
        this.menu.addSeparator();
        jMenuItem = this.repository.isGeneClusterRepository() ? new JMenuItem("Import Gene List", GUIFactory.getIcon((String)"empty.gif")) : new JMenuItem("Import Experiment List", GUIFactory.getIcon((String)"empty.gif"));
        jMenuItem.setActionCommand("import-list-command");
        jMenuItem.addActionListener(menuListener);
        this.menu.add(jMenuItem);
        if (this.repository.isGeneClusterRepository()) {
            this.menu.addSeparator();
            jMenuItem = new JMenuItem("Submit Gene List (External Repository)", GUIFactory.getIcon((String)"empty.gif"));
            jMenuItem.setActionCommand("submit-list-command");
            jMenuItem.addActionListener(menuListener);
            this.menu.add(jMenuItem);
        }
    }

    private JMenu initializeModifyMenu(MenuListener menuListener) {
        JMenu jMenu = new JMenu("Modify Cluster");
        JMenuItem jMenuItem = new JMenuItem("Modify Attributes");
        jMenuItem.setActionCommand("modify-command");
        jMenuItem.addActionListener(menuListener);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Modify Membership");
        jMenuItem.setActionCommand("modify-membership-command");
        jMenuItem.addActionListener(menuListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu initializeOpenMenu(MenuListener menuListener) {
        JMenu jMenu = new JMenu("Open/Launch");
        jMenu.setIcon(GUIFactory.getIcon((String)"open_launch.gif"));
        JMenuItem jMenuItem = new JMenuItem("Open Cluster Viewer", GUIFactory.getIcon((String)"Open16.gif"));
        jMenuItem.setActionCommand("go-to-origin-command");
        jMenuItem.addActionListener(menuListener);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch MeV Session", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        jMenuItem.setActionCommand("launch-new-command");
        jMenuItem.addActionListener(menuListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu initializeHideMenu(MenuListener menuListener) {
        JMenu jMenu = new JMenu("Hide Columns");
        jMenu.setIcon(GUIFactory.getIcon((String)"empty16.gif"));
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.model.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand("hide-command");
            jCheckBoxMenuItem.setSelected(false);
            jCheckBoxMenuItem.addActionListener(menuListener);
            jMenu.add(jCheckBoxMenuItem);
        }
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Show All");
        jMenuItem.setActionCommand("show-all-command");
        jMenuItem.addActionListener(menuListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu initializeSortMenu(MenuListener menuListener) {
        JMenu jMenu = new JMenu("Sort");
        jMenu.setIcon(GUIFactory.getIcon((String)"empty16.gif"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.model.getColumnCount() - 1; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.model.getColumnName(i));
            jRadioButtonMenuItem.setActionCommand("sort-command");
            if (this.model.getColumnName(i).equals("Serial #")) {
                jRadioButtonMenuItem.setSelected(true);
            } else {
                jRadioButtonMenuItem.setSelected(false);
            }
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(menuListener);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private JMenu initializeClusterOperationsMenu(MenuListener menuListener) {
        JMenu jMenu = new JMenu("Cluster Operations");
        jMenu.setIcon(GUIFactory.getIcon((String)"cluster_operations.gif"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < 3; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            if (i == 0) {
                jMenuItem.setText("Intersection");
                jMenuItem.setIcon(GUIFactory.getIcon((String)"intersection.gif"));
            } else if (i == 1) {
                jMenuItem.setText("Union");
                jMenuItem.setIcon(GUIFactory.getIcon((String)"union.gif"));
            } else if (i == 2) {
                jMenuItem.setText("XOR");
                jMenuItem.setIcon(GUIFactory.getIcon((String)"xor.gif"));
            }
            jMenuItem.setActionCommand("cluster-operations-command");
            buttonGroup.add(jMenuItem);
            jMenuItem.addActionListener(menuListener);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private void setInitialColumnWidths() {
        String[] stringArray = this.model.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.setColumnWidth(stringArray[i]);
        }
    }

    private void setColumnWidth(String string) {
        int n = 10;
        if (string.equals("Serial #")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 50;
            tableColumn.setWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
        } else if (string.equals("Source")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 100;
            tableColumn.setWidth(n);
            tableColumn.setPreferredWidth(n);
        } else if (string.equals("Color")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 60;
            tableColumn.setWidth(n);
            tableColumn.setPreferredWidth(n);
        } else if (string.equals("Size")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 50;
            tableColumn.setWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
        }
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData iData) {
        this.repaint();
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this.table;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.repaint();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public JComponent getHeaderComponent() {
        return this.table.getTableHeader();
    }

    public void onRepositoryChanged(ClusterRepository clusterRepository) {
        this.repository = clusterRepository;
        this.initializeTable();
        this.imposeHideMenu();
        this.validate();
        this.model.sortBy("Serial #");
        this.model.fireTableDataChanged();
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void imposeHideMenu() {
        JMenu jMenu = (JMenu)this.menu.getComponent(8);
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            JMenuItem jMenuItem;
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || !(jMenuItem = (JMenuItem)component).isSelected()) continue;
            this.model.hide(jMenuItem.getText());
        }
    }

    private void resetSortMenu() {
        JMenu jMenu = (JMenu)this.menu.getComponent(6);
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            if (i == 0) {
                this.model.sortBy(jMenuItem.getText());
                continue;
            }
            jMenuItem.setSelected(false);
        }
    }

    private void enableAllMenuItems() {
        int n = this.menu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.menu.getComponent(i) instanceof JMenuItem)) continue;
            this.menu.getComponent(i).setEnabled(true);
            int n2 = 0;
            n2 = ((JMenuItem)this.menu.getComponent(i)).getComponentCount();
            if (((JMenuItem)this.menu.getComponent(i)).getText().equals("Open/Launch")) {
                ((JMenu)this.menu.getComponent(i)).getMenuComponent(0).setEnabled(true);
            }
            for (int j = 0; j < n2; ++j) {
                ((JMenuItem)((JMenuItem)this.menu.getComponent(i)).getComponent(n2)).setEnabled(true);
            }
        }
    }

    private Cluster[] getSelectedClusters() {
        int[] nArray = this.table.getSelectedRows();
        Cluster[] clusterArray = new Cluster[nArray.length];
        for (int i = 0; i < clusterArray.length; ++i) {
            clusterArray[i] = this.repository.getCluster(this.model.getClusterSerialNumber(nArray[i]));
        }
        return clusterArray;
    }

    private void modifyColor(int n, int n2) {
        Color color = (Color)this.table.getValueAt(n, n2);
        if ((color = JColorChooser.showDialog(this, "Reassign Color", color)) != null) {
            this.table.setValueAt(color, n, n2);
            this.repository.updateClusterColor(this.model.getClusterSerialNumber(n), color);
        }
    }

    private void modifyShowColor(int n, int n2) {
        Cluster[] clusterArray = this.getSelectedClusters();
        if (clusterArray.length == 0) {
            return;
        }
        Boolean bl = (Boolean)this.model.getValueAt(n, n2);
        clusterArray[0].enableShowColor(bl);
        this.model.setValueAt(clusterArray[0].getClusterColor(), n, n2 - 1);
        this.model.fireTableDataChanged();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.table.repaint();
        this.repaint();
    }

    private void launchNewMevSession() {
        Cluster[] clusterArray = this.getSelectedClusters();
        ClusterWorker clusterWorker = new ClusterWorker(this.repository);
        int[] nArray = clusterWorker.getUniqueIndices(clusterArray);
        String[] stringArray = clusterWorker.getClusterLabels(clusterArray);
        if (stringArray.length == 1) {
            if (this.geneClusterTable) {
                this.framework.launchNewMAV(nArray, clusterWorker.getMinExperiment(clusterArray), "Cluster: " + stringArray[0], 0);
            } else {
                this.framework.launchNewMAV(nArray, clusterWorker.getMinExperiment(clusterArray), "Cluster: " + stringArray[0], 1);
            }
        } else if (stringArray.length > 1) {
            String string = "";
            string = "Clusters: ";
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string = string + stringArray[i] + " : ";
            }
            string = string + stringArray[stringArray.length - 1];
            if (this.geneClusterTable) {
                this.framework.launchNewMAV(nArray, clusterWorker.getMinExperiment(clusterArray), "Cluster: " + stringArray[0], 0);
            } else {
                this.framework.launchNewMAV(nArray, clusterWorker.getMinExperiment(clusterArray), "Cluster: " + stringArray[0], 1);
            }
        }
    }

    private void openClusterNode() {
        int n = this.table.getSelectedRow();
        Cluster cluster = this.repository.getCluster(this.model.getClusterSerialNumber(n));
        if (!cluster.getSource().equals("Algorithm")) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = cluster.getNode();
        if (defaultMutableTreeNode == null) {
            Object object = cluster.getUserObject();
            if (object != null && (defaultMutableTreeNode = this.framework.getNode(object)) != null) {
                cluster.setNode(defaultMutableTreeNode);
                this.framework.setTreeNode(defaultMutableTreeNode);
            }
        } else {
            this.framework.setTreeNode(defaultMutableTreeNode);
        }
    }

    private void modifyClusterAttributes() {
        int n = this.table.getSelectedRow();
        if (this.model.isLegalRow(n)) {
            Cluster cluster = this.repository.getCluster(this.model.getClusterSerialNumber(n));
            ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Modify Cluster Attributes", cluster.getAlgorithmName(), cluster.getClusterID(), cluster.getClusterLabel(), cluster.getClusterDescription(), cluster.getClusterColor());
            if (clusterAttributesDialog.showModal() != 0) {
                return;
            }
            Color color = clusterAttributesDialog.getColor();
            String string = clusterAttributesDialog.getLabel();
            String string2 = clusterAttributesDialog.getDescription();
            cluster.setClusterColor(color);
            cluster.setClusterLabel(string);
            cluster.setClusterDescription(string2);
            this.model.setClusterColor(n, color);
            this.model.setClusterLabel(n, string);
            this.model.setClusterDescription(n, string2);
            this.model.fireTableDataChanged();
        }
    }

    private void showAllColumns() {
        JMenu jMenu = (JMenu)this.menu.getComponent(8);
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            JMenuItem jMenuItem;
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || !(jMenuItem = (JMenuItem)component).isSelected()) continue;
            this.model.addColumn(jMenuItem.getText());
            jMenuItem.setSelected(false);
        }
    }

    private void performClusterOperation(String string) {
        Cluster[] clusterArray = this.getSelectedClusters();
        if (clusterArray.length < 2) {
            return;
        }
        ClusterWorker clusterWorker = new ClusterWorker(this.repository);
        Cluster cluster = null;
        if (string.equals("Intersection")) {
            cluster = clusterWorker.intersection(clusterArray);
        } else if (string.equals("Union")) {
            cluster = clusterWorker.union(clusterArray);
        } else if (string.equals("XOR")) {
            cluster = clusterWorker.xor(clusterArray);
        }
        if (cluster != null) {
            this.repository.addCluster(this.repository.getClusterOperationsList(), cluster);
            this.addCluster(cluster);
        }
        if (cluster != null) {
            this.framework.addHistory("Cluster Operation: " + cluster.getAlgorithmName());
        }
    }

    private void deleteSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.model.isLegalRow(nArray[i] - i)) continue;
            this.repository.removeCluster(this.model.getSerialNumber(nArray[i] - i));
            this.model.removeRow(nArray[i] - i);
        }
        if (nArray.length > 0) {
            this.model.fireTableDataChanged();
        }
        this.onRepositoryChanged(this.repository);
    }

    private void deleteAllRows() {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure that you want to delete all clusters in the repository?", "Delete All Clusters", 0, 2);
        if (n == 0) {
            this.model.removeAllRows();
            this.repository.clearClusterLists();
        }
    }

    public void deleteAllClusters() {
        this.model.removeAllRows();
        this.repository.clearClusterLists();
    }

    private void saveCluster() {
        Cluster[] clusterArray = this.getSelectedClusters();
        if (clusterArray.length != 1) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "One row must be selected to indicate the cluster to save.", "Save Error", 2);
            return;
        }
        this.repository.saveCluster(clusterArray[0].getSerialNumber());
    }

    private void submitCluster() {
        Cluster[] clusterArray = this.getSelectedClusters();
        if (clusterArray != null && clusterArray.length > 0) {
            this.repository.submitCluster(clusterArray[0]);
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("hide-command")) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                    ClusterTable.this.model.hide(((JCheckBoxMenuItem)actionEvent.getSource()).getText());
                } else {
                    ClusterTable.this.model.addColumn(((JCheckBoxMenuItem)actionEvent.getSource()).getText());
                }
            } else if (string.equals("show-all-command")) {
                ClusterTable.this.showAllColumns();
            } else if (string.equals("sort-command")) {
                ClusterTable.this.model.sortBy(((JRadioButtonMenuItem)actionEvent.getSource()).getText());
            } else if (string.equals("modify-command")) {
                ClusterTable.this.modifyClusterAttributes();
            } else if (!string.equals("modify-membership-command")) {
                if (string.equals("go-to-origin-command")) {
                    ClusterTable.this.openClusterNode();
                } else if (string.equals("launch-new-command")) {
                    ClusterTable.this.launchNewMevSession();
                } else if (string.equals("cluster-operations-command")) {
                    ClusterTable.this.performClusterOperation(((JMenuItem)actionEvent.getSource()).getText());
                } else if (string.equals("delete-command")) {
                    ClusterTable.this.deleteSelectedRows();
                } else if (string.equals("delete-all-command")) {
                    ClusterTable.this.deleteAllRows();
                } else if (string.equals("save-cluster-command")) {
                    ClusterTable.this.saveCluster();
                } else if (string.equals("import-list-command")) {
                    Cluster cluster = ClusterTable.this.repository.createClusterFromList();
                    if (cluster != null) {
                        ClusterTable.this.addCluster(cluster);
                    }
                } else if (string.equals("submit-list-command")) {
                    ClusterTable.this.submitCluster();
                }
            }
        }
    }

    public class ClusterCellEditor
    implements TableCellEditor {
        JTextArea textArea;
        EventListenerList list = new EventListenerList();

        public ClusterCellEditor(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.list.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = ClusterTable.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof JTextArea) {
                this.textArea.setText(((JTextArea)object).getText());
                this.textArea.selectAll();
                this.textArea.setCaretPosition(0);
                return this.textArea;
            }
            return (Component)object;
        }

        public void cancelCellEditing() {
            this.textArea = null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public Object getCellEditorValue() {
            return this.textArea;
        }

        public boolean stopCellEditing() {
            if (this.textArea != null) {
                ClusterTable.this.repository.getCluster(ClusterTable.this.model.getClusterSerialNumber(ClusterTable.this.table.getSelectedRow())).setClusterDescription(this.textArea.getText());
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }
    }

    public class TableListener
    implements TableModelListener,
    MouseListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                int n = ClusterTable.this.table.getSelectedColumn();
                int n2 = ClusterTable.this.table.getSelectedRow();
                if (!ClusterTable.this.model.isLegalRow(n2) || !ClusterTable.this.model.isLegalColumn(n)) {
                    return;
                }
                if (ClusterTable.this.table.getColumnClass(n) == (class$java$awt$Color == null ? (class$java$awt$Color = ClusterTable.class$("java.awt.Color")) : class$java$awt$Color)) {
                    ClusterTable.this.modifyColor(n2, n);
                } else if (ClusterTable.this.table.getColumnClass(n) == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClusterTable.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    ClusterTable.this.modifyShowColor(n2, n);
                }
            } else if (mouseEvent.isPopupTrigger()) {
                int n = ClusterTable.this.menu.getComponentCount();
                int n3 = ClusterTable.this.table.getSelectedRowCount();
                int[] nArray = ClusterTable.this.table.getSelectedRows();
                if (n3 < 1) {
                    return;
                }
                ClusterTable.this.enableAllMenuItems();
                for (int i = 0; i < n; ++i) {
                    String string;
                    Component component = ClusterTable.this.menu.getComponent(i);
                    if (component instanceof JMenuItem) {
                        JMenuItem jMenuItem = (JMenuItem)component;
                        string = jMenuItem.getText();
                        if (n3 != 1 && string.equals("Modify Attributes")) {
                            component.setEnabled(false);
                        }
                        if (n3 != 1 && string.equals("Save Cluster")) {
                            component.setEnabled(false);
                        }
                        if (n3 < 2 && string.equals("Cluster Operations")) {
                            component.setEnabled(false);
                        }
                        if (n3 != 1 && string.equals("Modify Cluster")) {
                            component.setEnabled(false);
                        }
                        if (n3 != 1 && string.equals("Open/Launch")) {
                            ((JMenu)jMenuItem).getMenuComponent(0).setEnabled(false);
                            continue;
                        }
                        if (!string.equals("Open/Launch") || ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(nArray[0])).getSource().equals("Algorithm")) continue;
                        ((JMenu)jMenuItem).getMenuComponent(0).setEnabled(false);
                        continue;
                    }
                    if (!(component instanceof JMenu)) continue;
                    JMenu jMenu = (JMenu)component;
                    string = jMenu.getText();
                    if (n3 != 1 && (string.equals("Modify Cluster") || string.equals("Open/Launch"))) {
                        jMenu.setEnabled(false);
                        continue;
                    }
                    if (string.equals("Open/Lanuch") && !ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(nArray[0])).getSource().equals("Algorithm")) {
                        jMenu.getMenuComponent(1).setEnabled(false);
                        continue;
                    }
                    jMenu.setEnabled(true);
                }
                ClusterTable.this.menu.show(ClusterTable.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = ClusterTable.this.menu.getComponentCount();
                int n2 = ClusterTable.this.table.getSelectedRowCount();
                int[] nArray = ClusterTable.this.table.getSelectedRows();
                if (n2 < 1) {
                    return;
                }
                ClusterTable.this.enableAllMenuItems();
                for (int i = 0; i < n; ++i) {
                    String string;
                    Component component = ClusterTable.this.menu.getComponent(i);
                    if (component instanceof JMenuItem) {
                        JMenuItem jMenuItem = (JMenuItem)component;
                        string = jMenuItem.getText();
                        if (n2 != 1 && string.equals("Modify Attributes")) {
                            component.setEnabled(false);
                        }
                        if (n2 != 1 && string.equals("Save Cluster")) {
                            component.setEnabled(false);
                        }
                        if (n2 < 2 && string.equals("Cluster Operations")) {
                            component.setEnabled(false);
                        }
                        if (n2 != 1 && string.equals("Modify Cluster")) {
                            component.setEnabled(false);
                        }
                        if (n2 != 1 && string.equals("Open/Launch")) {
                            ((JMenu)jMenuItem).getMenuComponent(0).setEnabled(false);
                            continue;
                        }
                        if (!string.equals("Open/Launch") || ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(nArray[0])).getSource().equals("Algorithm")) continue;
                        ((JMenu)jMenuItem).getMenuComponent(0).setEnabled(false);
                        continue;
                    }
                    if (!(component instanceof JMenu)) continue;
                    JMenu jMenu = (JMenu)component;
                    string = jMenu.getText();
                    if (n2 != 1 && (string.equals("Modify Cluster") || string.equals("Open/Launch"))) {
                        jMenu.setEnabled(false);
                        continue;
                    }
                    if (string.equals("Open/Lanuch") && !ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(nArray[0])).getSource().equals("Algorithm")) {
                        jMenu.getMenuComponent(1).setEnabled(false);
                        continue;
                    }
                    jMenu.setEnabled(true);
                }
                ClusterTable.this.menu.show(ClusterTable.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }

    public class ClusterCellRenderer
    implements TableCellRenderer {
        private JPanel colorPanel = new JPanel();
        private JLabel label;
        private JTextArea textArea;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.colorPanel.setBackground((Color)object);
                return this.colorPanel;
            }
            if (object instanceof JLabel) {
                this.label = (JLabel)object;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ClusterTable.this.table.isRowSelected(n)) {
                    this.label.setBackground(ClusterTable.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (object instanceof JTextArea) {
                this.textArea = (JTextArea)object;
                if (ClusterTable.this.table.isRowSelected(n)) {
                    this.textArea.setBackground(ClusterTable.this.table.getSelectionBackground());
                }
                return this.textArea;
            }
            if (object instanceof Boolean) {
                System.out.println("Handle Boolean");
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setBackground(Color.white);
                jCheckBox.setHorizontalAlignment(0);
                jCheckBox.setSelected((Boolean)object);
                return jCheckBox;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] rowData;
        private Row[] rows;
        private int colToSort = 0;

        public ClusterTableModel(Vector vector, Vector vector2) {
            this.initializeHeader(vector);
            this.initializeData(vector2);
            this.rows = new Row[this.rowData.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        private void initializeHeader(Vector vector) {
            this.columnNames = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.columnNames[i] = (String)vector.elementAt(i);
            }
        }

        private void initializeData(Vector vector) {
            int n = 0;
            this.rowData = new Object[vector.size() / this.columnNames.length][this.columnNames.length];
            while (n < vector.size()) {
                for (int i = 0; i < this.columnNames.length; ++i) {
                    this.rowData[n / this.columnNames.length][i] = vector.elementAt(n);
                    ++n;
                }
            }
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.rowData.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.rowData[this.rows[n].index][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 7 || n2 == 8;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.rowData[this.rows[n].index][n2] = object;
            this.fireTableChanged(new TableModelEvent(this, n, n, n2));
        }

        public Class getColumnClass(int n) {
            if (n == 7) {
                return class$java$awt$Color == null ? (class$java$awt$Color = ClusterTable.class$("java.awt.Color")) : class$java$awt$Color;
            }
            if (n == 4 || n == 5) {
                return class$java$lang$String == null ? (class$java$lang$String = ClusterTable.class$("java.lang.String")) : class$java$lang$String;
            }
            if (n == 8) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClusterTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = ClusterTable.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
        }

        public int getClusterSerialNumber(int n) {
            if (this.isLegalRow(n)) {
                return Integer.parseInt(((JLabel)this.getValueAt(n, 0)).getText());
            }
            return -1;
        }

        public boolean isLegalRow(int n) {
            return n > -1 && n < this.getRowCount();
        }

        public boolean isLegalColumn(int n) {
            return n > -1 && n < this.getColumnCount();
        }

        public void sort(int n) {
            this.colToSort = n;
            Arrays.sort(this.rows);
            ClusterTable.this.table.repaint();
        }

        public void sortBy(String string) {
            int n = this.getColumnIndex(string);
            if (n >= 0) {
                this.sort(n);
                this.colToSort = n;
            }
        }

        private int getColumnIndex(String string) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (this.columnNames[i] != string) continue;
                return i;
            }
            return 0;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void hide(String string) {
            ClusterTable.this.table.removeColumn(ClusterTable.this.table.getColumn(string));
        }

        public void addColumn(String string) {
            ClusterTable.this.table.addColumn(new TableColumn(this.getColumnIndex(string)));
            this.moveColumnFromEnd(this.getColumnIndex(string));
        }

        public void addRow(Vector vector) {
            int n;
            int n2;
            Object[][] objectArray = new Object[this.rowData.length + 1][this.columnNames.length];
            for (n2 = 0; n2 < this.rowData.length; ++n2) {
                for (n = 0; n < this.rowData[n2].length; ++n) {
                    objectArray[n2][n] = this.rowData[n2][n];
                }
            }
            for (n2 = 0; n2 < this.columnNames.length; ++n2) {
                objectArray[objectArray.length - 1][n2] = vector.elementAt(n2);
            }
            this.rowData = objectArray;
            Row[] rowArray = new Row[this.rowData.length];
            for (n = 0; n < this.rows.length; ++n) {
                rowArray[n] = this.rows[n];
            }
            rowArray[rowArray.length - 1] = new Row();
            rowArray[rowArray.length - 1].index = rowArray.length - 1;
            this.rows = rowArray;
            this.fireTableRowsInserted(this.rows.length - 1, this.rows.length - 1);
        }

        public void removeRow(int n) {
            int n2;
            int n3 = this.rows[n].index;
            Object[][] objectArray = new Object[this.rowData.length - 1][this.rowData[0].length];
            int n4 = -1;
            for (int i = 0; i < this.rowData.length; ++i) {
                if (i == n3) continue;
                ++n4;
                for (n2 = 0; n2 < this.rowData[i].length; ++n2) {
                    objectArray[n4][n2] = this.rowData[i][n2];
                }
            }
            this.rowData = objectArray;
            Row[] rowArray = new Row[this.rowData.length];
            n4 = -1;
            for (n2 = 0; n2 < this.rows.length; ++n2) {
                if (n2 == n3) continue;
                rowArray[++n4] = this.rows[n2];
                rowArray[n4].index = n4;
            }
            this.rows = rowArray;
            this.fireTableRowsDeleted(n3, n3);
        }

        public void removeAllRows() {
            int n = this.rows.length;
            this.rowData = new Object[0][0];
            this.rows = new Row[0];
            this.fireTableRowsDeleted(0, n);
        }

        private void moveColumnFromEnd(int n) {
            for (int i = ClusterTable.this.table.getColumnCount() - 1; i > n; --i) {
                ClusterTable.this.table.moveColumn(i - 1, i);
            }
        }

        public int getSerialNumber(int n) {
            JLabel jLabel = (JLabel)this.rowData[this.rows[n].index][0];
            return Integer.parseInt(jLabel.getText());
        }

        public void setClusterColor(int n, Color color) {
            int n2 = this.rows[n].index;
            int n3 = this.getColumnIndex("Color");
            this.setValueAt(color, n2, n3);
            this.fireTableCellUpdated(n, n3);
        }

        public void setClusterLabel(int n, String string) {
            int n2 = this.rows[n].index;
            int n3 = this.getColumnIndex("Cluster Label");
            this.setValueAt(string, n2, n3);
            this.fireTableCellUpdated(n, n3);
        }

        public void setClusterDescription(int n, String string) {
            int n2 = this.rows[n].index;
            int n3 = this.getColumnIndex("Remarks");
            this.setValueAt(string, n2, n3);
            this.fireTableCellUpdated(n, n3);
        }

        private class Row
        implements Comparable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object object) {
                Row row = (Row)object;
                Object object2 = ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort];
                Object object3 = ClusterTableModel.this.rowData[row.index][ClusterTableModel.this.colToSort];
                if (ClusterTable.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Serial #") || ClusterTable.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Size")) {
                    Integer n = new Integer(((JLabel)ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort]).getText());
                    return n.compareTo(new Integer(((JLabel)object3).getText()));
                }
                if (object2 instanceof Comparable) {
                    return ((Comparable)object2).compareTo(object3);
                }
                if (object2 instanceof JLabel) {
                    this.myString = ((JLabel)object2).getText();
                    this.otherString = ((JLabel)object3).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - row.index;
            }
        }
    }
}

