/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.tigr.microarray.mev.file.agilent.AgilentFile;
import org.tigr.microarray.mev.file.agilent.EightFeature;
import org.tigr.microarray.mev.file.agilent.Reader;
import org.tigr.microarray.mev.file.agilent.TopFeature;
import org.tigr.microarray.mev.file.agilent.UnrecognizedPatternException;

public class MeVotation {
    static String TAB = "\t";
    static String END_LINE = "\r\n";
    private Vector vLine;
    private AgilentFile af;

    public void parseAgilentPattern(File file, String string) throws UnrecognizedPatternException, IOException {
        Reader reader = new Reader();
        reader.readFile(file);
        this.vLine = reader.getVNullLine(string);
        this.af = new AgilentFile(this.vLine);
    }

    public String getFileString() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.af.getVAgilentFeature();
        if (this.af.getPatternType() == 8) {
            stringBuffer.append("UID\tR\tC\tGeneName\tDescription\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                EightFeature eightFeature = (EightFeature)vector.elementAt(i);
                if (eightFeature.getControlType().equals("ignore")) continue;
                stringBuffer.append(eightFeature.getRefNumber());
                stringBuffer.append(TAB);
                stringBuffer.append(eightFeature.getRow());
                stringBuffer.append(TAB);
                stringBuffer.append(eightFeature.getCol());
                stringBuffer.append(TAB);
                stringBuffer.append(this.nullify(eightFeature.getGeneName()));
                stringBuffer.append(TAB);
                stringBuffer.append(this.nullify(eightFeature.getDesc()));
                stringBuffer.append(END_LINE);
            }
        } else if (this.af.getPatternType() == 9) {
            stringBuffer.append("UID\tR\tC\tGeneName\tDescription\tTopHit\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                TopFeature topFeature = (TopFeature)vector.elementAt(i);
                if (topFeature.getControlType().equals("ignore")) continue;
                stringBuffer.append(topFeature.getRefNumber());
                stringBuffer.append(TAB);
                stringBuffer.append(topFeature.getRow());
                stringBuffer.append(TAB);
                stringBuffer.append(topFeature.getCol());
                stringBuffer.append(TAB);
                stringBuffer.append(this.nullify(topFeature.getName()));
                stringBuffer.append(TAB);
                stringBuffer.append(this.nullify(topFeature.getDesc()));
                stringBuffer.append(TAB);
                stringBuffer.append(this.nullify(TopFeature.parseAccession(topFeature.getTopHit())));
                stringBuffer.append(END_LINE);
            }
        } else {
            System.out.println("SomethingReallyFunky");
        }
        return stringBuffer.toString();
    }

    private String nullify(String string) {
        if (string == null) {
            return "null";
        }
        if (string.equals("")) {
            return "null";
        }
        if (string.equals("NA")) {
            return "null";
        }
        return string;
    }
}

