/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class CentroidEntropyRankingInitDialog
extends AlgorithmDialog {
    private int result;
    private JTextField numClustersField;
    private JTextField minClusterSizeField;
    private JRadioButton centroidVarianceButton;
    private JRadioButton centroidEntropyButton;

    public CentroidEntropyRankingInitDialog(JFrame jFrame) {
        super(jFrame, "Centroid Variance or Entropy Ranking Cluster Selection", true);
        ParameterPanel parameterPanel = new ParameterPanel("Selection Parameters");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel("Desired Number of Clusters");
        this.numClustersField = new JTextField("3", 5);
        JLabel jLabel2 = new JLabel("Minimum Cluster Size (# genes)");
        this.minClusterSizeField = new JTextField("10");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.centroidVarianceButton = new JRadioButton("Rank Clusters on Centroid Variance", true);
        this.centroidVarianceButton.setOpaque(false);
        buttonGroup.add(this.centroidVarianceButton);
        this.centroidVarianceButton.setFocusPainted(false);
        this.centroidEntropyButton = new JRadioButton("Rank Clusters on Centroid Entropy");
        this.centroidEntropyButton.setOpaque(false);
        buttonGroup.add(this.centroidEntropyButton);
        this.centroidEntropyButton.setFocusPainted(false);
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        parameterPanel.add((Component)this.numClustersField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        parameterPanel.add((Component)jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 10), 0, 0));
        parameterPanel.add((Component)this.minClusterSizeField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
        parameterPanel.add((Component)this.centroidVarianceButton, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)this.centroidEntropyButton, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 10, 0), 0, 0));
        this.addContent((Component)parameterPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getClusterNumber() {
        return Integer.parseInt(this.numClustersField.getText());
    }

    public int getClusterSize() {
        return Integer.parseInt(this.minClusterSizeField.getText());
    }

    public boolean isVarianceBased() {
        return this.centroidVarianceButton.isSelected();
    }

    private void resetControls() {
        this.numClustersField.setText("3");
        this.minClusterSizeField.setText("10");
        this.centroidVarianceButton.setSelected(true);
    }

    private boolean validateParameters() {
        int n;
        int n2;
        int n3 = 0;
        try {
            n2 = Integer.parseInt(this.numClustersField.getText());
            ++n3;
            n = Integer.parseInt(this.minClusterSizeField.getText());
            ++n3;
        }
        catch (Exception exception) {
            if (n3 == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The cluster number should be an integer > 0.\nPlease enter a new value.", "Parameter Type Mismatch", 0);
                this.numClustersField.selectAll();
                this.numClustersField.grabFocus();
                return false;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "The minimum cluster population should be an integer > 0.\nPlease enter a new value.", "Parameter Type Mismatch", 0);
            this.minClusterSizeField.selectAll();
            this.minClusterSizeField.grabFocus();
            return false;
        }
        if (n2 < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The cluster number should be an integer > 0.\nPlease enter a new value greater than zero.", "Parameter Value Error", 0);
            this.numClustersField.selectAll();
            this.numClustersField.grabFocus();
            return false;
        }
        if (n < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The minimum cluster size should be an integer > 0.\nPlease enter a new value greater than zero.", "Parameter Value Error", 0);
            this.numClustersField.selectAll();
            this.numClustersField.grabFocus();
            return false;
        }
        return true;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (CentroidEntropyRankingInitDialog.this.validateParameters()) {
                    CentroidEntropyRankingInitDialog.this.dispose();
                    CentroidEntropyRankingInitDialog.this.result = 0;
                }
                return;
            }
            if (string.equals("cancel-command")) {
                CentroidEntropyRankingInitDialog.this.result = 2;
                CentroidEntropyRankingInitDialog.this.dispose();
                return;
            }
            if (string.equals("reset-command")) {
                CentroidEntropyRankingInitDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)CentroidEntropyRankingInitDialog.this), "Centroid Variance/Entropy Ranking Cluster Selection");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            CentroidEntropyRankingInitDialog.this.result = -1;
            CentroidEntropyRankingInitDialog.this.dispose();
        }
    }
}

