/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTreeRenderer;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptNode;
import org.tigr.util.FloatMatrix;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScriptTree
extends JTree {
    private ScriptDocument document;
    private ScriptManager manager;
    private ScriptTreeRenderer renderer = new ScriptTreeRenderer();
    private DataNode primaryDataRoot;
    private Hashtable dataNodeHash;
    private boolean resetWidth = true;

    public ScriptTree(ScriptDocument scriptDocument, ScriptManager scriptManager) {
        super.setCellRenderer(this.renderer);
        super.setForeground(Color.black);
        super.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(50);
        super.putClientProperty("JTree.lineStyle", "Angled");
        this.document = scriptDocument;
        this.manager = scriptManager;
        this.dataNodeHash = new Hashtable();
        this.constructTree(this.document.getDocument());
        this.scrollAllToVisible();
    }

    public ScriptTree(ScriptTree scriptTree) {
        super.setCellRenderer(this.renderer);
        super.setForeground(Color.black);
        super.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(50);
        super.putClientProperty("JTree.lineStyle", "Angled");
        this.document = new ScriptDocument(scriptTree.getDocument());
        this.manager = scriptTree.getScriptManager();
        this.dataNodeHash = new Hashtable();
        this.constructTree(this.document.getDocument());
        this.scrollAllToVisible();
    }

    public ScriptDocument getDocument() {
        return this.document;
    }

    public ScriptManager getScriptManager() {
        return this.manager;
    }

    public ScriptTreeRenderer getScriptTreeRenderer() {
        return this.renderer;
    }

    public void highlightAlgSet(DataNode dataNode) {
        this.renderer.highlightAlgSet(dataNode);
    }

    public void clearHighlights() {
        this.renderer.clearHighlights();
    }

    public DataNode getPrimaryDataRoot() {
        return this.primaryDataRoot;
    }

    private void constructTree(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = document.getElementsByTagName("primary_data");
        if (nodeList != null) {
            Element element2 = (Element)nodeList.item(0);
            this.primaryDataRoot = new DataNode(Integer.parseInt(element2.getAttribute("id")), "Primary Data", "primary-data", element2.getAttribute("type"));
            ((DefaultTreeModel)this.getModel()).setRoot(this.primaryDataRoot);
            this.dataNodeHash.put(element2.getAttribute("id"), this.primaryDataRoot);
        }
        NodeList nodeList2 = document.getElementsByTagName("alg_set");
        int n = nodeList2.getLength();
        int n2 = 0;
        for (int i = 0; n2 < n && i < 100; ++i) {
            Element element3 = this.getAlgSet(nodeList2, i);
            if (element3 == null) continue;
            this.addAlgSet(element3);
            ++n2;
        }
    }

    private boolean addAlgSet(Element element) {
        NodeList nodeList = element.getElementsByTagName("algorithm");
        int n = nodeList.getLength();
        int n2 = 0;
        for (int i = 0; n2 < n && i < 100; ++i) {
            Element element2 = this.getAlgorithmElement(nodeList, i);
            if (element2 == null) continue;
            this.addAlgorithm(element2, element.getAttribute("input_data_ref"));
            ++n2;
        }
        return true;
    }

    private boolean addAlgorithm(Element element, String string) {
        int n;
        int n2;
        String string2 = element.getAttribute("alg_name");
        String string3 = element.getAttribute("alg_type");
        try {
            n2 = Integer.parseInt(element.getAttribute("alg_id"));
            n = Integer.parseInt(element.getAttribute("input_data_ref"));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return false;
        }
        AlgorithmNode algorithmNode = new AlgorithmNode(string2, n2, n, string3);
        AlgorithmData algorithmData = this.constructAlgorithmData(element);
        algorithmNode.setAlgorithmData(algorithmData);
        this.appendOutputNodes(algorithmNode, element);
        this.appendAlgorithmNode(algorithmNode, string);
        return true;
    }

    private void appendAlgorithmNode(AlgorithmNode algorithmNode, String string) {
        DataNode dataNode = (DataNode)this.dataNodeHash.get(string);
        if (dataNode != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.insertNodeInto(algorithmNode, dataNode, dataNode.getChildCount());
        } else {
            System.out.println("null data node can't append");
        }
    }

    private Element getAlgSet(NodeList nodeList, int n) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("set_id").equals(String.valueOf(n))) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    private Element getAlgorithmElement(NodeList nodeList, int n) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("alg_id").equals(String.valueOf(n))) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    public AlgorithmSet[] getAlgorithmSets() {
        DataNode dataNode = (DataNode)this.getModel().getRoot();
        Experiment experiment = this.manager.getCurrentExperiment();
        Vector<AlgorithmSet> vector = new Vector<AlgorithmSet>();
        Enumeration<TreeNode> enumeration = dataNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ScriptNode scriptNode = (ScriptNode)enumeration.nextElement();
            if (!(scriptNode instanceof DataNode) || scriptNode.isLeaf()) continue;
            AlgorithmSet algorithmSet = new AlgorithmSet();
            if (scriptNode.getParent() == null) {
                algorithmSet.setExperiment(experiment);
            }
            algorithmSet.setDataNode((DataNode)scriptNode);
            for (int i = 0; i < scriptNode.getChildCount(); ++i) {
                ScriptNode scriptNode2 = (ScriptNode)scriptNode.getChildAt(i);
                if (!(scriptNode2 instanceof AlgorithmNode)) continue;
                algorithmSet.addAlgorithmNode((AlgorithmNode)scriptNode2);
            }
            vector.add(algorithmSet);
        }
        AlgorithmSet[] algorithmSetArray = new AlgorithmSet[vector.size()];
        for (int i = 0; i < algorithmSetArray.length; ++i) {
            algorithmSetArray[i] = (AlgorithmSet)vector.elementAt(i);
        }
        return algorithmSetArray;
    }

    public DataNode getDataNodeNamed(String string) {
        DataNode dataNode = (DataNode)this.getModel().getRoot();
        Enumeration<TreeNode> enumeration = dataNode.breadthFirstEnumeration();
        boolean bl = false;
        ScriptNode scriptNode = null;
        while (!bl && enumeration.hasMoreElements()) {
            scriptNode = (ScriptNode)enumeration.nextElement();
            if (!scriptNode.toString().equals(string)) continue;
            bl = true;
        }
        return (DataNode)scriptNode;
    }

    private AlgorithmData constructAlgorithmData(Element element) {
        AlgorithmData algorithmData = new AlgorithmData();
        NodeList nodeList = element.getElementsByTagName("plist");
        if (nodeList != null && nodeList.getLength() > 0) {
            this.appendParameters(algorithmData, (Element)nodeList.item(0));
        }
        if ((nodeList = element.getElementsByTagName("mlist")) != null && nodeList.getLength() > 0) {
            this.appendMatrices(algorithmData, (Element)nodeList.item(0));
        }
        return algorithmData;
    }

    private void appendParameters(AlgorithmData algorithmData, Element element) {
        NodeList nodeList = element.getElementsByTagName("param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("key");
            String string2 = element2.getAttribute("value");
            algorithmData.addParam(string, string2);
        }
    }

    private void appendMatrices(AlgorithmData algorithmData, Element element) {
        NodeList nodeList = element.getElementsByTagName("matrix");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.addMatrix(algorithmData, (Element)nodeList.item(i));
        }
    }

    private void addMatrix(AlgorithmData algorithmData, Element element) {
        int n;
        int n2;
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("type");
        String string3 = element.getAttribute("row_dim");
        String string4 = element.getAttribute("col_dim");
        try {
            n2 = Integer.parseInt(string3);
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        NodeList nodeList = element.getElementsByTagName("element");
        int n3 = nodeList.getLength();
        if (string2.equalsIgnoreCase("int-array")) {
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                Element element2 = (Element)nodeList.item(i);
                nArray[Integer.parseInt((String)element2.getAttribute((String)"row"))] = Integer.parseInt(element2.getAttribute("value"));
            }
            algorithmData.addIntArray(string, nArray);
        } else if (string2.equalsIgnoreCase("FloatMatrix")) {
            FloatMatrix floatMatrix = new FloatMatrix(n2, n);
            if (n3 == n2 * n) {
                for (int i = 0; i < n3; ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    int n4 = Integer.parseInt(element3.getAttribute("row"));
                    int n5 = Integer.parseInt(element3.getAttribute("col"));
                    float f = Float.parseFloat(element3.getAttribute("value"));
                    floatMatrix.set(n4, n5, f);
                }
                algorithmData.addMatrix(string, floatMatrix);
            }
        } else if (string2.equalsIgnoreCase("String-array")) {
            String[] stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                Element element4 = (Element)nodeList.item(i);
                stringArray[Integer.parseInt((String)element4.getAttribute((String)"row"))] = element4.getAttribute("value");
            }
            algorithmData.addStringArray(string, stringArray);
        }
    }

    private void appendOutputNodes(AlgorithmNode algorithmNode, Element element) {
        NodeList nodeList = element.getElementsByTagName("output_data");
        if (nodeList == null || nodeList.getLength() < 1) {
            return;
        }
        Element element2 = (Element)nodeList.item(0);
        String string = element2.getAttribute("output_class");
        nodeList = element2.getElementsByTagName("data_node");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            int n = Integer.parseInt(element2.getAttribute("data_node_id"));
            DataNode dataNode = new DataNode(n, element2.getAttribute("name"), string);
            this.dataNodeHash.put(String.valueOf(n), dataNode);
            algorithmNode.add(dataNode);
        }
    }

    public boolean setDataRoot(DataNode dataNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.setRoot(dataNode);
        return true;
    }

    public ScriptNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        ScriptNode scriptNode = (ScriptNode)treePath.getLastPathComponent();
        return scriptNode;
    }

    public void scrollAllToVisible() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.isLeaf()) continue;
            Object[] objectArray = defaultMutableTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            this.scrollPathToVisible(treePath);
        }
    }

    public void addNewAlgorithmToDataNode(DataNode dataNode) {
        String string = dataNode.getDataOutputClass();
        AlgorithmData algorithmData = this.manager.getAlgorithm(string);
        if (algorithmData != null) {
            if (this.document.appendAlgorithm(algorithmData, dataNode.getID())) {
                try {
                    this.updateTree();
                    this.scrollAllToVisible();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                System.out.println("doc base didn't append");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlgorithm(AlgorithmData algorithmData, DataNode dataNode) {
        ScriptTree scriptTree = this;
        synchronized (scriptTree) {
            if (algorithmData != null) {
                if (this.document.appendAlgorithm(algorithmData, dataNode.getID())) {
                    try {
                        this.updateTree();
                        this.scrollAllToVisible();
                        this.validate();
                        this.validateTree();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    System.out.println("doc base didn't append");
                }
            }
        }
    }

    public void updateTree() {
        ((DefaultTreeModel)this.getModel()).setRoot(null);
        this.constructTree(this.document.getDocument());
        this.scrollAllToVisible();
    }

    public void removeAlgorithm(AlgorithmNode algorithmNode) {
        this.document.removeAlgorithm(algorithmNode);
    }

    private class Builder
    implements Runnable {
        DataNode parentNode;
        AlgorithmData data;

        public Builder(DataNode dataNode, AlgorithmData algorithmData) {
            this.parentNode = dataNode;
            this.data = algorithmData;
        }

        public void run() {
            if (ScriptTree.this.document.appendAlgorithm(this.data, this.parentNode.getID())) {
                try {
                    ScriptTree.this.updateTree();
                    ScriptTree.this.scrollAllToVisible();
                    ScriptTree.this.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                System.out.println("doc base didn't append");
            }
        }
    }
}

