/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication;

import org.tigr.remote.RemoteException;
import org.tigr.remote.protocol.Request;
import org.tigr.remote.protocol.Response;
import org.tigr.remote.protocol.communication.RequestMessage;
import org.tigr.remote.protocol.communication.ResponseMessage;
import org.tigr.remote.protocol.communication.Transport;
import org.tigr.remote.protocol.parser.Parser;
import org.tigr.remote.protocol.serializer.RequestSerializer;
import org.tigr.util.ConfMap;

public class Presentation {
    private Transport m_transport;
    private ConfMap m_config;

    public Presentation(ConfMap confMap, Transport transport) {
        this.m_transport = transport;
        this.m_config = confMap;
    }

    public Response getResponse() throws RemoteException {
        Response response = null;
        ResponseMessage responseMessage = this.m_transport.getResponse();
        Parser parser = Parser.createParser(this.m_config);
        response = parser.parseResponse(responseMessage.getStream());
        this.m_transport.finalizeReceive();
        return response;
    }

    public void sendRequest(Request request) throws RemoteException {
        RequestMessage requestMessage = new RequestMessage("TIGR-MEV", "Calculation service");
        RequestMessage requestMessage2 = this.m_transport.sendRequest(requestMessage);
        RequestSerializer requestSerializer = RequestSerializer.createSerializer(this.m_config);
        requestSerializer.serializeRequest(request, requestMessage2.getStream());
        this.m_transport.finalizeSend();
    }
}

