/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication.http;

import org.tigr.remote.RemoteException;
import org.tigr.remote.communication.ClientCommunicator;
import org.tigr.remote.communication.JobControl;
import org.tigr.remote.protocol.FinishedJob;
import org.tigr.remote.protocol.Request;
import org.tigr.remote.protocol.Response;
import org.tigr.remote.protocol.StartingJob;
import org.tigr.remote.protocol.StopJob;
import org.tigr.remote.protocol.communication.Presentation;
import org.tigr.remote.protocol.communication.http.HttpTransport;
import org.tigr.util.ConfMap;

public class Communicator
implements ClientCommunicator {
    private ConfMap m_conf;
    private Presentation m_presentation;
    private int i = 0;

    public Communicator(ConfMap confMap) throws RemoteException {
        this.m_conf = confMap;
        this.m_presentation = new Presentation(confMap, new HttpTransport(confMap));
    }

    public JobControl postJob(StartingJob startingJob) throws RemoteException {
        Request request = new Request(startingJob);
        this.m_presentation.sendRequest(request);
        return new SyncJobControl(this, startingJob.getId(), this.m_conf.getInt("remote.polling", 10));
    }

    protected FinishedJob getResult() throws RemoteException {
        Response response = this.m_presentation.getResponse();
        return response.getJob();
    }

    public String getNewJobId() {
        return ++this.i + "";
    }

    private class SyncJobControl
    implements JobControl {
        private Communicator m_comm;
        private String m_jobId;
        private int m_polling;
        private FinishedJob m_result = null;

        public SyncJobControl(Communicator communicator2, String string, int n) {
            this.m_comm = communicator2;
            this.m_jobId = string;
            this.m_polling = n;
        }

        private void waitForReply() throws RemoteException {
            while (this.m_result == null) {
                try {
                    Thread.sleep(this.m_polling * 1000);
                }
                catch (InterruptedException interruptedException) {
                    throw new RemoteException("Thread was interrupted", interruptedException);
                }
                this.m_result = this.m_comm.getResult();
            }
        }

        public void terminate() throws RemoteException {
            this.m_comm.postJob(new StopJob(this.getJobId()));
        }

        public FinishedJob getResult() throws RemoteException {
            this.waitForReply();
            if (this.m_result == null) {
                throw new RemoteException("No result available");
            }
            FinishedJob finishedJob = this.m_result;
            this.m_result = null;
            return finishedJob;
        }

        private String getJobId() {
            return this.m_jobId;
        }
    }
}

