/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.seqdoc;

import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.data.sequence.SequenceListener;

public class SeqWrap
implements SequenceListener {
    private int start = 0;
    private int length = 0;
    private Sequence seq;

    public SeqWrap(int offset, Sequence seq) {
        if (seq == null) {
            throw new NullPointerException("Cannot call SeqWrap(" + this.start + "," + seq + ")");
        }
        this.start = offset;
        this.seq = seq;
        this.length = seq.getField("sequence").toString().length();
        seq.addListener(this);
    }

    public int getStart() {
        return this.start;
    }

    public Object getField(String key) {
        return this.seq.getField(key);
    }

    public void setField(String key, Object value) {
        this.seq.setField(key, value);
    }

    public Sequence subseq(int start) {
        return this.seq.subseq(start);
    }

    public Sequence subseq(int start, int end) {
        return this.seq.subseq(start, end);
    }

    public void setStart(int offset) {
        this.start = offset;
    }

    public Sequence getSequence() {
        return this.seq;
    }

    public void addListener(SequenceListener listener) {
        this.seq.addListener(listener);
    }

    public void sequenceChanged(Sequence sequence, String key) {
    }

    protected void finalize() {
        this.seq.removeListener(this);
    }

    public boolean equals(Object test) {
        return test instanceof SeqWrap ? this.seq.equals(((SeqWrap)test).seq) : this.seq.equals(test);
    }
}

