/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.plugintypes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;

public abstract class DataFormat
extends FileFilter {
    public static void addFormats(JFileChooser filechooser, String defaultFormat) {
        DataFormat selected = null;
        DataFormat currentFormat = null;
        for (PluginWrapper plugin : PluginLoader.getPlugins(DataFormat.class)) {
            currentFormat = (DataFormat)plugin.create();
            if (currentFormat == null) continue;
            filechooser.addChoosableFileFilter(currentFormat);
            if (!currentFormat.getName().equals(defaultFormat)) continue;
            selected = currentFormat;
        }
        if (selected != null) {
            filechooser.setFileFilter(selected);
        }
    }

    public Sequence[] readFile(File file) throws IOException {
        Sequence[] result = new Sequence[]{};
        Object stream = null;
        if (file != null && file.exists() && file.isFile() && file.length() > 0L) {
            result = this.translateFrom(new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file)))));
        }
        return result;
    }

    public void writeFile(File file, Sequence[] data) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (Sequence line : data) {
            writer.write(this.translateTo(line));
        }
        writer.flush();
        writer.close();
    }

    public String getName() {
        return "";
    }

    public abstract String translateTo(Sequence var1);

    public abstract Sequence[] translateFrom(BufferedReader var1) throws IOException;

    public abstract boolean isFormat(Reader var1);

    public static DataFormat getFormat(String hashname) {
        DataFormat found = null;
        DataFormat currentFormat = null;
        for (PluginWrapper plugin : PluginLoader.getPlugins(DataFormat.class)) {
            if (hashname == null || plugin == null || (currentFormat = (DataFormat)plugin.create()) == null || !hashname.equalsIgnoreCase(currentFormat.getName())) continue;
            found = currentFormat;
            break;
        }
        return found;
    }

    public static Sequence[] auto(File file) {
        Sequence[] result = new Sequence[]{};
        try {
            result = DataFormat.auto(new FileInputStream(file));
        }
        catch (IOException ioe) {
            BLMain.error("Bad file: " + file.getAbsolutePath(), "DataFormat.auto");
        }
        return result;
    }

    public static Sequence[] auto(InputStream stream) {
        return DataFormat.auto(new BufferedReader(new InputStreamReader(new BufferedInputStream(stream))));
    }

    private static Sequence[] auto(BufferedReader data) {
        Sequence[] result = new Sequence[]{};
        DataFormat currentFormat = null;
        for (PluginWrapper plugin : PluginLoader.getPlugins(DataFormat.class)) {
            if (data == null || plugin == null) continue;
            try {
                currentFormat = (DataFormat)plugin.create();
                if (currentFormat == null || !currentFormat.isFormat(data)) continue;
                result = currentFormat.translateFrom(data);
                break;
            }
            catch (IOException e) {
            }
        }
        return result;
    }
}

