/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.properties;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.core.plugintypes.PropertiesExtension;
import org.biolegato.core.properties.PropertiesListener;
import org.biolegato.core.properties.PropertiesNumber;

public class BLProperties
extends Properties {
    private Hashtable<String, LinkedList<PropertiesListener>> propertiesListeners = new Hashtable();
    private static final long serialVersionUID = 7526472295622776168L;
    private static LinkedList<PropertiesExtension> propertyExtensionList = new LinkedList();

    public BLProperties() {
        super(new Properties(){
            private static final long serialVersionUID = 7526472295622777034L;
            {
                this.setProperty("debug", "false");
                this.setProperty("plugins", ProgramWindow.PROGRAM_DIR + File.separator + "plugins");
                this.setProperty("temp", ProgramWindow.CURRENT_DIR);
                this.setProperty("font.size", "12");
                this.setProperty("font.type", "Monospace");
                this.setProperty("shell.name", System.getProperty("os.name").startsWith("Windows 9") || System.getProperty("os.name").equals("Windows ME") ? "command.com" : (System.getProperty("os.name").startsWith("Windows") ? "cmd.exe" : "/bin/sh"));
                this.setProperty("shell.parameter", System.getProperty("os.name").startsWith("Windows") ? "/C" : "-c");
                this.setProperty("user.properties", "true");
                this.setProperty("user.plugins", "true");
                this.setProperty("default.canvas", "Raw");
                this.setProperty("default.fileformat", "genbank");
                this.setProperty("default.sequencename", "New sequence");
            }
        });
        this.reset();
        this.loadPropertiesFile(ProgramWindow.PROGRAM_DIR + File.separator + ".blproperties");
        if (this.getProperty("user.properties").equalsIgnoreCase("true") && System.getProperty("user.home") != null) {
            this.loadPropertiesFile(System.getProperty("user.home") + File.separator + ".blproperties");
        }
    }

    public Object setProperty(String key, String value) {
        key = key.toLowerCase();
        Object result = super.setProperty(key, value);
        LinkedList<PropertiesListener> listenerList = this.propertiesListeners.get(key.toLowerCase());
        if (listenerList != null && !listenerList.isEmpty()) {
            for (PropertiesListener listener : listenerList) {
                listener.propertiesUpdate(key, value);
            }
        }
        return result;
    }

    public String getProperty(String key) {
        String result = super.getProperty(key = key.toLowerCase());
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void addPropertiesListener(String key, PropertiesListener listener) {
        if (!this.propertiesListeners.containsKey(key = key.toLowerCase())) {
            this.propertiesListeners.put(key, new LinkedList());
        }
        this.propertiesListeners.get(key).add(listener);
    }

    private void reset() {
        this.setProperty("GDE.menu", "true");
        this.setProperty("GDE.help.viewer", "$BIRCH/script/gde_help_viewer.csh");
        this.setProperty("GDE.help.path", System.getenv("GDE_HELP_DIR") != null ? System.getenv("GDE_HELP_DIR") : "");
    }

    private void loadPropertiesFile(String fileName) {
        if (new File(fileName).exists()) {
            try {
                this.load(new FileInputStream(fileName));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void showPropertiesWindow(ProgramWindow window) {
        final JDialog propertiesWindow = new JDialog(window);
        Box outerPane = new Box(3);
        Box mainPane = new Box(3);
        JButton changeButton = new JButton(new AbstractAction("Close"){
            private static final long serialVersionUID = 7526472295622777011L;

            public void actionPerformed(ActionEvent e) {
                propertiesWindow.setVisible(false);
            }
        });
        outerPane.add(mainPane);
        outerPane.add(changeButton);
        PropertiesNumber fontChangeBox = new PropertiesNumber(this, "Font size", "font.size", 10, 100);
        mainPane.add(fontChangeBox);
        for (PropertiesExtension ext : propertyExtensionList) {
            ext.propertiesComponent(mainPane);
        }
        propertiesWindow.add(outerPane);
        propertiesWindow.setLocationRelativeTo(window);
        propertiesWindow.pack();
        propertiesWindow.setVisible(true);
    }

    public void addExtension(PropertiesExtension extension) {
        if (extension != null) {
            propertyExtensionList.add(extension);
        }
    }
}

