/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesListener;

public class PropertiesCheckbox
extends JCheckBox
implements ActionListener,
PropertiesListener {
    private String propertyKey;
    private BLProperties properties;

    public PropertiesCheckbox(BLProperties properties, String name, String propertyKey) {
        super(name);
        this.propertyKey = propertyKey;
        this.properties = properties;
        this.setSelected(properties.getProperty(propertyKey).equalsIgnoreCase("true"));
        properties.addPropertiesListener(propertyKey, this);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.properties.setProperty(this.propertyKey, this.isSelected() ? "true" : "false");
    }

    public void propertiesUpdate(String key, String value) {
        if (key.equalsIgnoreCase(this.propertyKey)) {
            this.setSelected(this.properties.getProperty(this.propertyKey).equalsIgnoreCase("true"));
        }
    }
}

