/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;

class AttributeBin
implements ObjectUpdate {
    RenderingAttributesRetained definingRenderingAttributes = null;
    RenderingAttributesRetained newRenderingAttrs = null;
    EnvironmentSet environmentSet = null;
    AttributeBin next = null;
    AttributeBin prev = null;
    TextureBin textureBinList = null;
    ArrayList addTextureBins = new ArrayList();
    ArrayList addTBs = new ArrayList();
    ArrayList removeTBs = new ArrayList();
    boolean onUpdateList = false;
    boolean ignoreVertexColors = false;

    AttributeBin(RenderingAttributesRetained renderingAttributesRetained) {
        this.reset(renderingAttributesRetained);
    }

    void addTextureBin(TextureBin textureBin, RenderBin renderBin) {
        textureBin.attributeBin = this;
        this.addTBs.add(textureBin);
        if (!this.onUpdateList) {
            this.onUpdateList = true;
            renderBin.objUpdateList.add(this);
        }
    }

    boolean equals(RenderingAttributesRetained renderingAttributesRetained) {
        return this.definingRenderingAttributes == renderingAttributesRetained || this.definingRenderingAttributes != null && this.definingRenderingAttributes.equivalent(renderingAttributesRetained);
    }

    void insertTextureBin(TextureBin textureBin) {
        TextureRetained textureRetained = null;
        if (textureBin.texUnitState != null && textureBin.texUnitState[0] != null) {
            textureRetained = textureBin.texUnitState[0].texture;
        }
        if (textureRetained != null) {
            TextureBin textureBin2 = this.textureBinList;
            while (textureBin2 != null) {
                if (textureBin2.texUnitState == null || textureBin2.texUnitState[0] == null || textureBin2.texUnitState[0].texture != textureRetained) {
                    textureBin2 = textureBin2.next;
                    continue;
                }
                textureBin.next = textureBin2;
                textureBin.prev = textureBin2.prev;
                if (textureBin2.prev == null) {
                    this.textureBinList = textureBin;
                } else {
                    textureBin2.prev.next = textureBin;
                }
                textureBin2.prev = textureBin;
                return;
            }
        }
        textureBin.next = this.textureBinList;
        this.textureBinList.prev = textureBin;
        this.textureBinList = textureBin;
    }

    void removeTextureBin(TextureBin textureBin) {
        int n;
        textureBin.attributeBin = null;
        if (textureBin.prev == null) {
            this.textureBinList = textureBin.next;
            if (textureBin.next != null) {
                textureBin.next.prev = null;
            }
        } else {
            textureBin.prev.next = textureBin.next;
            if (textureBin.next != null) {
                textureBin.next.prev = textureBin.prev;
            }
        }
        textureBin.prev = null;
        textureBin.next = null;
        this.environmentSet.renderBin.textureBinFreelist.add(textureBin);
        if (textureBin.texUnitState != null) {
            n = 0;
            while (n < textureBin.texUnitState.length) {
                if (textureBin.texUnitState[n] != null && textureBin.texUnitState[n].texture != null) {
                    TextureRetained textureRetained = textureBin.texUnitState[n].texture;
                    textureRetained.decTextureBinRefCount();
                    if (textureRetained.textureBinRefCount == 0) {
                        this.environmentSet.renderBin.addTextureResourceFreeList(textureRetained);
                    }
                }
                ++n;
            }
        }
        n = 0;
        while (n < textureBin.numImages) {
            if (textureBin.images[n] != null && textureBin.images[n].isByReference()) {
                this.environmentSet.renderBin.removeNodeComponent(textureBin.images[n]);
            }
            ++n;
        }
        if (this.textureBinList == null && this.addTBs.size() == 0) {
            this.environmentSet.removeAttributeBin(this);
        }
    }

    void render(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = bl = this.definingRenderingAttributes == null || this.definingRenderingAttributes.visible;
        if (this.environmentSet.renderBin.view.viewCache.visibilityPolicy == 0 && !bl || this.environmentSet.renderBin.view.viewCache.visibilityPolicy == 1 && bl) {
            return;
        }
        if ((canvas3D.canvasDirty & 0x200) != 0) {
            if (this.definingRenderingAttributes == null) {
                canvas3D.resetRenderingAttributes(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            }
            canvas3D.renderingAttrs = this.definingRenderingAttributes;
        } else if (canvas3D.attributeBin != this && canvas3D.renderingAttrs != this.definingRenderingAttributes) {
            if (this.definingRenderingAttributes == null) {
                canvas3D.resetRenderingAttributes(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            }
            canvas3D.renderingAttrs = this.definingRenderingAttributes;
        }
        canvas3D.attributeBin = this;
        canvas3D.canvasDirty &= 0xFFFFFDFF;
        TextureBin textureBin = this.textureBinList;
        while (textureBin != null) {
            textureBin.render(canvas3D);
            textureBin = textureBin.next;
        }
    }

    void reset(RenderingAttributesRetained renderingAttributesRetained) {
        this.prev = null;
        this.next = null;
        this.textureBinList = null;
        this.onUpdateList = false;
        if (renderingAttributesRetained != null) {
            if (this.definingRenderingAttributes != null) {
                this.definingRenderingAttributes.set(renderingAttributesRetained);
            } else {
                this.definingRenderingAttributes = (RenderingAttributesRetained)renderingAttributesRetained.clone();
            }
            this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
        } else {
            this.definingRenderingAttributes = null;
            this.ignoreVertexColors = false;
        }
    }

    public void updateObject() {
        if (this.addTBs.size() > 0) {
            TextureBin textureBin = (TextureBin)this.addTBs.get(0);
            if (this.textureBinList == null) {
                this.textureBinList = textureBin;
            } else {
                this.insertTextureBin(textureBin);
            }
            int n = 1;
            while (n < this.addTBs.size()) {
                textureBin = (TextureBin)this.addTBs.get(n);
                this.insertTextureBin(textureBin);
                ++n;
            }
        }
        this.addTBs.clear();
        this.onUpdateList = false;
    }
}

