/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.VirtualUniverse;

abstract class J3dStructure {
    ArrayList messageList = new ArrayList();
    J3dThread updateThread = null;
    int threadType = -1;
    VirtualUniverse universe = null;
    J3dThreadData threadData = new J3dThreadData();

    J3dStructure(VirtualUniverse virtualUniverse, int n) {
        this.universe = virtualUniverse;
        this.threadType = n;
        this.threadData.threadType = n;
    }

    final void addMessage(J3dMessage j3dMessage) {
        if (this.threadData != null) {
            this.threadData.lastUpdateTime = j3dMessage.time;
        } else {
            j3dMessage.time = -1L;
        }
        j3dMessage.incRefcount();
        ArrayList arrayList = this.messageList;
        synchronized (arrayList) {
            this.messageList.add(0, j3dMessage);
        }
    }

    final J3dMessage[] getMessages(long l) {
        J3dMessage[] j3dMessageArray = null;
        J3dMessage j3dMessage = null;
        ArrayList arrayList = this.messageList;
        synchronized (arrayList) {
            int n = this.messageList.size();
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    j3dMessage = (J3dMessage)this.messageList.get(n - n2 - 1);
                    if (j3dMessage.time > l) break;
                    ++n2;
                }
                if (n2 > 0) {
                    j3dMessageArray = new J3dMessage[n2];
                    n2 = 0;
                    while (n2 < j3dMessageArray.length) {
                        j3dMessageArray[n2] = (J3dMessage)this.messageList.remove(this.messageList.size() - 1);
                        ++n2;
                    }
                }
            }
        }
        return j3dMessageArray;
    }

    final J3dThreadData getUpdateThreadData() {
        return this.threadData;
    }

    abstract void processMessages(long var1);
}

