/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.QuadArrayRetained;

public class QuadArray
extends GeometryArray {
    QuadArray() {
    }

    public QuadArray(int n, int n2) {
        super(n, n2);
        if (n < 4 || n % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int n, int n2, int n3, int[] nArray) {
        super(n, n2, n3, nArray);
        if (n < 4 || n % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public NodeComponent cloneNodeComponent() {
        QuadArray quadArray;
        QuadArrayRetained quadArrayRetained = (QuadArrayRetained)this.retained;
        int n = quadArrayRetained.getTexCoordSetCount();
        if (n == 0) {
            quadArray = new QuadArray(quadArrayRetained.getVertexCount(), quadArrayRetained.getVertexFormat());
        } else {
            int[] nArray = new int[quadArrayRetained.getTexCoordSetMapLength()];
            quadArrayRetained.getTexCoordSetMap(nArray);
            quadArray = new QuadArray(quadArrayRetained.getVertexCount(), quadArrayRetained.getVertexFormat(), n, nArray);
        }
        quadArray.duplicateNodeComponent(this);
        return quadArray;
    }

    void createRetained() {
        this.retained = new QuadArrayRetained();
        this.retained.setSource(this);
    }
}

