/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

class RenderingEnvironmentStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList lights = new ArrayList();
    ArrayList fogs = new ArrayList();
    ArrayList altAppearances = new ArrayList();
    ArrayList modelClips = new ArrayList();
    ArrayList backgrounds = new ArrayList();
    ArrayList clips = new ArrayList();
    BackgroundRetained[] intersectedBacks = new BackgroundRetained[1];
    ClipRetained[] intersectedClips = new ClipRetained[1];
    Bounds[] intersectedBounds = new Bounds[1];
    Transform3D localeXform = new Transform3D();
    Vector3d localeTranslation = new Vector3d();
    Bounds localeBounds = null;
    FogRetained[] intersectedFogs = new FogRetained[1];
    AlternateAppearanceRetained[] intersectedAltApps = new AlternateAppearanceRetained[1];
    ModelClipRetained[] intersectedModelClips = new ModelClipRetained[1];
    double backClipDistance;
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList switchChangeLeafNodes = new ArrayList();
    ArrayList switchChangeLeafMasks = new ArrayList();
    ArrayList objFreeList = new ArrayList();
    ArrayList retlights = new ArrayList();

    RenderingEnvironmentStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 4096);
    }

    void addObjArrayToFreeList(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = null;
            ++n;
        }
        this.objFreeList.add(objectArray);
    }

    double backClipDistanceInVworld() {
        return this.backClipDistance;
    }

    Object[] getAllBackgrounds() {
        Object[] objectArray;
        ArrayList arrayList = this.backgrounds;
        synchronized (arrayList) {
            objectArray = this.backgrounds.toArray();
        }
        return objectArray;
    }

    Object[] getAllLights() {
        Object[] objectArray;
        ArrayList arrayList = this.lights;
        synchronized (arrayList) {
            objectArray = this.lights.toArray();
        }
        return objectArray;
    }

    synchronized BackgroundRetained getApplicationBackground(BoundingSphere boundingSphere, Locale locale) {
        BackgroundRetained backgroundRetained = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.backgrounds.size();
        Bounds[] boundsArray = this.intersectedBounds;
        synchronized (boundsArray) {
            if (this.intersectedBounds.length < n3) {
                this.intersectedBounds = new Bounds[n3];
            }
            n = 0;
            n2 = 0;
            while (n < n3) {
                BackgroundRetained backgroundRetained2 = (BackgroundRetained)this.backgrounds.get(n);
                if (backgroundRetained2.transformedRegion != null && backgroundRetained2.lastSwitchOn) {
                    if (backgroundRetained2.cachedLocale != locale) {
                        this.localeBounds = (Bounds)backgroundRetained2.transformedRegion.clone();
                        backgroundRetained2.cachedLocale.hiRes.difference(locale.hiRes, this.localeTranslation);
                        this.localeXform.setIdentity();
                        this.localeXform.setTranslation(this.localeTranslation);
                        this.localeBounds.transform(this.localeXform);
                        if (this.localeBounds.intersect(boundingSphere)) {
                            this.intersectedBounds[n2] = this.localeBounds;
                            this.intersectedBacks[n2++] = backgroundRetained2;
                        }
                    } else if (backgroundRetained2.transformedRegion.intersect(boundingSphere)) {
                        this.intersectedBounds[n2] = backgroundRetained2.transformedRegion;
                        this.intersectedBacks[n2++] = backgroundRetained2;
                    }
                }
                ++n;
            }
            if (n2 == 1) {
                backgroundRetained = this.intersectedBacks[0];
            } else if (n2 > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                n2 = 0;
                while (n2 < this.intersectedBounds.length) {
                    if (this.intersectedBounds[n2] == bounds) {
                        backgroundRetained = this.intersectedBacks[n2];
                        break;
                    }
                    ++n2;
                }
            }
            BackgroundRetained backgroundRetained3 = backgroundRetained;
            Object var11_11 = null;
            return backgroundRetained3;
        }
    }

    Object[] getInfluencingAppearance(RenderAtom renderAtom) {
        AlternateAppearanceRetained alternateAppearanceRetained = null;
        int n = this.altAppearances.size();
        Object[] objectArray = new Object[2];
        Bounds bounds = renderAtom.geometryAtom.source.vwcBounds != null ? renderAtom.geometryAtom.source.vwcBounds : renderAtom.localeVwcBounds;
        Bounds[] boundsArray = this.intersectedBounds;
        synchronized (boundsArray) {
            if (this.intersectedBounds.length < n) {
                this.intersectedBounds = new Bounds[n];
            }
            if (n > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    alternateAppearanceRetained = (AlternateAppearanceRetained)this.altAppearances.get(n2);
                    if (alternateAppearanceRetained.region != null && alternateAppearanceRetained.lastSwitchOn && alternateAppearanceRetained.region.intersect(bounds)) {
                        int n4 = renderAtom.geometryAtom.source.numAltApps;
                        AlternateAppearanceRetained[] alternateAppearanceRetainedArray = renderAtom.geometryAtom.source.altApps;
                        if (alternateAppearanceRetained.isScoped) {
                            int n5 = 0;
                            while (n5 < n4) {
                                if (alternateAppearanceRetained == alternateAppearanceRetainedArray[n5]) {
                                    this.intersectedBounds[n3] = alternateAppearanceRetained.region;
                                    this.intersectedAltApps[n3++] = alternateAppearanceRetained;
                                    break;
                                }
                                ++n5;
                            }
                        } else {
                            this.intersectedBounds[n3] = alternateAppearanceRetained.region;
                            this.intersectedAltApps[n3++] = alternateAppearanceRetained;
                        }
                    }
                    ++n2;
                }
                alternateAppearanceRetained = null;
                if (n3 == 1) {
                    alternateAppearanceRetained = this.intersectedAltApps[0];
                } else if (n3 > 1) {
                    Bounds bounds2 = bounds.closestIntersection(this.intersectedBounds);
                    n3 = 0;
                    while (n3 < this.intersectedBounds.length) {
                        if (this.intersectedBounds[n3] == bounds2) {
                            alternateAppearanceRetained = this.intersectedAltApps[n3];
                            break;
                        }
                        ++n3;
                    }
                }
            }
        }
        if (alternateAppearanceRetained == null) {
            objectArray[0] = Boolean.FALSE;
            return objectArray;
        }
        objectArray[0] = Boolean.TRUE;
        objectArray[1] = alternateAppearanceRetained.appearance;
        return objectArray;
    }

    FogRetained getInfluencingFog(RenderAtom renderAtom) {
        FogRetained fogRetained = null;
        Bounds bounds = renderAtom.geometryAtom.source.vwcBounds != null ? renderAtom.geometryAtom.source.vwcBounds : renderAtom.localeVwcBounds;
        ArrayList arrayList = renderAtom.geometryAtom.source.inBackgroundGroup ? renderAtom.geometryAtom.source.geometryBackground.fogs : this.fogs;
        int n = arrayList.size();
        Bounds[] boundsArray = this.intersectedBounds;
        synchronized (boundsArray) {
            if (this.intersectedBounds.length < n) {
                this.intersectedBounds = new Bounds[n];
            }
            if (n > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    fogRetained = (FogRetained)arrayList.get(n2);
                    if (fogRetained.region != null && fogRetained.lastSwitchOn && fogRetained.region.intersect(bounds)) {
                        int n4 = renderAtom.geometryAtom.source.numfogs;
                        FogRetained[] fogRetainedArray = renderAtom.geometryAtom.source.fogs;
                        if (fogRetained.isScoped) {
                            int n5 = 0;
                            while (n5 < n4) {
                                if (fogRetained == fogRetainedArray[n5]) {
                                    this.intersectedBounds[n3] = fogRetained.region;
                                    this.intersectedFogs[n3++] = fogRetained;
                                    break;
                                }
                                ++n5;
                            }
                        } else {
                            this.intersectedBounds[n3] = fogRetained.region;
                            this.intersectedFogs[n3++] = fogRetained;
                        }
                    }
                    ++n2;
                }
                fogRetained = null;
                if (n3 == 1) {
                    fogRetained = this.intersectedFogs[0];
                } else if (n3 > 1) {
                    Bounds bounds2 = bounds.closestIntersection(this.intersectedBounds);
                    n3 = 0;
                    while (n3 < this.intersectedBounds.length) {
                        if (this.intersectedBounds[n3] == bounds2) {
                            fogRetained = this.intersectedFogs[n3];
                            break;
                        }
                        ++n3;
                    }
                }
            }
        }
        return fogRetained;
    }

    LightRetained[] getInfluencingLights(RenderAtom renderAtom) {
        LightRetained[] lightRetainedArray = null;
        Bounds bounds = renderAtom.geometryAtom.source.vwcBounds != null ? renderAtom.geometryAtom.source.vwcBounds : renderAtom.localeVwcBounds;
        ArrayList arrayList = renderAtom.geometryAtom.source.inBackgroundGroup ? renderAtom.geometryAtom.source.geometryBackground.lights : this.lights;
        ArrayList arrayList2 = this.retlights;
        synchronized (arrayList2) {
            int n;
            int n2;
            this.retlights.clear();
            if (arrayList.size() > 0) {
                n2 = 0;
                while (n2 < arrayList.size()) {
                    LightRetained lightRetained = (LightRetained)arrayList.get(n2);
                    if (lightRetained.lightOn && lightRetained.lastSwitchOn && bounds.intersect(lightRetained.region)) {
                        int n3 = renderAtom.geometryAtom.source.numlights;
                        LightRetained[] lightRetainedArray2 = renderAtom.geometryAtom.source.lights;
                        if (lightRetained.isScoped) {
                            n = 0;
                            while (n < n3) {
                                if (lightRetained == lightRetainedArray2[n]) {
                                    this.retlights.add(lightRetained);
                                    break;
                                }
                                ++n;
                            }
                        } else {
                            this.retlights.add(lightRetained);
                        }
                    }
                    ++n2;
                }
            }
            boolean bl = false;
            if (renderAtom.lights != null && renderAtom.lights.length == this.retlights.size()) {
                n2 = 0;
                while (n2 < renderAtom.lights.length) {
                    n = 0;
                    while (n < this.retlights.size()) {
                        if (renderAtom.lights[n2] == this.retlights.get(n2)) break;
                        ++n;
                    }
                    if (n == this.retlights.size()) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            } else {
                bl = true;
            }
            if (bl) {
                lightRetainedArray = new LightRetained[this.retlights.size()];
                n2 = 0;
                while (n2 < this.retlights.size()) {
                    lightRetainedArray[n2] = (LightRetained)this.retlights.get(n2);
                    ++n2;
                }
                LightRetained[] lightRetainedArray3 = lightRetainedArray;
                Object var11_14 = null;
                return lightRetainedArray3;
            }
            LightRetained[] lightRetainedArray4 = renderAtom.lights;
            Object var11_15 = null;
            return lightRetainedArray4;
        }
    }

    ModelClipRetained getInfluencingModelClip(RenderAtom renderAtom) {
        ModelClipRetained modelClipRetained = null;
        Bounds bounds = renderAtom.geometryAtom.source.vwcBounds != null ? renderAtom.geometryAtom.source.vwcBounds : renderAtom.localeVwcBounds;
        ArrayList arrayList = renderAtom.geometryAtom.source.inBackgroundGroup ? renderAtom.geometryAtom.source.geometryBackground.modelClips : this.modelClips;
        int n = arrayList.size();
        Bounds[] boundsArray = this.intersectedBounds;
        synchronized (boundsArray) {
            if (this.intersectedBounds.length < n) {
                this.intersectedBounds = new Bounds[n];
            }
            if (n > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    modelClipRetained = (ModelClipRetained)arrayList.get(n2);
                    if (modelClipRetained.enableFlag && modelClipRetained.region != null && modelClipRetained.lastSwitchOn && modelClipRetained.region.intersect(bounds)) {
                        int n4 = renderAtom.geometryAtom.source.numModelClips;
                        ModelClipRetained[] modelClipRetainedArray = renderAtom.geometryAtom.source.modelClips;
                        if (modelClipRetained.isScoped) {
                            int n5 = 0;
                            while (n5 < n4) {
                                if (modelClipRetainedArray[n5] == modelClipRetained) {
                                    this.intersectedBounds[n3] = modelClipRetained.region;
                                    this.intersectedModelClips[n3++] = modelClipRetained;
                                    break;
                                }
                                ++n5;
                            }
                        } else {
                            this.intersectedBounds[n3] = modelClipRetained.region;
                            this.intersectedModelClips[n3++] = modelClipRetained;
                        }
                    }
                    ++n2;
                }
                modelClipRetained = null;
                if (n3 == 1) {
                    modelClipRetained = this.intersectedModelClips[0];
                } else if (n3 > 1) {
                    Bounds bounds2 = bounds.closestIntersection(this.intersectedBounds);
                    n3 = 0;
                    while (n3 < this.intersectedBounds.length) {
                        if (this.intersectedBounds[n3] == bounds2) {
                            modelClipRetained = this.intersectedModelClips[n3];
                            break;
                        }
                        ++n3;
                    }
                }
            }
        }
        return modelClipRetained;
    }

    Object[] getObjectArray() {
        Object[] objectArray;
        int n = this.objFreeList.size();
        if (n == 0) {
            objectArray = new Object[5];
        } else {
            objectArray = (Object[])this.objFreeList.get(n - 1);
            this.objFreeList.remove(n - 1);
        }
        return objectArray;
    }

    void insertNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[3];
        Object var6_3 = null;
        int n = 0;
        while (n < objectArray.length) {
            int n2;
            Object object = objectArray[n];
            if (object instanceof LightRetained) {
                LightRetained lightRetained = (LightRetained)object;
                if (lightRetained.inBackgroundGroup) {
                    lightRetained.geometryBackground.lights.add(lightRetained);
                } else {
                    this.lights.add(lightRetained);
                }
            } else if (object instanceof FogRetained) {
                FogRetained fogRetained = (FogRetained)object;
                if (fogRetained.inBackgroundGroup) {
                    fogRetained.geometryBackground.fogs.add(fogRetained);
                    n2 = fogRetained.geometryBackground.fogs.size();
                } else {
                    this.fogs.add(fogRetained);
                    n2 = this.fogs.size();
                }
                if (this.intersectedFogs.length < n2) {
                    this.intersectedFogs = new FogRetained[n2];
                }
            } else if (object instanceof AlternateAppearanceRetained) {
                this.altAppearances.add(object);
                n2 = this.altAppearances.size();
                if (this.intersectedAltApps.length < n2) {
                    this.intersectedAltApps = new AlternateAppearanceRetained[n2];
                }
            } else if (object instanceof BackgroundRetained) {
                this.backgrounds.add(object);
                n2 = this.backgrounds.size();
                if (this.intersectedBacks.length < n2) {
                    this.intersectedBacks = new BackgroundRetained[n2];
                }
            } else if (object instanceof ClipRetained) {
                this.clips.add(object);
                n2 = this.clips.size();
                if (this.intersectedClips.length < n2) {
                    this.intersectedClips = new ClipRetained[n2];
                }
            } else if (object instanceof ModelClipRetained) {
                ModelClipRetained modelClipRetained = (ModelClipRetained)object;
                if (modelClipRetained.inBackgroundGroup) {
                    modelClipRetained.geometryBackground.modelClips.add(modelClipRetained);
                    n2 = modelClipRetained.geometryBackground.modelClips.size();
                } else {
                    this.modelClips.add(object);
                    n2 = this.modelClips.size();
                }
                if (this.intersectedModelClips.length < n2) {
                    this.intersectedModelClips = new ModelClipRetained[n2];
                }
            }
            ++n;
        }
    }

    boolean isBackClipActive(BoundingSphere boundingSphere) {
        boolean bl = false;
        int n = this.clips.size();
        Bounds[] boundsArray = this.intersectedBounds;
        synchronized (boundsArray) {
            if (this.intersectedBounds.length < n) {
                this.intersectedBounds = new Bounds[n];
            }
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                ClipRetained clipRetained = (ClipRetained)this.clips.get(n2);
                if (clipRetained.transformedRegion.intersect(boundingSphere) && clipRetained.lastSwitchOn) {
                    this.intersectedBounds[n3] = clipRetained.transformedRegion;
                    this.intersectedClips[n3++] = clipRetained;
                }
                ++n2;
            }
            if (n3 == 1) {
                this.backClipDistance = this.intersectedClips[0].backDistanceInVworld;
                bl = true;
            } else if (n3 > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                n3 = 0;
                while (n3 < this.intersectedBounds.length) {
                    if (this.intersectedBounds[n3] == bounds) {
                        this.backClipDistance = this.intersectedClips[n3].backDistanceInVworld;
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
        }
        return bl;
    }

    void processMessages(long l) {
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        if (j3dMessageArray != null) {
            int n = 0;
            while (n < j3dMessageArray.length) {
                switch (j3dMessageArray[n].type) {
                    case 0: {
                        this.insertNodes((Object[])j3dMessageArray[n].args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes((Object[])j3dMessageArray[n].args[0]);
                        break;
                    }
                    case 19: {
                        this.updateLight(j3dMessageArray[n].args);
                        break;
                    }
                    case 23: {
                        this.updateBoundingLeaf(j3dMessageArray[n].args);
                        break;
                    }
                    case 22: {
                        this.updateFog(j3dMessageArray[n].args);
                        break;
                    }
                    case 41: {
                        this.updateAltApp(j3dMessageArray[n].args);
                        break;
                    }
                    case 24: {
                        this.updateShape3D(j3dMessageArray[n].args);
                        break;
                    }
                    case 16: {
                        this.updateMorph(j3dMessageArray[n].args);
                        break;
                    }
                    case 3: {
                        this.updateTransformChange(j3dMessageArray[n].args);
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessageArray[n]);
                        break;
                    }
                    case 36: {
                        this.updateModelClip(j3dMessageArray[n].args);
                        break;
                    }
                    case 20: {
                        this.updateBackground(j3dMessageArray[n].args);
                        break;
                    }
                    case 21: {
                        this.updateClip(j3dMessageArray[n].args);
                        break;
                    }
                }
                j3dMessageArray[n].decRefcount();
                ++n;
            }
            VirtualUniverse.mc.addMirrorObject(this);
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof LightRetained || objectArray[n] instanceof FogRetained || objectArray[n] instanceof AlternateAppearanceRetained || objectArray[n] instanceof ClipRetained || objectArray[n] instanceof BackgroundRetained || objectArray[n] instanceof ModelClipRetained) {
                ((LeafRetained)objectArray[n]).evalLastSwitchOn((long[])objectArray2[n]);
            } else if (objectArray[n] instanceof BoundingLeafRetained) {
                Object[] objectArray3 = (Object[])j3dMessage.args[2];
                Object[] objectArray4 = (Object[])objectArray3[n];
                BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n];
                boolean bl = boundingLeafRetained.currentSwitchOn;
                boundingLeafRetained.evalCurrentSwitchOn((long[])objectArray2[n]);
                if (bl != boundingLeafRetained.currentSwitchOn) {
                    int n2 = 0;
                    while (n2 < objectArray4.length) {
                        LeafRetained leafRetained = (LeafRetained)objectArray4[n2];
                        if (leafRetained instanceof FogRetained || leafRetained instanceof LightRetained || leafRetained instanceof ModelClipRetained || leafRetained instanceof ClipRetained || leafRetained instanceof AlternateAppearanceRetained || leafRetained instanceof BackgroundRetained) {
                            leafRetained.updateBoundingLeaf();
                        }
                        ++n2;
                    }
                }
            } else {
                this.switchChangeLeafNodes.add(objectArray[n]);
                this.switchChangeLeafMasks.add(objectArray2[n]);
            }
            ++n;
        }
    }

    void removeNodes(Object[] objectArray) {
        Shape3DRetained shape3DRetained = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof LightRetained) {
                this.lights.remove(this.lights.indexOf(object));
                ((LightRetained)object).isScoped = false;
            } else if (object instanceof FogRetained) {
                this.fogs.remove(this.fogs.indexOf(object));
                ((FogRetained)object).isScoped = false;
            } else if (object instanceof AlternateAppearanceRetained) {
                this.altAppearances.remove(this.altAppearances.indexOf(object));
                ((AlternateAppearanceRetained)object).isScoped = false;
            } else if (object instanceof BackgroundRetained) {
                this.backgrounds.remove(this.backgrounds.indexOf(object));
            } else if (object instanceof ClipRetained) {
                this.clips.remove(this.clips.indexOf(object));
            } else if (object instanceof ModelClipRetained) {
                this.modelClips.remove(this.modelClips.indexOf(object));
            } else if (object instanceof GeometryAtom) {
                GeometryAtom geometryAtom = (GeometryAtom)object;
                if (geometryAtom.source != shape3DRetained) {
                    geometryAtom.source.clearMirrorShape();
                    shape3DRetained = geometryAtom.source;
                }
            }
            ++n;
        }
    }

    void updateAltApp(Object[] objectArray) {
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if (alternateAppearanceRetained.source.isLive()) {
            alternateAppearanceRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBackground(Object[] objectArray) {
        BackgroundRetained backgroundRetained = (BackgroundRetained)objectArray[0];
        if (backgroundRetained.source.isLive()) {
            backgroundRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBoundingLeaf(Object[] objectArray) {
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[3];
        boundingLeafRetained.updateImmediateMirrorObject(objectArray);
        int n = 0;
        while (n < objectArray2.length) {
            LeafRetained leafRetained = (LeafRetained)objectArray2[n];
            leafRetained.updateBoundingLeaf();
            ++n;
        }
    }

    void updateClip(Object[] objectArray) {
        ClipRetained clipRetained = (ClipRetained)objectArray[0];
        if (clipRetained.source.isLive()) {
            clipRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateFog(Object[] objectArray) {
        FogRetained fogRetained = (FogRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x31) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if (fogRetained.source.isLive()) {
            fogRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateLight(Object[] objectArray) {
        LightRetained lightRetained = (LightRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if (lightRetained instanceof AmbientLightRetained && (n & 8) != 0) {
            if (lightRetained.source.isLive()) {
                lightRetained.updateImmediateMirrorObject(objectArray);
            }
        } else if ((n & 0x3E8) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if (lightRetained.source.isLive()) {
            lightRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateModelClip(Object[] objectArray) {
        ModelClipRetained modelClipRetained = (ModelClipRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0xF) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if (modelClipRetained.source.isLive()) {
            modelClipRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateMorph(Object[] objectArray) {
        MorphRetained morphRetained = (MorphRetained)objectArray[0];
        morphRetained.updateImmediateMirrorObject(objectArray);
    }

    public void updateObject() {
        LeafRetained leafRetained;
        int n = 0;
        while (n < this.objList.size()) {
            Object[] objectArray = (Object[])this.objList.get(n);
            leafRetained = (LeafRetained)objectArray[0];
            if (leafRetained.source.isLive()) {
                leafRetained.updateMirrorObject(objectArray);
            }
            this.addObjArrayToFreeList(objectArray);
            ++n;
        }
        this.objList.clear();
        n = 0;
        while (n < this.xformChangeList.size()) {
            leafRetained = (LeafRetained)this.xformChangeList.get(n);
            leafRetained.updateTransformChange();
            ++n;
        }
        this.xformChangeList.clear();
        if (this.switchChangeLeafNodes.size() > 0) {
            n = 0;
            while (n < this.switchChangeLeafNodes.size()) {
                leafRetained = (LeafRetained)this.switchChangeLeafNodes.get(n);
                long[] lArray = (long[])this.switchChangeLeafMasks.get(n);
                leafRetained.evalLastSwitchOn(lArray);
                ++n;
            }
            this.switchChangeLeafNodes.clear();
            this.switchChangeLeafMasks.clear();
        }
    }

    void updateShape3D(Object[] objectArray) {
        Shape3DRetained shape3DRetained = (Shape3DRetained)objectArray[0];
        shape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateTransformChange(Object[] objectArray) {
        Cloneable cloneable;
        Object[] objectArray2 = (Object[])objectArray[0];
        int n = 0;
        while (n < objectArray2.length) {
            if (objectArray2[n] instanceof BoundingLeafRetained) {
                BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray2[n];
                boundingLeafRetained.updateImmediateTransformChange();
            } else if (objectArray2[n] instanceof LightRetained) {
                LightRetained lightRetained = (LightRetained)objectArray2[n];
                lightRetained.updateImmediateTransformChange();
                this.xformChangeList.add(objectArray2[n]);
            } else if (objectArray2[n] instanceof FogRetained) {
                cloneable = (FogRetained)objectArray2[n];
                ((FogRetained)cloneable).updateImmediateTransformChange();
                this.xformChangeList.add(objectArray2[n]);
            } else if (objectArray2[n] instanceof AlternateAppearanceRetained) {
                cloneable = (AlternateAppearanceRetained)objectArray2[n];
                ((AlternateAppearanceRetained)cloneable).updateImmediateTransformChange();
                this.xformChangeList.add(objectArray2[n]);
            } else if (objectArray2[n] instanceof BackgroundRetained) {
                cloneable = (BackgroundRetained)objectArray2[n];
                ((BackgroundRetained)cloneable).updateImmediateTransformChange();
            } else if (objectArray2[n] instanceof ModelClipRetained) {
                cloneable = (ModelClipRetained)objectArray2[n];
                ((ModelClipRetained)cloneable).updateImmediateTransformChange();
            }
            ++n;
        }
        cloneable = (ArrayList)objectArray[3];
        if (cloneable != null) {
            n = 0;
            while (n < ((ArrayList)cloneable).size()) {
                LeafRetained leafRetained = (LeafRetained)((ArrayList)cloneable).get(n);
                leafRetained.updateBoundingLeaf();
                ++n;
            }
        }
    }
}

