/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

class Shape3DRetained
extends LeafRetained {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int ADD_AND_SET_OP = 1;
    static final int INSERT_OP = 2;
    static final int REMOVE_OP = 3;
    static final int targetThreads = 4224;
    AppearanceRetained appearance = null;
    Bounds collisionBound = null;
    ArrayList geometryList = null;
    private GeometryAtom[][] geomAtomArray = null;
    private int geomAtomArrayBlockSize = 1;
    private int geomAtomArrayMaxSize = 0;
    private int geomAtomArrayCount = 0;
    private MRSWLock mirrorShape3DLock = null;
    ArrayList mirrorShape3D = new ArrayList();
    NodeRetained sourceNode = null;
    HashKey key = null;
    Transform3D cachedLocalToVworld = null;
    Transform3D renderLocalToVworld = null;
    ArrayList parentList = null;
    boolean inImmCtx = false;
    int isDirty = 65535;
    LightRetained[] lights = null;
    int numlights = 0;
    FogRetained[] fogs = null;
    int numfogs = 0;
    ModelClipRetained[] modelClips = null;
    int numModelClips = 0;
    AlternateAppearanceRetained[] altApps = null;
    int numAltApps = 0;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    ArrayList orderedGroupsPath = null;
    ArrayList orderedChildIdsPath = null;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    boolean appearanceOverrideEnable = false;
    AppearanceRetained otherAppearance = null;
    Bounds vwcBounds = null;
    Bounds bounds = null;
    boolean onUpdateList = false;

    Shape3DRetained() {
        this.nodeType = 11;
        this.numlights = 0;
        this.numfogs = 0;
        this.numModelClips = 0;
        this.numAltApps = 0;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        this.mirrorShape3DLock = new MRSWLock();
        this.geometryList = new ArrayList();
        this.geometryList.add(null);
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        if (this.altApps == null) {
            this.altApps = new AlternateAppearanceRetained[10];
        } else if (this.altApps.length == this.numAltApps) {
            AlternateAppearanceRetained[] alternateAppearanceRetainedArray = new AlternateAppearanceRetained[this.numAltApps * 2];
            int n = 0;
            while (n < this.numAltApps) {
                alternateAppearanceRetainedArray[n] = this.altApps[n];
                ++n;
            }
            this.altApps = alternateAppearanceRetainedArray;
        }
        this.altApps[this.numAltApps] = alternateAppearanceRetained;
        ++this.numAltApps;
    }

    void addFog(FogRetained fogRetained) {
        if (this.fogs == null) {
            this.fogs = new FogRetained[10];
        } else if (this.fogs.length == this.numfogs) {
            FogRetained[] fogRetainedArray = new FogRetained[this.numfogs * 2];
            int n = 0;
            while (n < this.numfogs) {
                fogRetainedArray[n] = this.fogs[n];
                ++n;
            }
            this.fogs = fogRetainedArray;
        }
        this.fogs[this.numfogs] = fogRetained;
        ++this.numfogs;
    }

    void addGeometry(Geometry geometry) {
        GeometryRetained geometryRetained;
        if (this.geometryList.size() > 0 && (geometryRetained = (GeometryRetained)this.geometryList.get(0)) != null && geometry != null && !geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
        }
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null) {
                if (((GeometryRetained)geometry.retained).getInImmCtx()) {
                    throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained0"));
                }
                geometryRetained = (GeometryRetained)geometry.retained;
                geometryRetained.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.add(geometryRetained);
                this.sendDataChangedMessage(this.geometryList.size() - 1, geometryRetained, 1);
            } else {
                this.geometryList.add(null);
                this.addNullGeometryAtom();
            }
        } else if (this.inImmCtx) {
            if (geometry != null && geometry.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained1"));
            }
        } else if (geometry != null) {
            this.geometryList.add((GeometryRetained)geometry.retained);
        } else {
            this.geometryList.add(null);
        }
    }

    void addLight(LightRetained lightRetained) {
        if (this.lights == null) {
            this.lights = new LightRetained[10];
        } else if (this.lights.length == this.numlights) {
            LightRetained[] lightRetainedArray = new LightRetained[this.numlights * 2];
            int n = 0;
            while (n < this.numlights) {
                lightRetainedArray[n] = this.lights[n];
                ++n;
            }
            this.lights = lightRetainedArray;
        }
        this.lights[this.numlights] = lightRetained;
        ++this.numlights;
    }

    void addModelClip(ModelClipRetained modelClipRetained) {
        if (this.modelClips == null) {
            this.modelClips = new ModelClipRetained[10];
        } else if (this.modelClips.length == this.numModelClips) {
            ModelClipRetained[] modelClipRetainedArray = new ModelClipRetained[this.numModelClips * 2];
            int n = 0;
            while (n < this.numModelClips) {
                modelClipRetainedArray[n] = this.modelClips[n];
                ++n;
            }
            this.modelClips = modelClipRetainedArray;
        }
        this.modelClips[this.numModelClips] = modelClipRetained;
        ++this.numModelClips;
    }

    private void addNullGeometryAtom() {
        int n = 0;
        while (n < this.mirrorShape3D.size()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
            shape3DRetained.mirrorShape3DLock.writeLock();
            if (shape3DRetained.geomAtomArrayCount >= shape3DRetained.geomAtomArrayMaxSize) {
                shape3DRetained.geomAtomArrayMaxSize += shape3DRetained.geomAtomArrayBlockSize;
                shape3DRetained.geomAtomArrayBlockSize += 5;
                GeometryAtom[][] geometryAtomArray = shape3DRetained.geomAtomArray;
                shape3DRetained.geomAtomArray = new GeometryAtom[shape3DRetained.geomAtomArrayMaxSize][];
                int n2 = 0;
                while (n2 < shape3DRetained.geomAtomArrayCount) {
                    shape3DRetained.geomAtomArray[n2] = geometryAtomArray[n2];
                    ++n2;
                }
            }
            shape3DRetained.geomAtomArray[shape3DRetained.geomAtomArrayCount] = null;
            ++shape3DRetained.geomAtomArrayCount;
            shape3DRetained.mirrorShape3DLock.writeUnlock();
            ++n;
        }
    }

    boolean allowIntersect() {
        GeometryRetained geometryRetained = null;
        int n = 0;
        while (n < this.geometryList.size()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && !geometryRetained.source.capabilities.get(18)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void clearLive(SetLiveState setLiveState) {
        Shape3DRetained shape3DRetained;
        int n;
        GeometryRetained geometryRetained;
        int n2;
        super.clearLive(setLiveState);
        if (this.appearance != null) {
            this.appearance.clearLive(setLiveState.refCount);
        }
        if (this.geometryList != null) {
            n2 = 0;
            while (n2 < this.geometryList.size()) {
                geometryRetained = (GeometryRetained)this.geometryList.get(n2);
                if (geometryRetained != null) {
                    geometryRetained.clearLive(setLiveState.refCount);
                }
                ++n2;
            }
        }
        if (this.inSharedGroup) {
            Object[] objectArray = this.mirrorShape3D.toArray();
            n = 0;
            while (n < setLiveState.keys.length) {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    shape3DRetained = (Shape3DRetained)objectArray[n3];
                    if (shape3DRetained.key.equals(setLiveState.keys[n])) {
                        this.mirrorShape3D.remove(this.mirrorShape3D.indexOf(shape3DRetained));
                        if (this.appearance != null) {
                            this.appearance.removeAMirrorUser(shape3DRetained);
                        }
                        if (this.geometryList != null) {
                            n2 = 0;
                            while (n2 < this.geometryList.size()) {
                                geometryRetained = (GeometryRetained)this.geometryList.get(n2);
                                if (geometryRetained != null) {
                                    geometryRetained.removeUser(shape3DRetained);
                                }
                                ++n2;
                            }
                        }
                        setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                        if (this.inOrderedGroup) {
                            shape3DRetained.orderedGroupsPath = null;
                            shape3DRetained.orderedChildIdsPath = null;
                        }
                    }
                    ++n3;
                }
                ++n;
            }
        } else {
            shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            this.mirrorShape3D.remove(0);
            if (this.geometryList != null) {
                n2 = 0;
                while (n2 < this.geometryList.size()) {
                    geometryRetained = (GeometryRetained)this.geometryList.get(n2);
                    if (geometryRetained != null) {
                        geometryRetained.removeUser(shape3DRetained);
                    }
                    ++n2;
                }
            }
            if (this.appearance != null) {
                this.appearance.removeAMirrorUser(shape3DRetained);
            }
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
            if (this.inOrderedGroup) {
                shape3DRetained.orderedGroupsPath = null;
                shape3DRetained.orderedChildIdsPath = null;
            }
        }
        setLiveState.notifyThreads |= 0x10C0;
        if (!this.source.isLive()) {
            n = 0;
            while (n < this.numfogs) {
                this.fogs[n] = null;
                ++n;
            }
            this.numfogs = 0;
            n = 0;
            while (n < this.numModelClips) {
                this.modelClips[n] = null;
                ++n;
            }
            this.numModelClips = 0;
            n = 0;
            while (n < this.numlights) {
                this.lights[n] = null;
                ++n;
            }
            this.numlights = 0;
            n = 0;
            while (n < this.numAltApps) {
                this.altApps[n] = null;
                ++n;
            }
            this.numAltApps = 0;
        }
    }

    void clearMirrorShape() {
        this.source = null;
        this.sourceNode = null;
        this.parent = null;
        this.parentList = null;
        if (this.otherAppearance != null) {
            this.otherAppearance.sgApp.removeAMirrorUser(this);
            this.otherAppearance = null;
        }
        this.appearance = null;
        this.branchGroupPath = null;
        this.isPickable = true;
        this.isCollidable = true;
        this.branchGroupPath = null;
        this.geometryList = null;
        this.geomAtomArray = null;
        this.geomAtomArrayMaxSize = 0;
        this.geomAtomArrayCount = 0;
        int n = 0;
        while (n < this.numfogs) {
            this.fogs[n] = null;
            ++n;
        }
        this.numfogs = 0;
        n = 0;
        while (n < this.numModelClips) {
            this.modelClips[n] = null;
            ++n;
        }
        this.numModelClips = 0;
        n = 0;
        while (n < this.numlights) {
            this.lights[n] = null;
            ++n;
        }
        this.numlights = 0;
        n = 0;
        while (n < this.numAltApps) {
            this.altApps[n] = null;
            ++n;
        }
        this.numAltApps = 0;
    }

    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            if (this.geometryList != null) {
                int n = 0;
                while (n < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
                    if (geometryRetained != null && geometryRetained.geoType != -1) {
                        geometryRetained.computeBoundingBox();
                        BoundingBox boundingBox = geometryRetained.geoBounds;
                        synchronized (boundingBox) {
                            bounds.combine(geometryRetained.geoBounds);
                        }
                    }
                    ++n;
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    Enumeration getAllGeometries() {
        GeometryRetained geometryRetained = null;
        Vector<Geometry> vector = new Vector<Geometry>();
        int n = 0;
        while (n < this.geometryList.size()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                vector.add((Geometry)geometryRetained.source);
            } else {
                vector.add(null);
            }
            ++n;
        }
        return vector.elements();
    }

    void getAllScopedNodes(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        arrayList.add(shape3DRetained);
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.geometryList != null) {
                BoundingBox boundingBox = new BoundingBox(null);
                int n = 0;
                while (n < this.geometryList.size()) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
                    if (geometryRetained != null && geometryRetained.geoType != -1) {
                        geometryRetained.computeBoundingBox();
                        BoundingBox boundingBox2 = geometryRetained.geoBounds;
                        synchronized (boundingBox2) {
                            boundingBox.combine(geometryRetained.geoBounds);
                        }
                    }
                    ++n;
                }
                return boundingBox;
            }
            return null;
        }
        return super.getBounds();
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    static final ArrayList getGeomAtomsList(ArrayList arrayList) {
        ArrayList<GeometryAtom> arrayList2 = new ArrayList<GeometryAtom>();
        Shape3DRetained shape3DRetained = null;
        int n = arrayList.size() - 1;
        while (n >= 0) {
            shape3DRetained = (Shape3DRetained)arrayList.get(n);
            shape3DRetained.mirrorShape3DLock.readLock();
            int n2 = 0;
            while (n2 < shape3DRetained.geomAtomArrayCount) {
                if (shape3DRetained.geomAtomArray[n2] != null) {
                    int n3 = 0;
                    while (n3 < shape3DRetained.geomAtomArray[n2].length) {
                        arrayList2.add(shape3DRetained.geomAtomArray[n2][n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
            shape3DRetained.mirrorShape3DLock.readUnlock();
            --n;
        }
        return arrayList2;
    }

    static final ArrayList getGeomAtomsList(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList arrayList3 = new ArrayList();
        ArrayList<GeometryAtom> arrayList4 = null;
        Shape3DRetained shape3DRetained = null;
        boolean bl = false;
        VirtualUniverse virtualUniverse = null;
        int n = arrayList.size() - 1;
        while (n >= 0) {
            shape3DRetained = (Shape3DRetained)arrayList.get(n);
            if (!bl) {
                if (virtualUniverse == null) {
                    virtualUniverse = shape3DRetained.universe;
                    arrayList2.add(shape3DRetained.universe);
                    arrayList4 = new ArrayList<GeometryAtom>();
                    arrayList3.add(arrayList4);
                } else if (virtualUniverse != shape3DRetained.universe) {
                    bl = true;
                    arrayList2.add(shape3DRetained.universe);
                    arrayList4 = new ArrayList();
                    arrayList3.add(arrayList4);
                }
            } else {
                int n2 = arrayList2.indexOf(shape3DRetained.universe);
                if (n2 < 0) {
                    arrayList2.add(shape3DRetained.universe);
                    arrayList4 = new ArrayList();
                    arrayList3.add(arrayList4);
                } else {
                    arrayList4 = (ArrayList<GeometryAtom>)arrayList3.get(n2);
                }
            }
            shape3DRetained.mirrorShape3DLock.readLock();
            int n3 = 0;
            while (n3 < shape3DRetained.geomAtomArrayCount) {
                if (shape3DRetained.geomAtomArray[n3] != null) {
                    int n4 = 0;
                    while (n4 < shape3DRetained.geomAtomArray[n3].length) {
                        arrayList4.add(shape3DRetained.geomAtomArray[n3][n4]);
                        ++n4;
                    }
                }
                ++n3;
            }
            shape3DRetained.mirrorShape3DLock.readUnlock();
            --n;
        }
        return arrayList3;
    }

    static final ArrayList getGeomAtomsList(Shape3DRetained shape3DRetained) {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        shape3DRetained.mirrorShape3DLock.readLock();
        int n = 0;
        while (n < shape3DRetained.geomAtomArrayCount) {
            if (shape3DRetained.geomAtomArray[n] != null) {
                int n2 = 0;
                while (n2 < shape3DRetained.geomAtomArray[n].length) {
                    arrayList.add(shape3DRetained.geomAtomArray[n][n2]);
                    ++n2;
                }
            }
            ++n;
        }
        shape3DRetained.mirrorShape3DLock.readUnlock();
        return arrayList;
    }

    static final ArrayList getGeomAtomsList(Shape3DRetained shape3DRetained, int n) {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        shape3DRetained.mirrorShape3DLock.readLock();
        if (shape3DRetained.geomAtomArrayCount > n && shape3DRetained.geomAtomArray[n] != null) {
            int n2 = 0;
            while (n2 < shape3DRetained.geomAtomArray[n].length) {
                arrayList.add(shape3DRetained.geomAtomArray[n][n2]);
                ++n2;
            }
        }
        shape3DRetained.mirrorShape3DLock.readUnlock();
        return arrayList;
    }

    Geometry getGeometry(int n) {
        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
        return geometryRetained == null ? null : (Geometry)geometryRetained.source;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    Shape3DRetained getMirrorShape(HashKey hashKey) {
        int n = this.localToVworldKeys.length - 1;
        while (n >= 0) {
            if (this.localToVworldKeys[n].equals(hashKey)) {
                return (Shape3DRetained)this.mirrorShape3D.get(n);
            }
            --n;
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    Shape3DRetained getMirrorShape(SceneGraphPath sceneGraphPath) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey hashKey = new HashKey("");
        sceneGraphPath.getHashKey(hashKey);
        return this.getMirrorShape(hashKey);
    }

    void initMirrorShape3D(MorphRetained morphRetained) {
        GeometryAtom[] geometryAtomArray = null;
        this.universe = morphRetained.universe;
        this.inSharedGroup = morphRetained.inSharedGroup;
        this.inOrderedGroup = morphRetained.inOrderedGroup;
        this.inBackgroundGroup = morphRetained.inBackgroundGroup;
        this.geometryBackground = morphRetained.geometryBackground;
        this.parent = morphRetained.parent;
        this.locale = morphRetained.locale;
        this.cachedLocalToVworld = morphRetained.getCurrentLocalToVworld(this.key);
        this.renderLocalToVworld = morphRetained.getLastLocalToVworld(this.key);
        this.localBounds.set(morphRetained.localBounds);
        if (morphRetained.appearance != null) {
            morphRetained.appearance.initMirrorObject();
            this.appearance = (AppearanceRetained)morphRetained.appearance.mirror;
            if (this.appearance.renderingAttributes != null) {
                morphRetained.visible = this.appearance.renderingAttributes.visible;
            }
        } else {
            this.appearance = null;
        }
        if (morphRetained.collisionBound != null) {
            this.collisionBound = (Bounds)morphRetained.collisionBound.clone();
        }
        this.appearanceOverrideEnable = morphRetained.appearanceOverrideEnable;
        this.geometryList = new ArrayList();
        this.geometryList.add((GeometryArrayRetained)morphRetained.morphedGeometryArray.retained);
        this.geomAtomArrayCount = 0;
        this.geomAtomArrayMaxSize = 1;
        this.geomAtomArray = new GeometryAtom[1][];
        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(0);
        if (geometryRetained == null) {
            geometryAtomArray = null;
        } else {
            GeometryAtom geometryAtom = new GeometryAtom();
            geometryAtomArray = new GeometryAtom[]{geometryAtom};
            geometryAtom.locale = this.locale;
            geometryAtom.visible = morphRetained.visible;
            geometryAtom.geometry = (GeometryArrayRetained)morphRetained.morphedGeometryArray.retained;
            geometryAtom.geoType = geometryAtom.geometry.geoType;
            geometryAtom.source = this;
            geometryAtom.bounds = morphRetained.boundsAutoCompute ? geometryAtom.geometry.geoBounds : morphRetained.localBounds;
            geometryAtom.vwcBounds.transform(geometryAtom.bounds, this.cachedLocalToVworld);
            if (morphRetained.collisionBound == null) {
                geometryAtom.collisionBound = geometryAtom.vwcBounds;
            } else {
                geometryAtom.collisionBound = (Bounds)morphRetained.collisionBound.clone();
                geometryAtom.collisionBound.transform(this.cachedLocalToVworld);
            }
            if (morphRetained.inOrderedGroup) {
                geometryAtom.orderedGroupsPath = this.orderedGroupsPath;
                geometryAtom.orderedChildIdsPath = this.orderedChildIdsPath;
            }
        }
        this.geomAtomArray[0] = geometryAtomArray;
        ++this.geomAtomArrayCount;
        this.sourceNode = morphRetained;
        if (!this.boundsAutoCompute && this.localBounds != null) {
            this.bounds = this.localBounds;
            this.vwcBounds = (Bounds)this.localBounds.clone();
            this.vwcBounds.transform(this.cachedLocalToVworld);
        }
    }

    private void initMirrorShape3D(Shape3DRetained shape3DRetained) {
        SceneGraphObjectRetained sceneGraphObjectRetained;
        GeometryAtom geometryAtom = null;
        GeometryAtom[] geometryAtomArray = null;
        shape3DRetained.inBackgroundGroup = this.inBackgroundGroup;
        shape3DRetained.geometryBackground = this.geometryBackground;
        shape3DRetained.source = this.source;
        shape3DRetained.universe = this.universe;
        shape3DRetained.inSharedGroup = false;
        shape3DRetained.inOrderedGroup = this.inOrderedGroup;
        shape3DRetained.locale = this.locale;
        shape3DRetained.parent = this.parent;
        shape3DRetained.cachedLocalToVworld = this.getCurrentLocalToVworld(shape3DRetained.key);
        shape3DRetained.renderLocalToVworld = this.getLastLocalToVworld(shape3DRetained.key);
        shape3DRetained.localBounds.set(this.localBounds);
        if (this.collisionBound != null) {
            shape3DRetained.collisionBound = (Bounds)this.collisionBound.clone();
        }
        if (this.appearance != null) {
            this.appearance.initMirrorObject();
            shape3DRetained.appearance = (AppearanceRetained)this.appearance.mirror;
            if (shape3DRetained.appearance.renderingAttributes != null) {
                this.visible = shape3DRetained.appearance.renderingAttributes.visible;
            }
        } else {
            shape3DRetained.appearance = null;
        }
        shape3DRetained.appearanceOverrideEnable = this.appearanceOverrideEnable;
        shape3DRetained.geometryList = this.geometryList;
        shape3DRetained.geomAtomArrayCount = 0;
        shape3DRetained.geomAtomArrayMaxSize = this.geometryList.size();
        shape3DRetained.geomAtomArray = new GeometryAtom[shape3DRetained.geomAtomArrayMaxSize][];
        int n = 0;
        while (n < shape3DRetained.geomAtomArrayMaxSize) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained == null) {
                geometryAtomArray = null;
            } else if (geometryRetained.geoType == 16) {
                sceneGraphObjectRetained = (Text3DRetained)geometryRetained;
                geometryAtomArray = new GeometryAtom[((Text3DRetained)sceneGraphObjectRetained).numChars];
                int n2 = ((Text3DRetained)sceneGraphObjectRetained).numChars - 1;
                while (n2 >= 0) {
                    geometryAtomArray[n2] = geometryAtom = new GeometryAtom();
                    geometryAtom.locale = shape3DRetained.locale;
                    geometryAtom.geoType = geometryRetained.geoType;
                    geometryAtom.visible = this.visible;
                    if (((Text3DRetained)sceneGraphObjectRetained).font3D.fontData[((Text3DRetained)sceneGraphObjectRetained).charIndex[n2]] != null) {
                        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)((Text3DRetained)sceneGraphObjectRetained).font3D.fontData[((Text3DRetained)sceneGraphObjectRetained).charIndex[n2]].retained;
                        geometryAtom.geometry = geometryArrayRetained;
                        if (this.boundsAutoCompute) {
                            geometryAtom.bounds = (Bounds)geometryArrayRetained.geoBounds.clone();
                            geometryAtom.bounds.transform(geometryAtom.bounds, ((Text3DRetained)sceneGraphObjectRetained).charTransforms[n2]);
                        } else {
                            geometryAtom.bounds = shape3DRetained.localBounds;
                        }
                        geometryAtom.vwcBounds.transform(geometryAtom.bounds, shape3DRetained.cachedLocalToVworld);
                        if (this.collisionBound == null) {
                            geometryAtom.collisionBound = geometryAtom.vwcBounds;
                        } else {
                            geometryAtom.collisionBound = (Bounds)this.collisionBound.clone();
                            geometryAtom.collisionBound.transform(shape3DRetained.cachedLocalToVworld);
                        }
                    } else {
                        geometryAtom.geometry = null;
                    }
                    geometryAtom.source = shape3DRetained;
                    geometryAtom.currentLocalTransform = ((Text3DRetained)sceneGraphObjectRetained).charTransforms[n2];
                    geometryAtom.lastLocalTransform = ((Text3DRetained)sceneGraphObjectRetained).charTransforms[n2];
                    geometryAtom.evalAlphaEditable();
                    if (this.inOrderedGroup) {
                        geometryAtom.orderedGroupsPath = shape3DRetained.orderedGroupsPath;
                        geometryAtom.orderedChildIdsPath = shape3DRetained.orderedChildIdsPath;
                    }
                    --n2;
                }
            } else {
                geometryAtom = new GeometryAtom();
                geometryAtomArray = new GeometryAtom[]{geometryAtom};
                geometryAtom.locale = shape3DRetained.locale;
                geometryAtom.geometry = geometryRetained;
                geometryAtom.visible = this.visible;
                geometryAtom.geoType = geometryRetained.geoType;
                geometryAtom.bounds = this.boundsAutoCompute ? geometryRetained.geoBounds : this.localBounds;
                geometryAtom.source = shape3DRetained;
                geometryAtom.vwcBounds.transform(geometryAtom.bounds, shape3DRetained.cachedLocalToVworld);
                if (this.collisionBound == null) {
                    geometryAtom.collisionBound = geometryAtom.vwcBounds;
                } else {
                    geometryAtom.collisionBound = (Bounds)this.collisionBound.clone();
                    geometryAtom.collisionBound.transform(shape3DRetained.cachedLocalToVworld);
                }
                geometryAtom.evalAlphaEditable();
                if (this.inOrderedGroup) {
                    geometryAtom.orderedGroupsPath = shape3DRetained.orderedGroupsPath;
                    geometryAtom.orderedChildIdsPath = shape3DRetained.orderedChildIdsPath;
                }
            }
            shape3DRetained.geomAtomArray[n] = geometryAtomArray;
            ++shape3DRetained.geomAtomArrayCount;
            ++n;
        }
        shape3DRetained.sourceNode = this;
        if (!this.boundsAutoCompute && this.localBounds != null) {
            shape3DRetained.bounds = this.localBounds;
            shape3DRetained.vwcBounds = (Bounds)this.localBounds.clone();
            shape3DRetained.vwcBounds.transform(shape3DRetained.cachedLocalToVworld);
        }
        if (this instanceof OrientedShape3DRetained) {
            sceneGraphObjectRetained = (OrientedShape3DRetained)this;
            OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)shape3DRetained;
            orientedShape3DRetained.initAlignmentMode(sceneGraphObjectRetained.mode);
            orientedShape3DRetained.initAlignmentAxis(sceneGraphObjectRetained.axis);
            orientedShape3DRetained.initRotationPoint(sceneGraphObjectRetained.rotationPoint);
        }
    }

    void insertGeometry(Geometry geometry, int n) {
        GeometryRetained geometryRetained;
        GeometryRetained geometryRetained2 = null;
        Object var7_4 = null;
        int n2 = this.geometryList.size();
        if (n2 > 1 && (geometryRetained = (GeometryRetained)this.geometryList.get(0)) != null && geometry != null && !geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
        }
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null && ((GeometryRetained)geometry.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained0"));
            }
            if (geometry != null) {
                geometryRetained2 = (GeometryRetained)geometry.retained;
                this.geometryList.add(n, geometryRetained2);
                geometryRetained2.setLive(this.inBackgroundGroup, this.refCount);
                this.sendDataChangedMessage(n, geometryRetained2, 2);
            } else {
                this.geometryList.add(n, null);
                this.sendDataChangedMessage(n, null, 2);
            }
        } else if (this.inImmCtx) {
            if (geometry != null && geometry.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained1"));
            }
        } else if (geometry != null) {
            this.geometryList.add(n, (GeometryRetained)geometry.retained);
        } else {
            this.geometryList.add(n, null);
        }
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickRay pickRay, double[] dArray) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && (geometryRetained.mirrorGeometry == null ? geometryRetained.intersect(transform3D, pickRay, dArray) : geometryRetained.mirrorGeometry.intersect(transform3D, pickRay, dArray))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && (geometryRetained.mirrorGeometry == null ? geometryRetained.intersect(transform3D, pickShape) : geometryRetained.mirrorGeometry.intersect(transform3D, pickShape))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersectGeometryList(Transform3D transform3D, Bounds bounds) {
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null && geometryRetained.intersect(transform3D, bounds)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersectGeometryList(Transform3D transform3D, Transform3D transform3D2, ArrayList arrayList) {
        int n = 0;
        while (n < this.geometryList.size()) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    GeometryRetained geometryRetained2 = (GeometryRetained)arrayList.get(n2);
                    if (geometryRetained2 != null && geometryRetained.intersect(transform3D, transform3D2, geometryRetained2)) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    void markAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addAltApp(alternateAppearanceRetained);
    }

    void markAllNodesForScopedFog(FogRetained fogRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addFog(fogRetained);
    }

    void markAllNodesForScopedLight(LightRetained lightRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addLight(lightRetained);
    }

    void markAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addModelClip(modelClipRetained);
    }

    int numGeometries() {
        return this.geometryList.size();
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        int n = 0;
        while (n < this.numAltApps) {
            if (this.altApps[n] == alternateAppearanceRetained) {
                this.altApps[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numAltApps) {
            this.altApps[n - 1] = this.altApps[n];
            ++n;
        }
        --this.numAltApps;
    }

    void removeFog(FogRetained fogRetained) {
        int n = 0;
        while (n < this.numfogs) {
            if (this.fogs[n] == fogRetained) {
                this.fogs[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numfogs) {
            this.fogs[n - 1] = this.fogs[n];
            ++n;
        }
        --this.numfogs;
    }

    void removeGeometry(int n) {
        GeometryRetained geometryRetained = null;
        if (((Shape3D)this.source).isLive()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained != null) {
                geometryRetained.clearLive(this.refCount);
                int n2 = 0;
                while (n2 < this.mirrorShape3D.size()) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n2);
                    geometryRetained.removeUser(shape3DRetained);
                    ++n2;
                }
                this.sendDataChangedMessage(n, null, 3);
            } else {
                this.removeNullGeometryAtom(n);
            }
        }
        this.geometryList.remove(n);
    }

    void removeLight(LightRetained lightRetained) {
        int n = 0;
        while (n < this.numlights) {
            if (this.lights[n] == lightRetained) {
                this.lights[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numlights) {
            this.lights[n - 1] = this.lights[n];
            ++n;
        }
        --this.numlights;
    }

    void removeModelClip(ModelClipRetained modelClipRetained) {
        int n = 0;
        while (n < this.numModelClips) {
            if (this.modelClips[n] == modelClipRetained) {
                this.modelClips[n] = null;
                break;
            }
            ++n;
        }
        ++n;
        while (n < this.numModelClips) {
            this.modelClips[n - 1] = this.modelClips[n];
            ++n;
        }
        --this.numModelClips;
    }

    private void removeNullGeometryAtom(int n) {
        int n2 = 0;
        while (n2 < this.mirrorShape3D.size()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n2);
            shape3DRetained.mirrorShape3DLock.writeLock();
            int n3 = n;
            while (n3 < shape3DRetained.geomAtomArrayCount - 1) {
                shape3DRetained.geomAtomArray[n3] = shape3DRetained.geomAtomArray[n3 + 1];
                ++n3;
            }
            --shape3DRetained.geomAtomArrayCount;
            shape3DRetained.mirrorShape3DLock.writeUnlock();
            ++n2;
        }
    }

    private void sendDataChangedMessage(int n, GeometryRetained geometryRetained, int n2) {
        Object object;
        Text3DRetained text3DRetained = null;
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        ArrayList<GeometryAtom> arrayList2 = new ArrayList<GeometryAtom>();
        ArrayList<GeometryAtom> arrayList3 = new ArrayList<GeometryAtom>();
        ArrayList<GeometryAtom> arrayList4 = new ArrayList<GeometryAtom>();
        GeometryAtom[] geometryAtomArray = null;
        int n3 = 0;
        while (n3 < this.mirrorShape3D.size()) {
            int n4;
            Object object2;
            arrayList3.clear();
            arrayList4.clear();
            object = (Shape3DRetained)this.mirrorShape3D.get(n3);
            if (geometryRetained != null) {
                geometryRetained.addUser((Shape3DRetained)object);
            }
            ((Shape3DRetained)object).mirrorShape3DLock.writeLock();
            if (n >= ((Shape3DRetained)object).geomAtomArrayCount || n2 == 2 && n + 1 >= ((Shape3DRetained)object).geomAtomArrayCount) {
                if (((Shape3DRetained)object).geomAtomArrayCount >= ((Shape3DRetained)object).geomAtomArrayMaxSize) {
                    ((Shape3DRetained)object).geomAtomArrayMaxSize += ((Shape3DRetained)object).geomAtomArrayBlockSize;
                    ((Shape3DRetained)object).geomAtomArrayBlockSize += 5;
                    object2 = ((Shape3DRetained)object).geomAtomArray;
                    ((Shape3DRetained)object).geomAtomArray = new GeometryAtom[((Shape3DRetained)object).geomAtomArrayMaxSize][];
                    int n5 = 0;
                    while (n5 < ((Shape3DRetained)object).geomAtomArrayCount) {
                        ((Shape3DRetained)object).geomAtomArray[n5] = object2[n5];
                        ++n5;
                    }
                }
                if (n2 == 2) {
                    n4 = ((Shape3DRetained)object).geomAtomArrayCount - 1;
                    while (n4 >= n) {
                        ((Shape3DRetained)object).geomAtomArray[n4 + 1] = ((Shape3DRetained)object).geomAtomArray[n4];
                        --n4;
                    }
                }
                ++((Shape3DRetained)object).geomAtomArrayCount;
            } else if (((Shape3DRetained)object).geomAtomArray[n] != null) {
                if (n2 == 2) {
                    n4 = ((Shape3DRetained)object).geomAtomArrayCount - 1;
                    while (n4 >= n) {
                        ((Shape3DRetained)object).geomAtomArray[n4 + 1] = ((Shape3DRetained)object).geomAtomArray[n4];
                        --n4;
                    }
                    ++((Shape3DRetained)object).geomAtomArrayCount;
                } else {
                    n4 = 0;
                    while (n4 < ((Shape3DRetained)object).geomAtomArray[n].length) {
                        arrayList2.add(((Shape3DRetained)object).geomAtomArray[n][n4]);
                        arrayList3.add(((Shape3DRetained)object).geomAtomArray[n][n4]);
                        ++n4;
                    }
                    ((Shape3DRetained)object).geomAtomArray[n] = null;
                    if (n2 == 3) {
                        n4 = n;
                        while (n4 < ((Shape3DRetained)object).geomAtomArrayCount - 1) {
                            ((Shape3DRetained)object).geomAtomArray[n4] = ((Shape3DRetained)object).geomAtomArray[n4 + 1];
                            ++n4;
                        }
                        --((Shape3DRetained)object).geomAtomArrayCount;
                    }
                }
            }
            if (n2 != 3 && geometryRetained != null) {
                GeometryAtom geometryAtom;
                if (geometryRetained.geoType == 16) {
                    text3DRetained = (Text3DRetained)geometryRetained;
                    geometryAtomArray = new GeometryAtom[text3DRetained.numChars];
                    int n6 = 0;
                    while (n6 < text3DRetained.numChars) {
                        geometryAtomArray[n6] = geometryAtom = new GeometryAtom();
                        geometryAtom.locale = ((NodeRetained)object).locale;
                        geometryAtom.visible = this.visible;
                        geometryAtom.geoType = geometryRetained.geoType;
                        if (text3DRetained.font3D.fontData[text3DRetained.charIndex[n6]] != null) {
                            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)text3DRetained.font3D.fontData[text3DRetained.charIndex[n6]].retained;
                            geometryAtom.geometry = geometryArrayRetained;
                            if (this.boundsAutoCompute) {
                                geometryAtom.bounds = (Bounds)geometryRetained.geoBounds.clone();
                                geometryAtom.bounds.transform(geometryAtom.bounds, text3DRetained.charTransforms[n6]);
                            } else {
                                geometryAtom.bounds = this.localBounds;
                            }
                        } else {
                            geometryAtom.geometry = null;
                        }
                        geometryAtom.source = object;
                        geometryAtom.currentLocalTransform = text3DRetained.charTransforms[n6];
                        geometryAtom.lastLocalTransform = text3DRetained.charTransforms[n6];
                        geometryAtom.evalAlphaEditable();
                        if (this.inOrderedGroup) {
                            geometryAtom.orderedGroupsPath = ((Shape3DRetained)object).orderedGroupsPath;
                            geometryAtom.orderedChildIdsPath = ((Shape3DRetained)object).orderedChildIdsPath;
                        }
                        arrayList.add(geometryAtom);
                        arrayList4.add(geometryAtom);
                        ++n6;
                    }
                } else {
                    geometryAtom = new GeometryAtom();
                    geometryAtomArray = new GeometryAtom[]{geometryAtom};
                    geometryAtom.locale = ((NodeRetained)object).locale;
                    geometryAtom.visible = this.visible;
                    geometryAtom.geometry = geometryRetained;
                    geometryAtom.geoType = geometryRetained.geoType;
                    geometryAtom.source = object;
                    geometryAtom.bounds = this.boundsAutoCompute ? geometryRetained.geoBounds : this.localBounds;
                    geometryAtom.evalAlphaEditable();
                    if (this.inOrderedGroup) {
                        geometryAtom.orderedGroupsPath = ((Shape3DRetained)object).orderedGroupsPath;
                        geometryAtom.orderedChildIdsPath = ((Shape3DRetained)object).orderedChildIdsPath;
                    }
                    arrayList.add(geometryAtom);
                    arrayList4.add(geometryAtom);
                }
                ((Shape3DRetained)object).geomAtomArray[n] = geometryAtomArray;
            }
            ((Shape3DRetained)object).mirrorShape3DLock.writeUnlock();
            if (((Shape3DRetained)object).parentList != null) {
                n3 = 0;
                while (n3 < ((Shape3DRetained)object).parentList.size()) {
                    object2 = (TransformGroupRetained)((Shape3DRetained)object).parentList.get(n3);
                    ((TransformGroupRetained)object2).updateTargets(arrayList3, arrayList4);
                    ++n3;
                }
            }
            ++n3;
        }
        if (arrayList2.size() != 0 || arrayList.size() != 0) {
            object = VirtualUniverse.mc.getMessage();
            ((J3dMessage)object).type = 24;
            ((J3dMessage)object).threads = 8384;
            ((J3dMessage)object).universe = this.universe;
            ((J3dMessage)object).args[0] = this;
            ((J3dMessage)object).args[1] = new Integer(1);
            ((J3dMessage)object).args[2] = arrayList2.toArray();
            ((J3dMessage)object).args[3] = arrayList.toArray();
            VirtualUniverse.mc.processMessage((J3dMessage)object);
        }
    }

    void setAppearance(Appearance appearance) {
        boolean bl = false;
        if (((Shape3D)this.source).isLive()) {
            Shape3DRetained shape3DRetained;
            int n;
            if (appearance != null && ((AppearanceRetained)appearance.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained2"));
            }
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                n = 0;
                while (n < this.mirrorShape3D.size()) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                    this.appearance.removeAMirrorUser(shape3DRetained);
                    ++n;
                }
            }
            if (appearance != null) {
                ((AppearanceRetained)appearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)appearance.retained;
                n = 0;
                while (n < this.mirrorShape3D.size()) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                    this.appearance.addAMirrorUser(shape3DRetained);
                    ++n;
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    bl = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                bl = true;
            }
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            if (bl) {
                j3dMessage.threads |= 0x40;
            }
            j3dMessage.type = 24;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(2);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = appearance == null ? null : this.appearance.mirror.clone();
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else {
            this.appearance = appearance == null ? null : (AppearanceRetained)appearance.retained;
        }
    }

    void setAppearanceOverrideEnable(boolean bl) {
        if (((Shape3D)this.source).isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 24;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(16);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = bl ? Boolean.TRUE : Boolean.FALSE;
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.appearanceOverrideEnable = bl;
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 35;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[1] = this.localBounds != null ? this.localBounds.clone() : null;
            int n = 0;
            while (n < this.mirrorShape3D.size()) {
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                shape3DRetained.localBounds = (Bounds)j3dMessage.args[1];
                ++n;
            }
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            if (!bl) {
                this.localBounds = this.getBounds();
            }
            super.setBoundsAutoCompute(bl);
            if (this.source.isLive()) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[2] = bl ? null : (this.localBounds != null ? this.localBounds.clone() : null);
                Shape3DRetained shape3DRetained = null;
                int n = 0;
                while (n < this.mirrorShape3D.size()) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                    if (!bl) {
                        shape3DRetained.localBounds = (Bounds)j3dMessage.args[2];
                    }
                    ++n;
                }
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
                j3dMessage.args[1] = bl ? Boolean.TRUE : Boolean.FALSE;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8192;
            j3dMessage.universe = this.universe;
            j3dMessage.args[1] = this.collisionBound.clone();
            int n = 0;
            while (n < this.mirrorShape3D.size()) {
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                shape3DRetained.collisionBound = (Bounds)j3dMessage.args[1];
                ++n;
            }
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    static final void setGeomAtomsList(Shape3DRetained shape3DRetained, int n, GeometryAtom[] geometryAtomArray) {
        shape3DRetained.mirrorShape3DLock.readLock();
        if (shape3DRetained.geomAtomArrayCount > n) {
            shape3DRetained.geomAtomArray[n] = geometryAtomArray;
        }
        shape3DRetained.mirrorShape3DLock.readUnlock();
    }

    void setGeometry(Geometry geometry, int n) {
        GeometryRetained geometryRetained;
        GeometryRetained geometryRetained2 = null;
        GeometryRetained geometryRetained3 = null;
        int n2 = this.geometryList.size();
        if (n2 > 1 && (geometryRetained = (GeometryRetained)this.geometryList.get(0)) != null && geometry != null && !geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
        }
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null && ((GeometryRetained)geometry.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained0"));
            }
            geometryRetained3 = (GeometryRetained)this.geometryList.get(n);
            if (geometryRetained3 != null) {
                geometryRetained3.clearLive(this.refCount);
                int n3 = 0;
                while (n3 < this.mirrorShape3D.size()) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    geometryRetained3.removeUser(shape3DRetained);
                    ++n3;
                }
            }
            if (geometry != null) {
                geometryRetained2 = (GeometryRetained)geometry.retained;
                geometryRetained2.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.set(n, geometryRetained2);
                this.sendDataChangedMessage(n, geometryRetained2, 1);
            } else {
                this.geometryList.set(n, null);
                this.sendDataChangedMessage(n, null, 1);
            }
        } else if (this.inImmCtx) {
            if (geometry != null && geometry.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained1"));
            }
        } else if (geometry != null) {
            this.geometryList.set(n, (GeometryRetained)geometry.retained);
        } else {
            this.geometryList.set(n, null);
        }
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setLive(SetLiveState setLiveState) {
        GeometryRetained geometryRetained;
        int n;
        super.doSetLive(setLiveState);
        this.nodeId = this.universe.getNodeId();
        if (this.appearance != null) {
            if (this.appearance.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained2"));
            }
            this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
        }
        if (this.geometryList != null) {
            n = 0;
            while (n < this.geometryList.size()) {
                geometryRetained = (GeometryRetained)this.geometryList.get(n);
                if (geometryRetained != null) {
                    if (geometryRetained.getInImmCtx()) {
                        throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained4"));
                    }
                    geometryRetained.setLive(this.inBackgroundGroup, setLiveState.refCount);
                }
                ++n;
            }
        }
        if (this.inSharedGroup) {
            int n2 = 0;
            while (n2 < setLiveState.keys.length) {
                Shape3DRetained shape3DRetained = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
                shape3DRetained.key = setLiveState.keys[n2];
                shape3DRetained.currentLocalToVworld = new Transform3D[1];
                shape3DRetained.lastLocalToVworld = new Transform3D[1];
                int n3 = 0;
                while (n3 < this.currentLocalToVworld.length) {
                    if (this.localToVworldKeys[n3].equals(shape3DRetained.key)) break;
                    ++n3;
                }
                shape3DRetained.currentLocalToVworld[0] = this.currentLocalToVworld[n3];
                shape3DRetained.lastLocalToVworld[0] = this.lastLocalToVworld[n3];
                shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(n3);
                shape3DRetained.isPickable = setLiveState.pickable[n2];
                shape3DRetained.isCollidable = setLiveState.collidable[n2];
                shape3DRetained.parentList = (ArrayList)setLiveState.parentTransformGroups[n2].clone();
                if (this.inOrderedGroup) {
                    shape3DRetained.orderedGroupsPath = (ArrayList)setLiveState.orderedGroupsPath.clone();
                    shape3DRetained.orderedChildIdsPath = (ArrayList)setLiveState.orderedChildIdsPath.clone();
                }
                this.initMirrorShape3D(shape3DRetained);
                if (setLiveState.lights != null) {
                    n3 = 0;
                    while (n3 < setLiveState.lights.size()) {
                        shape3DRetained.addLight((LightRetained)setLiveState.lights.get(n3));
                        ++n3;
                    }
                }
                if (setLiveState.fogs != null) {
                    n3 = 0;
                    while (n3 < setLiveState.fogs.size()) {
                        shape3DRetained.addFog((FogRetained)setLiveState.fogs.get(n3));
                        ++n3;
                    }
                }
                if (setLiveState.modelClips != null) {
                    n3 = 0;
                    while (n3 < setLiveState.modelClips.size()) {
                        shape3DRetained.addModelClip((ModelClipRetained)setLiveState.modelClips.get(n3));
                        ++n3;
                    }
                }
                if (setLiveState.altAppearances != null) {
                    n3 = 0;
                    while (n3 < setLiveState.altAppearances.size()) {
                        shape3DRetained.addAltApp((AlternateAppearanceRetained)setLiveState.altAppearances.get(n3));
                        ++n3;
                    }
                }
                this.mirrorShape3D.add(shape3DRetained);
                if (this.geometryList != null) {
                    n = 0;
                    while (n < this.geometryList.size()) {
                        geometryRetained = (GeometryRetained)this.geometryList.get(n);
                        if (geometryRetained != null) {
                            geometryRetained.addUser(shape3DRetained);
                        }
                        ++n;
                    }
                }
                if (this.appearance != null) {
                    this.appearance.addAMirrorUser(shape3DRetained);
                }
                setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                if (setLiveState.transformTargets != null) {
                    setLiveState.transformTargets.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                    setLiveState.transformTargetThreads |= 0x20C0;
                }
                if (setLiveState.switchLevels[n2] >= 0) {
                    shape3DRetained.clearCompositeSwitchMask();
                    shape3DRetained.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n2]);
                    containsNodes.geoNodes.add(shape3DRetained);
                    shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[n2];
                    shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[n2];
                }
                ++n2;
            }
        } else {
            int n4;
            Shape3DRetained shape3DRetained = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
            shape3DRetained.currentLocalToVworld = new Transform3D[1];
            shape3DRetained.lastLocalToVworld = new Transform3D[1];
            shape3DRetained.currentLocalToVworld[0] = this.currentLocalToVworld[0];
            shape3DRetained.lastLocalToVworld[0] = this.lastLocalToVworld[0];
            shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape3DRetained.isPickable = setLiveState.pickable[0];
            shape3DRetained.isCollidable = setLiveState.collidable[0];
            shape3DRetained.parentList = (ArrayList)setLiveState.parentTransformGroups[0].clone();
            if (this.inOrderedGroup) {
                shape3DRetained.orderedGroupsPath = (ArrayList)setLiveState.orderedGroupsPath.clone();
                shape3DRetained.orderedChildIdsPath = (ArrayList)setLiveState.orderedChildIdsPath.clone();
            }
            this.initMirrorShape3D(shape3DRetained);
            if (setLiveState.lights != null) {
                n4 = 0;
                while (n4 < setLiveState.lights.size()) {
                    shape3DRetained.addLight((LightRetained)setLiveState.lights.get(n4));
                    ++n4;
                }
            }
            if (setLiveState.fogs != null) {
                n4 = 0;
                while (n4 < setLiveState.fogs.size()) {
                    shape3DRetained.addFog((FogRetained)setLiveState.fogs.get(n4));
                    ++n4;
                }
            }
            if (setLiveState.modelClips != null) {
                n4 = 0;
                while (n4 < setLiveState.modelClips.size()) {
                    shape3DRetained.addModelClip((ModelClipRetained)setLiveState.modelClips.get(n4));
                    ++n4;
                }
            }
            if (setLiveState.altAppearances != null) {
                n4 = 0;
                while (n4 < setLiveState.altAppearances.size()) {
                    shape3DRetained.addAltApp((AlternateAppearanceRetained)setLiveState.altAppearances.get(n4));
                    ++n4;
                }
            }
            this.mirrorShape3D.add(shape3DRetained);
            if (this.geometryList != null) {
                n = 0;
                while (n < this.geometryList.size()) {
                    geometryRetained = (GeometryRetained)this.geometryList.get(n);
                    if (geometryRetained != null) {
                        geometryRetained.addUser(shape3DRetained);
                    }
                    ++n;
                }
            }
            if (this.appearance != null) {
                this.appearance.addAMirrorUser(shape3DRetained);
            }
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
            if (setLiveState.transformTargets != null) {
                setLiveState.transformTargets.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                setLiveState.transformTargetThreads |= 0x20C0;
            }
            if (setLiveState.switchLevels[0] >= 0) {
                shape3DRetained.clearCompositeSwitchMask();
                shape3DRetained.isNewSwitchLeaf = true;
                ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
                containsNodes.geoNodes.add(shape3DRetained);
                shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[0];
                shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[0];
            }
        }
        setLiveState.notifyThreads |= 0x10C0;
        super.markAsLive();
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updateCollidable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isCollidable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals(shape3DRetained.key)) {
                        shape3DRetained.isCollidable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n;
        int n2 = (Integer)objectArray[1];
        ArrayList arrayList = (ArrayList)objectArray[2];
        if ((n2 & 2) != 0) {
            n = 0;
            while (n < arrayList.size()) {
                ((Shape3DRetained)arrayList.get((int)n)).appearance = (AppearanceRetained)objectArray[3];
                ++n;
            }
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
            while (n < arrayList.size()) {
                ((Shape3DRetained)arrayList.get((int)n)).appearanceOverrideEnable = (Boolean)objectArray[3];
                ++n;
            }
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updatePickable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isPickable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals(shape3DRetained.key)) {
                        shape3DRetained.isPickable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

