/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dI18N;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.GMatrix;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import javax.vecmath.Vector4f;

public class Transform3D {
    double[] mat = new double[16];
    private double[] tmp = new double[9];
    double[] rot = new double[9];
    double[] scales = new double[3];
    int type = 0;
    boolean autoNormalize = false;
    boolean positiveDeterminant = true;
    boolean svdAllocd = false;
    private double[] u1 = null;
    private double[] v1 = null;
    private double[] t1 = null;
    private double[] t2 = null;
    private double[] ts = null;
    private double[] svdTmp = null;
    private double[] svdRot = null;
    private double[] single_values = null;
    private double[] e = null;
    private double[] svdScales = null;
    private int[] svdOut = null;
    private double[] svdMag = null;
    private double[] cosl = null;
    private double[] cosr = null;
    private double[] sinl = null;
    private double[] sinr = null;
    private double[] qr_m = null;
    private double[] tmpMat = new double[16];
    private static final double EPS = 1.110223024E-16;
    private static final double ERR_EPS = 1.0E-8;
    boolean rotDirty = true;
    boolean scalesDirty = true;
    private double xin;
    private double yin;
    private double zin;
    private double xout;
    private double yout;
    private double zout;
    static final double EPSILON_ABSOLUTE = 1.0E-6;
    static final double EPSILON_RELATIVE = 1.0E-4;
    public static final int ZERO = 1;
    public static final int IDENTITY = 2;
    public static final int SCALE = 4;
    public static final int TRANSLATION = 8;
    public static final int ORTHOGONAL = 16;
    public static final int RIGID = 32;
    public static final int CONGRUENT = 64;
    public static final int AFFINE = 128;
    public static final int NEGATIVE_DETERMINANT = 256;

    public Transform3D() {
        this.setIdentity();
    }

    public Transform3D(Transform3D transform3D) {
        this.mat[0] = transform3D.mat[0];
        this.mat[1] = transform3D.mat[1];
        this.mat[2] = transform3D.mat[2];
        this.mat[3] = transform3D.mat[3];
        this.mat[4] = transform3D.mat[4];
        this.mat[5] = transform3D.mat[5];
        this.mat[6] = transform3D.mat[6];
        this.mat[7] = transform3D.mat[7];
        this.mat[8] = transform3D.mat[8];
        this.mat[9] = transform3D.mat[9];
        this.mat[10] = transform3D.mat[10];
        this.mat[11] = transform3D.mat[11];
        this.mat[12] = transform3D.mat[12];
        this.mat[13] = transform3D.mat[13];
        this.mat[14] = transform3D.mat[14];
        this.mat[15] = transform3D.mat[15];
        this.type = transform3D.type;
        this.autoNormalize = transform3D.autoNormalize;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public Transform3D(GMatrix gMatrix) {
        int n = gMatrix.getNumRow();
        int n2 = gMatrix.getNumCol();
        int n3 = 0;
        while (n3 < 4) {
            int n4 = n3 * 4;
            int n5 = 0;
            while (n5 < 4) {
                this.mat[n4 + n5] = n3 >= n || n5 >= n2 ? 0.0 : gMatrix.getElement(n3, n5);
                ++n5;
            }
            ++n3;
        }
        this.classify();
    }

    public Transform3D(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.mat[0] = matrix3d.m00 * d;
        this.mat[1] = matrix3d.m01 * d;
        this.mat[2] = matrix3d.m02 * d;
        this.mat[3] = vector3d.x;
        this.mat[4] = matrix3d.m10 * d;
        this.mat[5] = matrix3d.m11 * d;
        this.mat[6] = matrix3d.m12 * d;
        this.mat[7] = vector3d.y;
        this.mat[8] = matrix3d.m20 * d;
        this.mat[9] = matrix3d.m21 * d;
        this.mat[10] = matrix3d.m22 * d;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
    }

    public Transform3D(Matrix3f matrix3f, Vector3d vector3d, double d) {
        this.mat[0] = (double)matrix3f.m00 * d;
        this.mat[1] = (double)matrix3f.m01 * d;
        this.mat[2] = (double)matrix3f.m02 * d;
        this.mat[3] = vector3d.x;
        this.mat[4] = (double)matrix3f.m10 * d;
        this.mat[5] = (double)matrix3f.m11 * d;
        this.mat[6] = (double)matrix3f.m12 * d;
        this.mat[7] = vector3d.y;
        this.mat[8] = (double)matrix3f.m20 * d;
        this.mat[9] = (double)matrix3f.m21 * d;
        this.mat[10] = (double)matrix3f.m22 * d;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
    }

    public Transform3D(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.mat[0] = matrix3f.m00 * f;
        this.mat[1] = matrix3f.m01 * f;
        this.mat[2] = matrix3f.m02 * f;
        this.mat[3] = vector3f.x;
        this.mat[4] = matrix3f.m10 * f;
        this.mat[5] = matrix3f.m11 * f;
        this.mat[6] = matrix3f.m12 * f;
        this.mat[7] = vector3f.y;
        this.mat[8] = matrix3f.m20 * f;
        this.mat[9] = matrix3f.m21 * f;
        this.mat[10] = matrix3f.m22 * f;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
    }

    public Transform3D(Matrix4d matrix4d) {
        this.mat[0] = matrix4d.m00;
        this.mat[1] = matrix4d.m01;
        this.mat[2] = matrix4d.m02;
        this.mat[3] = matrix4d.m03;
        this.mat[4] = matrix4d.m10;
        this.mat[5] = matrix4d.m11;
        this.mat[6] = matrix4d.m12;
        this.mat[7] = matrix4d.m13;
        this.mat[8] = matrix4d.m20;
        this.mat[9] = matrix4d.m21;
        this.mat[10] = matrix4d.m22;
        this.mat[11] = matrix4d.m23;
        this.mat[12] = matrix4d.m30;
        this.mat[13] = matrix4d.m31;
        this.mat[14] = matrix4d.m32;
        this.mat[15] = matrix4d.m33;
        this.classify();
    }

    public Transform3D(Matrix4f matrix4f) {
        this.mat[0] = matrix4f.m00;
        this.mat[1] = matrix4f.m01;
        this.mat[2] = matrix4f.m02;
        this.mat[3] = matrix4f.m03;
        this.mat[4] = matrix4f.m10;
        this.mat[5] = matrix4f.m11;
        this.mat[6] = matrix4f.m12;
        this.mat[7] = matrix4f.m13;
        this.mat[8] = matrix4f.m20;
        this.mat[9] = matrix4f.m21;
        this.mat[10] = matrix4f.m22;
        this.mat[11] = matrix4f.m23;
        this.mat[12] = matrix4f.m30;
        this.mat[13] = matrix4f.m31;
        this.mat[14] = matrix4f.m32;
        this.mat[15] = matrix4f.m33;
        this.classify();
    }

    public Transform3D(Quat4d quat4d, Vector3d vector3d, double d) {
        this.rot[0] = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.rot[3] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.rot[6] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.rot[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.rot[4] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.rot[7] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.rot[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.rot[5] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.rot[8] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
        this.scales[1] = this.scales[2] = d;
        this.scales[0] = this.scales[2];
        Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        this.scalesDirty = false;
        this.rotDirty = false;
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
    }

    public Transform3D(Quat4f quat4f, Vector3d vector3d, double d) {
        this.rot[0] = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.rot[3] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.rot[6] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.rot[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.rot[4] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.rot[7] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.rot[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.rot[5] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.rot[8] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        this.scales[1] = this.scales[2] = d;
        this.scales[0] = this.scales[2];
        Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        this.scalesDirty = false;
        this.rotDirty = false;
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
    }

    public Transform3D(Quat4f quat4f, Vector3f vector3f, float f) {
        this.rot[0] = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.rot[3] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.rot[6] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.rot[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.rot[4] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.rot[7] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.rot[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.rot[5] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.rot[8] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        this.scales[1] = this.scales[2] = (double)f;
        this.scales[0] = this.scales[2];
        Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        this.scalesDirty = false;
        this.rotDirty = false;
        this.mat[3] = vector3f.x;
        this.mat[7] = vector3f.y;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
    }

    public Transform3D(double[] dArray) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = dArray[n];
            ++n;
        }
        this.classify();
    }

    public Transform3D(float[] fArray) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = fArray[n];
            ++n;
        }
        this.classify();
    }

    public final void add(Transform3D transform3D) {
        int n = 0;
        while (n < 16) {
            int n2 = n;
            this.mat[n2] = this.mat[n2] + transform3D.mat[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void add(Transform3D transform3D, Transform3D transform3D2) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = transform3D.mat[n] + transform3D2.mat[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    static final boolean almostEqual(double d, double d2) {
        double d3;
        if (d == d2) {
            return true;
        }
        double d4 = Math.abs(d - d2);
        if (d4 < 1.0E-6) {
            return true;
        }
        double d5 = Math.abs(d);
        double d6 = d5 >= (d3 = Math.abs(d2)) ? d5 : d3;
        return d4 / d6 < 1.0E-4;
    }

    final void classify() {
        block10: {
            block11: {
                block12: {
                    double d;
                    block17: {
                        block16: {
                            block13: {
                                block15: {
                                    block14: {
                                        this.type = 0;
                                        if (!Transform3D.almostEqual(this.mat[12], 0.0) || !Transform3D.almostEqual(this.mat[13], 0.0) || !Transform3D.almostEqual(this.mat[14], 0.0)) break block10;
                                        if (!Transform3D.almostEqual(this.mat[15], 1.0)) break block11;
                                        this.type |= 0x80;
                                        if (!Transform3D.almostEqual(this.mat[1], 0.0) || !Transform3D.almostEqual(this.mat[2], 0.0) || !Transform3D.almostEqual(this.mat[6], 0.0) || !Transform3D.almostEqual(this.mat[4], 0.0) || !Transform3D.almostEqual(this.mat[8], 0.0) || !Transform3D.almostEqual(this.mat[9], 0.0)) break block12;
                                        d = this.mat[0] * this.mat[5] * this.mat[10];
                                        if (Transform3D.almostEqual(d, 1.0) && Transform3D.almostEqual(Math.abs(this.mat[0]), 1.0) && Transform3D.almostEqual(Math.abs(this.mat[5]), 1.0) && Transform3D.almostEqual(Math.abs(this.mat[10]), 1.0)) {
                                            this.type |= 0x70;
                                        }
                                        if (!Transform3D.almostEqual(this.mat[3], 0.0) || !Transform3D.almostEqual(this.mat[7], 0.0) || !Transform3D.almostEqual(this.mat[11], 0.0)) break block13;
                                        if (Transform3D.almostEqual(this.mat[0], this.mat[5]) && Transform3D.almostEqual(this.mat[0], this.mat[10])) {
                                            this.type |= 4;
                                        }
                                        if (!Transform3D.almostEqual(this.mat[0], 1.0) || !Transform3D.almostEqual(this.mat[5], 1.0) || !Transform3D.almostEqual(this.mat[10], 1.0)) break block14;
                                        this.type |= 0x72;
                                        break block10;
                                    }
                                    if (Transform3D.almostEqual(this.mat[0], this.mat[5]) && Transform3D.almostEqual(this.mat[0], this.mat[10])) {
                                        this.type |= 0x60;
                                    }
                                    if (d != 0.0) break block15;
                                    this.type = 0;
                                    break block10;
                                }
                                if (!(d < 0.0)) break block10;
                                this.type |= 0x100;
                                break block10;
                            }
                            d = this.mat[0] * this.mat[5] * this.mat[10];
                            if (Transform3D.almostEqual(d, 1.0) && Transform3D.almostEqual(Math.abs(this.mat[0]), 1.0) && Transform3D.almostEqual(Math.abs(this.mat[5]), 1.0) && Transform3D.almostEqual(Math.abs(this.mat[10]), 1.0)) {
                                this.type |= 0x70;
                            }
                            if (!Transform3D.almostEqual(this.mat[0], 1.0) || !Transform3D.almostEqual(this.mat[5], 1.0) || !Transform3D.almostEqual(this.mat[10], 1.0)) break block16;
                            this.type |= 0x78;
                            break block10;
                        }
                        if (Transform3D.almostEqual(Math.abs(this.mat[0]), Math.abs(this.mat[5])) && Transform3D.almostEqual(Math.abs(this.mat[0]), Math.abs(this.mat[10]))) {
                            this.type |= 0x40;
                        }
                        if (d != 0.0) break block17;
                        this.type = 0;
                        break block10;
                    }
                    if (!(d < 0.0)) break block10;
                    this.type |= 0x100;
                    break block10;
                }
                double d = this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) + this.mat[1] * (this.mat[6] * this.mat[8] - this.mat[4] * this.mat[10]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
                if (d == 0.0) {
                    this.type = 0;
                    return;
                }
                if (d < 0.0) {
                    this.type |= 0x100;
                }
                double d2 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                double d3 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
                double d4 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10];
                if (!Transform3D.almostEqual(d2, d3) || !Transform3D.almostEqual(d2, d4)) break block10;
                this.type |= 0x40;
                if (!Transform3D.almostEqual(d2, 1.0)) break block10;
                this.type |= 0x20;
                if (!Transform3D.almostEqual(this.mat[3], 0.0) || !Transform3D.almostEqual(this.mat[7], 0.0) || !Transform3D.almostEqual(this.mat[11], 0.0)) break block10;
                this.type |= 0x10;
                break block10;
            }
            if (Transform3D.almostEqual(this.mat[15], 0.0)) {
                this.type = 1;
                int n = 0;
                while (n < 12) {
                    if (!Transform3D.almostEqual(this.mat[n], 0.0)) {
                        this.type = 0;
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private final void computeRotScales(double[] dArray, double[] dArray2) {
        this.formatRotScale(this, this.tmp);
        this.compute_svd(this.tmp, dArray2, dArray);
    }

    private final void computeScales(double[] dArray, double[] dArray2) {
        this.formatRotScale(this, this.tmp);
        this.compute_svd(this.tmp, dArray2, dArray);
    }

    static int compute_2X2(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n) {
        double d4;
        double d5;
        double d6 = 2.0;
        double d7 = 1.0;
        double d8 = dArray[0];
        double d9 = dArray[1];
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = d;
        double d16 = Math.abs(d15);
        double d17 = d3;
        double d18 = Math.abs(d3);
        int n2 = 1;
        boolean bl = d18 > d16;
        if (bl) {
            n2 = 3;
            double d19 = d15;
            d15 = d17;
            d17 = d19;
            d19 = d16;
            d16 = d18;
            d18 = d19;
        }
        if ((d5 = Math.abs(d4 = d2)) == 0.0) {
            dArray[1] = d18;
            dArray[0] = d16;
            d10 = 1.0;
            d11 = 1.0;
            d12 = 0.0;
            d13 = 0.0;
        } else {
            boolean bl2 = true;
            if (d5 > d16) {
                n2 = 2;
                if (d16 / d5 < 1.110223024E-16) {
                    bl2 = false;
                    d8 = d5;
                    d9 = d18 > 1.0 ? d16 / (d5 / d18) : d16 / d5 * d18;
                    d10 = 1.0;
                    d12 = d17 / d4;
                    d13 = 1.0;
                    d11 = d15 / d4;
                }
            }
            if (bl2) {
                double d20 = d16 - d18;
                double d21 = d20 == d16 ? 1.0 : d20 / d16;
                double d22 = d4 / d15;
                double d23 = 2.0 - d21;
                double d24 = d22 * d22;
                double d25 = d23 * d23;
                double d26 = Math.sqrt(d25 + d24);
                double d27 = d21 == 0.0 ? Math.abs(d22) : Math.sqrt(d21 * d21 + d24);
                double d28 = (d26 + d27) * 0.5;
                if (d5 > d16) {
                    n2 = 2;
                    if (d16 / d5 < 1.110223024E-16) {
                        bl2 = false;
                        d8 = d5;
                        d9 = d18 > 1.0 ? d16 / (d5 / d18) : d16 / d5 * d18;
                        d10 = 1.0;
                        d12 = d17 / d4;
                        d13 = 1.0;
                        d11 = d15 / d4;
                    }
                }
                if (bl2) {
                    d20 = d16 - d18;
                    d21 = d20 == d16 ? 1.0 : d20 / d16;
                    d22 = d4 / d15;
                    d23 = 2.0 - d21;
                    d24 = d22 * d22;
                    d25 = d23 * d23;
                    d26 = Math.sqrt(d25 + d24);
                    d27 = d21 == 0.0 ? Math.abs(d22) : Math.sqrt(d21 * d21 + d24);
                    d28 = (d26 + d27) * 0.5;
                    d9 = d18 / d28;
                    d8 = d16 * d28;
                    d23 = d24 == 0.0 ? (d21 == 0.0 ? Transform3D.d_sign(d6, d15) * Transform3D.d_sign(d7, d4) : d4 / Transform3D.d_sign(d20, d15) + d22 / d23) : (d22 / (d26 + d23) + d22 / (d27 + d21)) * (d28 + 1.0);
                    d21 = Math.sqrt(d23 * d23 + 4.0);
                    d11 = 2.0 / d21;
                    d13 = d23 / d21;
                    d10 = (d11 + d13 * d22) / d28;
                    d12 = d17 / d15 * d13 / d28;
                }
            }
            if (bl) {
                dArray3[0] = d13;
                dArray2[0] = d11;
                dArray5[0] = d12;
                dArray4[0] = d10;
            } else {
                dArray3[0] = d10;
                dArray2[0] = d12;
                dArray5[0] = d11;
                dArray4[0] = d13;
            }
            if (n2 == 1) {
                d14 = Transform3D.d_sign(d7, dArray5[0]) * Transform3D.d_sign(d7, dArray3[0]) * Transform3D.d_sign(d7, d);
            }
            if (n2 == 2) {
                d14 = Transform3D.d_sign(d7, dArray4[0]) * Transform3D.d_sign(d7, dArray3[0]) * Transform3D.d_sign(d7, d2);
            }
            if (n2 == 3) {
                d14 = Transform3D.d_sign(d7, dArray4[0]) * Transform3D.d_sign(d7, dArray2[0]) * Transform3D.d_sign(d7, d3);
            }
            dArray[n] = Transform3D.d_sign(d8, d14);
            double d29 = d14 * Transform3D.d_sign(d7, d) * Transform3D.d_sign(d7, d3);
            dArray[n + 1] = Transform3D.d_sign(d9, d29);
        }
        return 0;
    }

    private int compute_qr(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d;
        double d2;
        int n = 10;
        double d3 = 4.89E-15;
        double d4 = 1.0;
        double d5 = -1.0;
        boolean bl = false;
        int n2 = 1;
        if (Math.abs(dArray2[1]) < 4.89E-15 || Math.abs(dArray2[0]) < 4.89E-15) {
            bl = true;
        }
        int n3 = 0;
        while (n3 < 10 && !bl) {
            double d6 = Transform3D.compute_shift(dArray[1], dArray2[1], dArray[2]);
            double d7 = (Math.abs(dArray[0]) - d6) * (Transform3D.d_sign(d4, dArray[0]) + d6 / dArray[0]);
            double d8 = dArray2[0];
            double d9 = Transform3D.compute_rot(d7, d8, this.sinr, this.cosr, 0, n2);
            d7 = this.cosr[0] * dArray[0] + this.sinr[0] * dArray2[0];
            dArray2[0] = this.cosr[0] * dArray2[0] - this.sinr[0] * dArray[0];
            d8 = this.sinr[0] * dArray[1];
            dArray[1] = this.cosr[0] * dArray[1];
            d9 = Transform3D.compute_rot(d7, d8, this.sinl, this.cosl, 0, n2);
            n2 = 0;
            dArray[0] = d9;
            d7 = this.cosl[0] * dArray2[0] + this.sinl[0] * dArray[1];
            dArray[1] = this.cosl[0] * dArray[1] - this.sinl[0] * dArray2[0];
            d8 = this.sinl[0] * dArray2[1];
            dArray2[1] = this.cosl[0] * dArray2[1];
            dArray2[0] = d9 = Transform3D.compute_rot(d7, d8, this.sinr, this.cosr, 1, n2);
            d7 = this.cosr[1] * dArray[1] + this.sinr[1] * dArray2[1];
            dArray2[1] = this.cosr[1] * dArray2[1] - this.sinr[1] * dArray[1];
            d8 = this.sinr[1] * dArray[2];
            dArray[2] = this.cosr[1] * dArray[2];
            dArray[1] = d9 = Transform3D.compute_rot(d7, d8, this.sinl, this.cosl, 1, n2);
            d7 = this.cosl[1] * dArray2[1] + this.sinl[1] * dArray[2];
            dArray[2] = this.cosl[1] * dArray[2] - this.sinl[1] * dArray2[1];
            dArray2[1] = d7;
            d2 = dArray3[0];
            dArray3[0] = this.cosl[0] * d2 + this.sinl[0] * dArray3[3];
            dArray3[3] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[3];
            d2 = dArray3[1];
            dArray3[1] = this.cosl[0] * d2 + this.sinl[0] * dArray3[4];
            dArray3[4] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[4];
            d2 = dArray3[2];
            dArray3[2] = this.cosl[0] * d2 + this.sinl[0] * dArray3[5];
            dArray3[5] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[5];
            d2 = dArray3[3];
            dArray3[3] = this.cosl[1] * d2 + this.sinl[1] * dArray3[6];
            dArray3[6] = -this.sinl[1] * d2 + this.cosl[1] * dArray3[6];
            d2 = dArray3[4];
            dArray3[4] = this.cosl[1] * d2 + this.sinl[1] * dArray3[7];
            dArray3[7] = -this.sinl[1] * d2 + this.cosl[1] * dArray3[7];
            d2 = dArray3[5];
            dArray3[5] = this.cosl[1] * d2 + this.sinl[1] * dArray3[8];
            dArray3[8] = -this.sinl[1] * d2 + this.cosl[1] * dArray3[8];
            d = dArray4[0];
            dArray4[0] = this.cosr[0] * d + this.sinr[0] * dArray4[1];
            dArray4[1] = -this.sinr[0] * d + this.cosr[0] * dArray4[1];
            d = dArray4[3];
            dArray4[3] = this.cosr[0] * d + this.sinr[0] * dArray4[4];
            dArray4[4] = -this.sinr[0] * d + this.cosr[0] * dArray4[4];
            d = dArray4[6];
            dArray4[6] = this.cosr[0] * d + this.sinr[0] * dArray4[7];
            dArray4[7] = -this.sinr[0] * d + this.cosr[0] * dArray4[7];
            d = dArray4[1];
            dArray4[1] = this.cosr[1] * d + this.sinr[1] * dArray4[2];
            dArray4[2] = -this.sinr[1] * d + this.cosr[1] * dArray4[2];
            d = dArray4[4];
            dArray4[4] = this.cosr[1] * d + this.sinr[1] * dArray4[5];
            dArray4[5] = -this.sinr[1] * d + this.cosr[1] * dArray4[5];
            d = dArray4[7];
            dArray4[7] = this.cosr[1] * d + this.sinr[1] * dArray4[8];
            dArray4[8] = -this.sinr[1] * d + this.cosr[1] * dArray4[8];
            this.qr_m[0] = dArray[0];
            this.qr_m[1] = dArray2[0];
            this.qr_m[2] = 0.0;
            this.qr_m[3] = 0.0;
            this.qr_m[4] = dArray[1];
            this.qr_m[5] = dArray2[1];
            this.qr_m[6] = 0.0;
            this.qr_m[7] = 0.0;
            this.qr_m[8] = dArray[2];
            if (Math.abs(dArray2[1]) < 4.89E-15 || Math.abs(dArray2[0]) < 4.89E-15) {
                bl = true;
            }
            ++n3;
        }
        if (Math.abs(dArray2[1]) < 4.89E-15) {
            Transform3D.compute_2X2(dArray[0], dArray2[0], dArray[1], dArray, this.sinl, this.cosl, this.sinr, this.cosr, 0);
            d2 = dArray3[0];
            dArray3[0] = this.cosl[0] * d2 + this.sinl[0] * dArray3[3];
            dArray3[3] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[3];
            d2 = dArray3[1];
            dArray3[1] = this.cosl[0] * d2 + this.sinl[0] * dArray3[4];
            dArray3[4] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[4];
            d2 = dArray3[2];
            dArray3[2] = this.cosl[0] * d2 + this.sinl[0] * dArray3[5];
            dArray3[5] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[5];
            d = dArray4[0];
            dArray4[0] = this.cosr[0] * d + this.sinr[0] * dArray4[1];
            dArray4[1] = -this.sinr[0] * d + this.cosr[0] * dArray4[1];
            d = dArray4[3];
            dArray4[3] = this.cosr[0] * d + this.sinr[0] * dArray4[4];
            dArray4[4] = -this.sinr[0] * d + this.cosr[0] * dArray4[4];
            d = dArray4[6];
            dArray4[6] = this.cosr[0] * d + this.sinr[0] * dArray4[7];
            dArray4[7] = -this.sinr[0] * d + this.cosr[0] * dArray4[7];
        } else {
            Transform3D.compute_2X2(dArray[1], dArray2[1], dArray[2], dArray, this.sinl, this.cosl, this.sinr, this.cosr, 1);
            d2 = dArray3[3];
            dArray3[3] = this.cosl[0] * d2 + this.sinl[0] * dArray3[6];
            dArray3[6] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[6];
            d2 = dArray3[4];
            dArray3[4] = this.cosl[0] * d2 + this.sinl[0] * dArray3[7];
            dArray3[7] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[7];
            d2 = dArray3[5];
            dArray3[5] = this.cosl[0] * d2 + this.sinl[0] * dArray3[8];
            dArray3[8] = -this.sinl[0] * d2 + this.cosl[0] * dArray3[8];
            d = dArray4[1];
            dArray4[1] = this.cosr[0] * d + this.sinr[0] * dArray4[2];
            dArray4[2] = -this.sinr[0] * d + this.cosr[0] * dArray4[2];
            d = dArray4[4];
            dArray4[4] = this.cosr[0] * d + this.sinr[0] * dArray4[5];
            dArray4[5] = -this.sinr[0] * d + this.cosr[0] * dArray4[5];
            d = dArray4[7];
            dArray4[7] = this.cosr[0] * d + this.sinr[0] * dArray4[8];
            dArray4[8] = -this.sinr[0] * d + this.cosr[0] * dArray4[8];
        }
        return 0;
    }

    static double compute_rot(double d, double d2, double[] dArray, double[] dArray2, int n, int n2) {
        double d3;
        double d4;
        double d5;
        double d6 = 2.002083095183101E-146;
        double d7 = 4.994797680505588E145;
        if (d2 == 0.0) {
            d5 = 1.0;
            d4 = 0.0;
            d3 = d;
        } else if (d == 0.0) {
            d5 = 0.0;
            d4 = 1.0;
            d3 = d2;
        } else {
            double d8 = d;
            double d9 = d2;
            double d10 = Transform3D.max(Math.abs(d8), Math.abs(d9));
            if (d10 >= 4.994797680505588E145) {
                int n3 = 0;
                while (d10 >= 4.994797680505588E145) {
                    ++n3;
                    d10 = Transform3D.max(Math.abs(d8 *= 2.002083095183101E-146), Math.abs(d9 *= 2.002083095183101E-146));
                }
                d3 = Math.sqrt(d8 * d8 + d9 * d9);
                d5 = d8 / d3;
                d4 = d9 / d3;
                int n4 = n3;
                int n5 = 1;
                while (n5 <= n3) {
                    d3 *= 4.994797680505588E145;
                    ++n5;
                }
            } else if (d10 <= 2.002083095183101E-146) {
                int n6 = 0;
                while (d10 <= 2.002083095183101E-146) {
                    ++n6;
                    d10 = Transform3D.max(Math.abs(d8 *= 4.994797680505588E145), Math.abs(d9 *= 4.994797680505588E145));
                }
                d3 = Math.sqrt(d8 * d8 + d9 * d9);
                d5 = d8 / d3;
                d4 = d9 / d3;
                int n7 = n6;
                int n8 = 1;
                while (n8 <= n6) {
                    d3 *= 2.002083095183101E-146;
                    ++n8;
                }
            } else {
                d3 = Math.sqrt(d8 * d8 + d9 * d9);
                d5 = d8 / d3;
                d4 = d9 / d3;
            }
            if (Math.abs(d) > Math.abs(d2) && d5 < 0.0) {
                d5 = -d5;
                d4 = -d4;
                d3 = -d3;
            }
        }
        dArray[n] = d4;
        dArray2[n] = d5;
        return d3;
    }

    static final double compute_shift(double d, double d2, double d3) {
        double d4;
        double d5 = Math.abs(d);
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = Transform3D.min(d5, d7);
        double d9 = Transform3D.max(d5, d7);
        if (d8 == 0.0) {
            d4 = 0.0;
            if (d9 != 0.0) {
                double d10 = Transform3D.min(d9, d6) / Transform3D.max(d9, d6);
            }
        } else if (d6 < d9) {
            double d11 = d8 / d9 + 1.0;
            double d12 = (d9 - d8) / d9;
            double d13 = d6 / d9;
            double d14 = d13 * d13;
            double d15 = 2.0 / (Math.sqrt(d11 * d11 + d14) + Math.sqrt(d12 * d12 + d14));
            d4 = d8 * d15;
        } else {
            double d16 = d9 / d6;
            if (d16 == 0.0) {
                d4 = d8 * d9 / d6;
            } else {
                double d17 = d8 / d9 + 1.0;
                double d18 = (d9 - d8) / d9;
                double d19 = d17 * d16;
                double d20 = d18 * d16;
                double d21 = 1.0 / (Math.sqrt(d19 * d19 + 1.0) + Math.sqrt(d20 * d20 + 1.0));
                d4 = d8 * d21 * d16;
                d4 += d4;
            }
        }
        return d4;
    }

    private void compute_svd(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        if (!this.svdAllocd) {
            this.u1 = new double[9];
            this.v1 = new double[9];
            this.t1 = new double[9];
            this.t2 = new double[9];
            this.ts = new double[9];
            this.svdTmp = new double[9];
            this.svdRot = new double[9];
            this.single_values = new double[3];
            this.e = new double[3];
            this.svdScales = new double[3];
            this.svdOut = new int[3];
            this.svdMag = new double[3];
            this.cosl = new double[2];
            this.cosr = new double[2];
            this.sinl = new double[2];
            this.sinr = new double[2];
            this.qr_m = new double[9];
            this.svdAllocd = true;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 9) {
            this.svdRot[n2] = dArray[n2];
            ++n2;
        }
        if (dArray[3] * dArray[3] < 1.110223024E-16) {
            this.u1[0] = 1.0;
            this.u1[1] = 0.0;
            this.u1[2] = 0.0;
            this.u1[3] = 0.0;
            this.u1[4] = 1.0;
            this.u1[5] = 0.0;
            this.u1[6] = 0.0;
            this.u1[7] = 0.0;
            this.u1[8] = 1.0;
        } else if (dArray[0] * dArray[0] < 1.110223024E-16) {
            this.svdTmp[0] = dArray[0];
            this.svdTmp[1] = dArray[1];
            this.svdTmp[2] = dArray[2];
            dArray[0] = dArray[3];
            dArray[1] = dArray[4];
            dArray[2] = dArray[5];
            dArray[3] = -this.svdTmp[0];
            dArray[4] = -this.svdTmp[1];
            dArray[5] = -this.svdTmp[2];
            this.u1[0] = 0.0;
            this.u1[1] = 1.0;
            this.u1[2] = 0.0;
            this.u1[3] = -1.0;
            this.u1[4] = 0.0;
            this.u1[5] = 0.0;
            this.u1[6] = 0.0;
            this.u1[7] = 0.0;
            this.u1[8] = 1.0;
        } else {
            d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[3] * dArray[3]);
            double d2 = dArray[0] * d;
            double d3 = dArray[3] * d;
            this.svdTmp[0] = d2 * dArray[0] + d3 * dArray[3];
            this.svdTmp[1] = d2 * dArray[1] + d3 * dArray[4];
            this.svdTmp[2] = d2 * dArray[2] + d3 * dArray[5];
            dArray[3] = -d3 * dArray[0] + d2 * dArray[3];
            dArray[4] = -d3 * dArray[1] + d2 * dArray[4];
            dArray[5] = -d3 * dArray[2] + d2 * dArray[5];
            dArray[0] = this.svdTmp[0];
            dArray[1] = this.svdTmp[1];
            dArray[2] = this.svdTmp[2];
            this.u1[0] = d2;
            this.u1[1] = d3;
            this.u1[2] = 0.0;
            this.u1[3] = -d3;
            this.u1[4] = d2;
            this.u1[5] = 0.0;
            this.u1[6] = 0.0;
            this.u1[7] = 0.0;
            this.u1[8] = 1.0;
        }
        if (!(dArray[6] * dArray[6] < 1.110223024E-16)) {
            if (dArray[0] * dArray[0] < 1.110223024E-16) {
                this.svdTmp[0] = dArray[0];
                this.svdTmp[1] = dArray[1];
                this.svdTmp[2] = dArray[2];
                dArray[0] = dArray[6];
                dArray[1] = dArray[7];
                dArray[2] = dArray[8];
                dArray[6] = -this.svdTmp[0];
                dArray[7] = -this.svdTmp[1];
                dArray[8] = -this.svdTmp[2];
                this.svdTmp[0] = this.u1[0];
                this.svdTmp[1] = this.u1[1];
                this.svdTmp[2] = this.u1[2];
                this.u1[0] = this.u1[6];
                this.u1[1] = this.u1[7];
                this.u1[2] = this.u1[8];
                this.u1[6] = -this.svdTmp[0];
                this.u1[7] = -this.svdTmp[1];
                this.u1[8] = -this.svdTmp[2];
            } else {
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[6] * dArray[6]);
                double d4 = dArray[0] * d;
                double d5 = dArray[6] * d;
                this.svdTmp[0] = d4 * dArray[0] + d5 * dArray[6];
                this.svdTmp[1] = d4 * dArray[1] + d5 * dArray[7];
                this.svdTmp[2] = d4 * dArray[2] + d5 * dArray[8];
                dArray[6] = -d5 * dArray[0] + d4 * dArray[6];
                dArray[7] = -d5 * dArray[1] + d4 * dArray[7];
                dArray[8] = -d5 * dArray[2] + d4 * dArray[8];
                dArray[0] = this.svdTmp[0];
                dArray[1] = this.svdTmp[1];
                dArray[2] = this.svdTmp[2];
                this.svdTmp[0] = d4 * this.u1[0];
                this.svdTmp[1] = d4 * this.u1[1];
                this.u1[2] = d5;
                this.svdTmp[6] = -this.u1[0] * d5;
                this.svdTmp[7] = -this.u1[1] * d5;
                this.u1[8] = d4;
                this.u1[0] = this.svdTmp[0];
                this.u1[1] = this.svdTmp[1];
                this.u1[6] = this.svdTmp[6];
                this.u1[7] = this.svdTmp[7];
            }
        }
        if (dArray[2] * dArray[2] < 1.110223024E-16) {
            this.v1[0] = 1.0;
            this.v1[1] = 0.0;
            this.v1[2] = 0.0;
            this.v1[3] = 0.0;
            this.v1[4] = 1.0;
            this.v1[5] = 0.0;
            this.v1[6] = 0.0;
            this.v1[7] = 0.0;
            this.v1[8] = 1.0;
        } else if (dArray[1] * dArray[1] < 1.110223024E-16) {
            this.svdTmp[2] = dArray[2];
            this.svdTmp[5] = dArray[5];
            this.svdTmp[8] = dArray[8];
            dArray[2] = -dArray[1];
            dArray[5] = -dArray[4];
            dArray[8] = -dArray[7];
            dArray[1] = this.svdTmp[2];
            dArray[4] = this.svdTmp[5];
            dArray[7] = this.svdTmp[8];
            this.v1[0] = 1.0;
            this.v1[1] = 0.0;
            this.v1[2] = 0.0;
            this.v1[3] = 0.0;
            this.v1[4] = 0.0;
            this.v1[5] = -1.0;
            this.v1[6] = 0.0;
            this.v1[7] = 1.0;
            this.v1[8] = 0.0;
        } else {
            d = 1.0 / Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
            double d6 = dArray[1] * d;
            double d7 = dArray[2] * d;
            this.svdTmp[1] = d6 * dArray[1] + d7 * dArray[2];
            dArray[2] = -d7 * dArray[1] + d6 * dArray[2];
            dArray[1] = this.svdTmp[1];
            this.svdTmp[4] = d6 * dArray[4] + d7 * dArray[5];
            dArray[5] = -d7 * dArray[4] + d6 * dArray[5];
            dArray[4] = this.svdTmp[4];
            this.svdTmp[7] = d6 * dArray[7] + d7 * dArray[8];
            dArray[8] = -d7 * dArray[7] + d6 * dArray[8];
            dArray[7] = this.svdTmp[7];
            this.v1[0] = 1.0;
            this.v1[1] = 0.0;
            this.v1[2] = 0.0;
            this.v1[3] = 0.0;
            this.v1[4] = d6;
            this.v1[5] = -d7;
            this.v1[6] = 0.0;
            this.v1[7] = d7;
            this.v1[8] = d6;
        }
        if (!(dArray[7] * dArray[7] < 1.110223024E-16)) {
            if (dArray[4] * dArray[4] < 1.110223024E-16) {
                this.svdTmp[3] = dArray[3];
                this.svdTmp[4] = dArray[4];
                this.svdTmp[5] = dArray[5];
                dArray[3] = dArray[6];
                dArray[4] = dArray[7];
                dArray[5] = dArray[8];
                dArray[6] = -this.svdTmp[3];
                dArray[7] = -this.svdTmp[4];
                dArray[8] = -this.svdTmp[5];
                this.svdTmp[3] = this.u1[3];
                this.svdTmp[4] = this.u1[4];
                this.svdTmp[5] = this.u1[5];
                this.u1[3] = this.u1[6];
                this.u1[4] = this.u1[7];
                this.u1[5] = this.u1[8];
                this.u1[6] = -this.svdTmp[3];
                this.u1[7] = -this.svdTmp[4];
                this.u1[8] = -this.svdTmp[5];
            } else {
                d = 1.0 / Math.sqrt(dArray[4] * dArray[4] + dArray[7] * dArray[7]);
                double d8 = dArray[4] * d;
                double d9 = dArray[7] * d;
                this.svdTmp[3] = d8 * dArray[3] + d9 * dArray[6];
                dArray[6] = -d9 * dArray[3] + d8 * dArray[6];
                dArray[3] = this.svdTmp[3];
                this.svdTmp[4] = d8 * dArray[4] + d9 * dArray[7];
                dArray[7] = -d9 * dArray[4] + d8 * dArray[7];
                dArray[4] = this.svdTmp[4];
                this.svdTmp[5] = d8 * dArray[5] + d9 * dArray[8];
                dArray[8] = -d9 * dArray[5] + d8 * dArray[8];
                dArray[5] = this.svdTmp[5];
                this.svdTmp[3] = d8 * this.u1[3] + d9 * this.u1[6];
                this.u1[6] = -d9 * this.u1[3] + d8 * this.u1[6];
                this.u1[3] = this.svdTmp[3];
                this.svdTmp[4] = d8 * this.u1[4] + d9 * this.u1[7];
                this.u1[7] = -d9 * this.u1[4] + d8 * this.u1[7];
                this.u1[4] = this.svdTmp[4];
                this.svdTmp[5] = d8 * this.u1[5] + d9 * this.u1[8];
                this.u1[8] = -d9 * this.u1[5] + d8 * this.u1[8];
                this.u1[5] = this.svdTmp[5];
            }
        }
        this.single_values[0] = dArray[0];
        this.single_values[1] = dArray[4];
        this.single_values[2] = dArray[8];
        this.e[0] = dArray[1];
        this.e[1] = dArray[5];
        if (this.e[0] * this.e[0] > 1.110223024E-16 || this.e[1] * this.e[1] > 1.110223024E-16) {
            this.compute_qr(this.single_values, this.e, this.u1, this.v1);
        }
        this.svdScales[0] = this.single_values[0];
        this.svdScales[1] = this.single_values[1];
        this.svdScales[2] = this.single_values[2];
        if (Transform3D.almostEqual(Math.abs(this.svdScales[0]), 1.0) && Transform3D.almostEqual(Math.abs(this.svdScales[1]), 1.0) && Transform3D.almostEqual(Math.abs(this.svdScales[2]), 1.0)) {
            n2 = 0;
            while (n2 < 3) {
                if (this.svdScales[n2] < 0.0) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0 || n == 2) {
                dArray2[2] = 1.0;
                dArray2[1] = 1.0;
                dArray2[0] = 1.0;
                n2 = 0;
                while (n2 < 9) {
                    dArray3[n2] = this.svdRot[n2];
                    ++n2;
                }
                return;
            }
        }
        Transform3D.transpose_mat(this.u1, this.t1);
        Transform3D.transpose_mat(this.v1, this.t2);
        this.svdReorder(dArray, this.t1, this.t2, this.svdRot, this.svdScales, dArray3, dArray2);
    }

    private static final void concatRotScales(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] * dArray3[0];
        dArray[1] = dArray2[1] * dArray3[1];
        dArray[2] = dArray2[2] * dArray3[2];
        dArray[4] = dArray2[3] * dArray3[0];
        dArray[5] = dArray2[4] * dArray3[1];
        dArray[6] = dArray2[5] * dArray3[2];
        dArray[8] = dArray2[6] * dArray3[0];
        dArray[9] = dArray2[7] * dArray3[1];
        dArray[10] = dArray2[8] * dArray3[2];
    }

    private static final void copyRotToMat(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = dArray[2];
        dArray2[4] = dArray[3];
        dArray2[5] = dArray[4];
        dArray2[6] = dArray[5];
        dArray2[8] = dArray[6];
        dArray2[9] = dArray[7];
        dArray2[10] = dArray[8];
    }

    static final double d_sign(double d, double d2) {
        double d3 = d >= 0.0 ? d : -d;
        return d2 >= 0.0 ? d3 : -d3;
    }

    public final double determinant() {
        double d = this.mat[0] * (this.mat[5] * this.mat[10] * this.mat[15] + this.mat[6] * this.mat[11] * this.mat[13] + this.mat[7] * this.mat[9] * this.mat[14] - this.mat[7] * this.mat[10] * this.mat[13] - this.mat[5] * this.mat[11] * this.mat[14] - this.mat[6] * this.mat[9] * this.mat[15]);
        d -= this.mat[1] * (this.mat[4] * this.mat[10] * this.mat[15] + this.mat[6] * this.mat[11] * this.mat[12] + this.mat[7] * this.mat[8] * this.mat[14] - this.mat[7] * this.mat[10] * this.mat[12] - this.mat[4] * this.mat[11] * this.mat[14] - this.mat[6] * this.mat[8] * this.mat[15]);
        d += this.mat[2] * (this.mat[4] * this.mat[9] * this.mat[15] + this.mat[5] * this.mat[11] * this.mat[12] + this.mat[7] * this.mat[8] * this.mat[13] - this.mat[7] * this.mat[9] * this.mat[12] - this.mat[4] * this.mat[11] * this.mat[13] - this.mat[5] * this.mat[8] * this.mat[15]);
        return d -= this.mat[3] * (this.mat[4] * this.mat[9] * this.mat[14] + this.mat[5] * this.mat[10] * this.mat[12] + this.mat[6] * this.mat[8] * this.mat[13] - this.mat[6] * this.mat[9] * this.mat[12] - this.mat[4] * this.mat[10] * this.mat[13] - this.mat[5] * this.mat[8] * this.mat[14]);
    }

    public boolean epsilonEquals(Transform3D transform3D, double d) {
        int n = 0;
        while (n < 16) {
            double d2 = this.mat[n] - transform3D.mat[n];
            double d3 = d2 < 0.0 ? -d2 : d2;
            if (d3 > d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        try {
            Transform3D transform3D = (Transform3D)object;
            return this.mat[0] == transform3D.mat[0] && this.mat[1] == transform3D.mat[1] && this.mat[2] == transform3D.mat[2] && this.mat[3] == transform3D.mat[3] && this.mat[4] == transform3D.mat[4] && this.mat[5] == transform3D.mat[5] && this.mat[6] == transform3D.mat[6] && this.mat[7] == transform3D.mat[7] && this.mat[8] == transform3D.mat[8] && this.mat[9] == transform3D.mat[9] && this.mat[10] == transform3D.mat[10] && this.mat[11] == transform3D.mat[11] && this.mat[12] == transform3D.mat[12] && this.mat[13] == transform3D.mat[13] && this.mat[14] == transform3D.mat[14] && this.mat[15] == transform3D.mat[15];
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(Transform3D transform3D) {
        try {
            return this.mat[0] == transform3D.mat[0] && this.mat[1] == transform3D.mat[1] && this.mat[2] == transform3D.mat[2] && this.mat[3] == transform3D.mat[3] && this.mat[4] == transform3D.mat[4] && this.mat[5] == transform3D.mat[5] && this.mat[6] == transform3D.mat[6] && this.mat[7] == transform3D.mat[7] && this.mat[8] == transform3D.mat[8] && this.mat[9] == transform3D.mat[9] && this.mat[10] == transform3D.mat[10] && this.mat[11] == transform3D.mat[11] && this.mat[12] == transform3D.mat[12] && this.mat[13] == transform3D.mat[13] && this.mat[14] == transform3D.mat[14] && this.mat[15] == transform3D.mat[15];
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private final void formatRotScale(Transform3D transform3D, double[] dArray) {
        dArray[0] = transform3D.mat[0];
        dArray[1] = transform3D.mat[1];
        dArray[2] = transform3D.mat[2];
        dArray[3] = transform3D.mat[4];
        dArray[4] = transform3D.mat[5];
        dArray[5] = transform3D.mat[6];
        dArray[6] = transform3D.mat[8];
        dArray[7] = transform3D.mat[9];
        dArray[8] = transform3D.mat[10];
    }

    public void frustum(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 - d;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        this.setIdentity();
        this.mat[0] = 2.0 * d5 / d7;
        this.mat[5] = 2.0 * d5 / d8;
        this.mat[10] = (d6 + d5) / d9;
        this.mat[2] = (d2 + d) / d7;
        this.mat[6] = (d4 + d3) / d8;
        this.mat[11] = 2.0 * d6 * d5 / d9;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.type = 0;
    }

    public final void get(Matrix3d matrix3d) {
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        matrix3d.set(this.rot);
    }

    public final double get(Matrix3d matrix3d, Vector3d vector3d) {
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        matrix3d.m00 = this.rot[0];
        matrix3d.m01 = this.rot[1];
        matrix3d.m02 = this.rot[2];
        matrix3d.m10 = this.rot[3];
        matrix3d.m11 = this.rot[4];
        matrix3d.m12 = this.rot[5];
        matrix3d.m20 = this.rot[6];
        matrix3d.m21 = this.rot[7];
        matrix3d.m22 = this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final void get(Matrix3f matrix3f) {
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        matrix3f.m00 = (float)this.rot[0];
        matrix3f.m01 = (float)this.rot[1];
        matrix3f.m02 = (float)this.rot[2];
        matrix3f.m10 = (float)this.rot[3];
        matrix3f.m11 = (float)this.rot[4];
        matrix3f.m12 = (float)this.rot[5];
        matrix3f.m20 = (float)this.rot[6];
        matrix3f.m21 = (float)this.rot[7];
        matrix3f.m22 = (float)this.rot[8];
    }

    public final double get(Matrix3f matrix3f, Vector3d vector3d) {
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        matrix3f.m00 = (float)this.rot[0];
        matrix3f.m01 = (float)this.rot[1];
        matrix3f.m02 = (float)this.rot[2];
        matrix3f.m10 = (float)this.rot[3];
        matrix3f.m11 = (float)this.rot[4];
        matrix3f.m12 = (float)this.rot[5];
        matrix3f.m20 = (float)this.rot[6];
        matrix3f.m21 = (float)this.rot[7];
        matrix3f.m22 = (float)this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final float get(Matrix3f matrix3f, Vector3f vector3f) {
        vector3f.x = (float)this.mat[3];
        vector3f.y = (float)this.mat[7];
        vector3f.z = (float)this.mat[11];
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        matrix3f.m00 = (float)this.rot[0];
        matrix3f.m01 = (float)this.rot[1];
        matrix3f.m02 = (float)this.rot[2];
        matrix3f.m10 = (float)this.rot[3];
        matrix3f.m11 = (float)this.rot[4];
        matrix3f.m12 = (float)this.rot[5];
        matrix3f.m20 = (float)this.rot[6];
        matrix3f.m21 = (float)this.rot[7];
        matrix3f.m22 = (float)this.rot[8];
        return (float)Transform3D.max3(this.scales);
    }

    public final void get(Matrix4d matrix4d) {
        matrix4d.m00 = this.mat[0];
        matrix4d.m01 = this.mat[1];
        matrix4d.m02 = this.mat[2];
        matrix4d.m03 = this.mat[3];
        matrix4d.m10 = this.mat[4];
        matrix4d.m11 = this.mat[5];
        matrix4d.m12 = this.mat[6];
        matrix4d.m13 = this.mat[7];
        matrix4d.m20 = this.mat[8];
        matrix4d.m21 = this.mat[9];
        matrix4d.m22 = this.mat[10];
        matrix4d.m23 = this.mat[11];
        matrix4d.m30 = this.mat[12];
        matrix4d.m31 = this.mat[13];
        matrix4d.m32 = this.mat[14];
        matrix4d.m33 = this.mat[15];
    }

    public final void get(Matrix4f matrix4f) {
        matrix4f.m00 = (float)this.mat[0];
        matrix4f.m01 = (float)this.mat[1];
        matrix4f.m02 = (float)this.mat[2];
        matrix4f.m03 = (float)this.mat[3];
        matrix4f.m10 = (float)this.mat[4];
        matrix4f.m11 = (float)this.mat[5];
        matrix4f.m12 = (float)this.mat[6];
        matrix4f.m13 = (float)this.mat[7];
        matrix4f.m20 = (float)this.mat[8];
        matrix4f.m21 = (float)this.mat[9];
        matrix4f.m22 = (float)this.mat[10];
        matrix4f.m23 = (float)this.mat[11];
        matrix4f.m30 = (float)this.mat[12];
        matrix4f.m31 = (float)this.mat[13];
        matrix4f.m32 = (float)this.mat[14];
        matrix4f.m33 = (float)this.mat[15];
    }

    public final void get(Quat4d quat4d) {
        double d;
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        if (!(((d = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -d : d) < 1.0E-10)) {
            quat4d.w = Math.sqrt(d);
            d = 0.25 / quat4d.w;
            quat4d.x = (this.rot[7] - this.rot[5]) * d;
            quat4d.y = (this.rot[2] - this.rot[6]) * d;
            quat4d.z = (this.rot[3] - this.rot[1]) * d;
            return;
        }
        quat4d.w = 0.0;
        d = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4d.x = Math.sqrt(d);
            d = 0.5 / quat4d.x;
            quat4d.y = this.rot[3] * d;
            quat4d.z = this.rot[6] * d;
            return;
        }
        quat4d.x = 0.0;
        d = 0.5 * (1.0 - this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4d.y = Math.sqrt(d);
            quat4d.z = this.rot[7] / (2.0 * quat4d.y);
            return;
        }
        quat4d.y = 0.0;
        quat4d.z = 1.0;
    }

    public final double get(Quat4d quat4d, Vector3d vector3d) {
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        double d = Transform3D.max3(this.scales);
        double d2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4d.w = Math.sqrt(d2);
            d2 = 0.25 / quat4d.w;
            quat4d.x = (this.rot[7] - this.rot[5]) * d2;
            quat4d.y = (this.rot[2] - this.rot[6]) * d2;
            quat4d.z = (this.rot[3] - this.rot[1]) * d2;
            return d;
        }
        quat4d.w = 0.0;
        d2 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4d.x = Math.sqrt(d2);
            d2 = 0.5 / quat4d.x;
            quat4d.y = this.rot[3] * d2;
            quat4d.z = this.rot[6] * d2;
            return d;
        }
        quat4d.x = 0.0;
        d2 = 0.5 * (1.0 - this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4d.y = Math.sqrt(d2);
            quat4d.z = this.rot[7] / (2.0 * quat4d.y);
            return d;
        }
        quat4d.y = 0.0;
        quat4d.z = 1.0;
        return d;
    }

    public final void get(Quat4f quat4f) {
        double d;
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        if (!(((d = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -d : d) < 1.0E-10)) {
            quat4f.w = (float)Math.sqrt(d);
            d = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.rot[7] - this.rot[5]) * d);
            quat4f.y = (float)((this.rot[2] - this.rot[6]) * d);
            quat4f.z = (float)((this.rot[3] - this.rot[1]) * d);
            return;
        }
        quat4f.w = 0.0f;
        d = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4f.x = (float)Math.sqrt(d);
            d = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.rot[3] * d);
            quat4f.z = (float)(this.rot[6] * d);
            return;
        }
        quat4f.x = 0.0f;
        d = 0.5 * (1.0 - this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4f.y = (float)Math.sqrt(d);
            quat4f.z = (float)(this.rot[7] / (2.0 * (double)quat4f.y));
            return;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
    }

    public final double get(Quat4f quat4f, Vector3d vector3d) {
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        double d = Transform3D.max3(this.scales);
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        double d2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.w = (float)Math.sqrt(d2);
            d2 = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.rot[7] - this.rot[5]) * d2);
            quat4f.y = (float)((this.rot[2] - this.rot[6]) * d2);
            quat4f.z = (float)((this.rot[3] - this.rot[1]) * d2);
            return d;
        }
        quat4f.w = 0.0f;
        d2 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.x = (float)Math.sqrt(d2);
            d2 = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.rot[3] * d2);
            quat4f.z = (float)(this.rot[6] * d2);
            return d;
        }
        quat4f.x = 0.0f;
        d2 = 0.5 * (1.0 - this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.y = (float)Math.sqrt(d2);
            quat4f.z = (float)(this.rot[7] / (2.0 * (double)quat4f.y));
            return d;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
        return d;
    }

    public final float get(Quat4f quat4f, Vector3f vector3f) {
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        double d = Transform3D.max3(this.scales);
        vector3f.x = (float)this.mat[3];
        vector3f.y = (float)this.mat[7];
        vector3f.z = (float)this.mat[11];
        double d2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.w = (float)Math.sqrt(d2);
            d2 = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.rot[7] - this.rot[5]) * d2);
            quat4f.y = (float)((this.rot[2] - this.rot[6]) * d2);
            quat4f.z = (float)((this.rot[3] - this.rot[1]) * d2);
            return (float)d;
        }
        quat4f.w = 0.0f;
        d2 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.x = (float)Math.sqrt(d2);
            d2 = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.rot[3] * d2);
            quat4f.z = (float)(this.rot[6] * d2);
            return (float)d;
        }
        quat4f.x = 0.0f;
        d2 = 0.5 * (1.0 - this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.y = (float)Math.sqrt(d2);
            quat4f.z = (float)(this.rot[7] / (2.0 * (double)quat4f.y));
            return (float)d;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
        return (float)d;
    }

    public final void get(Vector3d vector3d) {
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
    }

    public final void get(Vector3f vector3f) {
        vector3f.x = (float)this.mat[3];
        vector3f.y = (float)this.mat[7];
        vector3f.z = (float)this.mat[11];
    }

    public final void get(double[] dArray) {
        int n = 0;
        while (n < 16) {
            dArray[n] = this.mat[n];
            ++n;
        }
    }

    public final void get(float[] fArray) {
        int n = 0;
        while (n < 16) {
            fArray[n] = (float)this.mat[n];
            ++n;
        }
    }

    public final boolean getAutoNormalize() {
        return this.autoNormalize;
    }

    public final int getBestType() {
        if ((this.type & 1) > 0) {
            return 1;
        }
        if ((this.type & 2) > 0) {
            return 2;
        }
        if ((this.type & 4) > 0) {
            return 4;
        }
        if ((this.type & 8) > 0) {
            return 8;
        }
        if ((this.type & 0x10) > 0) {
            return 16;
        }
        if ((this.type & 0x20) > 0) {
            return 32;
        }
        if ((this.type & 0x40) > 0) {
            return 64;
        }
        if ((this.type & 0x80) > 0) {
            return 128;
        }
        if ((this.type & 0x100) > 0) {
            return 256;
        }
        return 0;
    }

    public final boolean getDeterminantSign() {
        double d = this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) + this.mat[1] * (this.mat[6] * this.mat[8] - this.mat[4] * this.mat[10]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
        return d >= 0.0;
    }

    double getDistanceScale() {
        double d = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
        if ((this.type & 0x40) == 0) {
            double d2 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
            d = Math.max(d2, d);
            d2 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10];
            d = Math.max(d2, d);
        }
        return Math.sqrt(d);
    }

    final void getRotation(Transform3D transform3D) {
        if (this.rotDirty || this.scalesDirty) {
            this.computeRotScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        transform3D.setIdentity();
        transform3D.mat[0] = this.rot[0];
        transform3D.mat[1] = this.rot[1];
        transform3D.mat[2] = this.rot[2];
        transform3D.mat[4] = this.rot[3];
        transform3D.mat[5] = this.rot[4];
        transform3D.mat[6] = this.rot[5];
        transform3D.mat[8] = this.rot[6];
        transform3D.mat[9] = this.rot[7];
        transform3D.mat[10] = this.rot[8];
    }

    public final void getRotationScale(Matrix3d matrix3d) {
        matrix3d.m00 = this.mat[0];
        matrix3d.m01 = this.mat[1];
        matrix3d.m02 = this.mat[2];
        matrix3d.m10 = this.mat[4];
        matrix3d.m11 = this.mat[5];
        matrix3d.m12 = this.mat[6];
        matrix3d.m20 = this.mat[8];
        matrix3d.m21 = this.mat[9];
        matrix3d.m22 = this.mat[10];
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = (float)this.mat[0];
        matrix3f.m01 = (float)this.mat[1];
        matrix3f.m02 = (float)this.mat[2];
        matrix3f.m10 = (float)this.mat[4];
        matrix3f.m11 = (float)this.mat[5];
        matrix3f.m12 = (float)this.mat[6];
        matrix3f.m20 = (float)this.mat[8];
        matrix3f.m21 = (float)this.mat[9];
        matrix3f.m22 = (float)this.mat[10];
    }

    public final double getScale() {
        if (this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        return Transform3D.max3(this.scales);
    }

    public final void getScale(Vector3d vector3d) {
        if (this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
            this.scalesDirty = false;
            this.rotDirty = false;
        }
        vector3d.x = this.scales[0];
        vector3d.y = this.scales[1];
        vector3d.z = this.scales[2];
    }

    public final int getType() {
        return this.type;
    }

    synchronized void getWithLock(Transform3D transform3D) {
        transform3D.set(this);
    }

    public int hashCode() {
        long l = 1L;
        int n = 0;
        while (n < 16) {
            l = 31L * l + Double.doubleToLongBits(this.mat[n]);
            ++n;
        }
        return (int)(l ^ l >> 32);
    }

    public final void invert() {
        if ((this.type & 0x80) != 0) {
            this.invertAffine();
        } else {
            this.invertGeneral(this);
        }
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void invert(Transform3D transform3D) {
        if ((transform3D.type & 0x80) != 0) {
            this.invertAffine(transform3D);
        } else {
            this.invertGeneral(transform3D);
        }
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    final void invertAffine() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) + this.mat[1] * (this.mat[6] * this.mat[8] - this.mat[4] * this.mat[10]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
        if ((this.type & 0x40) == 0) {
            d = this.mat[0] * this.mat[0] + this.mat[1] * this.mat[1] + this.mat[2] * this.mat[2] + this.mat[3] * this.mat[3];
            d2 = this.mat[4] * this.mat[4] + this.mat[5] * this.mat[5] + this.mat[6] * this.mat[6] + this.mat[7] * this.mat[7];
            d *= d2;
            d2 = this.mat[8] * this.mat[8] + this.mat[9] * this.mat[9] + this.mat[10] * this.mat[10] + this.mat[11] * this.mat[11];
            if (d3 * d3 < 1.110223024E-16 * (d *= d2)) {
                this.invertGeneral(this);
                return;
            }
        }
        if (d3 == 0.0) {
            throw new SingularMatrixException(J3dI18N.getString("Transform3D1"));
        }
        double d4 = 1.0 / d3;
        double d5 = (this.mat[5] * this.mat[10] - this.mat[9] * this.mat[6]) * d4;
        double d6 = -(this.mat[1] * this.mat[10] - this.mat[9] * this.mat[2]) * d4;
        double d7 = (this.mat[1] * this.mat[6] - this.mat[5] * this.mat[2]) * d4;
        double d8 = -(this.mat[4] * this.mat[10] - this.mat[8] * this.mat[6]) * d4;
        double d9 = (this.mat[0] * this.mat[10] - this.mat[8] * this.mat[2]) * d4;
        double d10 = -(this.mat[0] * this.mat[6] - this.mat[4] * this.mat[2]) * d4;
        double d11 = (this.mat[4] * this.mat[9] - this.mat[8] * this.mat[5]) * d4;
        double d12 = -(this.mat[0] * this.mat[9] - this.mat[8] * this.mat[1]) * d4;
        double d13 = (this.mat[0] * this.mat[5] - this.mat[4] * this.mat[1]) * d4;
        double d14 = -(this.mat[3] * d5 + this.mat[7] * d6 + this.mat[11] * d7);
        double d15 = -(this.mat[3] * d8 + this.mat[7] * d9 + this.mat[11] * d10);
        double d16 = -(this.mat[3] * d11 + this.mat[7] * d12 + this.mat[11] * d13);
        this.mat[0] = d5;
        this.mat[1] = d6;
        this.mat[2] = d7;
        this.mat[3] = d14;
        this.mat[4] = d8;
        this.mat[5] = d9;
        this.mat[6] = d10;
        this.mat[7] = d15;
        this.mat[8] = d11;
        this.mat[9] = d12;
        this.mat[10] = d13;
        this.mat[11] = d16;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
    }

    final void invertAffine(Transform3D transform3D) {
        if (this == transform3D) {
            this.invertAffine();
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = transform3D.mat[0] * (transform3D.mat[5] * transform3D.mat[10] - transform3D.mat[6] * transform3D.mat[9]) + transform3D.mat[1] * (transform3D.mat[6] * transform3D.mat[8] - transform3D.mat[4] * transform3D.mat[10]) + transform3D.mat[2] * (transform3D.mat[4] * transform3D.mat[9] - transform3D.mat[5] * transform3D.mat[8]);
        if ((transform3D.type & 0x40) == 0) {
            d = transform3D.mat[0] * transform3D.mat[0] + transform3D.mat[1] * transform3D.mat[1] + transform3D.mat[2] * transform3D.mat[2] + transform3D.mat[3] * transform3D.mat[3];
            d2 = transform3D.mat[4] * transform3D.mat[4] + transform3D.mat[5] * transform3D.mat[5] + transform3D.mat[6] * transform3D.mat[6] + transform3D.mat[7] * transform3D.mat[7];
            d *= d2;
            d2 = transform3D.mat[8] * transform3D.mat[8] + transform3D.mat[9] * transform3D.mat[9] + transform3D.mat[10] * transform3D.mat[10] + transform3D.mat[11] * transform3D.mat[11];
            if (d3 * d3 < 1.110223024E-16 * (d *= d2)) {
                this.invertGeneral(transform3D);
                return;
            }
        }
        if (d3 == 0.0) {
            throw new SingularMatrixException(J3dI18N.getString("Transform3D1"));
        }
        double d4 = 1.0 / d3;
        this.mat[0] = (transform3D.mat[5] * transform3D.mat[10] - transform3D.mat[9] * transform3D.mat[6]) * d4;
        this.mat[1] = -(transform3D.mat[1] * transform3D.mat[10] - transform3D.mat[9] * transform3D.mat[2]) * d4;
        this.mat[2] = (transform3D.mat[1] * transform3D.mat[6] - transform3D.mat[5] * transform3D.mat[2]) * d4;
        this.mat[4] = -(transform3D.mat[4] * transform3D.mat[10] - transform3D.mat[8] * transform3D.mat[6]) * d4;
        this.mat[5] = (transform3D.mat[0] * transform3D.mat[10] - transform3D.mat[8] * transform3D.mat[2]) * d4;
        this.mat[6] = -(transform3D.mat[0] * transform3D.mat[6] - transform3D.mat[4] * transform3D.mat[2]) * d4;
        this.mat[8] = (transform3D.mat[4] * transform3D.mat[9] - transform3D.mat[8] * transform3D.mat[5]) * d4;
        this.mat[9] = -(transform3D.mat[0] * transform3D.mat[9] - transform3D.mat[8] * transform3D.mat[1]) * d4;
        this.mat[10] = (transform3D.mat[0] * transform3D.mat[5] - transform3D.mat[4] * transform3D.mat[1]) * d4;
        this.mat[3] = -(transform3D.mat[3] * this.mat[0] + transform3D.mat[7] * this.mat[1] + transform3D.mat[11] * this.mat[2]);
        this.mat[7] = -(transform3D.mat[3] * this.mat[4] + transform3D.mat[7] * this.mat[5] + transform3D.mat[11] * this.mat[6]);
        this.mat[11] = -(transform3D.mat[3] * this.mat[8] + transform3D.mat[7] * this.mat[9] + transform3D.mat[11] * this.mat[10]);
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.type = transform3D.type;
    }

    final void invertGeneral(Transform3D transform3D) {
        double[] dArray = new double[16];
        int[] nArray = new int[4];
        System.arraycopy(transform3D.mat, 0, dArray, 0, dArray.length);
        if (!Transform3D.luDecomposition(dArray, nArray)) {
            throw new SingularMatrixException(J3dI18N.getString("Transform3D1"));
        }
        this.setIdentity();
        Transform3D.luBacksubstitution(dArray, nArray, this.mat);
        this.classify();
    }

    public void lookAt(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        double d = point3d.x - point3d2.x;
        double d2 = point3d.y - point3d2.y;
        double d3 = point3d.z - point3d2.z;
        double d4 = 1.0 / Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d *= d4;
        d2 *= d4;
        d3 *= d4;
        this.setIdentity();
        d4 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d5 = vector3d.x * d4;
        double d6 = vector3d.y * d4;
        double d7 = vector3d.z * d4;
        double d8 = d6 * d3 - d2 * d7;
        double d9 = d7 * d - d5 * d3;
        double d10 = d5 * d2 - d6 * d;
        d4 = 1.0 / Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        d5 = d2 * (d10 *= d4) - (d9 *= d4) * d3;
        d6 = d3 * (d8 *= d4) - d * d10;
        d7 = d * d9 - d2 * d8;
        this.mat[0] = d8;
        this.mat[1] = d9;
        this.mat[2] = d10;
        this.mat[4] = d5;
        this.mat[5] = d6;
        this.mat[6] = d7;
        this.mat[8] = d;
        this.mat[9] = d2;
        this.mat[10] = d3;
        this.mat[3] = -point3d.x * this.mat[0] + -point3d.y * this.mat[1] + -point3d.z * this.mat[2];
        this.mat[7] = -point3d.x * this.mat[4] + -point3d.y * this.mat[5] + -point3d.z * this.mat[6];
        this.mat[11] = -point3d.x * this.mat[8] + -point3d.y * this.mat[9] + -point3d.z * this.mat[10];
        this.classify();
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3;
            int n4 = n2;
            int n5 = -1;
            int n6 = 0;
            while (n6 < 4) {
                int n7 = nArray[n + n6];
                double d = dArray2[n4 + 4 * n7];
                dArray2[n4 + 4 * n7] = dArray2[n4 + 4 * n6];
                if (n5 >= 0) {
                    n3 = n6 * 4;
                    int n8 = n5;
                    while (n8 <= n6 - 1) {
                        d -= dArray[n3 + n8] * dArray2[n4 + 4 * n8];
                        ++n8;
                    }
                } else if (d != 0.0) {
                    n5 = n6;
                }
                dArray2[n4 + 4 * n6] = d;
                ++n6;
            }
            n3 = 12;
            int n9 = n4 + 12;
            dArray2[n9] = dArray2[n9] / dArray[n3 + 3];
            dArray2[n4 + 8] = (dArray2[n4 + 8] - dArray[(n3 -= 4) + 3] * dArray2[n4 + 12]) / dArray[n3 + 2];
            dArray2[n4 + 4] = (dArray2[n4 + 4] - dArray[(n3 -= 4) + 2] * dArray2[n4 + 8] - dArray[n3 + 3] * dArray2[n4 + 12]) / dArray[n3 + 1];
            dArray2[n4] = (dArray2[n4] - dArray[(n3 -= 4) + 1] * dArray2[n4 + 4] - dArray[n3 + 2] * dArray2[n4 + 8] - dArray[n3 + 3] * dArray2[n4 + 12]) / dArray[n3];
            ++n2;
        }
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[4];
        int n = 0;
        int n2 = 0;
        int n3 = 4;
        while (n3-- != 0) {
            double d = 0.0;
            int n4 = 4;
            while (n4-- != 0) {
                double d2 = dArray[n++];
                if (!((d2 = Math.abs(d2)) > d)) continue;
                d = d2;
            }
            if (d == 0.0) {
                return false;
            }
            dArray2[n2++] = 1.0 / d;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 4) {
            double d;
            int n7;
            int n8;
            int n9;
            double d3;
            int n10;
            int n11 = 0;
            while (n11 < n6) {
                n10 = n5 + 4 * n11 + n6;
                d3 = dArray[n10];
                n9 = n11;
                n8 = n5 + 4 * n11;
                n7 = n5 + n6;
                while (n9-- != 0) {
                    d3 -= dArray[n8] * dArray[n7];
                    ++n8;
                    n7 += 4;
                }
                dArray[n10] = d3;
                ++n11;
            }
            double d4 = 0.0;
            int n12 = -1;
            n11 = n6;
            while (n11 < 4) {
                double d5;
                n10 = n5 + 4 * n11 + n6;
                d3 = dArray[n10];
                n9 = n6;
                n8 = n5 + 4 * n11;
                n7 = n5 + n6;
                while (n9-- != 0) {
                    d3 -= dArray[n8] * dArray[n7];
                    ++n8;
                    n7 += 4;
                }
                dArray[n10] = d3;
                d = dArray2[n11] * Math.abs(d3);
                if (d5 >= d4) {
                    d4 = d;
                    n12 = n11;
                }
                ++n11;
            }
            if (n12 < 0) {
                throw new RuntimeException(J3dI18N.getString("Transform3D4"));
            }
            if (n6 != n12) {
                n9 = 4;
                n8 = n5 + 4 * n12;
                n7 = n5 + 4 * n6;
                while (n9-- != 0) {
                    d = dArray[n8];
                    dArray[n8++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n12] = dArray2[n6];
            }
            nArray[n6] = n12;
            if (dArray[n5 + 4 * n6 + n6] == 0.0) {
                return false;
            }
            if (n6 != 3) {
                d = 1.0 / dArray[n5 + 4 * n6 + n6];
                n10 = n5 + 4 * (n6 + 1) + n6;
                n11 = 3 - n6;
                while (n11-- != 0) {
                    int n13 = n10;
                    dArray[n13] = dArray[n13] * d;
                    n10 += 4;
                }
            }
            ++n6;
        }
        return true;
    }

    private static void mat_mul(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = dArray3;
        if (dArray == dArray3 || dArray2 == dArray3) {
            dArray4 = new double[]{dArray[0] * dArray2[0] + dArray[1] * dArray2[3] + dArray[2] * dArray2[6], dArray[0] * dArray2[1] + dArray[1] * dArray2[4] + dArray[2] * dArray2[7], dArray[0] * dArray2[2] + dArray[1] * dArray2[5] + dArray[2] * dArray2[8], dArray[3] * dArray2[0] + dArray[4] * dArray2[3] + dArray[5] * dArray2[6], dArray[3] * dArray2[1] + dArray[4] * dArray2[4] + dArray[5] * dArray2[7], dArray[3] * dArray2[2] + dArray[4] * dArray2[5] + dArray[5] * dArray2[8], dArray[6] * dArray2[0] + dArray[7] * dArray2[3] + dArray[8] * dArray2[6], dArray[6] * dArray2[1] + dArray[7] * dArray2[4] + dArray[8] * dArray2[7], dArray[6] * dArray2[2] + dArray[7] * dArray2[5] + dArray[8] * dArray2[8]};
        }
        if (dArray4 != dArray3) {
            int n = 0;
            while (n < 9) {
                dArray3[n] = dArray4[n];
                ++n;
            }
        }
    }

    static final double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    private static final double max3(double[] dArray) {
        if (dArray[0] > dArray[1]) {
            if (dArray[0] > dArray[2]) {
                return dArray[0];
            }
            return dArray[2];
        }
        if (dArray[1] > dArray[2]) {
            return dArray[1];
        }
        return dArray[2];
    }

    static final double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public final void mul(double d) {
        int n = 0;
        while (n < 16) {
            int n2 = n++;
            this.mat[n2] = this.mat[n2] * d;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void mul(double d, Transform3D transform3D) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = transform3D.mat[n] * d;
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void mul(Transform3D transform3D) {
        this.tmpMat[0] = this.mat[0] * transform3D.mat[0] + this.mat[1] * transform3D.mat[4] + this.mat[2] * transform3D.mat[8] + this.mat[3] * transform3D.mat[12];
        this.tmpMat[1] = this.mat[0] * transform3D.mat[1] + this.mat[1] * transform3D.mat[5] + this.mat[2] * transform3D.mat[9] + this.mat[3] * transform3D.mat[13];
        this.tmpMat[2] = this.mat[0] * transform3D.mat[2] + this.mat[1] * transform3D.mat[6] + this.mat[2] * transform3D.mat[10] + this.mat[3] * transform3D.mat[14];
        this.tmpMat[3] = this.mat[0] * transform3D.mat[3] + this.mat[1] * transform3D.mat[7] + this.mat[2] * transform3D.mat[11] + this.mat[3] * transform3D.mat[15];
        this.tmpMat[4] = this.mat[4] * transform3D.mat[0] + this.mat[5] * transform3D.mat[4] + this.mat[6] * transform3D.mat[8] + this.mat[7] * transform3D.mat[12];
        this.tmpMat[5] = this.mat[4] * transform3D.mat[1] + this.mat[5] * transform3D.mat[5] + this.mat[6] * transform3D.mat[9] + this.mat[7] * transform3D.mat[13];
        this.tmpMat[6] = this.mat[4] * transform3D.mat[2] + this.mat[5] * transform3D.mat[6] + this.mat[6] * transform3D.mat[10] + this.mat[7] * transform3D.mat[14];
        this.tmpMat[7] = this.mat[4] * transform3D.mat[3] + this.mat[5] * transform3D.mat[7] + this.mat[6] * transform3D.mat[11] + this.mat[7] * transform3D.mat[15];
        this.tmpMat[8] = this.mat[8] * transform3D.mat[0] + this.mat[9] * transform3D.mat[4] + this.mat[10] * transform3D.mat[8] + this.mat[11] * transform3D.mat[12];
        this.tmpMat[9] = this.mat[8] * transform3D.mat[1] + this.mat[9] * transform3D.mat[5] + this.mat[10] * transform3D.mat[9] + this.mat[11] * transform3D.mat[13];
        this.tmpMat[10] = this.mat[8] * transform3D.mat[2] + this.mat[9] * transform3D.mat[6] + this.mat[10] * transform3D.mat[10] + this.mat[11] * transform3D.mat[14];
        this.tmpMat[11] = this.mat[8] * transform3D.mat[3] + this.mat[9] * transform3D.mat[7] + this.mat[10] * transform3D.mat[11] + this.mat[11] * transform3D.mat[15];
        this.tmpMat[12] = this.mat[12] * transform3D.mat[0] + this.mat[13] * transform3D.mat[4] + this.mat[14] * transform3D.mat[8] + this.mat[15] * transform3D.mat[12];
        this.tmpMat[13] = this.mat[12] * transform3D.mat[1] + this.mat[13] * transform3D.mat[5] + this.mat[14] * transform3D.mat[9] + this.mat[15] * transform3D.mat[13];
        this.tmpMat[14] = this.mat[12] * transform3D.mat[2] + this.mat[13] * transform3D.mat[6] + this.mat[14] * transform3D.mat[10] + this.mat[15] * transform3D.mat[14];
        this.tmpMat[15] = this.mat[12] * transform3D.mat[3] + this.mat[13] * transform3D.mat[7] + this.mat[14] * transform3D.mat[11] + this.mat[15] * transform3D.mat[15];
        this.mat[0] = this.tmpMat[0];
        this.mat[1] = this.tmpMat[1];
        this.mat[2] = this.tmpMat[2];
        this.mat[3] = this.tmpMat[3];
        this.mat[4] = this.tmpMat[4];
        this.mat[5] = this.tmpMat[5];
        this.mat[6] = this.tmpMat[6];
        this.mat[7] = this.tmpMat[7];
        this.mat[8] = this.tmpMat[8];
        this.mat[9] = this.tmpMat[9];
        this.mat[10] = this.tmpMat[10];
        this.mat[11] = this.tmpMat[11];
        this.mat[12] = this.tmpMat[12];
        this.mat[13] = this.tmpMat[13];
        this.mat[14] = this.tmpMat[14];
        this.mat[15] = this.tmpMat[15];
        this.type &= transform3D.getType();
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
    }

    public final void mul(Transform3D transform3D, Transform3D transform3D2) {
        if (this != transform3D && this != transform3D2) {
            this.mat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[2] * transform3D2.mat[8] + transform3D.mat[3] * transform3D2.mat[12];
            this.mat[1] = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[9] + transform3D.mat[3] * transform3D2.mat[13];
            this.mat[2] = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[1] * transform3D2.mat[6] + transform3D.mat[2] * transform3D2.mat[10] + transform3D.mat[3] * transform3D2.mat[14];
            this.mat[3] = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[1] * transform3D2.mat[7] + transform3D.mat[2] * transform3D2.mat[11] + transform3D.mat[3] * transform3D2.mat[15];
            this.mat[4] = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[8] + transform3D.mat[7] * transform3D2.mat[12];
            this.mat[5] = transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[9] + transform3D.mat[7] * transform3D2.mat[13];
            this.mat[6] = transform3D.mat[4] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[6] * transform3D2.mat[10] + transform3D.mat[7] * transform3D2.mat[14];
            this.mat[7] = transform3D.mat[4] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[6] * transform3D2.mat[11] + transform3D.mat[7] * transform3D2.mat[15];
            this.mat[8] = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8] + transform3D.mat[11] * transform3D2.mat[12];
            this.mat[9] = transform3D.mat[8] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9] + transform3D.mat[11] * transform3D2.mat[13];
            this.mat[10] = transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[11] * transform3D2.mat[14];
            this.mat[11] = transform3D.mat[8] * transform3D2.mat[3] + transform3D.mat[9] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[11] * transform3D2.mat[15];
            this.mat[12] = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[4] + transform3D.mat[14] * transform3D2.mat[8] + transform3D.mat[15] * transform3D2.mat[12];
            this.mat[13] = transform3D.mat[12] * transform3D2.mat[1] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[9] + transform3D.mat[15] * transform3D2.mat[13];
            this.mat[14] = transform3D.mat[12] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[14];
            this.mat[15] = transform3D.mat[12] * transform3D2.mat[3] + transform3D.mat[13] * transform3D2.mat[7] + transform3D.mat[14] * transform3D2.mat[11] + transform3D.mat[15] * transform3D2.mat[15];
            this.type = transform3D.getType() & transform3D2.getType();
        } else {
            this.tmpMat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[2] * transform3D2.mat[8] + transform3D.mat[3] * transform3D2.mat[12];
            this.tmpMat[1] = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[9] + transform3D.mat[3] * transform3D2.mat[13];
            this.tmpMat[2] = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[1] * transform3D2.mat[6] + transform3D.mat[2] * transform3D2.mat[10] + transform3D.mat[3] * transform3D2.mat[14];
            this.tmpMat[3] = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[1] * transform3D2.mat[7] + transform3D.mat[2] * transform3D2.mat[11] + transform3D.mat[3] * transform3D2.mat[15];
            this.tmpMat[4] = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[8] + transform3D.mat[7] * transform3D2.mat[12];
            this.tmpMat[5] = transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[9] + transform3D.mat[7] * transform3D2.mat[13];
            this.tmpMat[6] = transform3D.mat[4] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[6] * transform3D2.mat[10] + transform3D.mat[7] * transform3D2.mat[14];
            this.tmpMat[7] = transform3D.mat[4] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[6] * transform3D2.mat[11] + transform3D.mat[7] * transform3D2.mat[15];
            this.tmpMat[8] = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8] + transform3D.mat[11] * transform3D2.mat[12];
            this.tmpMat[9] = transform3D.mat[8] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9] + transform3D.mat[11] * transform3D2.mat[13];
            this.tmpMat[10] = transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[11] * transform3D2.mat[14];
            this.tmpMat[11] = transform3D.mat[8] * transform3D2.mat[3] + transform3D.mat[9] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[11] * transform3D2.mat[15];
            this.tmpMat[12] = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[4] + transform3D.mat[14] * transform3D2.mat[8] + transform3D.mat[15] * transform3D2.mat[12];
            this.tmpMat[13] = transform3D.mat[12] * transform3D2.mat[1] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[9] + transform3D.mat[15] * transform3D2.mat[13];
            this.tmpMat[14] = transform3D.mat[12] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[14];
            this.tmpMat[15] = transform3D.mat[12] * transform3D2.mat[3] + transform3D.mat[13] * transform3D2.mat[7] + transform3D.mat[14] * transform3D2.mat[11] + transform3D.mat[15] * transform3D2.mat[15];
            this.mat[0] = this.tmpMat[0];
            this.mat[1] = this.tmpMat[1];
            this.mat[2] = this.tmpMat[2];
            this.mat[3] = this.tmpMat[3];
            this.mat[4] = this.tmpMat[4];
            this.mat[5] = this.tmpMat[5];
            this.mat[6] = this.tmpMat[6];
            this.mat[7] = this.tmpMat[7];
            this.mat[8] = this.tmpMat[8];
            this.mat[9] = this.tmpMat[9];
            this.mat[10] = this.tmpMat[10];
            this.mat[11] = this.tmpMat[11];
            this.mat[12] = this.tmpMat[12];
            this.mat[13] = this.tmpMat[13];
            this.mat[14] = this.tmpMat[14];
            this.mat[15] = this.tmpMat[15];
            this.type &= transform3D.getType() & transform3D2.getType();
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
    }

    public final void mulInverse(Transform3D transform3D) {
        Transform3D transform3D2 = new Transform3D(transform3D);
        transform3D2.invert();
        this.mul(transform3D2);
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void mulInverse(Transform3D transform3D, Transform3D transform3D2) {
        Transform3D transform3D3 = new Transform3D(transform3D2);
        transform3D3.invert();
        this.mul(transform3D, transform3D3);
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void mulTransposeBoth(Transform3D transform3D, Transform3D transform3D2) {
        if (this != transform3D && this != transform3D2) {
            this.mat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[12] * transform3D2.mat[3];
            this.mat[1] = transform3D.mat[0] * transform3D2.mat[4] + transform3D.mat[4] * transform3D2.mat[5] + transform3D.mat[8] * transform3D2.mat[6] + transform3D.mat[12] * transform3D2.mat[7];
            this.mat[2] = transform3D.mat[0] * transform3D2.mat[8] + transform3D.mat[4] * transform3D2.mat[9] + transform3D.mat[8] * transform3D2.mat[10] + transform3D.mat[12] * transform3D2.mat[11];
            this.mat[3] = transform3D.mat[0] * transform3D2.mat[12] + transform3D.mat[4] * transform3D2.mat[13] + transform3D.mat[8] * transform3D2.mat[14] + transform3D.mat[12] * transform3D2.mat[15];
            this.mat[4] = transform3D.mat[1] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[3];
            this.mat[5] = transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[13] * transform3D2.mat[7];
            this.mat[6] = transform3D.mat[1] * transform3D2.mat[8] + transform3D.mat[5] * transform3D2.mat[9] + transform3D.mat[9] * transform3D2.mat[10] + transform3D.mat[13] * transform3D2.mat[11];
            this.mat[7] = transform3D.mat[1] * transform3D2.mat[12] + transform3D.mat[5] * transform3D2.mat[13] + transform3D.mat[9] * transform3D2.mat[14] + transform3D.mat[13] * transform3D2.mat[15];
            this.mat[8] = transform3D.mat[2] * transform3D2.mat[0] + transform3D.mat[6] * transform3D2.mat[1] + transform3D.mat[10] * transform3D2.mat[2] + transform3D.mat[14] * transform3D2.mat[3];
            this.mat[9] = transform3D.mat[2] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[7];
            this.mat[10] = transform3D.mat[2] * transform3D2.mat[8] + transform3D.mat[6] * transform3D2.mat[9] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[14] * transform3D2.mat[11];
            this.mat[11] = transform3D.mat[2] * transform3D2.mat[12] + transform3D.mat[6] * transform3D2.mat[13] + transform3D.mat[10] * transform3D2.mat[14] + transform3D.mat[14] * transform3D2.mat[15];
            this.mat[12] = transform3D.mat[3] * transform3D2.mat[0] + transform3D.mat[7] * transform3D2.mat[1] + transform3D.mat[11] * transform3D2.mat[2] + transform3D.mat[15] * transform3D2.mat[3];
            this.mat[13] = transform3D.mat[3] * transform3D2.mat[4] + transform3D.mat[7] * transform3D2.mat[5] + transform3D.mat[11] * transform3D2.mat[6] + transform3D.mat[15] * transform3D2.mat[7];
            this.mat[14] = transform3D.mat[3] * transform3D2.mat[8] + transform3D.mat[7] * transform3D2.mat[9] + transform3D.mat[11] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[11];
            this.mat[15] = transform3D.mat[3] * transform3D2.mat[12] + transform3D.mat[7] * transform3D2.mat[13] + transform3D.mat[11] * transform3D2.mat[14] + transform3D.mat[15] * transform3D2.mat[15];
        } else {
            this.tmpMat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[4] * transform3D2.mat[1] + transform3D.tmpMat[8] * transform3D2.mat[2] + transform3D.mat[12] * transform3D2.mat[3];
            this.tmpMat[1] = transform3D.mat[0] * transform3D2.mat[4] + transform3D.mat[4] * transform3D2.mat[5] + transform3D.tmpMat[8] * transform3D2.mat[6] + transform3D.mat[12] * transform3D2.mat[7];
            this.tmpMat[2] = transform3D.mat[0] * transform3D2.mat[8] + transform3D.mat[4] * transform3D2.mat[9] + transform3D.tmpMat[8] * transform3D2.mat[10] + transform3D.mat[12] * transform3D2.mat[11];
            this.tmpMat[3] = transform3D.mat[0] * transform3D2.mat[12] + transform3D.mat[4] * transform3D2.mat[13] + transform3D.tmpMat[8] * transform3D2.mat[14] + transform3D.mat[12] * transform3D2.mat[15];
            this.tmpMat[4] = transform3D.mat[1] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[1] + transform3D.tmpMat[9] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[3];
            this.tmpMat[5] = transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.tmpMat[9] * transform3D2.mat[6] + transform3D.mat[13] * transform3D2.mat[7];
            this.tmpMat[6] = transform3D.mat[1] * transform3D2.mat[8] + transform3D.mat[5] * transform3D2.mat[9] + transform3D.tmpMat[9] * transform3D2.mat[10] + transform3D.mat[13] * transform3D2.mat[11];
            this.tmpMat[7] = transform3D.mat[1] * transform3D2.mat[12] + transform3D.mat[5] * transform3D2.mat[13] + transform3D.tmpMat[9] * transform3D2.mat[14] + transform3D.mat[13] * transform3D2.mat[15];
            this.tmpMat[8] = transform3D.mat[2] * transform3D2.mat[0] + transform3D.mat[6] * transform3D2.mat[1] + transform3D.tmpMat[10] * transform3D2.mat[2] + transform3D.mat[14] * transform3D2.mat[3];
            this.tmpMat[9] = transform3D.mat[2] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[5] + transform3D.tmpMat[10] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[7];
            this.tmpMat[10] = transform3D.mat[2] * transform3D2.mat[8] + transform3D.mat[6] * transform3D2.mat[9] + transform3D.tmpMat[10] * transform3D2.mat[10] + transform3D.mat[14] * transform3D2.mat[11];
            this.tmpMat[11] = transform3D.mat[2] * transform3D2.mat[12] + transform3D.mat[6] * transform3D2.mat[13] + transform3D.tmpMat[10] * transform3D2.mat[14] + transform3D.mat[14] * transform3D2.mat[15];
            this.tmpMat[12] = transform3D.mat[3] * transform3D2.mat[0] + transform3D.mat[7] * transform3D2.mat[1] + transform3D.tmpMat[11] * transform3D2.mat[2] + transform3D.mat[15] * transform3D2.mat[3];
            this.tmpMat[13] = transform3D.mat[3] * transform3D2.mat[4] + transform3D.mat[7] * transform3D2.mat[5] + transform3D.tmpMat[11] * transform3D2.mat[6] + transform3D.mat[15] * transform3D2.mat[7];
            this.tmpMat[14] = transform3D.mat[3] * transform3D2.mat[8] + transform3D.mat[7] * transform3D2.mat[9] + transform3D.tmpMat[11] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[11];
            this.tmpMat[15] = transform3D.mat[3] * transform3D2.mat[12] + transform3D.mat[7] * transform3D2.mat[13] + transform3D.tmpMat[11] * transform3D2.mat[14] + transform3D.mat[15] * transform3D2.mat[15];
            this.mat[0] = this.tmpMat[0];
            this.mat[1] = this.tmpMat[1];
            this.mat[2] = this.tmpMat[2];
            this.mat[3] = this.tmpMat[3];
            this.mat[4] = this.tmpMat[4];
            this.mat[5] = this.tmpMat[5];
            this.mat[6] = this.tmpMat[6];
            this.mat[7] = this.tmpMat[7];
            this.mat[8] = this.tmpMat[8];
            this.mat[9] = this.tmpMat[9];
            this.mat[10] = this.tmpMat[10];
            this.mat[11] = this.tmpMat[11];
            this.mat[12] = this.tmpMat[12];
            this.mat[13] = this.tmpMat[13];
            this.mat[14] = this.tmpMat[14];
            this.mat[15] = this.tmpMat[15];
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void mulTransposeLeft(Transform3D transform3D, Transform3D transform3D2) {
        if (this != transform3D && this != transform3D2) {
            this.mat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[4] * transform3D2.mat[4] + transform3D.mat[8] * transform3D2.mat[8] + transform3D.mat[12] * transform3D2.mat[12];
            this.mat[1] = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[4] * transform3D2.mat[5] + transform3D.mat[8] * transform3D2.mat[9] + transform3D.mat[12] * transform3D2.mat[13];
            this.mat[2] = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[4] * transform3D2.mat[6] + transform3D.mat[8] * transform3D2.mat[10] + transform3D.mat[12] * transform3D2.mat[14];
            this.mat[3] = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[4] * transform3D2.mat[7] + transform3D.mat[8] * transform3D2.mat[11] + transform3D.mat[12] * transform3D2.mat[15];
            this.mat[4] = transform3D.mat[1] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[9] * transform3D2.mat[8] + transform3D.mat[13] * transform3D2.mat[12];
            this.mat[5] = transform3D.mat[1] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[9] * transform3D2.mat[9] + transform3D.mat[13] * transform3D2.mat[13];
            this.mat[6] = transform3D.mat[1] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[9] * transform3D2.mat[10] + transform3D.mat[13] * transform3D2.mat[14];
            this.mat[7] = transform3D.mat[1] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[9] * transform3D2.mat[11] + transform3D.mat[13] * transform3D2.mat[15];
            this.mat[8] = transform3D.mat[2] * transform3D2.mat[0] + transform3D.mat[6] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8] + transform3D.mat[14] * transform3D2.mat[12];
            this.mat[9] = transform3D.mat[2] * transform3D2.mat[1] + transform3D.mat[6] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9] + transform3D.mat[14] * transform3D2.mat[13];
            this.mat[10] = transform3D.mat[2] * transform3D2.mat[2] + transform3D.mat[6] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[14] * transform3D2.mat[14];
            this.mat[11] = transform3D.mat[2] * transform3D2.mat[3] + transform3D.mat[6] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[14] * transform3D2.mat[15];
            this.mat[12] = transform3D.mat[3] * transform3D2.mat[0] + transform3D.mat[7] * transform3D2.mat[4] + transform3D.mat[11] * transform3D2.mat[8] + transform3D.mat[15] * transform3D2.mat[12];
            this.mat[13] = transform3D.mat[3] * transform3D2.mat[1] + transform3D.mat[7] * transform3D2.mat[5] + transform3D.mat[11] * transform3D2.mat[9] + transform3D.mat[15] * transform3D2.mat[13];
            this.mat[14] = transform3D.mat[3] * transform3D2.mat[2] + transform3D.mat[7] * transform3D2.mat[6] + transform3D.mat[11] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[14];
            this.mat[15] = transform3D.mat[3] * transform3D2.mat[3] + transform3D.mat[7] * transform3D2.mat[7] + transform3D.mat[11] * transform3D2.mat[11] + transform3D.mat[15] * transform3D2.mat[15];
        } else {
            this.tmpMat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[4] * transform3D2.mat[4] + transform3D.tmpMat[8] * transform3D2.mat[8] + transform3D.mat[12] * transform3D2.mat[12];
            this.tmpMat[1] = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[4] * transform3D2.mat[5] + transform3D.tmpMat[8] * transform3D2.mat[9] + transform3D.mat[12] * transform3D2.mat[13];
            this.tmpMat[2] = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[4] * transform3D2.mat[6] + transform3D.tmpMat[8] * transform3D2.mat[10] + transform3D.mat[12] * transform3D2.mat[14];
            this.tmpMat[3] = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[4] * transform3D2.mat[7] + transform3D.tmpMat[8] * transform3D2.mat[11] + transform3D.mat[12] * transform3D2.mat[15];
            this.tmpMat[4] = transform3D.mat[1] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.tmpMat[9] * transform3D2.mat[8] + transform3D.mat[13] * transform3D2.mat[12];
            this.tmpMat[5] = transform3D.mat[1] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.tmpMat[9] * transform3D2.mat[9] + transform3D.mat[13] * transform3D2.mat[13];
            this.tmpMat[6] = transform3D.mat[1] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.tmpMat[9] * transform3D2.mat[10] + transform3D.mat[13] * transform3D2.mat[14];
            this.tmpMat[7] = transform3D.mat[1] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.tmpMat[9] * transform3D2.mat[11] + transform3D.mat[13] * transform3D2.mat[15];
            this.tmpMat[8] = transform3D.mat[2] * transform3D2.mat[0] + transform3D.mat[6] * transform3D2.mat[4] + transform3D.tmpMat[10] * transform3D2.mat[8] + transform3D.mat[14] * transform3D2.mat[12];
            this.tmpMat[9] = transform3D.mat[2] * transform3D2.mat[1] + transform3D.mat[6] * transform3D2.mat[5] + transform3D.tmpMat[10] * transform3D2.mat[9] + transform3D.mat[14] * transform3D2.mat[13];
            this.tmpMat[10] = transform3D.mat[2] * transform3D2.mat[2] + transform3D.mat[6] * transform3D2.mat[6] + transform3D.tmpMat[10] * transform3D2.mat[10] + transform3D.mat[14] * transform3D2.mat[14];
            this.tmpMat[11] = transform3D.mat[2] * transform3D2.mat[3] + transform3D.mat[6] * transform3D2.mat[7] + transform3D.tmpMat[10] * transform3D2.mat[11] + transform3D.mat[14] * transform3D2.mat[15];
            this.tmpMat[12] = transform3D.mat[3] * transform3D2.mat[0] + transform3D.mat[7] * transform3D2.mat[4] + transform3D.tmpMat[11] * transform3D2.mat[8] + transform3D.mat[15] * transform3D2.mat[12];
            this.tmpMat[13] = transform3D.mat[3] * transform3D2.mat[1] + transform3D.mat[7] * transform3D2.mat[5] + transform3D.tmpMat[11] * transform3D2.mat[9] + transform3D.mat[15] * transform3D2.mat[13];
            this.tmpMat[14] = transform3D.mat[3] * transform3D2.mat[2] + transform3D.mat[7] * transform3D2.mat[6] + transform3D.tmpMat[11] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[14];
            this.tmpMat[15] = transform3D.mat[3] * transform3D2.mat[3] + transform3D.mat[7] * transform3D2.mat[7] + transform3D.tmpMat[11] * transform3D2.mat[11] + transform3D.mat[15] * transform3D2.mat[15];
            this.mat[0] = this.tmpMat[0];
            this.mat[1] = this.tmpMat[1];
            this.mat[2] = this.tmpMat[2];
            this.mat[3] = this.tmpMat[3];
            this.mat[4] = this.tmpMat[4];
            this.mat[5] = this.tmpMat[5];
            this.mat[6] = this.tmpMat[6];
            this.mat[7] = this.tmpMat[7];
            this.mat[8] = this.tmpMat[8];
            this.mat[9] = this.tmpMat[9];
            this.mat[10] = this.tmpMat[10];
            this.mat[11] = this.tmpMat[11];
            this.mat[12] = this.tmpMat[12];
            this.mat[13] = this.tmpMat[13];
            this.mat[14] = this.tmpMat[14];
            this.mat[15] = this.tmpMat[15];
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void mulTransposeRight(Transform3D transform3D, Transform3D transform3D2) {
        if (this != transform3D && this != transform3D2) {
            this.mat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[1] + transform3D.mat[2] * transform3D2.mat[2] + transform3D.mat[3] * transform3D2.mat[3];
            this.mat[1] = transform3D.mat[0] * transform3D2.mat[4] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[6] + transform3D.mat[3] * transform3D2.mat[7];
            this.mat[2] = transform3D.mat[0] * transform3D2.mat[8] + transform3D.mat[1] * transform3D2.mat[9] + transform3D.mat[2] * transform3D2.mat[10] + transform3D.mat[3] * transform3D2.mat[11];
            this.mat[3] = transform3D.mat[0] * transform3D2.mat[12] + transform3D.mat[1] * transform3D2.mat[13] + transform3D.mat[2] * transform3D2.mat[14] + transform3D.mat[3] * transform3D2.mat[15];
            this.mat[4] = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[1] + transform3D.mat[6] * transform3D2.mat[2] + transform3D.mat[7] * transform3D2.mat[3];
            this.mat[5] = transform3D.mat[4] * transform3D2.mat[4] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[6] + transform3D.mat[7] * transform3D2.mat[7];
            this.mat[6] = transform3D.mat[4] * transform3D2.mat[8] + transform3D.mat[5] * transform3D2.mat[9] + transform3D.mat[6] * transform3D2.mat[10] + transform3D.mat[7] * transform3D2.mat[11];
            this.mat[7] = transform3D.mat[4] * transform3D2.mat[12] + transform3D.mat[5] * transform3D2.mat[13] + transform3D.mat[6] * transform3D2.mat[14] + transform3D.mat[7] * transform3D2.mat[15];
            this.mat[8] = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[1] + transform3D.mat[10] * transform3D2.mat[2] + transform3D.mat[11] * transform3D2.mat[3];
            this.mat[9] = transform3D.mat[8] * transform3D2.mat[4] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[6] + transform3D.mat[11] * transform3D2.mat[7];
            this.mat[10] = transform3D.mat[8] * transform3D2.mat[8] + transform3D.mat[9] * transform3D2.mat[9] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[11] * transform3D2.mat[11];
            this.mat[11] = transform3D.mat[8] * transform3D2.mat[12] + transform3D.mat[9] * transform3D2.mat[13] + transform3D.mat[10] * transform3D2.mat[14] + transform3D.mat[11] * transform3D2.mat[15];
            this.mat[12] = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[1] + transform3D.mat[14] * transform3D2.mat[2] + transform3D.mat[15] * transform3D2.mat[3];
            this.mat[13] = transform3D.mat[12] * transform3D2.mat[4] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[6] + transform3D.mat[15] * transform3D2.mat[7];
            this.mat[14] = transform3D.mat[12] * transform3D2.mat[8] + transform3D.mat[13] * transform3D2.mat[9] + transform3D.mat[14] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[11];
            this.mat[15] = transform3D.mat[12] * transform3D2.mat[12] + transform3D.mat[13] * transform3D2.mat[13] + transform3D.mat[14] * transform3D2.mat[14] + transform3D.mat[15] * transform3D2.mat[15];
        } else {
            this.tmpMat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[1] + transform3D.tmpMat[2] * transform3D2.mat[2] + transform3D.mat[3] * transform3D2.mat[3];
            this.tmpMat[1] = transform3D.mat[0] * transform3D2.mat[4] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.tmpMat[2] * transform3D2.mat[6] + transform3D.mat[3] * transform3D2.mat[7];
            this.tmpMat[2] = transform3D.mat[0] * transform3D2.mat[8] + transform3D.mat[1] * transform3D2.mat[9] + transform3D.tmpMat[2] * transform3D2.mat[10] + transform3D.mat[3] * transform3D2.mat[11];
            this.tmpMat[3] = transform3D.mat[0] * transform3D2.mat[12] + transform3D.mat[1] * transform3D2.mat[13] + transform3D.tmpMat[2] * transform3D2.mat[14] + transform3D.mat[3] * transform3D2.mat[15];
            this.tmpMat[4] = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[1] + transform3D.tmpMat[6] * transform3D2.mat[2] + transform3D.mat[7] * transform3D2.mat[3];
            this.tmpMat[5] = transform3D.mat[4] * transform3D2.mat[4] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.tmpMat[6] * transform3D2.mat[6] + transform3D.mat[7] * transform3D2.mat[7];
            this.tmpMat[6] = transform3D.mat[4] * transform3D2.mat[8] + transform3D.mat[5] * transform3D2.mat[9] + transform3D.tmpMat[6] * transform3D2.mat[10] + transform3D.mat[7] * transform3D2.mat[11];
            this.tmpMat[7] = transform3D.mat[4] * transform3D2.mat[12] + transform3D.mat[5] * transform3D2.mat[13] + transform3D.tmpMat[6] * transform3D2.mat[14] + transform3D.mat[7] * transform3D2.mat[15];
            this.tmpMat[8] = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[1] + transform3D.tmpMat[10] * transform3D2.mat[2] + transform3D.mat[11] * transform3D2.mat[3];
            this.tmpMat[9] = transform3D.mat[8] * transform3D2.mat[4] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.tmpMat[10] * transform3D2.mat[6] + transform3D.mat[11] * transform3D2.mat[7];
            this.tmpMat[10] = transform3D.mat[8] * transform3D2.mat[8] + transform3D.mat[9] * transform3D2.mat[9] + transform3D.tmpMat[10] * transform3D2.mat[10] + transform3D.mat[11] * transform3D2.mat[11];
            this.tmpMat[11] = transform3D.mat[8] * transform3D2.mat[12] + transform3D.mat[9] * transform3D2.mat[13] + transform3D.tmpMat[10] * transform3D2.mat[14] + transform3D.mat[11] * transform3D2.mat[15];
            this.tmpMat[12] = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[1] + transform3D.tmpMat[14] * transform3D2.mat[2] + transform3D.mat[15] * transform3D2.mat[3];
            this.tmpMat[13] = transform3D.mat[12] * transform3D2.mat[4] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.tmpMat[14] * transform3D2.mat[6] + transform3D.mat[15] * transform3D2.mat[7];
            this.tmpMat[14] = transform3D.mat[12] * transform3D2.mat[8] + transform3D.mat[13] * transform3D2.mat[9] + transform3D.tmpMat[14] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[11];
            this.tmpMat[15] = transform3D.mat[12] * transform3D2.mat[12] + transform3D.mat[13] * transform3D2.mat[13] + transform3D.mat[14] * transform3D2.mat[14] + transform3D.mat[15] * transform3D2.mat[15];
            this.mat[0] = this.tmpMat[0];
            this.mat[1] = this.tmpMat[1];
            this.mat[2] = this.tmpMat[2];
            this.mat[3] = this.tmpMat[3];
            this.mat[4] = this.tmpMat[4];
            this.mat[5] = this.tmpMat[5];
            this.mat[6] = this.tmpMat[6];
            this.mat[7] = this.tmpMat[7];
            this.mat[8] = this.tmpMat[8];
            this.mat[9] = this.tmpMat[9];
            this.mat[10] = this.tmpMat[10];
            this.mat[11] = this.tmpMat[11];
            this.mat[12] = this.tmpMat[12];
            this.mat[13] = this.tmpMat[13];
            this.mat[14] = this.tmpMat[14];
            this.mat[15] = this.tmpMat[15];
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void normalize() {
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
        }
        this.mat[0] = this.rot[0];
        this.mat[1] = this.rot[1];
        this.mat[2] = this.rot[2];
        this.mat[4] = this.rot[3];
        this.mat[5] = this.rot[4];
        this.mat[6] = this.rot[5];
        this.mat[8] = this.rot[6];
        this.mat[9] = this.rot[7];
        this.mat[10] = this.rot[8];
        this.scales[2] = 1.0;
        this.scales[1] = 1.0;
        this.scales[0] = 1.0;
        this.scalesDirty = false;
        this.rotDirty = false;
    }

    public final void normalize(Transform3D transform3D) {
        if (transform3D.rotDirty) {
            this.formatRotScale(transform3D, this.tmp);
            this.compute_svd(this.tmp, this.scales, this.rot);
        } else {
            System.arraycopy(transform3D.rot, 0, this.rot, 0, 9);
        }
        this.mat[0] = this.rot[0];
        this.mat[1] = this.rot[1];
        this.mat[2] = this.rot[2];
        this.mat[4] = this.rot[3];
        this.mat[5] = this.rot[4];
        this.mat[6] = this.rot[5];
        this.mat[8] = this.rot[6];
        this.mat[9] = this.rot[7];
        this.mat[10] = this.rot[8];
        this.scales[2] = 1.0;
        this.scales[1] = 1.0;
        this.scales[0] = 1.0;
        this.scalesDirty = false;
        this.rotDirty = false;
    }

    public final void normalizeCP() {
        double d = 1.0 / Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
        this.mat[0] = this.mat[0] * d;
        this.mat[4] = this.mat[4] * d;
        this.mat[8] = this.mat[8] * d;
        d = 1.0 / Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
        this.mat[1] = this.mat[1] * d;
        this.mat[5] = this.mat[5] * d;
        this.mat[9] = this.mat[9] * d;
        this.mat[2] = this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8];
        this.mat[6] = this.mat[1] * this.mat[8] - this.mat[0] * this.mat[9];
        this.mat[10] = this.mat[0] * this.mat[5] - this.mat[1] * this.mat[4];
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void normalizeCP(Transform3D transform3D) {
        double d = 1.0 / Math.sqrt(transform3D.mat[0] * transform3D.mat[0] + transform3D.mat[4] * transform3D.mat[4] + transform3D.mat[8] * transform3D.mat[8]);
        this.mat[0] = transform3D.mat[0] * d;
        this.mat[4] = transform3D.mat[4] * d;
        this.mat[8] = transform3D.mat[8] * d;
        d = 1.0 / Math.sqrt(transform3D.mat[1] * transform3D.mat[1] + transform3D.mat[5] * transform3D.mat[5] + transform3D.mat[9] * transform3D.mat[9]);
        this.mat[1] = transform3D.mat[1] * d;
        this.mat[5] = transform3D.mat[5] * d;
        this.mat[9] = transform3D.mat[9] * d;
        this.mat[2] = this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8];
        this.mat[6] = this.mat[1] * this.mat[8] - this.mat[0] * this.mat[9];
        this.mat[10] = this.mat[0] * this.mat[5] - this.mat[1] * this.mat[4];
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public void ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 - d;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        this.setIdentity();
        this.mat[0] = 2.0 / d7;
        this.mat[3] = -(d2 + d) / d7;
        this.mat[5] = 2.0 / d8;
        this.mat[7] = -(d4 + d3) / d8;
        this.mat[10] = 2.0 / d9;
        this.mat[11] = (d6 + d5) / d9;
        this.classify();
    }

    public void perspective(double d, double d2, double d3, double d4) {
        double d5 = d * 0.5;
        Vector3d vector3d = new Vector3d();
        double d6 = d4 - d3;
        double d7 = Math.sin(d5);
        double d8 = Math.cos(d5) / d7;
        this.setIdentity();
        this.mat[0] = d8;
        this.mat[5] = d8 * d2;
        this.mat[10] = (d4 + d3) / d6;
        this.mat[11] = 2.0 * d3 * d4 / d6;
        this.mat[15] = 0.0;
        this.mat[14] = -1.0;
        this.type = 0;
    }

    public void rotX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = d3;
        this.mat[6] = -d2;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = d2;
        this.mat[10] = d3;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public void rotY(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.mat[0] = d2 = Math.cos(d);
        this.mat[1] = 0.0;
        this.mat[2] = d3;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = -d3;
        this.mat[9] = 0.0;
        this.mat[10] = d2;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public void rotZ(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.mat[0] = d2 = Math.cos(d);
        this.mat[1] = -d3;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = d3;
        this.mat[5] = d2;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void scaleAdd(double d, Transform3D transform3D) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = d * this.mat[n] + transform3D.mat[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void scaleAdd(double d, Transform3D transform3D, Transform3D transform3D2) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = d * transform3D.mat[n] + transform3D2.mat[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(double d) {
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            this.scales[1] = this.scales[2] = d;
            this.scales[0] = this.scales[2];
        }
        this.mat[0] = this.scales[0];
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = this.scales[1];
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = this.scales[2];
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 4;
        if (d != 0.0) {
            this.type |= 0xC0;
            if (Transform3D.almostEqual(d, 1.0)) {
                this.type |= 0x30;
            }
        }
        if (d < 0.0) {
            this.type |= 0x100;
        }
        this.rotDirty = true;
        this.scalesDirty = false;
    }

    public final void set(double d, Vector3d vector3d) {
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            this.scales[1] = this.scales[2] = d;
            this.scales[0] = this.scales[2];
        }
        this.mat[0] = this.scales[0];
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3d.x;
        this.mat[4] = 0.0;
        this.mat[5] = this.scales[1];
        this.mat[6] = 0.0;
        this.mat[7] = vector3d.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = this.scales[2];
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0;
        if (Transform3D.almostEqual(vector3d.x, 0.0) && Transform3D.almostEqual(vector3d.y, 0.0) && Transform3D.almostEqual(vector3d.z, 0.0)) {
            this.type |= 4;
        } else if (Transform3D.almostEqual(this.scales[0], 1.0)) {
            this.type |= 8;
        }
        if (d != 0.0) {
            this.type |= 0xC0;
            if (Transform3D.almostEqual(this.scales[0], 1.0)) {
                this.type |= 0x30;
            }
        }
        if (this.scales[0] < 0.0) {
            this.type |= 0x100;
        }
        this.rotDirty = true;
        this.scalesDirty = false;
    }

    public final void set(float f, Vector3f vector3f) {
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            this.scales[1] = this.scales[2] = (double)f;
            this.scales[0] = this.scales[2];
        }
        this.mat[0] = this.scales[0];
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3f.x;
        this.mat[4] = 0.0;
        this.mat[5] = this.scales[1];
        this.mat[6] = 0.0;
        this.mat[7] = vector3f.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = this.scales[2];
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0;
        if (Transform3D.almostEqual(vector3f.x, 0.0) && Transform3D.almostEqual(vector3f.y, 0.0) && Transform3D.almostEqual(vector3f.z, 0.0)) {
            this.type |= 4;
        } else if (Transform3D.almostEqual(this.scales[0], 1.0)) {
            this.type |= 8;
        }
        if ((double)f != 0.0) {
            this.type |= 0xC0;
            if (Transform3D.almostEqual(this.scales[0], 1.0)) {
                this.type |= 0x30;
            }
        }
        if (this.scales[0] < 0.0) {
            this.type |= 0x100;
        }
        this.rotDirty = true;
        this.scalesDirty = false;
    }

    public final void set(Transform3D transform3D) {
        this.mat[0] = transform3D.mat[0];
        this.mat[1] = transform3D.mat[1];
        this.mat[2] = transform3D.mat[2];
        this.mat[3] = transform3D.mat[3];
        this.mat[4] = transform3D.mat[4];
        this.mat[5] = transform3D.mat[5];
        this.mat[6] = transform3D.mat[6];
        this.mat[7] = transform3D.mat[7];
        this.mat[8] = transform3D.mat[8];
        this.mat[9] = transform3D.mat[9];
        this.mat[10] = transform3D.mat[10];
        this.mat[11] = transform3D.mat[11];
        this.mat[12] = transform3D.mat[12];
        this.mat[13] = transform3D.mat[13];
        this.mat[14] = transform3D.mat[14];
        this.mat[15] = transform3D.mat[15];
        this.type = transform3D.type;
        this.autoNormalize = transform3D.autoNormalize;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
    }

    public final void set(AxisAngle4d axisAngle4d) {
        double d = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z);
        if (Transform3D.almostEqual(d, 0.0)) {
            this.setIdentity();
        } else {
            d = 1.0 / d;
            double d2 = axisAngle4d.x * d;
            double d3 = axisAngle4d.y * d;
            double d4 = axisAngle4d.z * d;
            double d5 = Math.sin(axisAngle4d.angle);
            double d6 = Math.cos(axisAngle4d.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.mat[0] = d7 * d2 * d2 + d6;
            this.mat[1] = d7 * d9 - d5 * d4;
            this.mat[2] = d7 * d8 + d5 * d3;
            this.mat[3] = 0.0;
            this.mat[4] = d7 * d9 + d5 * d4;
            this.mat[5] = d7 * d3 * d3 + d6;
            this.mat[6] = d7 * d10 - d5 * d2;
            this.mat[7] = 0.0;
            this.mat[8] = d7 * d8 - d5 * d3;
            this.mat[9] = d7 * d10 + d5 * d2;
            this.mat[10] = d7 * d4 * d4 + d6;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            this.classify();
            this.scalesDirty = true;
            this.rotDirty = true;
        }
    }

    public final void set(AxisAngle4f axisAngle4f) {
        double d = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z);
        if (Transform3D.almostEqual(d, 0.0)) {
            this.setIdentity();
        } else {
            d = 1.0 / d;
            double d2 = (double)axisAngle4f.x * d;
            double d3 = (double)axisAngle4f.y * d;
            double d4 = (double)axisAngle4f.z * d;
            double d5 = Math.sin(axisAngle4f.angle);
            double d6 = Math.cos(axisAngle4f.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.mat[0] = d7 * d2 * d2 + d6;
            this.mat[1] = d7 * d9 - d5 * d4;
            this.mat[2] = d7 * d8 + d5 * d3;
            this.mat[3] = 0.0;
            this.mat[4] = d7 * d9 + d5 * d4;
            this.mat[5] = d7 * d3 * d3 + d6;
            this.mat[6] = d7 * d10 - d5 * d2;
            this.mat[7] = 0.0;
            this.mat[8] = d7 * d8 - d5 * d3;
            this.mat[9] = d7 * d10 + d5 * d2;
            this.mat[10] = d7 * d4 * d4 + d6;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            this.classify();
            this.scalesDirty = true;
            this.rotDirty = true;
        }
    }

    public final void set(GMatrix gMatrix) {
        int n = gMatrix.getNumRow();
        int n2 = gMatrix.getNumCol();
        int n3 = 0;
        while (n3 < 4) {
            int n4 = n3 * 4;
            int n5 = 0;
            while (n5 < 4) {
                this.mat[n4 + n5] = n3 >= n || n5 >= n2 ? 0.0 : gMatrix.getElement(n3, n5);
                ++n5;
            }
            ++n3;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix3d matrix3d) {
        this.mat[0] = matrix3d.m00;
        this.mat[1] = matrix3d.m01;
        this.mat[2] = matrix3d.m02;
        this.mat[3] = 0.0;
        this.mat[4] = matrix3d.m10;
        this.mat[5] = matrix3d.m11;
        this.mat[6] = matrix3d.m12;
        this.mat[7] = 0.0;
        this.mat[8] = matrix3d.m20;
        this.mat[9] = matrix3d.m21;
        this.mat[10] = matrix3d.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.mat[0] = matrix3d.m00 * d;
        this.mat[1] = matrix3d.m01 * d;
        this.mat[2] = matrix3d.m02 * d;
        this.mat[3] = vector3d.x;
        this.mat[4] = matrix3d.m10 * d;
        this.mat[5] = matrix3d.m11 * d;
        this.mat[6] = matrix3d.m12 * d;
        this.mat[7] = vector3d.y;
        this.mat[8] = matrix3d.m20 * d;
        this.mat[9] = matrix3d.m21 * d;
        this.mat[10] = matrix3d.m22 * d;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix3f matrix3f) {
        this.mat[0] = matrix3f.m00;
        this.mat[1] = matrix3f.m01;
        this.mat[2] = matrix3f.m02;
        this.mat[3] = 0.0;
        this.mat[4] = matrix3f.m10;
        this.mat[5] = matrix3f.m11;
        this.mat[6] = matrix3f.m12;
        this.mat[7] = 0.0;
        this.mat[8] = matrix3f.m20;
        this.mat[9] = matrix3f.m21;
        this.mat[10] = matrix3f.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix3f matrix3f, Vector3d vector3d, double d) {
        this.mat[0] = (double)matrix3f.m00 * d;
        this.mat[1] = (double)matrix3f.m01 * d;
        this.mat[2] = (double)matrix3f.m02 * d;
        this.mat[3] = vector3d.x;
        this.mat[4] = (double)matrix3f.m10 * d;
        this.mat[5] = (double)matrix3f.m11 * d;
        this.mat[6] = (double)matrix3f.m12 * d;
        this.mat[7] = vector3d.y;
        this.mat[8] = (double)matrix3f.m20 * d;
        this.mat[9] = (double)matrix3f.m21 * d;
        this.mat[10] = (double)matrix3f.m22 * d;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.mat[0] = matrix3f.m00 * f;
        this.mat[1] = matrix3f.m01 * f;
        this.mat[2] = matrix3f.m02 * f;
        this.mat[3] = vector3f.x;
        this.mat[4] = matrix3f.m10 * f;
        this.mat[5] = matrix3f.m11 * f;
        this.mat[6] = matrix3f.m12 * f;
        this.mat[7] = vector3f.y;
        this.mat[8] = matrix3f.m20 * f;
        this.mat[9] = matrix3f.m21 * f;
        this.mat[10] = matrix3f.m22 * f;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix4d matrix4d) {
        this.mat[0] = matrix4d.m00;
        this.mat[1] = matrix4d.m01;
        this.mat[2] = matrix4d.m02;
        this.mat[3] = matrix4d.m03;
        this.mat[4] = matrix4d.m10;
        this.mat[5] = matrix4d.m11;
        this.mat[6] = matrix4d.m12;
        this.mat[7] = matrix4d.m13;
        this.mat[8] = matrix4d.m20;
        this.mat[9] = matrix4d.m21;
        this.mat[10] = matrix4d.m22;
        this.mat[11] = matrix4d.m23;
        this.mat[12] = matrix4d.m30;
        this.mat[13] = matrix4d.m31;
        this.mat[14] = matrix4d.m32;
        this.mat[15] = matrix4d.m33;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Matrix4f matrix4f) {
        this.mat[0] = matrix4f.m00;
        this.mat[1] = matrix4f.m01;
        this.mat[2] = matrix4f.m02;
        this.mat[3] = matrix4f.m03;
        this.mat[4] = matrix4f.m10;
        this.mat[5] = matrix4f.m11;
        this.mat[6] = matrix4f.m12;
        this.mat[7] = matrix4f.m13;
        this.mat[8] = matrix4f.m20;
        this.mat[9] = matrix4f.m21;
        this.mat[10] = matrix4f.m22;
        this.mat[11] = matrix4f.m23;
        this.mat[12] = matrix4f.m30;
        this.mat[13] = matrix4f.m31;
        this.mat[14] = matrix4f.m32;
        this.mat[15] = matrix4f.m33;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(Quat4d quat4d) {
        this.mat[0] = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.mat[4] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.mat[8] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.mat[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.mat[5] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.mat[9] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.mat[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.mat[6] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.mat[10] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void set(Quat4d quat4d, Vector3d vector3d, double d) {
        this.rot[0] = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.rot[3] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.rot[6] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.rot[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.rot[4] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.rot[7] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.rot[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.rot[5] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.rot[8] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
            Transform3D.copyRotToMat(this.rot, this.mat);
        } else {
            this.scales[1] = this.scales[2] = d;
            this.scales[0] = this.scales[2];
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = false;
        this.rotDirty = false;
    }

    public final void set(Quat4f quat4f) {
        this.mat[0] = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.mat[4] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.mat[8] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.mat[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.mat[5] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.mat[9] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.mat[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.mat[6] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.mat[10] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void set(Quat4f quat4f, Vector3d vector3d, double d) {
        this.rot[0] = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.rot[3] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.rot[6] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.rot[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.rot[4] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.rot[7] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.rot[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.rot[5] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.rot[8] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
            Transform3D.copyRotToMat(this.rot, this.mat);
        } else {
            this.scales[1] = this.scales[2] = d;
            this.scales[0] = this.scales[2];
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = false;
        this.rotDirty = false;
    }

    public final void set(Quat4f quat4f, Vector3f vector3f, float f) {
        this.rot[0] = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.rot[3] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.rot[6] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.rot[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.rot[4] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.rot[7] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.rot[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.rot[5] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.rot[8] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
            Transform3D.copyRotToMat(this.rot, this.mat);
        } else {
            this.scales[1] = this.scales[2] = (double)f;
            this.scales[0] = this.scales[2];
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.mat[3] = vector3f.x;
        this.mat[7] = vector3f.y;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.classify();
        this.scalesDirty = false;
        this.rotDirty = false;
    }

    public final void set(Vector3d vector3d) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3d.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = vector3d.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 232;
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void set(Vector3d vector3d, double d) {
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            this.scales[1] = this.scales[2] = d;
            this.scales[0] = this.scales[2];
        }
        this.mat[0] = this.scales[0];
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3d.x * this.scales[0];
        this.mat[4] = 0.0;
        this.mat[5] = this.scales[1];
        this.mat[6] = 0.0;
        this.mat[7] = vector3d.y * this.scales[0];
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = this.scales[2];
        this.mat[11] = vector3d.z * this.scales[0];
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0;
        if (Transform3D.almostEqual(vector3d.x, 0.0) && Transform3D.almostEqual(vector3d.y, 0.0) && Transform3D.almostEqual(vector3d.z, 0.0)) {
            this.type |= 4;
        } else if (Transform3D.almostEqual(this.scales[0], 1.0)) {
            this.type |= 8;
        }
        if (d != 0.0) {
            this.type |= 0xC0;
            if (Transform3D.almostEqual(this.scales[0], 1.0)) {
                this.type |= 0x30;
            }
        }
        if (this.scales[0] < 0.0) {
            this.type |= 0x100;
        }
        this.rotDirty = true;
        this.scalesDirty = false;
    }

    public final void set(Vector3f vector3f) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3f.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = vector3f.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 232;
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void set(Vector3f vector3f, float f) {
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            this.scales[1] = this.scales[2] = (double)f;
            this.scales[0] = this.scales[2];
        }
        this.mat[0] = this.scales[0];
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = (double)vector3f.x * this.scales[0];
        this.mat[4] = 0.0;
        this.mat[5] = this.scales[1];
        this.mat[6] = 0.0;
        this.mat[7] = (double)vector3f.y * this.scales[0];
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = this.scales[2];
        this.mat[11] = (double)vector3f.z * this.scales[0];
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0;
        if (Transform3D.almostEqual(vector3f.x, 0.0) && Transform3D.almostEqual(vector3f.y, 0.0) && Transform3D.almostEqual(vector3f.z, 0.0)) {
            this.type |= 4;
        } else if (Transform3D.almostEqual(this.scales[0], 1.0)) {
            this.type |= 8;
        }
        if ((double)f != 0.0) {
            this.type |= 0xC0;
            if (Transform3D.almostEqual(this.scales[0], 1.0)) {
                this.type |= 0x30;
            }
        }
        if (this.scales[0] < 0.0) {
            this.type |= 0x100;
        }
        this.rotDirty = true;
        this.scalesDirty = false;
    }

    public final void set(double[] dArray) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = dArray[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void set(float[] fArray) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = fArray[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void setAutoNormalize(boolean bl) {
        this.autoNormalize = bl;
    }

    public final void setEuler(Vector3d vector3d) {
        double d = Math.sin(vector3d.x);
        double d2 = Math.sin(vector3d.y);
        double d3 = Math.sin(vector3d.z);
        double d4 = Math.cos(vector3d.x);
        double d5 = Math.cos(vector3d.y);
        double d6 = Math.cos(vector3d.z);
        this.mat[0] = d5 * d6;
        this.mat[1] = -(d4 * d3) + d * d2 * d6;
        this.mat[2] = d * d3 + d4 * d2 * d6;
        this.mat[3] = 0.0;
        this.mat[4] = d5 * d3;
        this.mat[5] = d4 * d6 + d * d2 * d3;
        this.mat[6] = -(d * d6) + d4 * d2 * d3;
        this.mat[7] = 0.0;
        this.mat[8] = -d2;
        this.mat[9] = d * d5;
        this.mat[10] = d4 * d5;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 240;
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void setIdentity() {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 246;
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void setNonUniformScale(double d, double d2, double d3) {
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            this.scales[0] = d;
            this.scales[1] = d2;
            this.scales[2] = d3;
        }
        this.mat[0] = this.scales[0];
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = this.scales[1];
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = this.scales[2];
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.rotDirty = true;
        this.scalesDirty = false;
        this.type = 0;
        if (d != 0.0 && d2 != 0.0 && d3 != 0.0) {
            this.type |= 0x80;
            if (Transform3D.almostEqual(d, d2) && Transform3D.almostEqual(d, d3)) {
                this.type |= 0x40;
                if (Transform3D.almostEqual(d, 1.0)) {
                    this.type |= 0x30;
                }
            }
        }
    }

    public final void setRotation(AxisAngle4d axisAngle4d) {
        double d;
        if (!this.autoNormalize && this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
        }
        if (Transform3D.almostEqual(d = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z), 0.0)) {
            this.rot[0] = 1.0;
            this.rot[1] = 0.0;
            this.rot[2] = 0.0;
            this.rot[3] = 0.0;
            this.rot[4] = 1.0;
            this.rot[5] = 0.0;
            this.rot[6] = 0.0;
            this.rot[7] = 0.0;
            this.rot[8] = 1.0;
        } else {
            d = 1.0 / d;
            double d2 = axisAngle4d.x * d;
            double d3 = axisAngle4d.y * d;
            double d4 = axisAngle4d.z * d;
            double d5 = Math.sin(axisAngle4d.angle);
            double d6 = Math.cos(axisAngle4d.angle);
            double d7 = 1.0 - d6;
            if (!this.autoNormalize && this.scalesDirty) {
                this.computeScales(this.rot, this.scales);
            }
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.rot[0] = d7 * d2 * d2 + d6;
            this.rot[1] = d7 * d9 - d5 * d4;
            this.rot[2] = d7 * d8 + d5 * d3;
            this.rot[3] = d7 * d9 + d5 * d4;
            this.rot[4] = d7 * d3 * d3 + d6;
            this.rot[5] = d7 * d10 - d5 * d2;
            this.rot[6] = d7 * d8 - d5 * d3;
            this.rot[7] = d7 * d10 + d5 * d2;
            this.rot[8] = d7 * d4 * d4 + d6;
        }
        if (this.autoNormalize) {
            Transform3D.copyRotToMat(this.rot, this.mat);
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.toString();
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setRotation(AxisAngle4f axisAngle4f) {
        double d;
        if (!this.autoNormalize && this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
        }
        if (Transform3D.almostEqual(d = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z), 0.0)) {
            this.rot[0] = 1.0;
            this.rot[1] = 0.0;
            this.rot[2] = 0.0;
            this.rot[3] = 0.0;
            this.rot[4] = 1.0;
            this.rot[5] = 0.0;
            this.rot[6] = 0.0;
            this.rot[7] = 0.0;
            this.rot[8] = 1.0;
        } else {
            d = 1.0 / d;
            double d2 = (double)axisAngle4f.x * d;
            double d3 = (double)axisAngle4f.y * d;
            double d4 = (double)axisAngle4f.z * d;
            double d5 = Math.sin(axisAngle4f.angle);
            double d6 = Math.cos(axisAngle4f.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.rot[0] = d7 * d2 * d2 + d6;
            this.rot[1] = d7 * d9 - d5 * d4;
            this.rot[2] = d7 * d8 + d5 * d3;
            this.rot[3] = d7 * d9 + d5 * d4;
            this.rot[4] = d7 * d3 * d3 + d6;
            this.rot[5] = d7 * d10 - d5 * d2;
            this.rot[6] = d7 * d8 - d5 * d3;
            this.rot[7] = d7 * d10 + d5 * d2;
            this.rot[8] = d7 * d4 * d4 + d6;
        }
        if (this.autoNormalize) {
            Transform3D.copyRotToMat(this.rot, this.mat);
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setRotation(Matrix3d matrix3d) {
        if (!this.autoNormalize && this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
        }
        this.rot[0] = matrix3d.m00;
        this.rot[3] = matrix3d.m10;
        this.rot[6] = matrix3d.m20;
        this.rot[1] = matrix3d.m01;
        this.rot[4] = matrix3d.m11;
        this.rot[7] = matrix3d.m21;
        this.rot[2] = matrix3d.m02;
        this.rot[5] = matrix3d.m12;
        this.rot[8] = matrix3d.m22;
        if (this.autoNormalize) {
            Transform3D.copyRotToMat(this.rot, this.mat);
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setRotation(Matrix3f matrix3f) {
        if (!this.autoNormalize && this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
        }
        this.rot[0] = matrix3f.m00;
        this.rot[3] = matrix3f.m10;
        this.rot[6] = matrix3f.m20;
        this.rot[1] = matrix3f.m01;
        this.rot[4] = matrix3f.m11;
        this.rot[7] = matrix3f.m21;
        this.rot[2] = matrix3f.m02;
        this.rot[5] = matrix3f.m12;
        this.rot[8] = matrix3f.m22;
        if (this.autoNormalize) {
            Transform3D.copyRotToMat(this.rot, this.mat);
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setRotation(Quat4d quat4d) {
        if (!this.autoNormalize && this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
        }
        this.rot[0] = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.rot[3] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.rot[6] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.rot[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.rot[4] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.rot[7] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.rot[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.rot[5] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.rot[8] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
        if (this.autoNormalize) {
            Transform3D.copyRotToMat(this.rot, this.mat);
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setRotation(Quat4f quat4f) {
        if (!this.autoNormalize && this.scalesDirty) {
            this.computeScales(this.rot, this.scales);
        }
        this.rot[0] = 1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z;
        this.rot[3] = 2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.rot[6] = 2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.rot[1] = 2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.rot[4] = 1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z;
        this.rot[7] = 2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.rot[2] = 2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.rot[5] = 2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.rot[8] = 1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y;
        if (this.autoNormalize) {
            Transform3D.copyRotToMat(this.rot, this.mat);
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
        } else {
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setRotationScale(Matrix3d matrix3d) {
        this.mat[0] = matrix3d.m00;
        this.mat[1] = matrix3d.m01;
        this.mat[2] = matrix3d.m02;
        this.mat[4] = matrix3d.m10;
        this.mat[5] = matrix3d.m11;
        this.mat[6] = matrix3d.m12;
        this.mat[8] = matrix3d.m20;
        this.mat[9] = matrix3d.m21;
        this.mat[10] = matrix3d.m22;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.mat[0] = matrix3f.m00;
        this.mat[1] = matrix3f.m01;
        this.mat[2] = matrix3f.m02;
        this.mat[4] = matrix3f.m10;
        this.mat[5] = matrix3f.m11;
        this.mat[6] = matrix3f.m12;
        this.mat[8] = matrix3f.m20;
        this.mat[9] = matrix3f.m21;
        this.mat[10] = matrix3f.m22;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void setScale(double d) {
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
        }
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
            Transform3D.copyRotToMat(this.rot, this.mat);
        } else {
            this.scales[1] = this.scales[2] = d;
            this.scales[0] = this.scales[2];
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setScale(Vector3d vector3d) {
        if (this.rotDirty) {
            this.computeRotScales(this.rot, this.scales);
        }
        if (this.autoNormalize) {
            this.scales[2] = 1.0;
            this.scales[1] = 1.0;
            this.scales[0] = 1.0;
            Transform3D.copyRotToMat(this.rot, this.mat);
        } else {
            this.scales[0] = vector3d.x;
            this.scales[1] = vector3d.y;
            this.scales[2] = vector3d.z;
            Transform3D.concatRotScales(this.mat, this.rot, this.scales);
        }
        this.scalesDirty = false;
        this.rotDirty = false;
        this.classify();
    }

    public final void setTranslation(Vector3d vector3d) {
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        if (this.autoNormalize) {
            this.normalize();
        }
        this.classify();
    }

    public final void setTranslation(Vector3f vector3f) {
        this.mat[3] = vector3f.x;
        this.mat[7] = vector3f.y;
        this.mat[11] = vector3f.z;
        if (this.autoNormalize) {
            this.normalize();
        }
        this.classify();
    }

    synchronized void setWithLock(Transform3D transform3D) {
        this.set(transform3D);
    }

    public final void setZero() {
        this.mat[0] = 0.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 0.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 0.0;
        this.type = 0;
        this.scalesDirty = true;
        this.rotDirty = true;
    }

    public final void sub(Transform3D transform3D) {
        int n = 0;
        while (n < 16) {
            int n2 = n;
            this.mat[n2] = this.mat[n2] - transform3D.mat[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void sub(Transform3D transform3D, Transform3D transform3D2) {
        int n = 0;
        while (n < 16) {
            this.mat[n] = transform3D.mat[n] - transform3D2.mat[n];
            ++n;
        }
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    private void svdReorder(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        if (dArray5[0] < 0.0) {
            dArray5[0] = -dArray5[0];
            dArray3[0] = -dArray3[0];
            dArray3[1] = -dArray3[1];
            dArray3[2] = -dArray3[2];
        }
        if (dArray5[1] < 0.0) {
            dArray5[1] = -dArray5[1];
            dArray3[3] = -dArray3[3];
            dArray3[4] = -dArray3[4];
            dArray3[5] = -dArray3[5];
        }
        if (dArray5[2] < 0.0) {
            dArray5[2] = -dArray5[2];
            dArray3[6] = -dArray3[6];
            dArray3[7] = -dArray3[7];
            dArray3[8] = -dArray3[8];
        }
        Transform3D.mat_mul(dArray2, dArray3, dArray4);
        if (Transform3D.almostEqual(Math.abs(dArray5[0]), Math.abs(dArray5[1])) && Transform3D.almostEqual(Math.abs(dArray5[1]), Math.abs(dArray5[2]))) {
            int n = 0;
            while (n < 9) {
                dArray6[n] = dArray4[n];
                ++n;
            }
            n = 0;
            while (n < 3) {
                dArray7[n] = dArray5[n];
                ++n;
            }
        } else {
            int n;
            int n2;
            int n3;
            if (dArray5[0] > dArray5[1]) {
                if (dArray5[0] > dArray5[2]) {
                    if (dArray5[2] > dArray5[1]) {
                        this.svdOut[0] = 0;
                        this.svdOut[1] = 2;
                        this.svdOut[2] = 1;
                    } else {
                        this.svdOut[0] = 0;
                        this.svdOut[1] = 1;
                        this.svdOut[2] = 2;
                    }
                } else {
                    this.svdOut[0] = 2;
                    this.svdOut[1] = 0;
                    this.svdOut[2] = 1;
                }
            } else if (dArray5[1] > dArray5[2]) {
                if (dArray5[2] > dArray5[0]) {
                    this.svdOut[0] = 1;
                    this.svdOut[1] = 2;
                    this.svdOut[2] = 0;
                } else {
                    this.svdOut[0] = 1;
                    this.svdOut[1] = 0;
                    this.svdOut[2] = 2;
                }
            } else {
                this.svdOut[0] = 2;
                this.svdOut[1] = 1;
                this.svdOut[2] = 0;
            }
            this.svdMag[0] = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
            this.svdMag[1] = dArray[3] * dArray[3] + dArray[4] * dArray[4] + dArray[5] * dArray[5];
            this.svdMag[2] = dArray[6] * dArray[6] + dArray[7] * dArray[7] + dArray[8] * dArray[8];
            if (this.svdMag[0] > this.svdMag[1]) {
                if (this.svdMag[0] > this.svdMag[2]) {
                    if (this.svdMag[2] > this.svdMag[1]) {
                        n3 = 0;
                        n2 = 1;
                        n = 2;
                    } else {
                        n3 = 0;
                        n = 1;
                        n2 = 2;
                    }
                } else {
                    n2 = 0;
                    n3 = 1;
                    n = 2;
                }
            } else if (this.svdMag[1] > this.svdMag[2]) {
                if (this.svdMag[2] > this.svdMag[0]) {
                    n = 0;
                    n2 = 1;
                    n3 = 2;
                } else {
                    n = 0;
                    n3 = 1;
                    n2 = 2;
                }
            } else {
                n2 = 0;
                n = 1;
                n3 = 2;
            }
            int n4 = this.svdOut[n3];
            dArray7[0] = dArray5[n4];
            n4 = this.svdOut[n];
            dArray7[1] = dArray5[n4];
            n4 = this.svdOut[n2];
            dArray7[2] = dArray5[n4];
            n4 = this.svdOut[n3];
            dArray6[0] = dArray4[n4];
            n4 = this.svdOut[n3] + 3;
            dArray6[3] = dArray4[n4];
            n4 = this.svdOut[n3] + 6;
            dArray6[6] = dArray4[n4];
            n4 = this.svdOut[n];
            dArray6[1] = dArray4[n4];
            n4 = this.svdOut[n] + 3;
            dArray6[4] = dArray4[n4];
            n4 = this.svdOut[n] + 6;
            dArray6[7] = dArray4[n4];
            n4 = this.svdOut[n2];
            dArray6[2] = dArray4[n4];
            n4 = this.svdOut[n2] + 3;
            dArray6[5] = dArray4[n4];
            n4 = this.svdOut[n2] + 6;
            dArray6[8] = dArray4[n4];
        }
    }

    public String toString() {
        return String.valueOf(this.mat[0]) + ", " + this.mat[1] + ", " + this.mat[2] + ", " + this.mat[3] + "\n" + this.mat[4] + ", " + this.mat[5] + ", " + this.mat[6] + ", " + this.mat[7] + "\n" + this.mat[8] + ", " + this.mat[9] + ", " + this.mat[10] + ", " + this.mat[11] + "\n" + this.mat[12] + ", " + this.mat[13] + ", " + this.mat[14] + ", " + this.mat[15] + "\n";
    }

    public final void transform(Point3d point3d) {
        double d = this.mat[0] * point3d.x + this.mat[1] * point3d.y + this.mat[2] * point3d.z + this.mat[3];
        double d2 = this.mat[4] * point3d.x + this.mat[5] * point3d.y + this.mat[6] * point3d.z + this.mat[7];
        point3d.z = this.mat[8] * point3d.x + this.mat[9] * point3d.y + this.mat[10] * point3d.z + this.mat[11];
        point3d.x = d;
        point3d.y = d2;
    }

    public final void transform(Point3d point3d, Point3d point3d2) {
        if (point3d == point3d2) {
            this.transform(point3d);
        } else {
            point3d2.x = this.mat[0] * point3d.x + this.mat[1] * point3d.y + this.mat[2] * point3d.z + this.mat[3];
            point3d2.y = this.mat[4] * point3d.x + this.mat[5] * point3d.y + this.mat[6] * point3d.z + this.mat[7];
            point3d2.z = this.mat[8] * point3d.x + this.mat[9] * point3d.y + this.mat[10] * point3d.z + this.mat[11];
        }
    }

    public final void transform(Point3f point3f) {
        float f = (float)(this.mat[0] * (double)point3f.x + this.mat[1] * (double)point3f.y + this.mat[2] * (double)point3f.z + this.mat[3]);
        float f2 = (float)(this.mat[4] * (double)point3f.x + this.mat[5] * (double)point3f.y + this.mat[6] * (double)point3f.z + this.mat[7]);
        point3f.z = (float)(this.mat[8] * (double)point3f.x + this.mat[9] * (double)point3f.y + this.mat[10] * (double)point3f.z + this.mat[11]);
        point3f.x = f;
        point3f.y = f2;
    }

    public final void transform(Point3f point3f, Point3f point3f2) {
        if (point3f == point3f2) {
            this.transform(point3f);
        } else {
            point3f2.x = (float)(this.mat[0] * (double)point3f.x + this.mat[1] * (double)point3f.y + this.mat[2] * (double)point3f.z + this.mat[3]);
            point3f2.y = (float)(this.mat[4] * (double)point3f.x + this.mat[5] * (double)point3f.y + this.mat[6] * (double)point3f.z + this.mat[7]);
            point3f2.z = (float)(this.mat[8] * (double)point3f.x + this.mat[9] * (double)point3f.y + this.mat[10] * (double)point3f.z + this.mat[11]);
        }
    }

    public final void transform(Vector3d vector3d) {
        double d = this.mat[0] * vector3d.x + this.mat[1] * vector3d.y + this.mat[2] * vector3d.z;
        double d2 = this.mat[4] * vector3d.x + this.mat[5] * vector3d.y + this.mat[6] * vector3d.z;
        vector3d.z = this.mat[8] * vector3d.x + this.mat[9] * vector3d.y + this.mat[10] * vector3d.z;
        vector3d.x = d;
        vector3d.y = d2;
    }

    public final void transform(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d2 == vector3d) {
            this.transform(vector3d);
        } else {
            vector3d2.x = this.mat[0] * vector3d.x + this.mat[1] * vector3d.y + this.mat[2] * vector3d.z;
            vector3d2.y = this.mat[4] * vector3d.x + this.mat[5] * vector3d.y + this.mat[6] * vector3d.z;
            vector3d2.z = this.mat[8] * vector3d.x + this.mat[9] * vector3d.y + this.mat[10] * vector3d.z;
        }
    }

    public final void transform(Vector3f vector3f) {
        float f = (float)(this.mat[0] * (double)vector3f.x + this.mat[1] * (double)vector3f.y + this.mat[2] * (double)vector3f.z);
        float f2 = (float)(this.mat[4] * (double)vector3f.x + this.mat[5] * (double)vector3f.y + this.mat[6] * (double)vector3f.z);
        vector3f.z = (float)(this.mat[8] * (double)vector3f.x + this.mat[9] * (double)vector3f.y + this.mat[10] * (double)vector3f.z);
        vector3f.x = f;
        vector3f.y = f2;
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f == vector3f2) {
            this.transform(vector3f);
        } else {
            vector3f2.x = (float)(this.mat[0] * (double)vector3f.x + this.mat[1] * (double)vector3f.y + this.mat[2] * (double)vector3f.z);
            vector3f2.y = (float)(this.mat[4] * (double)vector3f.x + this.mat[5] * (double)vector3f.y + this.mat[6] * (double)vector3f.z);
            vector3f2.z = (float)(this.mat[8] * (double)vector3f.x + this.mat[9] * (double)vector3f.y + this.mat[10] * (double)vector3f.z);
        }
    }

    public final void transform(Vector4d vector4d) {
        double d = this.mat[0] * vector4d.x + this.mat[1] * vector4d.y + this.mat[2] * vector4d.z + this.mat[3] * vector4d.w;
        double d2 = this.mat[4] * vector4d.x + this.mat[5] * vector4d.y + this.mat[6] * vector4d.z + this.mat[7] * vector4d.w;
        double d3 = this.mat[8] * vector4d.x + this.mat[9] * vector4d.y + this.mat[10] * vector4d.z + this.mat[11] * vector4d.w;
        vector4d.w = this.mat[12] * vector4d.x + this.mat[13] * vector4d.y + this.mat[14] * vector4d.z + this.mat[15] * vector4d.w;
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
    }

    public final void transform(Vector4d vector4d, Vector4d vector4d2) {
        if (vector4d == vector4d2) {
            this.transform(vector4d);
        } else {
            vector4d2.x = this.mat[0] * vector4d.x + this.mat[1] * vector4d.y + this.mat[2] * vector4d.z + this.mat[3] * vector4d.w;
            vector4d2.y = this.mat[4] * vector4d.x + this.mat[5] * vector4d.y + this.mat[6] * vector4d.z + this.mat[7] * vector4d.w;
            vector4d2.z = this.mat[8] * vector4d.x + this.mat[9] * vector4d.y + this.mat[10] * vector4d.z + this.mat[11] * vector4d.w;
            vector4d2.w = this.mat[12] * vector4d.x + this.mat[13] * vector4d.y + this.mat[14] * vector4d.z + this.mat[15] * vector4d.w;
        }
    }

    public final void transform(Vector4f vector4f) {
        float f = (float)(this.mat[0] * (double)vector4f.x + this.mat[1] * (double)vector4f.y + this.mat[2] * (double)vector4f.z + this.mat[3] * (double)vector4f.w);
        float f2 = (float)(this.mat[4] * (double)vector4f.x + this.mat[5] * (double)vector4f.y + this.mat[6] * (double)vector4f.z + this.mat[7] * (double)vector4f.w);
        float f3 = (float)(this.mat[8] * (double)vector4f.x + this.mat[9] * (double)vector4f.y + this.mat[10] * (double)vector4f.z + this.mat[11] * (double)vector4f.w);
        vector4f.w = (float)(this.mat[12] * (double)vector4f.x + this.mat[13] * (double)vector4f.y + this.mat[14] * (double)vector4f.z + this.mat[15] * (double)vector4f.w);
        vector4f.x = f;
        vector4f.y = f2;
        vector4f.z = f3;
    }

    public final void transform(Vector4f vector4f, Vector4f vector4f2) {
        if (vector4f2 == vector4f) {
            this.transform(vector4f);
        } else {
            vector4f2.x = (float)(this.mat[0] * (double)vector4f.x + this.mat[1] * (double)vector4f.y + this.mat[2] * (double)vector4f.z + this.mat[3] * (double)vector4f.w);
            vector4f2.y = (float)(this.mat[4] * (double)vector4f.x + this.mat[5] * (double)vector4f.y + this.mat[6] * (double)vector4f.z + this.mat[7] * (double)vector4f.w);
            vector4f2.z = (float)(this.mat[8] * (double)vector4f.x + this.mat[9] * (double)vector4f.y + this.mat[10] * (double)vector4f.z + this.mat[11] * (double)vector4f.w);
            vector4f2.w = (float)(this.mat[12] * (double)vector4f.x + this.mat[13] * (double)vector4f.y + this.mat[14] * (double)vector4f.z + this.mat[15] * (double)vector4f.w);
        }
    }

    public final void transpose() {
        double d = this.mat[4];
        this.mat[4] = this.mat[1];
        this.mat[1] = d;
        d = this.mat[8];
        this.mat[8] = this.mat[2];
        this.mat[2] = d;
        d = this.mat[12];
        this.mat[12] = this.mat[3];
        this.mat[3] = d;
        d = this.mat[9];
        this.mat[9] = this.mat[6];
        this.mat[6] = d;
        d = this.mat[13];
        this.mat[13] = this.mat[7];
        this.mat[7] = d;
        d = this.mat[14];
        this.mat[14] = this.mat[11];
        this.mat[11] = d;
        if (this.autoNormalize) {
            this.normalize();
        } else {
            this.scalesDirty = true;
            this.rotDirty = true;
        }
        this.classify();
    }

    public final void transpose(Transform3D transform3D) {
        if (this != transform3D) {
            this.mat[0] = transform3D.mat[0];
            this.mat[1] = transform3D.mat[4];
            this.mat[2] = transform3D.mat[8];
            this.mat[3] = transform3D.mat[12];
            this.mat[4] = transform3D.mat[1];
            this.mat[5] = transform3D.mat[5];
            this.mat[6] = transform3D.mat[9];
            this.mat[7] = transform3D.mat[13];
            this.mat[8] = transform3D.mat[2];
            this.mat[9] = transform3D.mat[6];
            this.mat[10] = transform3D.mat[10];
            this.mat[11] = transform3D.mat[14];
            this.mat[12] = transform3D.mat[3];
            this.mat[13] = transform3D.mat[7];
            this.mat[14] = transform3D.mat[11];
            this.mat[15] = transform3D.mat[15];
            if (this.autoNormalize) {
                this.normalize();
            } else {
                this.scalesDirty = true;
                this.rotDirty = true;
            }
            this.classify();
        } else {
            this.transpose();
        }
    }

    private static void transpose_mat(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[3];
        dArray2[2] = dArray[6];
        dArray2[3] = dArray[1];
        dArray2[4] = dArray[4];
        dArray2[5] = dArray[7];
        dArray2[6] = dArray[2];
        dArray2[7] = dArray[5];
        dArray2[8] = dArray[8];
    }
}

