/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu.variables;

import java.awt.Container;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.biolegato.core.main.BLMain;
import org.biolegato.ezmenu.variables.GDEVariable;

public class GDEComboBox
extends GDEVariable {
    protected HashMap<Object, Object> choices = null;
    protected JComboBox combobox = null;
    protected Box container = new Box(2);
    public final BasicComboBoxUI comboboxUI = new BasicComboBoxUI(){

        protected ComboPopup createPopup() {
            BasicComboPopup uipopup = new BasicComboPopup(this.comboBox){

                protected JScrollPane createScroller() {
                    return new JScrollPane(this.list, 20, 30);
                }
            };
            return uipopup;
        }
    };
    private static final long serialVersionUID = 7526472295622776158L;

    public GDEComboBox(Map data) {
        super(data);
        boolean defaultEntry = false;
        String[] orderChoices = null;
        if (data.containsKey("description")) {
            this.container.add(new JLabel(data.get("description").toString()));
        }
        if (data.containsKey("choices") && data.get("choices") instanceof Map) {
            this.choices = new HashMap((Map)data.get("choices"));
            if (data.containsKey("choiceorder") && data.get("choiceorder") instanceof LinkedList) {
                orderChoices = ((LinkedList)data.get("choiceorder")).toArray(new String[0]);
                this.combobox = new JComboBox<String>(orderChoices);
            } else {
                this.combobox = new JComboBox<Object>(this.choices.keySet().toArray());
            }
            if (data.containsKey("default")) {
                if (data.containsKey("choiceorder")) {
                    try {
                        this.combobox.setSelectedIndex(Integer.parseInt(data.get("default").toString()));
                    }
                    catch (NumberFormatException nfe) {}
                } else {
                    this.combobox.setSelectedItem(data.get("default").toString());
                }
            }
            this.container.add(this.combobox);
        } else {
            BLMain.error((String)"Invalid argument (missing choice list)", (String)"BLComboBox");
        }
        this.combobox.setUI(this.comboboxUI);
        this.combobox.updateUI();
    }

    public static String getType() {
        return "choice_menu";
    }

    public Object getValue() {
        return this.choices.get(this.combobox.getItemAt(this.combobox.getSelectedIndex()));
    }

    public Container display() {
        return this.container;
    }
}

