/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.gdesupport.canvas.colour.GDEColourMaskFile;
import org.biolegato.gdesupport.canvas.colour.GDEColourMaskMap;

public class GDESequenceWindow
extends JDialog
implements ActionListener,
ItemListener {
    private Sequence seq;
    private JTextField name = new JTextField();
    private JCheckBox protectAlignmentCB = new JCheckBox("Alignment gaps");
    private JCheckBox protectAmbiguousCB = new JCheckBox("Ambiguous characters");
    private JCheckBox protectUnambiguousCB = new JCheckBox("Unambiguous characters");
    private JComboBox type = new JComboBox<Object>(new Object[]{Sequence.Type.DNA, Sequence.Type.RNA, Sequence.Type.PROTEIN, Sequence.Type.TEXT});
    private JComboBox direction = new JComboBox<Object>(new Object[]{Sequence.Direction.FROM5TO3, Sequence.Direction.FROM3TO5});
    private JComboBox topology = new JComboBox<Object>(new Object[]{Sequence.Topology.LINEAR, Sequence.Topology.CIRCULAR});
    private JComboBox strandedness = new JComboBox<Object>(new Object[]{Sequence.Strandedness.SINGLE, Sequence.Strandedness.MIXED, Sequence.Strandedness.DOUBLE});
    private GDEColourMaskFile mask;
    private static final long serialVersionUID = 7526472295622777013L;

    public GDESequenceWindow(int index, ProgramWindow window, Sequence seq) {
        super((Frame)window, "Sequence properties");
        Box mainBox = new Box(3);
        this.seq = seq;
        GDEColourMaskMap currentMask = null;
        Box nameBox = new Box(2);
        nameBox.add(new JLabel("Name:"));
        nameBox.add(this.name);
        this.name.setText(seq.getField("name").toString());
        mainBox.add(nameBox);
        Box typeBox = new Box(2);
        typeBox.add(new JLabel("Type:"));
        typeBox.add(this.type);
        this.type.setSelectedItem(seq.getField("type"));
        this.type.addItemListener(this);
        mainBox.add(typeBox);
        Box directionBox = new Box(2);
        directionBox.add(new JLabel("Direction:"));
        directionBox.add(this.direction);
        this.direction.setSelectedItem(seq.getField("direction"));
        mainBox.add(directionBox);
        Box topologyBox = new Box(2);
        topologyBox.add(new JLabel("Topology:"));
        topologyBox.add(this.topology);
        this.topology.setSelectedItem(seq.getField("topology"));
        mainBox.add(topologyBox);
        Box strandednessBox = new Box(2);
        strandednessBox.add(new JLabel("Strandedness:"));
        strandednessBox.add(this.strandedness);
        this.strandedness.setSelectedItem(seq.getField("strandedness"));
        mainBox.add(strandednessBox);
        Box protectionBox = new Box(3);
        protectionBox.add(this.protectAlignmentCB);
        this.protectAlignmentCB.setSelected(seq.getField("protect_align") != null && seq.getField("protect_align") instanceof Boolean && (Boolean)seq.getField("protect_align") != false);
        protectionBox.add(this.protectAmbiguousCB);
        this.protectAmbiguousCB.setSelected(seq.getField("protect_ambig") != null && seq.getField("protect_ambig") instanceof Boolean && (Boolean)seq.getField("protect_ambig") != false);
        protectionBox.add(this.protectUnambiguousCB);
        this.protectUnambiguousCB.setSelected(seq.getField("protect_unambig") != null && seq.getField("protect_unambig") instanceof Boolean && (Boolean)seq.getField("protect_unambig") != false);
        protectionBox.setBorder(BorderFactory.createTitledBorder("Set character protections"));
        mainBox.add(protectionBox);
        Box maskBox = new Box(2);
        if (seq.getField("mask") != null && seq.getField("mask") instanceof GDEColourMaskMap) {
            currentMask = (GDEColourMaskMap)seq.getField("mask");
        }
        this.mask = new GDEColourMaskFile(this, currentMask);
        maskBox.add(new JLabel("Colour mask:"));
        maskBox.add(this.mask);
        mainBox.add(maskBox);
        JButton update = new JButton("Update");
        update.setActionCommand("update");
        update.addActionListener(this);
        mainBox.add(update);
        this.itemStateChanged(new ItemEvent(this.type, this.type.getSelectedIndex(), this.type.getSelectedItem(), 1));
        this.add(mainBox);
        this.pack();
        this.setLocationRelativeTo((Component)window);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("update")) {
            this.seq.setField("name", (Object)this.name.getText());
            this.seq.setField("type", this.type.getSelectedItem());
            this.seq.setField("direction", this.direction.getSelectedItem());
            this.seq.setField("topology", this.topology.getSelectedItem());
            this.seq.setField("strandedness", this.strandedness.getSelectedItem());
            this.seq.setField("mask", this.mask.getSelectedItem());
            this.seq.setField("protect_align", (Object)new Boolean(this.protectAlignmentCB.isSelected()));
            this.seq.setField("protect_ambig", (Object)new Boolean(this.protectAmbiguousCB.isSelected()));
            this.seq.setField("protect_unambig", (Object)new Boolean(this.protectUnambiguousCB.isSelected()));
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (((Sequence.Type)this.type.getSelectedItem()).equals((Object)Sequence.Type.DNA) || ((Sequence.Type)this.type.getSelectedItem()).equals((Object)Sequence.Type.RNA)) {
            this.direction.setEnabled(true);
            this.topology.setEnabled(true);
            this.strandedness.setEnabled(true);
            this.mask.setEnabled(true);
        } else if (((Sequence.Type)this.type.getSelectedItem()).equals((Object)Sequence.Type.PROTEIN)) {
            this.direction.setEnabled(false);
            this.topology.setEnabled(false);
            this.strandedness.setEnabled(false);
            this.mask.setEnabled(true);
        } else if (((Sequence.Type)this.type.getSelectedItem()).equals((Object)Sequence.Type.TEXT)) {
            this.direction.setEnabled(false);
            this.topology.setEnabled(false);
            this.strandedness.setEnabled(false);
            this.mask.setEnabled(false);
        }
    }
}

