/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.util.regex.Pattern;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.gdesupport.canvas.BLTextArea;

public class GDETextArea
extends BLTextArea {
    private static final long serialVersionUID = 7526472295622777017L;

    public GDETextArea(ProgramWindow instance) {
        super(instance);
    }

    protected boolean insert(char character) {
        boolean result = true;
        String text = character + "";
        Sequence current = this.instance.getSeqDoc().getSequence(this.row);
        boolean bl = result = result && !this.getProtectAlignment(current, text) && !this.getProtectAmbiguous(current, text) && !this.getProtectUnambiguous(current, text);
        if (result) {
            result = super.insert(character);
        }
        return result;
    }

    public boolean delete(int offset, int length) {
        boolean result = true;
        int start = offset;
        int end = start + length;
        int startLine = Math.max(0, this.instance.getSeqDoc().getLineNumber(start));
        int startColumn = Math.max(0, Math.min(this.instance.getSeqDoc().getLineEndOffset(startLine), start - this.instance.getSeqDoc().getLineStartOffset(startLine)));
        int endLine = Math.max(0, Math.min(this.instance.getSeqDoc().getLineNumber(end), this.instance.getSeqDoc().getLineCount()));
        int endColumn = Math.max(0, Math.min(this.instance.getSeqDoc().getLineEndOffset(startLine), end - this.instance.getSeqDoc().getLineStartOffset(endLine)));
        String text = null;
        Sequence current = null;
        for (int count = startLine; count <= endLine; ++count) {
            current = (Sequence)this.instance.getSeqDoc().getSequence(count).clone();
            text = current.getField("sequence").toString();
            if (startLine == endLine && startColumn > 0 && endColumn > 0 && endColumn < text.length()) {
                text = text.substring(startColumn, endColumn);
            } else if (count == startLine && startColumn > 0) {
                text = text.substring(startColumn);
            } else if (count == endLine && endColumn < text.length()) {
                text = text.substring(0, endColumn);
            }
            result = result && !this.getProtectAlignment(current, text) && !this.getProtectAmbiguous(current, text) && !this.getProtectUnambiguous(current, text);
        }
        if (result) {
            result = super.delete(offset, length);
        }
        return result;
    }

    public boolean getProtectAlignment(Sequence seq, String text) {
        boolean protect = false;
        if (Boolean.TRUE.equals(seq.getField("protect_align"))) {
            if (Sequence.Type.DNA.equals(seq.getField("type")) || Sequence.Type.RNA.equals(seq.getField("type"))) {
                protect = Pattern.matches("[^ACTGUactguRYWSMKHBVIDNrywsmkhbvidn]", text);
            } else if (Sequence.Type.PROTEIN.equals(seq.getField("type"))) {
                protect = Pattern.matches("[\\s-]", text);
            }
        }
        return protect;
    }

    public boolean getProtectAmbiguous(Sequence seq, String text) {
        boolean protect = false;
        if (Boolean.TRUE.equals(seq.getField("protect_ambig"))) {
            if (Sequence.Type.DNA.equals(seq.getField("type")) || Sequence.Type.RNA.equals(seq.getField("type"))) {
                protect = Pattern.matches("[RYWSMKHBVIDNrywsmkhbvidn]", text);
            } else if (Sequence.Type.PROTEIN.equals(seq.getField("type"))) {
                protect = Pattern.matches("[BZ\\*Xbzx]", text);
            }
        }
        return protect;
    }

    public boolean getProtectUnambiguous(Sequence seq, String text) {
        boolean protect = false;
        if (Boolean.TRUE.equals(seq.getField("protect_unambig"))) {
            if (Sequence.Type.DNA.equals(seq.getField("type")) || Sequence.Type.RNA.equals(seq.getField("type"))) {
                protect = Pattern.matches("[ACTGUactgu]", text);
            } else if (Sequence.Type.PROTEIN.equals(seq.getField("type"))) {
                protect = Pattern.matches("[^BZ\\*Xbzx\\s-]", text);
            }
        }
        return protect;
    }
}

