/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.selections;

import java.util.LinkedList;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.BLTextArea;
import org.biolegato.gdesupport.canvas.selections.LineSelection;
import org.biolegato.gdesupport.canvas.selections.SelectionListener;

public abstract class Selection {
    private int x1 = -1;
    private int y1 = -1;
    private int x2 = -1;
    private int y2 = -1;
    private LinkedList<SelectionListener> selectionListeners = new LinkedList();

    public Selection() {
    }

    public Selection(Selection s) {
        this.selectionListeners = s.selectionListeners;
        this.move(s.x1, s.y1);
        this.stretch(s.x2, s.y2);
    }

    public void move(int newx, int newy) {
        int oldx = this.x1;
        int oldy = this.y1;
        this.x1 = newx;
        this.y1 = newy;
        for (SelectionListener l : this.selectionListeners) {
            l.selectionMoved(oldx, oldy, newx, newy);
        }
    }

    public void stretch(int newx, int newy) {
        int oldx = this.x2;
        int oldy = this.y2;
        this.x2 = newx;
        this.y2 = newy;
        for (SelectionListener l : this.selectionListeners) {
            l.selectionStretched(oldx, oldy, newx, newy);
        }
    }

    public void reset() {
        this.move(-1, -1);
        this.stretch(-1, -1);
    }

    protected Integer axisIntersect(int t1x1, int t1x2, int t2x1, int t2x2) {
        Integer xint = null;
        if (t2x1 <= t2x2 && (t1x1 <= t2x1 && t2x1 <= t1x2 || t1x2 <= t2x1 && t2x1 <= t1x1)) {
            xint = t2x1;
        } else if (t1x1 <= t1x2 && (t2x1 <= t1x1 && t1x1 <= t2x2 || t2x2 <= t1x1 && t1x1 <= t2x1)) {
            xint = t1x1;
        } else if (t2x1 >= t2x2 && (t1x1 <= t2x2 && t2x2 <= t1x2 || t1x2 <= t2x2 && t2x2 <= t1x1)) {
            xint = t2x2;
        } else if (t1x1 >= t1x2 && (t2x1 <= t1x2 && t1x2 <= t2x2 || t2x2 <= t1x2 && t1x2 <= t2x1)) {
            xint = t1x2;
        }
        return xint;
    }

    public int getX1() {
        return this.x1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public int getMinX() {
        return Math.min(this.x1, this.x2);
    }

    public int getMaxX() {
        return Math.max(this.x1, this.x2);
    }

    public int getMinY() {
        return Math.min(this.y1, this.y2);
    }

    public int getMaxY() {
        return Math.max(this.y1, this.y2);
    }

    public boolean isEmpty() {
        return this.x1 == this.x2 && this.y1 == this.y2;
    }

    public void addListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public String getSelectionText(SeqDoc document) {
        StringBuffer result = new StringBuffer();
        Sequence[] sequences = this.getSelectionSequences(document);
        for (int count = 0; count < sequences.length; ++count) {
            if (count > 0) {
                result.append("\n");
            }
            result.append(sequences[count].getField("sequence").toString());
        }
        return result.toString();
    }

    public abstract LineSelection intersect(int var1, int var2);

    public abstract Sequence[] getSelectionSequences(SeqDoc var1);

    public abstract boolean delete(BLTextArea var1);
}

