/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.selections;

import java.util.LinkedList;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.BLTextArea;
import org.biolegato.gdesupport.canvas.selections.LineSelection;
import org.biolegato.gdesupport.canvas.selections.Selection;

public class TextRectangle
extends Selection {
    public TextRectangle() {
    }

    public TextRectangle(Selection s) {
        super(s);
    }

    public LineSelection intersect(int line, int length) {
        Integer int1 = this.axisIntersect(0, length, this.getX1(), this.getX2());
        Integer int2 = this.axisIntersect(0 - length, 0, 0 - this.getX2(), 0 - this.getX1());
        LineSelection intersect = null;
        if (int1 != null && int2 != null && (line >= this.getY1() && line <= this.getY2() || line <= this.getY1() && line >= this.getY2())) {
            intersect = new LineSelection(int1, 0 - int2);
        }
        return intersect;
    }

    public Sequence[] getSelectionSequences(SeqDoc document) {
        String currentSequence = "";
        Sequence current = null;
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        if (!this.isEmpty()) {
            for (int count = this.getMinY(); count <= this.getMaxY(); ++count) {
                int length = document.getLineLength(count);
                if (this.getMinX() >= length || (current = document.getSequence(count)) == null) continue;
                current = (Sequence)current.clone();
                currentSequence = current.getField("sequence").toString();
                if (this.getMaxX() < length) {
                    currentSequence = currentSequence.substring(0, this.getMaxX());
                }
                if (this.getMinX() > 0) {
                    currentSequence = currentSequence.substring(this.getMinX());
                }
                if (!currentSequence.equals(current.getField("sequence").toString())) {
                    current.setField("sequence", (Object)currentSequence);
                }
                result.add(current);
            }
        }
        return result.toArray(new Sequence[0]);
    }

    public boolean delete(BLTextArea textarea) {
        boolean result = true;
        if (!this.isEmpty()) {
            for (int count = this.getMaxY(); count >= this.getMinY(); --count) {
                result = result && textarea.delete(textarea.getSeqDoc().getLineStartOffset(count) + this.getMinX(), Math.min(textarea.getSeqDoc().getLineLength(count), this.getMaxX() - this.getMinX()));
            }
        }
        return result;
    }
}

