/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.menu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.core.plugintypes.DataFormat;
import org.biolegato.ezmenu.EZMenuType;
import org.biolegato.ezmenu.RunWindow;
import org.biolegato.ezmenu.variables.GDETempFile;
import org.biolegato.ezmenu.variables.GDEVariable;

public class GDEMenu
extends EZMenuType {
    public static void loadMenu(ProgramWindow program) {
        if (program.getProperty("GDE.menu").equalsIgnoreCase("true")) {
            if (System.getenv("GDE_HELP_DIR") != null) {
                GDEMenu.readGDEMenuFile(program, new File(System.getenv("GDE_HELP_DIR") + File.separator + ".GDEmenus"));
            } else {
                BLMain.warning((String)"GDE_HELP_DIR not set!", (String)"GDEMenu plugin");
            }
            GDEMenu.readGDEMenuFile(program, new File(".GDEmenus"));
            try {
                if (System.getProperty("user.home") != null) {
                    GDEMenu.readGDEMenuFile(program, new File(System.getProperty("user.home") + File.separator + ".GDEmenus"));
                } else {
                    BLMain.warning((String)"HOME not set!", (String)"GDEMenu plugin");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void readGDEMenuFile(final ProgramWindow program, File file) {
        String line = "";
        String menuName = "File";
        String fname = "";
        String fvalue = "";
        String itemName = "";
        BufferedReader reader = null;
        JMenuItem jmitemp = null;
        RunWindow currentItem = null;
        LinkedList<String> orderChoices = new LinkedList<String>();
        HashMap<String, String> choices = new HashMap<String, String>();
        HashMap<String, Object> infile = new HashMap<String, Object>();
        HashMap<String, Object> outfile = new HashMap<String, Object>();
        HashMap<String, Object> arg = new HashMap<String, Object>();
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                reader = new BufferedReader(new FileReader(file));
                do {
                    fname = "";
                    fvalue = "";
                    line = reader.readLine();
                    if (line != null && !line.equals("") && line.indexOf(35) != 0 && line.indexOf(58) >= 0) {
                        fname = line.substring(0, line.indexOf(58)).trim().toLowerCase();
                        fvalue = line.substring(line.indexOf(58) + 1).trim();
                    }
                    if (currentItem != null) {
                        if ((line == null || fname.equals("item") || fname.equals("arg") || fname.equals("in") || fname.equals("menu")) && infile.containsKey("name")) {
                            infile.put("window", program);
                            infile.put("input", Boolean.TRUE);
                            currentItem.addVariable(new GDETempFile(infile));
                            infile.clear();
                        }
                        if ((line == null || fname.equals("item") || fname.equals("arg") || fname.equals("out") || fname.equals("menu")) && outfile.containsKey("name")) {
                            outfile.put("window", program);
                            outfile.put("output", Boolean.TRUE);
                            currentItem.addVariable(new GDETempFile(outfile));
                            outfile.clear();
                        }
                        if ((line == null || fname.equals("item") || fname.equals("arg") || fname.equals("menu")) && arg.containsKey("name")) {
                            arg.put("window", program);
                            arg.put("choices", choices);
                            arg.put("choiceorder", orderChoices);
                            if (arg.containsKey("name") && arg.containsKey("type")) {
                                currentItem.addVariable(GDEVariable.createVariable(arg));
                            }
                            orderChoices.clear();
                            choices.clear();
                            arg.clear();
                        }
                    }
                    if (fname.equals("")) continue;
                    if (fname.equals("menu")) {
                        menuName = fvalue;
                        program.addMenuHeading(menuName);
                        continue;
                    }
                    if (fname.equals("item")) {
                        itemName = fvalue;
                        currentItem = new RunWindow(program, itemName);
                        jmitemp = new JMenuItem(itemName);
                        jmitemp.addActionListener(currentItem);
                        program.addMenuItem(menuName, jmitemp);
                        continue;
                    }
                    if (currentItem != null) {
                        if (fname.equals("itemmeta") && fvalue.length() >= 1) {
                            if (fvalue.charAt(0) >= 'a' && fvalue.charAt(0) <= 'z' || fvalue.charAt(0) < 'A' || fvalue.charAt(0) > 'Z') continue;
                            continue;
                        }
                        if (fname.equals("itemlabel") || fname.equals("itemopen")) continue;
                        if (fname.equals("itemhelp")) {
                            final String helpCommand = program.getProperty("GDE.help.viewer") + " " + program.getProperty("GDE.help.path") + File.separator + fvalue;
                            currentItem.addButton(new RunWindow.ActionThread("Help", new Runnable(){

                                public void run() {
                                    try {
                                        program.shellCommand(helpCommand, "");
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                            }));
                            continue;
                        }
                        if (fname.equals("itemmethod")) {
                            currentItem.setCommand(fvalue);
                            continue;
                        }
                        if (fname.equals("arg")) {
                            arg.put("name", fvalue);
                            continue;
                        }
                        if (fname.equals("argtype")) {
                            arg.put("type", fvalue);
                            continue;
                        }
                        if (fname.equals("arglabel")) {
                            arg.put("description", fvalue);
                            continue;
                        }
                        if (fname.equals("argmin")) {
                            try {
                                arg.put("minimum", Integer.parseInt(fvalue));
                            }
                            catch (NumberFormatException nfe) {
                                BLMain.error((String)("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                            }
                            continue;
                        }
                        if (fname.equals("argmax")) {
                            try {
                                arg.put("maximum", Integer.parseInt(fvalue));
                            }
                            catch (NumberFormatException nfe) {
                                BLMain.error((String)("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                            }
                            continue;
                        }
                        if (fname.equals("argvalue") || fname.equals("argtext")) {
                            arg.put("default", fvalue);
                            continue;
                        }
                        if (fname.equals("argchoice")) {
                            if (fvalue.indexOf(58) >= 0) {
                                choices.put(fvalue.substring(0, fvalue.indexOf(58)), fvalue.substring(fvalue.indexOf(58) + 1));
                                orderChoices.add(fvalue.substring(0, fvalue.indexOf(58)));
                                continue;
                            }
                            choices.put(fvalue, "");
                            orderChoices.add(fvalue);
                            BLMain.warning((String)("Badly formed argchoice field: " + fvalue), (String)"GDEMenu");
                            continue;
                        }
                        if (fname.equals("in")) {
                            infile.put("name", fvalue);
                            continue;
                        }
                        if (fname.equals("informat")) {
                            infile.put("format", DataFormat.getFormat((String)fvalue));
                            continue;
                        }
                        if (fname.equals("inmask")) {
                            infile.put("mask", Boolean.TRUE);
                            continue;
                        }
                        if (fname.equals("insave")) {
                            infile.put("save", Boolean.TRUE);
                            continue;
                        }
                        if (fname.equals("out")) {
                            outfile.put("name", fvalue);
                            continue;
                        }
                        if (fname.equals("outformat")) {
                            outfile.put("format", DataFormat.getFormat((String)fvalue));
                            continue;
                        }
                        if (fname.equals("outsave")) {
                            outfile.put("save", Boolean.TRUE);
                            continue;
                        }
                        if (fname.equals("outoverwrite")) {
                            outfile.put("overwrite", Boolean.TRUE);
                            continue;
                        }
                        BLMain.error((String)("Invalid GDE field (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                        continue;
                    }
                    BLMain.error((String)("Invalid GDE location or field value (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                } while (line != null);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

