/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.PixelAccessor;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.Histogram;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

final class HistogramOpImage
extends StatisticsOpImage {
    private Histogram histogram;
    private PixelAccessor srcPA;
    private int srcPixelType;

    public HistogramOpImage(RenderedImage renderedImage, Histogram histogram, ROI rOI, int n, int n2, int n3, int n4, int n5, int n6) {
        super(renderedImage, rOI, n, n2, n3, n4, n5, n6);
        this.histogram = histogram;
        this.srcPA = new PixelAccessor(renderedImage);
        this.srcPixelType = this.srcPA.pixelType == -1 ? 0 : this.srcPA.pixelType;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        LinkedList linkedList;
        Rectangle rectangle = this.source0.getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
            int n = rectangle2.x;
            int n2 = rectangle2.y;
            rectangle2.x = this.startPosition(n, this.xStart, this.xPeriod);
            rectangle2.y = this.startPosition(n2, this.yStart, this.yPeriod);
            rectangle2.width = n + rectangle2.width - rectangle2.x;
            rectangle2.height = n2 + rectangle2.height - rectangle2.y;
            if (rectangle2.isEmpty()) continue;
            UnpackedPixelData unpackedPixelData = this.srcPA.getData(raster, rectangle2, this.srcPixelType, false);
            switch (unpackedPixelData.dataType) {
                case 0: {
                    this.accumulateStatisticsByte(unpackedPixelData);
                    break;
                }
                case 1: {
                    this.accumulateStatisticsUShort(unpackedPixelData);
                    break;
                }
                case 2: {
                    this.accumulateStatisticsShort(unpackedPixelData);
                    break;
                }
                case 3: {
                    this.accumulateStatisticsInt(unpackedPixelData);
                    break;
                }
                case 4: {
                    this.accumulateStatisticsFloat(unpackedPixelData);
                    break;
                }
                case 5: {
                    this.accumulateStatisticsDouble(unpackedPixelData);
                    break;
                }
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        byte[][] byArray = unpackedPixelData.getByteData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int[][] nArray = this.histogram.getBins();
        double[] dArray = this.histogram.getLowValue();
        double[] dArray2 = this.histogram.getHighValue();
        int[] nArray2 = this.histogram.getNumBins();
        int n5 = Math.min(this.srcPA.numBands, nArray2.length);
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray3 = nArray[n6];
            float f = (float)dArray[n6];
            float f2 = (float)dArray2[n6];
            float f3 = (float)nArray2[n6] / (f2 - f);
            byte[] byArray2 = byArray[n6];
            int n7 = unpackedPixelData.offsets[n6] + rectangle.height * n;
            int n8 = unpackedPixelData.offsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n2;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = byArray2[n10] & 0xFF;
                    if ((float)n11 >= f && (float)n11 < f2) {
                        int n12;
                        int n13 = n12 = (int)(((float)n11 - f) * f3);
                        nArray3[n13] = nArray3[n13] + 1;
                    }
                    n10 += n4;
                }
                n8 += n3;
            }
            ++n6;
        }
    }

    private void accumulateStatisticsDouble(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        double[][] dArray = unpackedPixelData.getDoubleData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int[][] nArray = this.histogram.getBins();
        double[] dArray2 = this.histogram.getLowValue();
        double[] dArray3 = this.histogram.getHighValue();
        int[] nArray2 = this.histogram.getNumBins();
        int n5 = Math.min(this.srcPA.numBands, nArray2.length);
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray3 = nArray[n6];
            double d = dArray2[n6];
            double d2 = dArray3[n6];
            double d3 = (double)nArray2[n6] / (d2 - d);
            double[] dArray4 = dArray[n6];
            int n7 = unpackedPixelData.offsets[n6] + rectangle.height * n;
            int n8 = unpackedPixelData.offsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n2;
                int n10 = n8;
                while (n10 < n9) {
                    double d4 = dArray4[n10];
                    if (d4 >= d && d4 < d2) {
                        int n11;
                        int n12 = n11 = (int)((d4 - d) * d3);
                        nArray3[n12] = nArray3[n12] + 1;
                    }
                    n10 += n4;
                }
                n8 += n3;
            }
            ++n6;
        }
    }

    private void accumulateStatisticsFloat(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        float[][] fArray = unpackedPixelData.getFloatData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int[][] nArray = this.histogram.getBins();
        double[] dArray = this.histogram.getLowValue();
        double[] dArray2 = this.histogram.getHighValue();
        int[] nArray2 = this.histogram.getNumBins();
        int n5 = Math.min(this.srcPA.numBands, nArray2.length);
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray3 = nArray[n6];
            float f = (float)dArray[n6];
            float f2 = (float)dArray2[n6];
            float f3 = (float)nArray2[n6] / (f2 - f);
            float[] fArray2 = fArray[n6];
            int n7 = unpackedPixelData.offsets[n6] + rectangle.height * n;
            int n8 = unpackedPixelData.offsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n2;
                int n10 = n8;
                while (n10 < n9) {
                    float f4 = fArray2[n10];
                    if (f4 >= f && f4 < f2) {
                        int n11;
                        int n12 = n11 = (int)((f4 - f) * f3);
                        nArray3[n12] = nArray3[n12] + 1;
                    }
                    n10 += n4;
                }
                n8 += n3;
            }
            ++n6;
        }
    }

    private void accumulateStatisticsInt(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        int[][] nArray = unpackedPixelData.getIntData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int[][] nArray2 = this.histogram.getBins();
        double[] dArray = this.histogram.getLowValue();
        double[] dArray2 = this.histogram.getHighValue();
        int[] nArray3 = this.histogram.getNumBins();
        int n5 = Math.min(this.srcPA.numBands, nArray3.length);
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray4 = nArray2[n6];
            float f = (float)dArray[n6];
            float f2 = (float)dArray2[n6];
            float f3 = (float)nArray3[n6] / (f2 - f);
            int[] nArray5 = nArray[n6];
            int n7 = unpackedPixelData.offsets[n6] + rectangle.height * n;
            int n8 = unpackedPixelData.offsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n2;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = nArray5[n10];
                    if ((float)n11 >= f && (float)n11 < f2) {
                        int n12;
                        int n13 = n12 = (int)(((float)n11 - f) * f3);
                        nArray4[n13] = nArray4[n13] + 1;
                    }
                    n10 += n4;
                }
                n8 += n3;
            }
            ++n6;
        }
    }

    private void accumulateStatisticsShort(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        short[][] sArray = unpackedPixelData.getShortData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int[][] nArray = this.histogram.getBins();
        double[] dArray = this.histogram.getLowValue();
        double[] dArray2 = this.histogram.getHighValue();
        int[] nArray2 = this.histogram.getNumBins();
        int n5 = Math.min(this.srcPA.numBands, nArray2.length);
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray3 = nArray[n6];
            float f = (float)dArray[n6];
            float f2 = (float)dArray2[n6];
            float f3 = (float)nArray2[n6] / (f2 - f);
            short[] sArray2 = sArray[n6];
            int n7 = unpackedPixelData.offsets[n6] + rectangle.height * n;
            int n8 = unpackedPixelData.offsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n2;
                int n10 = n8;
                while (n10 < n9) {
                    short s = sArray2[n10];
                    if ((float)s >= f && (float)s < f2) {
                        int n11;
                        int n12 = n11 = (int)(((float)s - f) * f3);
                        nArray3[n12] = nArray3[n12] + 1;
                    }
                    n10 += n4;
                }
                n8 += n3;
            }
            ++n6;
        }
    }

    private void accumulateStatisticsUShort(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        short[][] sArray = unpackedPixelData.getShortData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int[][] nArray = this.histogram.getBins();
        double[] dArray = this.histogram.getLowValue();
        double[] dArray2 = this.histogram.getHighValue();
        int[] nArray2 = this.histogram.getNumBins();
        int n5 = Math.min(this.srcPA.numBands, nArray2.length);
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray3 = nArray[n6];
            float f = (float)dArray[n6];
            float f2 = (float)dArray2[n6];
            float f3 = (float)nArray2[n6] / (f2 - f);
            short[] sArray2 = sArray[n6];
            int n7 = unpackedPixelData.offsets[n6] + rectangle.height * n;
            int n8 = unpackedPixelData.offsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n2;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = sArray2[n10] & 0xFFFF;
                    if ((float)n11 >= f && (float)n11 < f2) {
                        int n12;
                        int n13 = n12 = (int)(((float)n11 - f) * f3);
                        nArray3[n13] = nArray3[n13] + 1;
                    }
                    n10 += n4;
                }
                n8 += n3;
            }
            ++n6;
        }
    }

    protected Object createStatistics(String string) {
        if (string.equalsIgnoreCase("histogram")) {
            return this.histogram;
        }
        return Image.UndefinedProperty;
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"histogram"};
        return stringArray;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }
}

