/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.ezmenu.variables.GDETempFile;
import org.biolegato.ezmenu.variables.GDEVariable;

public class RunWindow
extends JDialog
implements Runnable,
ActionListener {
    private LinkedList<GDETempFile> files = new LinkedList();
    private ProgramWindow program = null;
    private String command = "";
    protected Container variablePane = new Box(3);
    protected Container buttonPane = new Box(2);
    protected Hashtable<String, GDEVariable> variables = new Hashtable();
    private static final long serialVersionUID = 7526472295622777007L;

    public RunWindow(ProgramWindow parent, String name) {
        super((Frame)parent, "BioLegato: " + name, true);
        this.setContentPane(new JScrollPane(new Box(3){
            private static final long serialVersionUID = 7526472295622777003L;
            {
                this.add(RunWindow.this.variablePane);
                this.add(RunWindow.this.buttonPane);
            }
        }));
        this.setMinimumSize(new Dimension(50, 50));
        this.setSize(new Dimension(100, 100));
        this.setLocationRelativeTo((Component)parent);
        this.setVisible(false);
        this.program = parent;
        this.addButton(new ActionThread("Run", this));
    }

    public void addButton(Action run) {
        this.buttonPane.add(new JButton(run));
        this.pack();
    }

    public void addVariable(GDEVariable variable) {
        Container panel = null;
        if (variable != null) {
            panel = variable.display();
            if (panel != null) {
                this.variablePane.add(panel);
            }
            this.pack();
        }
        if (variable instanceof GDETempFile) {
            this.files.add((GDETempFile)variable);
        } else {
            this.variables.put(variable.getName().toLowerCase(), variable);
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void run() {
        String run = this.command;
        this.setVisible(false);
        run = this.replaceArguments(run);
        this.program.shellCommand(run, "");
        this.cleanupExecution();
    }

    public void actionPerformed(ActionEvent event) {
        this.setVisible(true);
    }

    private String replaceArguments(String run) {
        int start = -1;
        int end = -1;
        String name = "";
        String value = "";
        while ((start = run.indexOf(36, start)) >= 0) {
            for (end = start + 1; end < run.length() && this.isDigit(run.charAt(end)); ++end) {
            }
            name = run.substring(start + 1, end).toLowerCase();
            value = "";
            if (this.variables.containsKey(name)) {
                value = this.variables.get(name).getValue().toString();
                run = (start == 0 ? "" : run.substring(0, start)) + value + (end >= run.length() ? "" : run.substring(end));
                --start;
                continue;
            }
            ++start;
        }
        for (GDETempFile file : this.files) {
            start = -1;
            end = -1;
            if (file.getName() == null || file.getName().equals("")) continue;
            name = file.getName();
            value = file.getValue().toString();
            while ((start = run.indexOf(name, end + 1)) >= 0) {
                end = start + name.length();
                if (start != 0 && !this.notDigit(run.charAt(start - 1)) || end < run.length() && !this.notDigit(run.charAt(end))) continue;
                run = (start == 0 ? "" : run.substring(0, start)) + value + (end >= run.length() ? "" : run.substring(end));
                end = start - 1;
            }
        }
        return run;
    }

    private boolean notDigit(char test) {
        return !(test >= '0' && test <= '9' || test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z');
    }

    private boolean isDigit(char test) {
        return test >= '0' && test <= '9' || test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z';
    }

    private void cleanupExecution() {
        for (GDETempFile file : this.files) {
            file.close();
        }
    }

    public static class ActionThread
    extends AbstractAction {
        private Runnable run = null;
        private static final long serialVersionUID = 7526472295622777001L;

        public ActionThread(String name, Runnable run) {
            super(name);
            this.run = run;
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(this.run).start();
        }
    }
}

