/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu.variables;

import java.io.File;
import java.util.Map;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.core.plugintypes.DataFormat;
import org.biolegato.ezmenu.variables.GDEVariable;

public class GDETempFile
extends GDEVariable {
    private File currentFile = null;
    private boolean input = false;
    private boolean output = false;
    private boolean save = false;
    private boolean mask = false;
    private boolean overwrite = false;
    private ProgramWindow window = null;
    private DataFormat format = null;

    public GDETempFile(Map data) {
        super(data);
        if (data.containsKey("window") && data.get("window") instanceof ProgramWindow) {
            this.window = (ProgramWindow)data.get("window");
        }
        if (data.containsKey("format") && data.get("format") instanceof DataFormat) {
            this.format = (DataFormat)data.get("format");
            if (this.format == null) {
                this.format = DataFormat.getFormat((String)"raw");
                if (this.format == null) {
                    BLMain.error((String)"missing raw file type", (String)"TempFileVariable");
                }
            }
        }
        if (data.containsKey("save") && Boolean.TRUE.equals(data.get("save"))) {
            this.save = true;
        }
        if (data.containsKey("overwrite") && Boolean.TRUE.equals(data.get("overwrite"))) {
            this.overwrite = true;
        }
        if (data.containsKey("mask") && Boolean.TRUE.equals(data.get("mask"))) {
            this.mask = true;
        }
        if (data.containsKey("input") && Boolean.TRUE.equals(data.get("input"))) {
            this.input = true;
        }
        if (data.containsKey("output") && Boolean.TRUE.equals(data.get("output"))) {
            this.output = true;
        }
    }

    public Object getValue() {
        String result = "";
        String data = "";
        if (this.currentFile == null) {
            try {
                this.currentFile = File.createTempFile("bio", null, new File(ProgramWindow.CURRENT_DIR));
                if (!this.save) {
                    this.currentFile.deleteOnExit();
                }
                if (this.input && this.format != null) {
                    this.format.writeFile(this.currentFile, this.window.getData());
                } else if (this.format == null) {
                    BLMain.error((String)"Invalid file format", (String)"GDETempFile");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (this.currentFile != null) {
            result = this.currentFile.getName();
        }
        return result != null && !"".equals(result.trim()) ? result : this.getName();
    }

    public void close() {
        if (this.currentFile != null && this.currentFile.exists()) {
            if (this.output) {
                if (this.format != null) {
                    try {
                        Sequence[] dataIn = this.format.readFile(this.currentFile);
                        this.window.addData(dataIn);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else {
                    BLMain.error((String)"Invalid file format", (String)"GDETempFile");
                }
            }
            if (!this.save) {
                this.currentFile.delete();
            }
        }
        this.currentFile = null;
    }

    public static String getType() {
        return "tempfile";
    }
}

