/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.text.BadLocationException;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.core.properties.PropertiesListener;
import org.biolegato.gdesupport.canvas.BLTextArea;
import org.biolegato.gdesupport.canvas.GDEList;
import org.biolegato.gdesupport.canvas.GDETextArea;
import org.biolegato.gdesupport.canvas.SelectByNameWindow;
import org.biolegato.gdesupport.canvas.colour.GDECharColourMap;
import org.biolegato.gdesupport.canvas.listeners.CursorListener;
import org.biolegato.gdesupport.canvas.listeners.ModeListener;

public class GDECanvas
extends DataCanvas
implements CursorListener,
FocusListener,
ModeListener,
PropertiesListener {
    private boolean useNameList = false;
    private GDEList nameList = new GDEList(this.program);
    private GDETextArea dataCollector = new GDETextArea(this.program);
    private static final long serialVersionUID = 7526472295622776154L;
    private Box canvasPane = new Box(2);
    private final GDECanvas canvasSelf = this;
    private final JLabel status = new JLabel("Row: 1 Col: 1");
    private final JLabel insertStatus = new JLabel("     ");
    private final JMenuItem splitAction = new JMenuItem(new AbstractAction("Split"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDECanvas.this.canvasPane.add(new JScrollPane(new GDETextArea(GDECanvas.this.program), 22, 32));
            GDECanvas.this.dataCollector.addPopupMenuItem(GDECanvas.this.joinAction);
        }
    });
    public final SelectByNameWindow selectionWindow = new SelectByNameWindow((JFrame)this.program, this.nameList);
    public final JMenuItem selectByNameAction = new JMenuItem(new AbstractAction("Select sequence by name"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.selectionWindow.setVisible(true);
        }
    });
    private final JMenuItem joinAction = new JMenuItem(new AbstractAction("Join"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            System.out.println(((JMenuItem)e.getSource()).getParent().getClass());
        }
    });
    private final JMenuItem cutAction = new JMenuItem(new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.cut();
        }
    });
    private final JMenuItem copyAction = new JMenuItem(new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.copy();
        }
    });
    private final JMenuItem pasteAction = new JMenuItem(new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.paste();
        }
    });
    private final JMenuItem selectAllAction = new JMenuItem(new AbstractAction("Select All"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.selectAll();
        }
    });
    public final GDECanvas gdeCanvasSelf = this;

    public GDECanvas(ProgramWindow program) {
        super(program, 3);
        this.dataCollector.addFocusListener(this);
        this.dataCollector.addCursorListener(this);
        this.dataCollector.addModeListener(this);
        this.nameList.addFocusListener(this);
        program.addPropertiesListener("font.size", (PropertiesListener)this);
        program.addPropertiesListener("font.bold", (PropertiesListener)this);
        this.dataCollector.setColourMap(new GDECharColourMap());
        this.dataCollector.setBackground(new Color(255, 255, 240));
        JScrollPane dataPane = new JScrollPane(this.dataCollector, 22, 32);
        JScrollPane listPane = new JScrollPane(this.nameList, 21, 32);
        dataPane.setPreferredSize(new Dimension(200, 150));
        listPane.setPreferredSize(new Dimension(100, 150));
        dataPane.setVerticalScrollBar(listPane.getVerticalScrollBar());
        this.updateFont();
        this.canvasPane.add(dataPane);
        JSplitPane mainPane = new JSplitPane(1, listPane, this.canvasPane);
        mainPane.setAlignmentX(0.5f);
        mainPane.setAlignmentY(0.5f);
        Box statusBar = new Box(2);
        statusBar.setAlignmentX(0.0f);
        statusBar.add(this.status);
        statusBar.add(this.insertStatus);
        this.add(mainPane, "First");
        this.add(new JSeparator(0));
        this.add(statusBar, "Last");
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof JTabbedPane && ((JTabbedPane)source).getSelectedComponent() == this) {
            this.program.addMenuHeading(1, "Edit").insert(this.cutAction, 0);
            this.program.addMenuHeading(1, "Edit").insert(this.copyAction, 1);
            this.program.addMenuHeading(1, "Edit").insert(this.pasteAction, 2);
            this.program.addMenuHeading(1, "Edit").insert(this.selectAllAction, 3);
            this.program.addMenuHeading(1, "Edit").insert(this.nameList.getInfoAction, 4);
            this.program.addMenuHeading(1, "Edit").insert(this.selectByNameAction, 5);
        } else {
            this.program.addMenuHeading(1, "Edit").remove(this.cutAction);
            this.program.addMenuHeading(1, "Edit").remove(this.copyAction);
            this.program.addMenuHeading(1, "Edit").remove(this.pasteAction);
            this.program.addMenuHeading(1, "Edit").remove(this.selectAllAction);
            this.program.addMenuHeading(1, "Edit").remove(this.nameList.getInfoAction);
            this.program.addMenuHeading(1, "Edit").remove(this.selectByNameAction);
        }
    }

    public Sequence[] getData() throws BadLocationException {
        LinkedList<Sequence> lines = new LinkedList<Sequence>();
        Sequence[] result = new Sequence[]{};
        if (this.useNameList) {
            for (int lineNumber : this.nameList.getSelectedIndices()) {
                if (this.program.getSeqDoc().getSequence(lineNumber) == null) continue;
                lines.add(this.program.getSeqDoc().getSequence(lineNumber));
            }
            result = lines.toArray(new Sequence[0]);
        } else {
            result = this.dataCollector.getData();
        }
        return result != null ? result : new Sequence[]{};
    }

    public String getTabName() {
        return "GDE";
    }

    public void focusGained(FocusEvent event) {
        if (event.getComponent() instanceof GDEList) {
            this.useNameList = true;
        } else if (event.getComponent() instanceof BLTextArea) {
            this.useNameList = false;
        }
    }

    public void focusLost(FocusEvent event) {
    }

    private void updateFont() {
        int fontsize = 12;
        String fontsizestr = this.program.getProperty("font.size");
        if (fontsizestr != null) {
            try {
                fontsize = Integer.parseInt(fontsizestr);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        Font currentFont = new Font("Lucida Sans Typewriter", 0, fontsize);
        if ("true".equalsIgnoreCase(this.program.getProperty("font.bold"))) {
            this.dataCollector.setFont(currentFont.deriveFont(1));
        } else {
            this.dataCollector.setFont(currentFont);
        }
        this.nameList.setFont(currentFont);
    }

    public void copy() {
        if (this.useNameList) {
            this.nameList.copy();
        } else {
            this.dataCollector.copy();
        }
    }

    public void cut() {
        if (this.useNameList) {
            this.nameList.cut();
        } else {
            this.dataCollector.cut();
        }
    }

    public void paste() {
        if (this.useNameList) {
            this.nameList.paste();
        } else {
            this.dataCollector.paste();
        }
    }

    public void selectAll() {
        this.nameList.selectAll();
        this.dataCollector.selectAll();
        this.nameList.requestFocus();
    }

    public void cursorChange(BLTextArea source, int column, int row) {
        this.status.setText("Row: " + (row + 1) + " Col: " + (column + 1));
    }

    public void insertionMode(boolean mode) {
        if (mode) {
            this.insertStatus.setText("[INS]");
        } else {
            this.insertStatus.setText("     ");
        }
    }

    public void propertiesUpdate(String key, String value) {
        if (key.toLowerCase().startsWith("font.")) {
            this.updateFont();
        }
    }
}

