/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.biolegato.core.main.ProgramWindow;
import org.biolegato.gdesupport.canvas.Editable;
import org.biolegato.gdesupport.canvas.GDESequenceWindow;
import org.biolegato.gdesupport.canvas.SequenceListModel;

public class GDEList
extends JList
implements MouseListener,
FocusListener,
Editable {
    private long lastClickTime = -1000L;
    private int lastClickEntry = -1;
    protected ProgramWindow program = null;
    private final GDEList listSelf = this;
    protected JPopupMenu popup = new JPopupMenu();
    public final JMenuItem getInfoAction = new JMenuItem(new AbstractAction("Get info..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.getInfo();
        }
    });
    private final JMenuItem cutAction = new JMenuItem(new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.cut();
        }
    });
    private final JMenuItem copyAction = new JMenuItem(new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.copy();
        }
    });
    private final JMenuItem pasteAction = new JMenuItem(new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.paste();
        }
    });
    private final JMenuItem selectAllAction = new JMenuItem(new AbstractAction("Select All"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.selectAll();
        }
    });
    private static final long serialVersionUID = 7526472295622777009L;

    public GDEList(ProgramWindow program) {
        super(new SequenceListModel(program.getSeqDoc()));
        this.program = program;
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addPopupMenuItem(this.cutAction);
        this.addPopupMenuItem(this.copyAction);
        this.addPopupMenuItem(this.pasteAction);
        this.addPopupMenuItem(this.selectAllAction);
        this.addPopupMenuItem(this.getInfoAction);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.LIGHT_GRAY);
        this.setSelectionBackground(Color.WHITE);
        this.setSelectionForeground(Color.GRAY);
        this.setSize(this.getPreferredSize());
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 2 || this.getSelectedIndex() == this.lastClickEntry && event.getWhen() - this.lastClickTime < 300L) {
            this.getInfo();
        }
        this.lastClickTime = event.getWhen();
        this.lastClickEntry = this.getSelectedIndex();
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public int row2Y(int r) {
        return r * this.getFontMetrics(this.getFont()).getHeight();
    }

    public int column2X(int c) {
        return c * this.getFontMetrics(this.getFont()).charWidth('a');
    }

    public int Y2Row(int Y) {
        return Y / this.getFontMetrics(this.getFont()).getHeight();
    }

    public int X2Column(int X) {
        return X / this.getFontMetrics(this.getFont()).charWidth('a');
    }

    public void copy() {
        this.program.setClipboard(this.program.getSeqDoc().getSequences(this.getSelectedIndices()));
    }

    public void cut() {
        this.copy();
        this.program.getSeqDoc().removeSequences(this.getSelectedIndices());
    }

    public void paste() {
        int position = this.program.getSeqDoc().getLineCount();
        if (this.getSelectedIndex() >= 0) {
            position = this.getSelectedIndex() + 1;
        }
        this.program.getSeqDoc().addSequences(position, this.program.getClipboard());
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getModel().getSize());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFixedCellHeight(this.getFontMetrics(font).getHeight());
        this.repaint();
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.popup.add(item);
    }

    public void getInfo() {
        if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.program.getSeqDoc().getLineCount()) {
            new GDESequenceWindow(this.getSelectedIndex(), this.program, this.program.getSeqDoc().getSequence(this.getSelectedIndex()));
        }
    }

    public void focusGained(FocusEvent e) {
        this.setBackground(new Color(255, 255, 240));
        this.setSelectionBackground(Color.BLUE);
        this.setSelectionForeground(Color.WHITE);
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.setBackground(Color.LIGHT_GRAY);
        this.setSelectionBackground(Color.WHITE);
        this.setSelectionForeground(Color.GRAY);
        this.repaint();
    }

    public SequenceListModel getListModel() {
        return (SequenceListModel)super.getModel();
    }
}

