/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colour;

import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.BLTextArea;
import org.biolegato.gdesupport.canvas.selections.LineSelection;

public abstract class ColourMap {
    protected Color foreground = Color.BLACK;
    protected Color background = Color.WHITE;
    protected Color foregroundSelect = Color.WHITE;
    protected Color backgroundSelect = Color.BLUE;
    public static final Color colour1 = new Color(255, 0, 0);
    public static final Color colour2 = new Color(240, 180, 20);
    public static final Color colour3 = new Color(0, 0, 255);
    public static final Color colour4 = new Color(0, 0, 0);
    public static final Color colour5 = new Color(0, 200, 0);
    public static final Color colour6 = new Color(255, 0, 160);
    public static final Color colour7 = new Color(0, 160, 200);
    public static final Color colour8 = new Color(0, 127, 255);
    public static final Color colour9 = new Color(105, 139, 30);
    public static final Color colour10 = new Color(128, 0, 255);
    public static final Color colour11 = new Color(125, 158, 192);
    public static final Color colour12 = new Color(205, 205, 0);
    public static final Color colour13 = new Color(139, 10, 80);
    public static final Color colour14 = new Color(233, 116, 81);
    public static final Color colour15 = new Color(0, 180, 127);
    public static final Color colour16 = new Color(127, 230, 0);
    public static final Color neutralColour = new Color(64, 64, 64);

    public void drawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq, LineSelection intersect) {
        int startSelect = -1;
        int endSelect = -1;
        String string = seq.getField("sequence").toString();
        Sequence first = null;
        Sequence selected = null;
        Sequence tail = null;
        if (intersect != null && !intersect.isEmpty()) {
            startSelect = Math.max(0, intersect.getStart());
            endSelect = Math.min(intersect.getEnd(), string.length() - 1);
        }
        if (startSelect < string.length() && endSelect >= 0) {
            first = (Sequence)seq.clone();
            first.setField("sequence", (Object)string.substring(0, startSelect));
            selected = (Sequence)seq.clone();
            selected.setField("sequence", (Object)string.substring(startSelect, endSelect));
            tail = (Sequence)seq.clone();
            tail.setField("sequence", (Object)string.substring(endSelect));
            this.regularDrawString(ta, gfx, xstart, ystart, first);
            this.selectDrawString(ta, gfx, xstart + Math.round(ta.columnSize() * startSelect), ystart, selected);
            this.regularDrawString(ta, gfx, xstart + Math.round(ta.columnSize() * endSelect), ystart, tail);
        } else {
            this.regularDrawString(ta, gfx, xstart, ystart, seq);
        }
    }

    public abstract void regularDrawString(BLTextArea var1, Graphics var2, int var3, int var4, Sequence var5);

    public void selectDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq) {
        this.drawString(ta, gfx, xstart, ystart, seq.getField("sequence").toString(), this.foregroundSelect, this.backgroundSelect);
    }

    protected void drawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, String string, Color foreground, Color background) {
        int xstartMod = 0;
        char[] drawArray = string.toCharArray();
        gfx.setColor(background);
        gfx.fillRect(xstart, ystart, string.length() * ta.columnSize(), ta.rowSize());
        gfx.setFont(ta.getFont());
        gfx.setColor(foreground);
        for (int column = 0; column < drawArray.length; ++column) {
            xstartMod = (ta.columnSize() - ta.getFontMetrics(ta.getFont()).charWidth(drawArray[column])) / 2;
            gfx.drawChars(drawArray, column, 1, xstart + xstartMod, ystart + ta.rowSize() - 5);
            xstart += ta.columnSize();
        }
    }

    public Color getForeground() {
        return this.background;
    }

    public void setForeground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
    }
}

