/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.selections;

import java.util.LinkedList;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.BLTextArea;
import org.biolegato.gdesupport.canvas.selections.LineSelection;
import org.biolegato.gdesupport.canvas.selections.Selection;

public class TextLines
extends Selection {
    public TextLines() {
    }

    public TextLines(Selection s) {
        super(s);
    }

    public LineSelection intersect(int line, int length) {
        LineSelection intersect = null;
        if (line > this.getMinY() && line < this.getMaxY()) {
            intersect = new LineSelection(0, length);
        } else if (line == this.getY1() && line == this.getY2()) {
            intersect = new LineSelection(this.getMinX(), this.getMaxX());
        } else if (line == this.getY1()) {
            intersect = this.getY1() == this.getMinY() ? new LineSelection(this.getX1(), length) : new LineSelection(0, this.getX1());
        } else if (line == this.getY2()) {
            intersect = this.getY2() == this.getMinY() ? new LineSelection(this.getX2(), length) : new LineSelection(0, this.getX2());
        }
        return intersect;
    }

    public Sequence[] getSelectionSequences(SeqDoc document) {
        int length = 0;
        int startLine = 0;
        int startColumn = 0;
        int endLine = 0;
        int endColumn = 0;
        String currentSequence = null;
        Sequence current = null;
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        if (!this.isEmpty()) {
            if (this.getY1() < this.getY2()) {
                startLine = this.getY1();
                startColumn = this.getX1();
                endLine = this.getY2();
                endColumn = this.getX2();
            } else if (this.getY1() == this.getY2()) {
                startLine = this.getY1();
                startColumn = this.getMinX();
                endLine = this.getY2();
                endColumn = this.getMaxX();
            } else {
                startLine = this.getY2();
                startColumn = this.getX2();
                endLine = this.getY1();
                endColumn = this.getX1();
            }
            startLine = Math.max(0, Math.min(startLine, document.getLineCount() - 1));
            endLine = Math.max(0, Math.min(endLine, document.getLineCount() - 1));
            for (int count = startLine; count <= endLine; ++count) {
                length = document.getLineLength(count);
                current = (Sequence)document.getSequence(count).clone();
                currentSequence = current.getField("sequence").toString();
                if (count == endLine && endColumn < length) {
                    currentSequence = currentSequence.substring(0, endColumn);
                }
                if (count == startLine && startColumn > 0) {
                    currentSequence = currentSequence.substring(startColumn);
                }
                if (!currentSequence.equals(current.getField("sequence").toString())) {
                    current.setField("sequence", (Object)currentSequence);
                }
                result.add(current);
            }
        }
        return result.toArray(new Sequence[0]);
    }

    public boolean delete(BLTextArea textarea) {
        int pos1 = textarea.getSeqDoc().getLineStartOffset(this.getY1()) + this.getX1();
        int pos2 = textarea.getSeqDoc().getLineStartOffset(this.getY2()) + this.getX2();
        boolean result = false;
        if (!this.isEmpty()) {
            result = textarea.delete(Math.min(pos1, pos2), Math.abs(pos1 - pos2));
        }
        return result;
    }
}

