/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.DataFormat;

public class GDEFile
extends DataFormat {
    public String translateTo(Sequence seq) {
        StringBuffer result = new StringBuffer();
        if (seq != null) {
            result.append("{\nname            \"").append(GDEFile.quote(seq.getField("name").toString())).append("\"\nlongname        \"").append(GDEFile.quote(seq.getField("name").toString())).append("\"\nsequence-ID     \"").append(GDEFile.quote(seq.getField("accession").toString())).append("\"\ncreation-date   \"").append(new SimpleDateFormat("MM/dd/yy kk:mm:ss").format(new Date())).append("\"\ndirection       ").append(Sequence.Direction.FROM5TO3.equals(seq.getField("direction")) ? "1" : "-1").append("\nstrandedness    ").append(Sequence.Strandedness.SINGLE.equals(seq.getField("strandedness")) ? "1" : "2").append("\ntype            ").append(GDEFile.blTypetoGDE((Sequence.Type)seq.getField("type"))).append("\n").append(Sequence.Topology.CIRCULAR.equals(seq.getField("topology")) ? "circular        1\n" : "").append("offset          0\ngroupID         0\ncreator         \"").append(GDEFile.quote("")).append("\"\ndescrip         \"").append(GDEFile.quote(seq.getField("description").toString())).append("\"\ncomments        \"").append(GDEFile.quote(seq.getField("comments").toString())).append("\"\nsequence        \"").append(GDEFile.quote(seq.getField("sequence").toString())).append("\"\n}\n");
        }
        return result.toString();
    }

    public Sequence[] translateFrom(BufferedReader data) throws IOException {
        String line = "";
        String fname = "";
        String fvalue = "";
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        Hashtable<String, Object> sequence = new Hashtable<String, Object>();
        while ((line = data.readLine()) != null) {
            if ("".equals(line = line.trim())) continue;
            if ((line.contains("}") || line.contains("{")) && !sequence.isEmpty() && sequence.containsKey("sequence")) {
                result.add(new Sequence(sequence));
                sequence.clear();
                line = line.substring(line.indexOf(123) + 1).trim();
            }
            if (line.contains(" ") && (!line.contains("\t") || line.indexOf(32) < line.indexOf(9))) {
                fname = line.substring(0, line.indexOf(32)).trim();
                fvalue = line.substring(line.indexOf(32) + 1).trim();
            } else if (line.contains("\t")) {
                fname = line.substring(0, line.indexOf(9)).trim();
                fvalue = line.substring(line.indexOf(9) + 1).trim();
            } else {
                fname = "";
                fvalue = "";
            }
            if (fvalue.startsWith("\"")) {
                StringBuffer fvalueBuffer = new StringBuffer();
                fvalue = fvalue.substring(1);
                fvalueBuffer.append(fvalue);
                while (fvalue != null && !fvalue.contains("\"")) {
                    fvalue = data.readLine();
                    fvalueBuffer.append(fvalue);
                }
                fvalue = fvalueBuffer.toString();
                if (fvalue.contains("\"")) {
                    fvalue = fvalue.substring(0, fvalue.indexOf(34));
                }
            }
            if ("".equals(fname) && "".equals(fvalue)) continue;
            if ("type".equals(fname)) {
                if ("RNA".equalsIgnoreCase(fvalue)) {
                    sequence.put("type", Sequence.Type.RNA);
                    continue;
                }
                if ("PROTEIN".equalsIgnoreCase(fvalue)) {
                    sequence.put("type", Sequence.Type.PROTEIN);
                    continue;
                }
                if ("TEXT".equalsIgnoreCase(fvalue)) {
                    sequence.put("type", Sequence.Type.TEXT);
                    continue;
                }
                if ("MASK".equalsIgnoreCase(fvalue)) {
                    sequence.put("type", Sequence.Type.MASK);
                    continue;
                }
                sequence.put("type", Sequence.Type.DNA);
                continue;
            }
            if ("circular".equals(fname)) {
                if ("0".equals(fvalue)) {
                    sequence.put("topology", Sequence.Topology.LINEAR);
                    continue;
                }
                sequence.put("topology", Sequence.Topology.CIRCULAR);
                continue;
            }
            if ("direction".equals(fname)) {
                if ("-1".equals(fvalue)) {
                    sequence.put("direction", Sequence.Direction.FROM3TO5);
                    continue;
                }
                sequence.put("direction", Sequence.Direction.FROM5TO3);
                continue;
            }
            if ("strandedness".equals(fname)) {
                if ("1".equals(fvalue)) {
                    sequence.put("strandedness", Sequence.Strandedness.SINGLE);
                    continue;
                }
                sequence.put("strandedness", Sequence.Strandedness.DOUBLE);
                continue;
            }
            if ("creation-date".equals(fname)) {
                sequence.put("creation-date", fvalue);
                continue;
            }
            if ("creator".equals(fname)) {
                sequence.put("creator", fvalue);
                continue;
            }
            if ("sequence-ID".equals(fname)) {
                sequence.put("accession", fvalue);
                continue;
            }
            if ("name".equals(fname)) {
                sequence.put("name", fvalue);
                continue;
            }
            if ("longname".equals(fname)) {
                sequence.put("longname", fvalue);
                continue;
            }
            if ("descrip".equals(fname)) {
                sequence.put("description", fvalue);
                continue;
            }
            if ("comments".equals(fname)) {
                sequence.put("comments", fvalue);
                continue;
            }
            if ("sequence".equals(fname)) {
                sequence.put("sequence", fvalue);
                continue;
            }
            BLMain.warning((String)("Unsupported attribute (" + fname + " = " + fvalue + " )"), (String)"GDEFile plugin");
        }
        if (!sequence.isEmpty() && sequence.containsKey("sequence")) {
            result.add(new Sequence(sequence));
        }
        return result.toArray(new Sequence[0]);
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".gde");
    }

    public String getName() {
        return "gde";
    }

    public String getDescription() {
        return "GDE file (*.gde)";
    }

    public static String quote(String input) {
        return input.replaceAll("\"", "'").replaceAll("\\{", "\\[").replaceAll("\\}", "\\]");
    }

    private static String blTypetoGDE(Sequence.Type type) {
        String result = "DNA";
        switch (type) {
            case RNA: {
                result = "RNA";
                break;
            }
            case PROTEIN: {
                result = "PROTEIN";
                break;
            }
            case MASK: {
                result = "MASK";
                break;
            }
            case TEXT: {
                result = "TEXT";
            }
        }
        return result;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return check == 123;
    }
}

