/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.plugintypes.DataFormat;

public class GDEFlatfile
extends DataFormat {
    public String translateTo(Sequence seq) {
        int type = 35;
        StringBuffer result = new StringBuffer();
        if (seq != null) {
            type = GDEFlatfile.typeToFlatFile((Sequence.Type)seq.getField("type"));
            if (type != 37 && type != 64 && type != 34) {
                type = 35;
            }
            result.append((char)type).append(seq.getField("name")).append("\n").append(seq.getField("sequence")).append("\n");
        }
        return result.toString();
    }

    public Sequence[] translateFrom(BufferedReader data) throws IOException {
        String line = "";
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        HashMap<String, Object> sequence = new HashMap<String, Object>();
        while ((line = data.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("%") || line.startsWith("@") || line.startsWith("\"")) {
                if (!sequence.isEmpty()) {
                    result.add(new Sequence(sequence));
                    sequence.clear();
                }
                if (line.indexOf(32) > 0) {
                    line = line.substring(0, line.indexOf(32));
                }
                if (line.indexOf(9) > 0) {
                    line = line.substring(0, line.indexOf(9));
                }
                if (line.indexOf(10) > 0) {
                    line = line.substring(0, line.indexOf(10));
                }
                if (line.indexOf(13) > 0) {
                    line = line.substring(0, line.indexOf(13));
                }
                sequence.put("type", GDEFlatfile.flatFileToType(line.trim().charAt(0)));
                sequence.put("name", line.trim().substring(1));
                continue;
            }
            sequence.put("sequence", (sequence.containsKey("sequence") ? sequence.get("sequence") : "") + line.trim());
        }
        if (!sequence.isEmpty()) {
            result.add(new Sequence(sequence));
        }
        return result.toArray(new Sequence[0]);
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".flat");
    }

    public String getName() {
        return "flat";
    }

    public String getDescription() {
        return "GDE Flatfile (*.flat)";
    }

    private static Sequence.Type flatFileToType(char test) {
        Sequence.Type result = Sequence.Type.DNA;
        switch (test) {
            case '%': {
                result = Sequence.Type.PROTEIN;
                break;
            }
            case '@': {
                result = Sequence.Type.MASK;
                break;
            }
            case '\"': {
                result = Sequence.Type.TEXT;
            }
        }
        return result;
    }

    private static char typeToFlatFile(Sequence.Type t) {
        char result = '#';
        switch (t) {
            case PROTEIN: {
                result = '%';
                break;
            }
            case MASK: {
                result = '@';
                break;
            }
            case TEXT: {
                result = '\"';
            }
        }
        return result;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return check == 35 || check == 37 || check == 64 || check == 34;
    }
}

