/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseElementList;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.JEASEStatistics;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class EASE
extends AbstractAlgorithm {
    private JEASEStatistics jstats;
    private Vector sampleVector;
    private Vector populationVector;
    private String[] annotationFileList;
    private String[][] result;
    private String[][] hitList;
    private String[] categoryNames;
    private boolean haveAccessionNumbers = false;
    private boolean reportEaseScore = false;
    private AlgorithmEvent event;
    private Vector headerNames;
    private DecimalFormat format;
    private FloatMatrix expData;
    private boolean stop = false;
    private boolean performClusterAnalysis;
    long start;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.performClusterAnalysis = algorithmParameters.getBoolean("perform-cluster-analysis", true);
        this.expData = algorithmData.getMatrix("expression");
        if (this.performClusterAnalysis) {
            return this.performClusterAnnotationAnalysis(algorithmData);
        }
        return this.performSlideAnnotationSurvey(algorithmData);
    }

    private AlgorithmData performClusterAnnotationAnalysis(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.headerNames = new Vector();
        this.reportEaseScore = algorithmParameters.getBoolean("report-ease-score", false);
        this.intializeHeaderNames();
        this.format = new DecimalFormat("0.###E00");
        this.event = new AlgorithmEvent((Object)this, 3, 0);
        this.event.setDescription("Start EASE Analyis\n");
        this.fireValueChanged(this.event);
        String string = algorithmParameters.getString("converter-file-name");
        int[] nArray = algorithmData.getIntArray("sample-indices");
        String[] stringArray = algorithmData.getStringArray("sample-list");
        String[] stringArray2 = algorithmData.getStringArray("population-list");
        this.annotationFileList = algorithmData.getStringArray("annotation-file-list");
        EaseElementList easeElementList = new EaseElementList(nArray, stringArray);
        EaseElementList easeElementList2 = new EaseElementList(stringArray2);
        if (this.stop) {
            return null;
        }
        try {
            if (string != null) {
                this.event.setDescription("Loading Cluster Annotation List\n");
                this.fireValueChanged(this.event);
                easeElementList.loadValues(string);
                this.event.setDescription("Loading Population Annotation List\n");
                this.fireValueChanged(this.event);
                easeElementList2.loadValues(string);
            } else {
                this.event.setDescription("Preparing Annotation Lists (no conversion file)\n");
                easeElementList.setDefaultValues();
                easeElementList2.setDefaultValues();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AlgorithmException("Annotation Conversion File Not Found\n" + string + "\n" + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new AlgorithmException("Error Reading File: " + string + "\n" + iOException.getMessage());
        }
        this.event.setDescription("Extracting Unique Cluster Annotation List\n");
        this.fireValueChanged(this.event);
        this.sampleVector = easeElementList.getUniqueValueList();
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Extracting Unique Population Annotation List\n");
        this.fireValueChanged(this.event);
        this.populationVector = easeElementList2.getUniqueValueList();
        if (this.stop) {
            return null;
        }
        this.jstats = new JEASEStatistics(this.reportEaseScore);
        for (int i = 0; i < this.annotationFileList.length; ++i) {
            this.jstats.AddAnnotationFileName(this.annotationFileList[i]);
        }
        this.event.setDescription("Loading Annotation Category Files\n");
        this.fireValueChanged(this.event);
        this.jstats.GetCategories(this.populationVector);
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Finding Sample Category Hits\n");
        this.fireValueChanged(this.event);
        this.jstats.GetListHitsByCategory(this.sampleVector);
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Finding Population Category Hits\n");
        this.fireValueChanged(this.event);
        this.jstats.GetPopulationHitsByCategory(this.populationVector);
        this.event.setDescription("Statistical Testing and Result Prep.\n");
        this.fireValueChanged(this.event);
        this.jstats.ConstructResults();
        this.result = this.jstats.getResults();
        if (this.result.length < 1) {
            return algorithmData;
        }
        this.hitList = this.jstats.getListHitMatrix();
        this.categoryNames = this.jstats.getCategoryNames();
        this.event.setDescription("Sorting Result on p-value\n");
        this.fireValueChanged(this.event);
        this.sortResults();
        if (this.stop) {
            return null;
        }
        if (algorithmData.getParams().getBoolean("p-value-corrections", false)) {
            this.event.setDescription("Applying p-value Multiplicity Corrections\n");
            this.fireValueChanged(this.event);
            this.pValueCorrections(algorithmData);
        }
        if (algorithmData.getParams().getBoolean("run-permutation-analysis", false)) {
            this.event.setDescription("Resampling Analysis\n");
            this.fireValueChanged(this.event);
            this.permutationAnalysis(algorithmData.getParams().getInt("permutation-count", 1));
        }
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Appending Accessions\n");
        this.fireValueChanged(this.event);
        this.result = this.appendAccessions(this.result, this.annotationFileList);
        algorithmData.addParam("have-accession-numbers", String.valueOf(this.haveAccessionNumbers));
        String string2 = algorithmParameters.getString("trim-option");
        if (!string2.equals("NO_TRIM")) {
            this.event.setDescription("Trim Result\n");
            this.fireValueChanged(this.event);
            float f = algorithmParameters.getFloat("trim-value");
            this.trimResult(string2, f);
        }
        this.event.setDescription("Indexing Result\n");
        this.fireValueChanged(this.event);
        this.indexResult();
        algorithmData.addObjectMatrix("result-matrix", (Object[][])this.result);
        algorithmData.addObjectMatrix("hit-list-matrix", (Object[][])this.hitList);
        this.event.setDescription("Extracting Cluster Indices and Stats\n");
        this.fireValueChanged(this.event);
        int[][] nArray2 = this.getClusters(easeElementList, this.hitList);
        algorithmData.addStringArray("category-names", this.categoryNames);
        algorithmData.addIntMatrix("cluster-matrix", nArray2);
        algorithmData.addStringArray("header-names", this.getHeaderNames());
        FloatMatrix floatMatrix = this.getMeans(this.expData, nArray2);
        algorithmData.addMatrix("means", floatMatrix);
        algorithmData.addMatrix("variances", this.getVariances(this.expData, floatMatrix, nArray2));
        if (this.stop) {
            return null;
        }
        return algorithmData;
    }

    private AlgorithmData performSlideAnnotationSurvey(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.headerNames = new Vector();
        this.intializeHeaderNames();
        this.format = new DecimalFormat("0.###E00");
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 3, 0);
        algorithmEvent.setDescription("Start Survey\n");
        this.fireValueChanged(algorithmEvent);
        String string = algorithmParameters.getString("converter-file-name");
        String[] stringArray = algorithmData.getStringArray("population-list");
        String[] stringArray2 = algorithmData.getStringArray("annotation-file-list");
        EaseElementList easeElementList = new EaseElementList(stringArray);
        try {
            if (string != null) {
                algorithmEvent.setDescription("Loading Population Annotation List\n");
                this.fireValueChanged(algorithmEvent);
                easeElementList.loadValues(string);
            } else {
                algorithmEvent.setDescription("Preparing Annotation Lists (no conversion file)\n");
                easeElementList.setDefaultValues();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AlgorithmException("Annotation Conversion File Not Found\n" + string + "\n" + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new AlgorithmException("Error Reading File: " + string + "\n" + iOException.getMessage());
        }
        algorithmEvent.setDescription("Extracting Unique Population Annotation List\n");
        this.fireValueChanged(algorithmEvent);
        this.populationVector = easeElementList.getUniqueValueList();
        this.jstats = new JEASEStatistics();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.jstats.AddAnnotationFileName(stringArray2[i]);
        }
        algorithmEvent.setDescription("Reading Annotation Category Files into Memory\n");
        this.fireValueChanged(algorithmEvent);
        this.jstats.GetCategories();
        algorithmEvent.setDescription("Finding Population Category Hits\n");
        this.fireValueChanged(algorithmEvent);
        this.jstats.GetPopulationHitsByCategoryForSurvey(this.populationVector);
        algorithmEvent.setDescription("Result Prep.\n");
        this.fireValueChanged(algorithmEvent);
        this.jstats.ConstructSurveyResults();
        this.result = this.jstats.getSurveyResults();
        if (this.result.length < 1) {
            return algorithmData;
        }
        this.hitList = this.jstats.getListHitMatrix();
        this.categoryNames = this.jstats.getCategoryNames();
        algorithmEvent.setDescription("Sorting Result on hit count\n");
        this.fireValueChanged(algorithmEvent);
        this.sortSurveyResults();
        algorithmEvent.setDescription("Appending Accessions\n");
        this.fireValueChanged(algorithmEvent);
        this.result = this.appendAccessions(this.result, stringArray2);
        algorithmData.addParam("have-accession-numbers", String.valueOf(this.haveAccessionNumbers));
        algorithmData.addStringArray("header-names", this.getHeaderNames());
        String string2 = algorithmParameters.getString("trim-option");
        if (!string2.equals("NO_TRIM")) {
            algorithmEvent.setDescription("Trim Result\n");
            this.fireValueChanged(algorithmEvent);
            float f = algorithmParameters.getFloat("trim-value");
            this.trimResult(string2, f);
        }
        algorithmEvent.setDescription("Indexing Result\n");
        this.fireValueChanged(algorithmEvent);
        this.indexResult();
        algorithmData.addObjectMatrix("result-matrix", (Object[][])this.result);
        algorithmData.addObjectMatrix("hit-list-matrix", (Object[][])this.hitList);
        algorithmEvent.setDescription("Extracting Cluster Indices and Stats\n");
        this.fireValueChanged(algorithmEvent);
        int[][] nArray = this.getClusters(easeElementList, this.hitList);
        algorithmData.addStringArray("category-names", this.categoryNames);
        algorithmData.addIntMatrix("cluster-matrix", nArray);
        FloatMatrix floatMatrix = this.getMeans(this.expData, nArray);
        algorithmData.addMatrix("means", floatMatrix);
        algorithmData.addMatrix("variances", this.getVariances(this.expData, floatMatrix, nArray));
        return algorithmData;
    }

    private void intializeHeaderNames() {
        if (this.performClusterAnalysis) {
            this.headerNames.add("Index");
            this.headerNames.add("File");
            this.headerNames.add("Term");
            this.headerNames.add("List Hits");
            this.headerNames.add("List Size");
            this.headerNames.add("Pop. Hits");
            this.headerNames.add("Pop. Size");
            if (this.reportEaseScore) {
                this.headerNames.add("EASE Score");
            } else {
                this.headerNames.add("Fisher's Exact");
            }
        } else {
            this.headerNames.add("Index");
            this.headerNames.add("File");
            this.headerNames.add("Term");
            this.headerNames.add("Pop. Hits");
            this.headerNames.add("Pop. Size");
        }
    }

    private int[][] getClusters(EaseElementList easeElementList, String[][] stringArray) {
        int[][] nArrayArray = new int[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            nArrayArray[i] = easeElementList.getIndices(stringArray[i]);
        }
        return nArrayArray;
    }

    private void sortResults() {
        int n;
        double[] dArray = new double[this.result.length];
        int n2 = this.reportEaseScore ? this.headerNames.indexOf("EASE Score") : this.headerNames.indexOf("Fisher's Exact");
        --n2;
        for (int i = 0; i < this.result.length; ++i) {
            dArray[i] = Double.parseDouble(this.result[i][n2]);
        }
        QSort qSort = new QSort(dArray);
        dArray = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        String[] stringArray = new String[this.categoryNames.length];
        String[][] stringArrayArray = new String[this.hitList.length][];
        String[][] stringArrayArray2 = new String[this.result.length][];
        for (n = 0; n < nArray.length; ++n) {
            stringArray[n] = this.categoryNames[nArray[n]];
            stringArrayArray[n] = this.hitList[nArray[n]];
            stringArrayArray2[n] = this.result[nArray[n]];
        }
        for (n = 0; n < stringArrayArray2.length; ++n) {
            stringArrayArray2[n][n2] = this.format.format(Double.parseDouble(stringArrayArray2[n][n2]));
        }
        this.categoryNames = stringArray;
        this.hitList = stringArrayArray;
        this.result = stringArrayArray2;
    }

    private void sortSurveyResults() {
        double[] dArray = new double[this.result.length];
        int n = this.headerNames.indexOf("Pop. Hits");
        --n;
        for (int i = 0; i < this.result.length; ++i) {
            dArray[i] = Double.parseDouble(this.result[i][n]);
        }
        QSort qSort = new QSort(dArray);
        dArray = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        String[] stringArray = new String[this.categoryNames.length];
        String[][] stringArrayArray = new String[this.hitList.length][];
        String[][] stringArrayArray2 = new String[this.result.length][];
        int n2 = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            stringArray[n2] = this.categoryNames[nArray[i]];
            stringArrayArray[n2] = this.hitList[nArray[i]];
            stringArrayArray2[n2] = this.result[nArray[i]];
            ++n2;
        }
        this.categoryNames = stringArray;
        this.hitList = stringArrayArray;
        this.result = stringArrayArray2;
    }

    private String[][] appendAccessions(String[][] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length < 1) {
            return stringArray;
        }
        String[][] stringArray3 = null;
        File file = null;
        this.haveAccessionNumbers = false;
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                file = this.getAccessionFile(stringArray2[i]);
                if (!file.isFile()) continue;
                if (!this.haveAccessionNumbers) {
                    stringArray3 = new String[stringArray.length][stringArray[0].length + 1];
                    this.initializeNewResult(stringArray3, stringArray);
                    this.headerNames.insertElementAt("Acc.", 2);
                }
                this.insertAccessions(file, stringArray3);
                this.haveAccessionNumbers = true;
                stringArray = stringArray3;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(new JFrame(), "Error in collecting accessions following analysis from file: " + file.getName() + "\n Results will not have accessions.  Please check file location" + " and format", "File Error", 2);
            return this.result;
        }
        if (this.haveAccessionNumbers) {
            return stringArray3;
        }
        return stringArray;
    }

    private void initializeNewResult(String[][] stringArray, String[][] stringArray2) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray2[0].length; ++i) {
                if (i < 1) {
                    stringArray[n][i] = stringArray2[n][i];
                    continue;
                }
                stringArray[n][i + 1] = stringArray2[n][i];
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n][1] = " ";
        }
    }

    private void indexResult() {
        if (this.result == null || this.result.length < 1) {
            return;
        }
        String[][] stringArray = new String[this.result.length][this.result[0].length + 1];
        for (int i = 0; i < this.result.length; ++i) {
            stringArray[i][0] = String.valueOf(i + 1);
            for (int j = 1; j < stringArray[0].length; ++j) {
                stringArray[i][j] = this.result[i][j - 1];
            }
        }
        this.result = stringArray;
    }

    private void insertAccessions(File file, String[][] stringArray) throws IOException {
        String string;
        if (file == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            hashtable.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = (String)hashtable.get(stringArray[i][2]);
            if (string2 == null) continue;
            stringArray[i][1] = string2;
        }
    }

    private File getAccessionFile(String string) {
        String string2 = System.getProperty("file.separator");
        File file = new File(string);
        String string3 = file.getName();
        file = file.getParentFile();
        file = new File(file.getPath() + string2 + "URL data" + string2 + "Tags" + string2 + string3);
        return file;
    }

    private String[] getHeaderNames() {
        String[] stringArray = new String[this.headerNames.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.headerNames.elementAt(i);
        }
        return stringArray;
    }

    private FloatMatrix getMeans(FloatMatrix floatMatrix, int[][] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = this.getMeans(floatMatrix, nArray[i]);
        }
        return floatMatrix2;
    }

    private float[] getMeans(FloatMatrix floatMatrix, int[] nArray) {
        int n = floatMatrix.getColumnDimension();
        float[] fArray = new float[n];
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 = 0.0f;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += f3;
                f2 += 1.0f;
            }
            fArray[i] = f2 > 0.0f ? f / f2 : Float.NaN;
        }
        return fArray;
    }

    private FloatMatrix getVariances(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[][] nArray) {
        int n = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, n);
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = this.getVariances(floatMatrix, floatMatrix2, nArray[i], i);
        }
        return floatMatrix3;
    }

    private float[] getVariances(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[] nArray, int n) {
        int n2 = floatMatrix.getColumnDimension();
        float[] fArray = new float[n2];
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            float f2 = floatMatrix2.get(n, i);
            n3 = 0;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += (float)Math.pow(f3 - f2, 2.0);
                ++n3;
            }
            fArray[i] = n3 > 1 ? (float)Math.sqrt(f / (float)(n3 - 1)) : 0.0f;
        }
        return fArray;
    }

    private void appendResult(Vector vector) {
        int n;
        int n2;
        int n3 = vector.size();
        int n4 = this.result[0].length;
        int n5 = n4 + n3;
        String[][] stringArray = new String[this.result.length][n5];
        for (n2 = 0; n2 < this.result.length; ++n2) {
            for (n = 0; n < this.result[0].length; ++n) {
                stringArray[n2][n] = this.result[n2][n];
            }
        }
        for (n = 0; n < n3; ++n) {
            double[] dArray = (double[])vector.elementAt(n);
            n2 = n + n4;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i][n2] = this.format.format(dArray[i]);
            }
        }
        this.result = stringArray;
    }

    private void pValueCorrections(AlgorithmData algorithmData) {
        int n = this.result.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = this.reportEaseScore ? this.headerNames.indexOf("EASE Score") : this.headerNames.indexOf("Fisher's Exact");
        --n2;
        Vector<double[]> vector = new Vector<double[]>();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble(this.result[i][n2]);
        }
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        if (algorithmParameters.getBoolean("bonferroni-correction", false)) {
            vector.add(this.bonferroniCorrection(dArray));
            this.headerNames.add("Bonf. Corr.");
        }
        if (algorithmParameters.getBoolean("bonferroni-step-down-correction", false)) {
            vector.add(this.stepDownBonferroniCorrection(dArray));
            this.headerNames.add("Bonf. S.D. Corr.");
        }
        if (algorithmParameters.getBoolean("sidak-correction", false)) {
            vector.add(this.sidakCorrection(dArray));
            this.headerNames.add("Sidak Corr.");
        }
        this.appendResult(vector);
    }

    private double[] bonferroniCorrection(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] * (double)n;
            if (!(dArray2[i] > 1.0)) continue;
            dArray2[i] = 1.0;
        }
        return dArray2;
    }

    private double[] stepDownBonferroniCorrection(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        dArray2[0] = dArray[0] * (double)n;
        for (int i = 1; i < n; ++i) {
            if (dArray[i] > dArray[i - 1]) {
                n2 = i;
            }
            dArray2[i] = dArray[i] * (double)(n - n2);
            if (!(dArray2[i] > 1.0)) continue;
            dArray2[i] = 1.0;
        }
        return dArray2;
    }

    private double[] sidakCorrection(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 1.0 - Math.pow(1.0 - dArray[i], n);
            if (!(dArray2[i] > 1.0)) continue;
            dArray2[i] = 1.0;
        }
        return dArray2;
    }

    private void permutationAnalysis(int n) {
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 2, n);
        algorithmEvent.setDescription("SET_UNITS");
        algorithmEvent.setIntValue(n);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setDescription("SET_VALUE");
        long l = System.currentTimeMillis();
        int n2 = this.result.length;
        int n3 = this.sampleVector.size();
        int n4 = this.populationVector.size();
        int[] nArray = new int[this.result.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[0] = 0;
        }
        int[] nArray2 = new int[n3];
        Random random = new Random(System.currentTimeMillis());
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
            this.sampleVector = this.getRandomSampleVector(n3, random);
            this.jstats.resetForNewList();
            this.jstats.GetListHitsByCategory(this.sampleVector);
            this.jstats.ConstructResults();
            String[][] stringArray = this.jstats.getResults();
            this.accumulateBinHits(stringArray, nArray);
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = (double)nArray[i] / (double)n;
            if (dArray[i] != 0.0) continue;
            dArray[i] = 1.0 / (double)n;
        }
        algorithmEvent.setDescription("DISPOSE");
        this.fireValueChanged(algorithmEvent);
        Vector<double[]> vector = new Vector<double[]>();
        vector.add(dArray);
        this.appendResult(vector);
        this.headerNames.add("Prob. Anal.");
    }

    private int getMaxPopHits(String[][] stringArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            n = Math.max(n, Integer.parseInt(stringArray[i][4]));
        }
        return n;
    }

    private Vector getRandomSampleVector(int n, Random random) {
        Vector vector = new Vector(n);
        Vector vector2 = (Vector)this.populationVector.clone();
        int n2 = this.populationVector.size();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = (int)((float)vector2.size() * random.nextFloat());
            vector.add(vector2.remove(n3));
        }
        return vector;
    }

    private void accumulateHits(String[][] stringArray, String[] stringArray2, int[] nArray) {
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i][1].equals(stringArray2[j])) continue;
                if (Integer.parseInt(stringArray[i][2]) <= Integer.parseInt(this.result[j][2])) continue block0;
                int n = j;
                nArray[n] = nArray[n] + 1;
                continue block0;
            }
        }
    }

    private void accumulateBinHits(String[][] stringArray, int[] nArray) {
        for (int i = 0; i < this.annotationFileList.length; ++i) {
            int n;
            double d = Double.POSITIVE_INFINITY;
            for (n = 0; n < stringArray.length; ++n) {
                if (this.annotationFileList[i].indexOf(stringArray[n][0]) < 0) continue;
                d = Math.min(d, Double.parseDouble(stringArray[n][6]));
            }
            for (n = 0; n < this.result.length; ++n) {
                if (this.annotationFileList[i].indexOf(this.result[n][0]) < 0 || !(d < Double.parseDouble(this.result[n][6]))) continue;
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
        }
    }

    private double[] orderBootStrappedProb(double[] dArray) {
        double[] dArray2 = new double[this.result.length];
        for (int i = 0; i < this.result.length; ++i) {
            dArray2[i] = dArray[Integer.parseInt(this.result[i][2])];
        }
        return dArray2;
    }

    private void trimResult(String string, float f) {
        int n;
        boolean[] blArray = new boolean[this.result.length];
        int n2 = this.performClusterAnalysis ? this.headerNames.indexOf("List Hits") : this.headerNames.indexOf("Pop. Hits");
        --n2;
        int n3 = this.result.length;
        if (string.equals("N_TRIM")) {
            for (n = 0; n < this.result.length; ++n) {
                if (!((float)Integer.parseInt(this.result[n][n2]) < f)) continue;
                blArray[n] = true;
                --n3;
            }
        } else {
            f /= 100.0f;
            for (n = 0; n < this.result.length; ++n) {
                if (!(Double.parseDouble(this.result[n][n2]) / Double.parseDouble(this.result[n][n2 + 1]) < (double)f)) continue;
                blArray[n] = true;
                --n3;
            }
        }
        String[][] stringArrayArray = new String[n3][];
        String[][] stringArrayArray2 = new String[n3][];
        String[] stringArray = new String[n3];
        int n4 = 0;
        for (int i = 0; i < this.result.length; ++i) {
            if (blArray[i]) continue;
            stringArrayArray[n4] = this.result[i];
            stringArrayArray2[n4] = this.hitList[i];
            stringArray[n4] = this.categoryNames[i];
            ++n4;
        }
        this.result = stringArrayArray;
        this.hitList = stringArrayArray2;
        this.categoryNames = stringArray;
    }
}

