/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.services;

import ca.ucalgary.seahawk.services.IterativeMatchResult;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.services.RegexParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.encoding.Base64;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.PrimitiveTypes;
import org.biomoby.shared.data.MobyDataBytes;
import org.biomoby.shared.data.MobyDataComposite;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyComplexBuilder {
    public static final String ANON_ARTICLE = "_seahawk_data";
    public static final String INHERITED_MEMBERS_SENTINEL = "_seahawk_member_inheritance";
    private static XPathFactory xPathFactory = XPathFactory.newInstance();
    private static DocumentBuilder docBuilder;
    private Map<String, String> namespaceRules;
    private Map<String, String[]> memberRules;
    private String articleNameRule;
    private MobyDataType mobyDataType;
    private MobyNamespace[] mobyNS;
    private MobyRelationship[] children;
    private MobyClient client;

    public MobyComplexBuilder(String dataType, Map<String, String[]> members, Map<String, String> nameSpaces, MobyClient cl) throws Exception {
        this(dataType, members, nameSpaces, cl, ANON_ARTICLE);
    }

    public MobyComplexBuilder(String dataType, Map<String, String[]> members, Map<String, String> nameSpaces, MobyClient cl, String articleName) throws Exception {
        this.mobyDataType = MobyDataType.getDataType(dataType, cl.getRegistry());
        if (this.mobyDataType == null) {
            this.mobyDataType = new MobyDataType(dataType);
        }
        this.articleNameRule = articleName;
        this.memberRules = members;
        this.client = cl;
        if (this.mobyDataType != null && this.mobyDataType.getName() != null && !this.mobyDataType.getName().equals("Object")) {
            int i;
            this.children = this.mobyDataType.getAllChildren();
            String[] ruleNames = this.memberRules.keySet().toArray(new String[this.memberRules.size()]);
            block0: for (i = 0; this.children != null && i < this.children.length; ++i) {
                String childName = this.children[i].getName();
                if (!this.memberRules.containsKey(childName)) {
                    if (!this.memberRules.containsKey(INHERITED_MEMBERS_SENTINEL)) {
                        throw new Exception("Ruleset for object " + this.mobyDataType.getName() + " does not include a rule for required member '" + childName + "'");
                    }
                    String inheritedRuleName = this.memberRules.get(INHERITED_MEMBERS_SENTINEL)[0];
                    MobyComplexBuilder inheritedBuilder = this.client.getBuilder(inheritedRuleName);
                    if (inheritedBuilder.getDataType().getChild(childName) == null) {
                        throw new Exception("Ruleset for object " + this.mobyDataType.getName() + " does not include a rule for required member '" + childName + "', nor does the inherited rule '" + inheritedRuleName + "'");
                    }
                }
                for (int j = 0; j < ruleNames.length; ++j) {
                    if (ruleNames[j] != childName) continue;
                    ruleNames[j] = null;
                    continue block0;
                }
            }
            if (this.children != null && this.memberRules.size() != this.children.length) {
                System.err.println("Ignoring member rules for object type " + this.mobyDataType.getName() + " (not in the MOBY ontology):");
                for (i = 0; i < ruleNames.length; ++i) {
                    if (ruleNames[i] == null || ruleNames[i].equals(INHERITED_MEMBERS_SENTINEL)) continue;
                    System.err.println("Extra member: " + ruleNames[i]);
                }
            }
            for (Map.Entry<String, String[]> member : members.entrySet()) {
                String memberDataTypeSetting;
                if (member.getKey().equals(INHERITED_MEMBERS_SENTINEL) || (memberDataTypeSetting = member.getValue()[1]) == null || memberDataTypeSetting.length() <= 0) continue;
                MobyRelationship child = this.mobyDataType.getChild(member.getKey());
                String defaultDataTypeName = child.getDataTypeName();
                MobyDataType castType = MobyDataType.getDataType(memberDataTypeSetting, this.client.getRegistry());
                MobyDataType origType = MobyDataType.getDataType(defaultDataTypeName, this.client.getRegistry());
                if (castType == null) {
                    System.err.println("Could not find the data type " + memberDataTypeSetting + " in the ontology, ignoring the data type cast" + " that says it should override " + defaultDataTypeName);
                    member.getValue()[1] = null;
                    continue;
                }
                if (origType == null) {
                    System.err.println("Could not find the data type " + defaultDataTypeName + " in the ontology, ignoring the data type cast" + " that overrides it to data type (" + memberDataTypeSetting + "), can't tell if the cast is legal or not)");
                    member.getValue()[1] = null;
                    continue;
                }
                if (castType.inheritsFrom(origType)) continue;
                System.err.println("The data type " + memberDataTypeSetting + " does not inherit from the member's type in the ontology (" + defaultDataTypeName + "), ignoring the data type cast");
                member.getValue()[1] = null;
            }
        }
        this.namespaceRules = nameSpaces;
        if (this.namespaceRules != null && this.namespaceRules.size() > 0) {
            this.mobyNS = new MobyNamespace[this.namespaceRules.size()];
            Iterator<String> iter = this.namespaceRules.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                String ns = iter.next();
                this.mobyNS[i] = MobyNamespace.getNamespace(ns, this.client.getRegistry());
                if (this.mobyNS[i] == null) {
                    System.err.println("Namespace '" + ns + "' is not registered in MOBY Central");
                    this.mobyNS[i] = new MobyNamespace(ns);
                }
                ++i;
            }
        }
    }

    public MobyDataObject apply(Matcher matcher) throws MobyException {
        return this.apply(matcher, null);
    }

    public MobyDataObject apply(Matcher matcher, byte[] data) throws MobyException {
        String[] resultSpec;
        MobyDataObject mobyObj = null;
        if (this.mobyDataType.getName().equals("Object")) {
            mobyObj = new MobyDataObject("", this.client.getRegistry());
        } else if (this.mobyDataType.inheritsFrom(MobyDataType.getDataType("text-base64", this.client.getRegistry()))) {
            mobyObj = new MobyDataBytes("", (CharSequence)null);
            mobyObj.setDataType(this.mobyDataType);
        } else {
            mobyObj = new MobyDataComposite(this.mobyDataType);
        }
        if (this.articleNameRule != null && this.articleNameRule.length() > 0 && !this.articleNameRule.equals(ANON_ARTICLE)) {
            mobyObj.setName(this.evaluateRule(matcher, this.articleNameRule, "flanking", null, data));
        }
        if (this.namespaceRules != null && this.namespaceRules.size() > 0) {
            boolean haveID = false;
            for (int i = 0; this.mobyNS != null && i < this.mobyNS.length; ++i) {
                resultSpec = this.namespaceRules.get(this.mobyNS[i].getName());
                String result = this.evaluateRule(matcher, (String)resultSpec, "flanking", null, data);
                if (this.mobyNS.length != 1 && result.length() <= 0) continue;
                if (!haveID) {
                    mobyObj.setPrimaryNamespace(this.mobyNS[i]);
                    mobyObj.setId(result);
                    haveID = true;
                    continue;
                }
                mobyObj.addCrossReference(new MobyDataObject(this.mobyNS[i].getName(), result, this.client.getRegistry()));
            }
        }
        if (!(mobyObj instanceof MobyDataComposite) || this.children == null) {
            return mobyObj;
        }
        if (this.memberRules.containsKey(INHERITED_MEMBERS_SENTINEL)) {
            String[] ruleSpec = this.memberRules.get(INHERITED_MEMBERS_SENTINEL);
            MobyComplexBuilder inheritedBuilder = this.client.getBuilder(ruleSpec[0]);
            String result = this.evaluateRule(matcher, ruleSpec[1], null, null, data);
            Matcher submatcher = this.client.getPattern(ruleSpec[0]).matcher(result);
            if (!submatcher.find()) {
                throw new MobyException("Pattern of inherited rule '" + ruleSpec[0] + "' does not match data given: " + result);
            }
            MobyDataObject inheritedResult = inheritedBuilder.apply(submatcher, result.getBytes());
            if (inheritedResult instanceof MobyDataComposite) {
                ((MobyDataComposite)mobyObj).putAll((MobyDataComposite)inheritedResult);
            }
        }
        for (int i = 0; i < this.children.length; ++i) {
            String memberName = this.children[i].getName();
            resultSpec = this.memberRules.get(memberName);
            if (resultSpec == null) {
                if (((MobyDataComposite)mobyObj).containsKey(memberName)) continue;
                throw new MobyException("Member " + memberName + " does not have a rule, nor" + " was not populated by any inherited rule");
            }
            String dataTypeName = this.children[i].getDataTypeName();
            if (resultSpec[1] != null && resultSpec[1].length() > 0) {
                dataTypeName = resultSpec[1];
            }
            String[] results = new String[1];
            if (this.children[i].getRelationshipType() == 3) {
                try {
                    results = this.evaluateIterativeRule(matcher, resultSpec[0], resultSpec[2], resultSpec[3], data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MobyException("Error while evaluating HAS (iterative evaluation) rule: " + e);
                }
            } else {
                results[0] = this.evaluateRule(matcher, resultSpec[0], resultSpec[2], resultSpec[3], data);
            }
            for (String result : results) {
                if (PrimitiveTypes.isPrimitive(dataTypeName) || MobyDataType.getDataType(dataTypeName, this.client.getRegistry()).inheritsFrom(MobyDataType.getDataType("text-base64", this.client.getRegistry()))) {
                    ((MobyDataComposite)mobyObj).put(memberName, MobyDataObject.createInstanceFromString(dataTypeName, result, this.client.getRegistry()));
                    continue;
                }
                String memberRuleName = resultSpec[4];
                if (memberRuleName == null || memberRuleName.length() == 0) {
                    throw new MobyException("Composite member " + memberName + " does not have an associated rule to produce it");
                }
                MobyComplexBuilder memberBuilder = this.client.getBuilder(memberRuleName);
                if (memberBuilder == null) {
                    throw new MobyException("The object builder for the rule " + memberRuleName + " could not be found");
                }
                Pattern memberPattern = this.client.getPattern(memberRuleName);
                Matcher memberMatcher = memberPattern.matcher(result);
                if (memberMatcher.find()) {
                    ((MobyDataComposite)mobyObj).put(memberName, memberBuilder.apply(memberMatcher));
                    continue;
                }
                System.err.println("Could not match pattern \"" + memberPattern.pattern() + "\" to string \"" + result + "\", abandoning " + dataTypeName + " object creation");
            }
        }
        return mobyObj;
    }

    public String[] evaluateIterativeRule(Matcher matcher, String result, String whitespaceMode, String encodingMode, byte[] data) throws MobyException, Exception {
        Vector<String> capturedValues = new Vector<String>();
        Vector<Integer> captureGroups = new Vector<Integer>();
        for (int captureGroup = 1; captureGroup <= matcher.groupCount(); ++captureGroup) {
            if (result.indexOf("$" + captureGroup) == -1) continue;
            captureGroups.add(captureGroup);
        }
        if (captureGroups.isEmpty()) {
            return new String[]{this.evaluateRule(matcher, result, whitespaceMode, encodingMode, data)};
        }
        HashMap<Integer, String> captureGroupRegexes = new HashMap<Integer, String>();
        for (Integer captureGroup : captureGroups) {
            captureGroupRegexes.put(captureGroup, RegexParser.getCaptureGroupRegex(matcher.pattern(), captureGroup));
        }
        HashMap<Integer, String[]> captureGroupSubvalues = new HashMap<Integer, String[]>();
        for (Map.Entry entry : captureGroupRegexes.entrySet()) {
            String wholeMatch = matcher.group((Integer)entry.getKey() - 1);
            String regex = (String)entry.getValue();
            if (regex.length() == 0) {
                throw new Exception("Encountered empty regex in capture group " + entry.getKey());
            }
            Pattern captureGroupPattern = Pattern.compile("\\G" + regex, 36);
            Vector<String> subValues = new Vector<String>();
            Matcher subMatcher = captureGroupPattern.matcher(wholeMatch);
            int lastSubMatcherEnd = -1;
            while (subMatcher.find()) {
                subValues.add(subMatcher.group());
                lastSubMatcherEnd = subMatcher.end();
            }
            if (lastSubMatcherEnd != -1 && lastSubMatcherEnd != wholeMatch.length()) {
                throw new Exception("The submatcher for capture group " + entry.getKey() + " did not match to the last char of \"" + wholeMatch + "\", should have ended match at index " + (wholeMatch.length() - 1) + ", but instead matched until " + (lastSubMatcherEnd - 1));
            }
            captureGroupSubvalues.put((Integer)entry.getKey(), subValues.toArray(new String[subValues.size()]));
        }
        IterativeMatchResult iterMatch = new IterativeMatchResult((MatchResult)matcher, captureGroupSubvalues);
        for (int i = 0; i < iterMatch.getNumIterations(); ++i) {
            iterMatch.setIteration(i);
            capturedValues.add(this.evaluateRule((MatchResult)iterMatch, result, whitespaceMode, encodingMode, data));
        }
        return capturedValues.toArray(new String[capturedValues.size()]);
    }

    private String evaluateRule(MatchResult match, String result, String whitespaceMode, String encodingMode, byte[] data) throws MobyException {
        byte[] resultBytes = result.getBytes();
        boolean nonBasic = result.length() != 2 || result.indexOf("$") != 0;
        boolean isBinary = encodingMode != null && encodingMode.equals("Base64");
        MobyPrefixResolver.MobyNodeList nodeList = new MobyPrefixResolver.MobyNodeList();
        Document doc = null;
        if (nonBasic) {
            doc = docBuilder.newDocument();
        }
        for (int j = 0; j <= match.groupCount(); ++j) {
            if (data != null && isBinary) {
                int srcPos = 0;
                int varIndex = result.indexOf("$" + j, srcPos);
                while (varIndex != -1) {
                    int varValueLength = match.end(j) - match.start(j);
                    int varLen = ("$" + j).getBytes().length;
                    byte[] newResultBytes = new byte[resultBytes.length + varValueLength - varLen];
                    if (varIndex > 0) {
                        System.arraycopy(resultBytes, 0, newResultBytes, 0, varIndex);
                    }
                    System.arraycopy(data, match.start(j), newResultBytes, varIndex, varValueLength);
                    int remaining = result.length() - varIndex - varLen;
                    if (remaining > 0) {
                        System.arraycopy(resultBytes, varIndex + varLen, newResultBytes, varIndex + varValueLength, result.length() - varIndex - varLen);
                    }
                    resultBytes = newResultBytes;
                    varIndex = result.indexOf("$" + j, srcPos += varIndex + varValueLength + 1);
                }
                continue;
            }
            if (result.indexOf("$" + j) == -1) continue;
            String varValue = match.group(j);
            if (whitespaceMode != null) {
                if (whitespaceMode.equals("normalize")) {
                    varValue = varValue.replaceAll("\\s+", " ");
                } else if (whitespaceMode.equals("strip")) {
                    varValue = varValue.replaceAll("\\s+", "");
                } else if (whitespaceMode.equals("flanking")) {
                    varValue = varValue.trim();
                }
            }
            result = result.replaceAll("\\$" + j + "(?=\\D|\\z)", varValue);
            if (!nonBasic) continue;
            nodeList.add(doc.createTextNode(result));
        }
        if (isBinary) {
            result = Base64.encode(data == null ? result.getBytes() : resultBytes);
        }
        if (nonBasic && data == null) {
            XPath xpath = xPathFactory.newXPath();
            try {
                result = xpath.evaluate(result, nodeList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MobyException("Could not evaluate result of XPath expression ('" + result + "'): " + e);
            }
        }
        return result;
    }

    public MobyDataObject applyXPath(Object result, NamespaceContext nsContext) throws MobyException, XPathExpressionException {
        String value;
        String expr;
        XPath xpath = xPathFactory.newXPath();
        xpath.setNamespaceContext(nsContext);
        MobyDataObject mobyObj = null;
        mobyObj = this.mobyDataType.getName().equals("Object") ? new MobyDataObject("", this.client.getRegistry()) : new MobyDataComposite(this.mobyDataType);
        if (this.namespaceRules != null && this.namespaceRules.size() > 0) {
            boolean haveID = false;
            for (int i = 0; this.mobyNS != null && i < this.mobyNS.length; ++i) {
                expr = this.namespaceRules.get(this.mobyNS[i].getName());
                value = xpath.evaluate(expr, result);
                if (value == null || value.length() <= 0) continue;
                if (!haveID) {
                    mobyObj.setPrimaryNamespace(this.mobyNS[i]);
                    mobyObj.setId(value);
                    haveID = true;
                    continue;
                }
                mobyObj.addCrossReference(new MobyDataObject(this.mobyNS[i].getName(), value, this.client.getRegistry()));
            }
        }
        if (mobyObj instanceof MobyDataComposite && this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                String memberName = this.children[i].getName();
                expr = this.memberRules.get(memberName)[0];
                value = xpath.evaluate(expr, result);
                ((MobyDataComposite)mobyObj).put(memberName, MobyDataObject.createInstanceFromString(this.children[i].getDataTypeName(), value, this.client.getRegistry()));
            }
        }
        return mobyObj;
    }

    public MobyDataType getDataType() {
        return this.mobyDataType;
    }

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            docBuilder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

