/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import ca.ucalgary.seahawk.util.CombinedIcon;
import ca.ucalgary.seahawk.util.NullIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class CloseTabIcon
extends CombinedIcon {
    public static final String CLOSE_TAB_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/tabclose.gif";
    private static Icon closeIcon;
    private JTabbedPane tabbedPane = null;
    private Rectangle closeIconArea;

    public CloseTabIcon() throws Exception {
        this(new NullIcon());
    }

    public CloseTabIcon(Icon otherIcon) throws Exception {
        super(CloseTabIcon.getIcon(), otherIcon);
    }

    public CloseTabIcon(Icon otherIcon, int spacerWidth) throws Exception {
        super(CloseTabIcon.getIcon(), otherIcon, spacerWidth);
    }

    public CloseTabIcon(Icon otherIcon, int spacerWidth, int orient) throws Exception {
        super(CloseTabIcon.getIcon(), otherIcon, spacerWidth, orient);
    }

    public Rectangle getCloseIconArea() {
        return this.closeIconArea;
    }

    public static Icon getIcon() throws Exception {
        if (closeIcon == null) {
            URL u = Thread.currentThread().getContextClassLoader().getResource(CLOSE_TAB_ICON_RESOURCE);
            if (u == null) {
                throw new Exception("Could not find icon resource ca/ucalgary/seahawk/resources/images/tabclose.gif");
            }
            closeIcon = new ImageIcon(u);
        }
        return closeIcon;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        if (c != this.tabbedPane) {
            if (!(c instanceof JTabbedPane)) {
                System.err.println("CloseTabIcon being drawn on a component that is not a JTabbedPane (" + c.getClass() + "), no close functionality is provided");
                return;
            }
            this.tabbedPane = (JTabbedPane)c;
            this.tabbedPane.addMouseListener(new Closer(this, this.tabbedPane));
        }
        this.closeIconArea = new Rectangle(x, y, this.getFirstIcon().getIconWidth(), this.getFirstIcon().getIconHeight());
    }

    class Closer
    extends MouseAdapter {
        private CloseTabIcon icon;
        private JTabbedPane tabbedPane;
        private boolean active;

        public Closer(CloseTabIcon cti, JTabbedPane tp) {
            this.icon = cti;
            this.tabbedPane = tp;
            this.active = false;
        }

        public void mousePressed(MouseEvent e) {
            this.active = !e.isConsumed() && CloseTabIcon.this.getCloseIconArea() != null && CloseTabIcon.this.getCloseIconArea().contains(e.getX(), e.getY()) && this.tabbedPane.getIconAt(this.tabbedPane.getSelectedIndex()) == this.icon;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.active && !e.isConsumed() && CloseTabIcon.this.getCloseIconArea() != null && CloseTabIcon.this.getCloseIconArea().contains(e.getX(), e.getY())) {
                int tabIndex = this.tabbedPane.getSelectedIndex();
                if (tabIndex < 0) {
                    return;
                }
                if (this.tabbedPane.getIconAt(tabIndex) != this.icon) {
                    return;
                }
                this.tabbedPane.remove(tabIndex);
                e.consume();
                this.tabbedPane.removeMouseListener(this);
            }
        }
    }
}

