/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleEventManager
implements GraphEventManager {
    protected Graph graph;
    protected List listeners;

    SimpleEventManager(Graph graph) {
        this.graph = graph;
        this.listeners = new ArrayList();
    }

    public GraphEventManager register(GraphListener graphListener) {
        this.listeners.add(graphListener);
        return this;
    }

    public GraphEventManager unregister(GraphListener graphListener) {
        this.listeners.remove(graphListener);
        return this;
    }

    public boolean listening() {
        return this.listeners.size() > 0;
    }

    public void notifyAddTriple(Triple triple) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddTriple(triple);
        }
    }

    public void notifyAddArray(Triple[] tripleArray) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddArray(tripleArray);
        }
    }

    public void notifyAddList(List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddList(list);
        }
    }

    public void notifyAddIterator(List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddIterator(list.iterator());
        }
    }

    public void notifyAddIterator(Iterator iterator) {
        this.notifyAddIterator(GraphUtil.iteratorToList((Iterator)iterator));
    }

    public void notifyAddGraph(Graph graph) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddGraph(graph);
        }
    }

    public void notifyDeleteTriple(Triple triple) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteTriple(triple);
        }
    }

    public void notifyDeleteArray(Triple[] tripleArray) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteArray(tripleArray);
        }
    }

    public void notifyDeleteList(List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteList(list);
        }
    }

    public void notifyDeleteIterator(List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteIterator(list.iterator());
        }
    }

    public void notifyDeleteIterator(Iterator iterator) {
        this.notifyDeleteIterator(GraphUtil.iteratorToList((Iterator)iterator));
    }

    public void notifyDeleteGraph(Graph graph) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteGraph(graph);
        }
    }
}

