/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.daml.DAMLOntology;
import com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.LiteralAccessorImpl;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;

public class DAMLOntologyImpl
extends DAMLCommonImpl
implements DAMLOntology {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLOntologyImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLOntology");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return DAMLOntologyImpl.hasType(node, enhGraph, DAML_OIL.Ontology);
        }
    };
    private LiteralAccessor m_propVersionInfo = null;

    public DAMLOntologyImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public LiteralAccessor prop_versionInfo() {
        if (this.m_propVersionInfo == null) {
            this.m_propVersionInfo = new LiteralAccessorImpl(this.getVocabulary().versionInfo(), (OntResource)this);
        }
        return this.m_propVersionInfo;
    }

    public NodeIterator getImportedOntologies() {
        return this.listPropertyValues(DAML_OIL.imports);
    }

    public void addImportedOntology(String string) {
        this.addProperty(this.getVocabulary().imports(), this.getModel().createLiteral(string));
        if (this.getDAMLModel().getLoader().getLoadImportedOntologies()) {
            this.getModel().read(string);
        }
    }
}

