/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.meta;

import java.net.URL;
import org.biomoby.client.CentralImpl;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyResourceRef;

public class Registry {
    String synonym;
    String endpoint;
    String namespace;
    String longName;
    String contact;
    String description;
    boolean isPublic = true;

    public Registry(String synonym, String endpoint, String namespace) {
        this.setSynonym(synonym);
        this.setEndpoint(endpoint);
        this.setNamespace(namespace);
    }

    public Registry(String synonym, String endpoint, String namespace, String longName, String contact, boolean isPublic, String description) {
        this(synonym, endpoint, namespace);
        this.setLongName(longName);
        this.setContact(contact);
        this.setPublic(isPublic);
        this.setDescription(description);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(200);
        String title = "Information about '" + this.getSynonym() + "' registry:";
        buf.append(title);
        buf.append("\n");
        for (int i = 0; i < title.length(); ++i) {
            buf.append("-");
        }
        buf.append("\n");
        buf.append("Full name: " + this.getLongName() + "\n");
        buf.append("Endpoint:  " + this.getEndpoint() + "\n");
        buf.append("Namespace: " + this.getNamespace() + "\n");
        buf.append("Contact:   " + this.getContact() + "\n");
        buf.append("Public:    " + new Boolean(this.isPublic()).toString() + "\n\n");
        buf.append("Description:\n" + this.getDescription() + "\n");
        return buf.toString();
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String value) {
        this.synonym = value;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String value) {
        this.endpoint = value;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String value) {
        this.namespace = value;
    }

    public String getLongName() {
        return this.longName == null ? "" : this.longName;
    }

    public void setLongName(String value) {
        this.longName = value;
    }

    public String getContact() {
        return this.contact == null ? "" : this.contact;
    }

    public void setContact(String value) {
        this.contact = value;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean value) {
        this.isPublic = value;
    }

    public static URL findResourceURL(Registry reg, String resourceName) throws MobyException {
        MobyResourceRef[] resources;
        CentralImpl central = new CentralImpl(reg.getEndpoint());
        for (MobyResourceRef resource : resources = central.getResourceRefs()) {
            if (!resourceName.equals(resource.getResourceName())) continue;
            return resource.getResourceLocation();
        }
        System.err.println("Error! Could not find the data type resource from the registry " + reg.getSynonym());
        return null;
    }
}

