/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.meta;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import org.biomoby.client.CentralImpl;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyException;

public class RegistryCache {
    public static final String REG_CACHE_FILE_PREFIX = "mobyCtrRDF";
    public static final String CALL_CACHE_FILE_PREFIX = "mobyCtrCall";
    private static Registry defaultRegistry = null;
    private static File tempDir = new File(System.getProperty("java.io.tmpdir"));

    public static File getOntologyFile(Registry reg, String resourceName) {
        Object fileLocation = null;
        if ("Object".equals(resourceName)) {
            return RegistryCache.calcDataTypeOntologyFile(reg);
        }
        if ("Service".equals(resourceName)) {
            return RegistryCache.calcServiceTypeOntologyFile(reg);
        }
        if ("Namespace".equals(resourceName)) {
            return RegistryCache.calcNamespaceOntologyFile(reg);
        }
        if ("ServiceInstance".equals(resourceName)) {
            return RegistryCache.calcServiceOntologyFile(reg);
        }
        return null;
    }

    public static File cacheRegistryOntology(Registry reg, String resourceName) throws Exception {
        return RegistryCache.cacheRegistryOntology(reg, resourceName, -1L);
    }

    public static File cacheRegistryOntology(Registry reg, String resourceName, long allowedAgeMillis) throws Exception {
        if (resourceName == null) {
            throw new NullPointerException("The resource to be cached was null");
        }
        if (reg == null) {
            reg = RegistryCache.getDefaultRegistry();
        }
        if (reg == null) {
            throw new MobyException("No registry, even the default one, could be found.  Ontology caching aborted");
        }
        File cacheFile = null;
        if ("Object".equals(resourceName)) {
            cacheFile = RegistryCache.calcDataTypeOntologyFile(reg);
        } else if ("Service".equals(resourceName)) {
            cacheFile = RegistryCache.calcServiceTypeOntologyFile(reg);
        } else if ("Namespace".equals(resourceName)) {
            cacheFile = RegistryCache.calcNamespaceOntologyFile(reg);
        } else if ("ServiceInstance".equals(resourceName)) {
            cacheFile = RegistryCache.calcServiceOntologyFile(reg);
        } else {
            throw new MobyException("The resource asked to be cached (" + resourceName + ") was not recognized.");
        }
        URL sourceURL = Registry.findResourceURL(reg, resourceName);
        long currentTime = System.currentTimeMillis();
        if (!cacheFile.exists() || allowedAgeMillis <= 0L || currentTime - cacheFile.lastModified() > allowedAgeMillis) {
            FileWriter cacheFileWriter = new FileWriter(cacheFile);
            LineNumberReader r = new LineNumberReader(new InputStreamReader(sourceURL.openStream()));
            String line = r.readLine();
            while (line != null) {
                cacheFileWriter.write(line + "\n");
                line = r.readLine();
            }
            cacheFileWriter.close();
        }
        return cacheFile;
    }

    public static synchronized Registry getDefaultRegistry() {
        if (defaultRegistry == null) {
            try {
                defaultRegistry = new Registry("default", CentralImpl.getDefaultURL(), CentralImpl.getDefaultURI());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultRegistry;
    }

    public static File calcDataTypeOntologyFile(Registry reg) {
        String regName = reg == null ? "default" : reg.getSynonym();
        String userName = System.getProperty("user.name") == null ? "" : "." + System.getProperty("user.name");
        return new File(tempDir, REG_CACHE_FILE_PREFIX + userName + "." + regName + ".DataTypes.rdf");
    }

    public static File getServiceTypeOntologyFile(Registry reg) {
        File fileLocation = RegistryCache.calcServiceTypeOntologyFile(reg);
        if (fileLocation.exists()) {
            return fileLocation;
        }
        return null;
    }

    public static File calcServiceTypeOntologyFile(Registry reg) {
        String regName = reg == null ? "default" : reg.getSynonym();
        String userName = System.getProperty("user.name") == null ? "" : "." + System.getProperty("user.name");
        return new File(tempDir, REG_CACHE_FILE_PREFIX + userName + "." + regName + ".ServiceTypes.rdf");
    }

    public static File getNamespaceOntologyFile(Registry reg) {
        File fileLocation = RegistryCache.calcNamespaceOntologyFile(reg);
        if (fileLocation.exists()) {
            return fileLocation;
        }
        return null;
    }

    public static File calcNamespaceOntologyFile(Registry reg) {
        String regName = reg == null ? "default" : reg.getSynonym();
        String userName = System.getProperty("user.name") == null ? "" : "." + System.getProperty("user.name");
        return new File(tempDir, REG_CACHE_FILE_PREFIX + userName + "." + regName + ".Namespaces.rdf");
    }

    public static File getServiceOntologyFile(Registry reg) {
        File fileLocation = RegistryCache.calcServiceOntologyFile(reg);
        if (fileLocation.exists()) {
            return fileLocation;
        }
        return null;
    }

    public static File calcServiceOntologyFile(Registry reg) {
        String regName = reg == null ? "default" : reg.getSynonym();
        String userName = System.getProperty("user.name") == null ? "" : "." + System.getProperty("user.name");
        return new File(tempDir, REG_CACHE_FILE_PREFIX + userName + "." + regName + ".Services.rdf");
    }

    public static File getCentralCallFile(String centralEndpoint, String callKey) {
        File fileLocation = RegistryCache.calcCentralCallFile(centralEndpoint, callKey);
        if (fileLocation.exists()) {
            return fileLocation;
        }
        return null;
    }

    public static File calcCentralCallFile(String centralEndpoint, String callKey) {
        String userName = System.getProperty("user.name") == null ? "" : "." + System.getProperty("user.name");
        return new File(tempDir, CALL_CACHE_FILE_PREFIX + userName + "." + centralEndpoint.hashCode() + "." + callKey.hashCode());
    }

    public static void setTempDir(File dir) {
        tempDir = dir;
    }

    public static void deleteExpiredCacheFiles(long allowedAgeMillis) {
        String userName = System.getProperty("user.name") == null ? "" : "." + System.getProperty("user.name");
        String relativeRegFilePrefix = REG_CACHE_FILE_PREFIX + userName;
        String relativeCallFilePrefix = CALL_CACHE_FILE_PREFIX + userName;
        long currentTime = System.currentTimeMillis();
        for (File tempFile : tempDir.listFiles()) {
            if (!tempFile.getName().startsWith(relativeRegFilePrefix) && !tempFile.getName().startsWith(relativeCallFilePrefix)) continue;
            if (allowedAgeMillis == 0L) {
                tempFile.deleteOnExit();
                continue;
            }
            if (allowedAgeMillis >= 0L && currentTime - tempFile.lastModified() <= allowedAgeMillis) continue;
            tempFile.delete();
        }
    }

    public static void deleteAllCacheFiles() {
        RegistryCache.deleteExpiredCacheFiles(-1L);
    }
}

