/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;
import org.biomoby.shared.LSIDAccessible;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.Utils;
import org.biomoby.shared.extended.DataTypeParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyDataType
implements Comparable<MobyDataType>,
LSIDAccessible {
    public static final String DUMMY_NAME = "_dummy_";
    protected String name;
    protected String authority = "";
    protected String emailContact = "";
    protected String description = "";
    protected String[] parentNames = new String[0];
    protected MobyRelationship[] children = new MobyRelationship[0];
    protected String id = null;
    protected String comment = null;
    protected String lsid = null;
    protected Registry registry = null;
    private static Map<String, MobyDataType[]> datatypesMapBySynonym = new HashMap<String, MobyDataType[]>();
    private static Map<URL, MobyDataType[]> datatypesMapByURL = new HashMap<URL, MobyDataType[]>();

    @Override
    public int compareTo(MobyDataType obj) {
        return this.name.compareToIgnoreCase(obj.getName());
    }

    public boolean equals(Object obj) {
        return this.name.equals(((MobyDataType)obj).getName());
    }

    public MobyDataType() {
        this(DUMMY_NAME);
    }

    public MobyDataType(String name) {
        this.setName(name);
    }

    public void setRegistry(Registry r) {
        this.registry = r;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDataTypes(URL dataDefURL, Registry reg) throws Exception {
        Map<String, MobyDataType[]> map = datatypesMapBySynonym;
        synchronized (map) {
            MobyDataType[] datatypes;
            if (reg == null) {
                reg = RegistryCache.getDefaultRegistry();
            }
            DataTypeParser p = new DataTypeParser(dataDefURL);
            for (MobyDataType dataType : datatypes = p.getMobyDataTypesFromRDF()) {
                dataType.setRegistry(reg);
            }
            datatypesMapBySynonym.put(reg.getSynonym(), datatypes);
            datatypesMapByURL.put(dataDefURL, datatypes);
        }
    }

    public static MobyDataType getDataType(String className) {
        return MobyDataType.getDataType(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobyDataType getDataType(String className, Registry reg) {
        if (className == null) {
            return null;
        }
        if (reg == null) {
            reg = RegistryCache.getDefaultRegistry();
        }
        if (reg == null) {
            return null;
        }
        MobyDataType[] datatypes = null;
        Map<Object, MobyDataType[]> map = datatypesMapBySynonym;
        synchronized (map) {
            datatypes = datatypesMapBySynonym.get(reg.getSynonym());
        }
        map = datatypesMapByURL;
        synchronized (map) {
            if (datatypes == null) {
                try {
                    URL dataDefURL = Registry.findResourceURL(reg, "Object");
                    datatypes = datatypesMapByURL.get(dataDefURL);
                    if (datatypes == null) {
                        System.err.println("Fetching data type ontology from " + dataDefURL);
                        MobyDataType.loadDataTypes(dataDefURL, reg);
                        System.err.println(" ... done");
                        datatypes = datatypesMapByURL.get(dataDefURL);
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot parse MOBY Data Type Ontology: " + e);
                    e.printStackTrace();
                    return null;
                }
            }
        }
        for (int i = 0; i < datatypes.length; ++i) {
            String dt_name = datatypes[i].getName();
            String dt_lsid = datatypes[i].getLSID();
            if ((dt_name == null || !dt_name.equals(className)) && (dt_lsid == null || !dt_lsid.equals(className))) continue;
            return datatypes[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String value) {
        this.authority = value == null ? "" : value;
    }

    public String getEmailContact() {
        return this.emailContact;
    }

    public void setEmailContact(String value) {
        this.emailContact = value == null ? "" : value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value == null ? "" : value;
    }

    @Override
    public String getLSID() {
        return this.lsid;
    }

    public void setLSID(String value) {
        this.lsid = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParentNames() {
        String[] stringArray = this.parentNames;
        synchronized (this.parentNames) {
            String[] names = new String[this.parentNames.length];
            System.arraycopy(this.parentNames, 0, names, 0, this.parentNames.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return names;
        }
    }

    public String getParentName() {
        String[] names = this.getParentNames();
        return names.length == 0 ? "" : names[0];
    }

    public MobyDataType getParent() {
        String parentName = this.getParentName();
        return parentName == null || parentName.length() == 0 ? null : MobyDataType.getDataType(parentName, this.getRegistry());
    }

    public MobyDataType[] getLineage() {
        Vector<MobyDataType> lineage = new Vector<MobyDataType>();
        for (MobyDataType parent = this; parent != null; parent = parent.getParent()) {
            lineage.insertElementAt(parent, 0);
        }
        return lineage.toArray(new MobyDataType[lineage.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentNames(String[] value) {
        String[] stringArray = this.parentNames;
        synchronized (this.parentNames) {
            if (value == null) {
                this.parentNames = new String[0];
            } else {
                this.parentNames = new String[value.length];
                System.arraycopy(value, 0, this.parentNames, 0, value.length);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addParentName(String value) {
        if (value == null) return;
        String[] stringArray = this.parentNames;
        synchronized (this.parentNames) {
            int len = this.parentNames.length + 1;
            String[] newNames = new String[len];
            System.arraycopy(this.parentNames, 0, newNames, 0, len - 1);
            newNames[len - 1] = value;
            this.setParentNames(newNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public MobyRelationship[] getChildren() {
        return this.children;
    }

    public MobyRelationship[] getAllChildren() {
        Vector<MobyRelationship> allChildren = new Vector<MobyRelationship>();
        MobyDataType[] lineage = this.getLineage();
        for (int i = 0; lineage != null && i < lineage.length; ++i) {
            MobyRelationship[] members = lineage[i].getChildren();
            for (int j = 0; members != null && j < members.length; ++j) {
                allChildren.add(members[j]);
            }
        }
        return allChildren.toArray(new MobyRelationship[allChildren.size()]);
    }

    public MobyRelationship getChild(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        MobyDataType[] lineage = this.getLineage();
        for (int i = 0; lineage != null && i < lineage.length; ++i) {
            MobyRelationship[] members = lineage[i].getChildren();
            for (int j = 0; members != null && j < members.length; ++j) {
                if (members[j] == null || !fieldName.equals(members[j].getName())) continue;
                return members[j];
            }
        }
        return null;
    }

    public boolean inheritsFrom(String otherTypeName) {
        return this.inheritsFrom(MobyDataType.getDataType(otherTypeName));
    }

    public boolean inheritsFrom(MobyDataType otherType) {
        if (otherType == null) {
            return false;
        }
        MobyDataType[] parents = this.getLineage();
        for (int i = 0; parents != null && i < parents.length; ++i) {
            if (parents[i] == null || parents[i] != otherType && !parents[i].getName().equals(otherType.getName())) continue;
            return true;
        }
        return false;
    }

    public void setChildren(MobyRelationship[] value) {
        this.children = value == null ? new MobyRelationship[]{} : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(MobyRelationship child) {
        if (child == null) return;
        MobyRelationship[] mobyRelationshipArray = this.children;
        synchronized (this.children) {
            int len = this.children.length + 1;
            MobyRelationship[] newChildren = new MobyRelationship[len];
            System.arraycopy(this.children, 0, newChildren, 0, len - 1);
            newChildren[len - 1] = child;
            this.setChildren(newChildren);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addChild(String name, String typeName, int relationshipType) {
        if (typeName != null) {
            if (name == null) {
                name = "";
            }
            if (relationshipType != 2 && relationshipType != 3) {
                relationshipType = 2;
            }
            this.addChild(new MobyRelationship(name, typeName, relationshipType));
        }
    }

    public String toString() {
        int chLen;
        StringBuffer buf = new StringBuffer();
        buf.append("Name:    " + this.name + "\n");
        buf.append("Auth:    " + this.authority + "\n");
        buf.append("Desc:    " + this.description + "\n");
        buf.append("Contact: " + this.emailContact + "\n");
        buf.append("LSID:    " + this.lsid + "\n");
        buf.append("ID:      " + this.id + "\n");
        if (this.parentNames.length > 0) {
            buf.append("Parents: ");
            for (int i = 0; i < this.parentNames.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.parentNames[i]);
            }
            buf.append("\n");
        }
        if ((chLen = this.children.length) > 0) {
            buf.append("Children (only those registered here): ");
            if (chLen > 1) {
                buf.append("\n");
            }
            for (int i = 0; i < chLen; ++i) {
                if (i > 0) {
                    buf.append("\n\t");
                }
                buf.append(this.children[i].toString());
            }
            buf.append("\n");
        }
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value == null ? "" : value;
    }

    public static Comparator getAuthorityComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

