/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.biomoby.client.CentralImpl;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;
import org.biomoby.shared.LSIDAccessible;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyResourceRef;
import org.biomoby.shared.Utils;
import org.biomoby.shared.extended.NamespaceParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyNamespace
implements Comparable<MobyNamespace>,
LSIDAccessible {
    protected String name;
    protected String authority = "";
    protected String emailContact = "";
    protected String description = "";
    protected String lsid = null;
    protected String id = null;
    protected Registry registry;
    private static Map<String, MobyNamespace[]> namespacesMapBySynonym = new HashMap<String, MobyNamespace[]>();
    private static Map<URL, MobyNamespace[]> namespacesMapByURL = new HashMap<URL, MobyNamespace[]>();

    public MobyNamespace(String name) {
        this.name = name;
    }

    protected static String convertRegistryToNamespaceResourceURL(Registry reg) throws MobyException {
        MobyResourceRef[] resources;
        CentralImpl central = new CentralImpl(reg.getEndpoint());
        for (MobyResourceRef resource : resources = central.getResourceRefs()) {
            if (!"Namespace".equals(resource.getResourceName())) continue;
            return resource.getResourceLocation().toString();
        }
        System.err.println("Error! Could not find the namespace resource from the registry " + reg.getSynonym());
        return null;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry reg) {
        reg = this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNamespaces(URL namespaceDefURL, Registry reg) throws Exception {
        Map<String, MobyNamespace[]> map = namespacesMapBySynonym;
        synchronized (map) {
            MobyNamespace[] namespaces;
            if (reg == null) {
                reg = RegistryCache.getDefaultRegistry();
            }
            NamespaceParser p = new NamespaceParser(namespaceDefURL);
            for (MobyNamespace namespace : namespaces = p.getMobyNamespacesFromRDF()) {
                namespace.setRegistry(reg);
            }
            namespacesMapBySynonym.put(reg.getSynonym(), namespaces);
            namespacesMapByURL.put(namespaceDefURL, namespaces);
        }
    }

    public static MobyNamespace getNamespace(String ns) {
        return MobyNamespace.getNamespace(ns, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobyNamespace getNamespace(String ns, Registry reg) {
        if (ns == null) {
            return null;
        }
        if (reg == null) {
            reg = RegistryCache.getDefaultRegistry();
        }
        if (reg == null) {
            return null;
        }
        MobyNamespace[] namespaces = null;
        Map<Object, MobyNamespace[]> map = namespacesMapBySynonym;
        synchronized (map) {
            namespaces = namespacesMapBySynonym.get(reg.getSynonym());
        }
        map = namespacesMapByURL;
        synchronized (map) {
            if (namespaces == null) {
                try {
                    URL namespaceDefURL = Registry.findResourceURL(reg, "Namespace");
                    namespaces = namespacesMapByURL.get(namespaceDefURL);
                    if (namespaces == null) {
                        System.err.println("Fetching namespace ontology from " + namespaceDefURL);
                        MobyNamespace.loadNamespaces(namespaceDefURL, reg);
                        namespaces = namespacesMapByURL.get(namespaceDefURL);
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot parse MOBY Namespace Ontology: " + e);
                    e.printStackTrace();
                    return null;
                }
            }
        }
        for (int i = 0; i < namespaces.length; ++i) {
            String ns_name = namespaces[i].getName();
            String ns_lsid = namespaces[i].getLSID();
            if ((ns_name == null || !ns_name.equals(ns)) && (ns_lsid == null || !ns_lsid.equals(ns))) continue;
            return namespaces[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String value) {
        this.authority = value == null ? "" : value;
    }

    public String getEmailContact() {
        return this.emailContact;
    }

    public void setEmailContact(String value) {
        this.emailContact = value == null ? "" : value;
    }

    @Override
    public String getLSID() {
        return this.lsid;
    }

    public void setLSID(String value) {
        this.lsid = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value == null ? "" : value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name:    " + this.name + "\n");
        buf.append("Auth:    " + this.authority + "\n");
        buf.append("Desc:    " + this.description + "\n");
        buf.append("ID:      " + this.id + "\n");
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }

    @Override
    public int compareTo(MobyNamespace obj) {
        return this.name.compareToIgnoreCase(obj.getName());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MobyNamespace)) {
            return false;
        }
        MobyNamespace other = (MobyNamespace)o;
        return other == this || (this.name == null && other.name == null || this.name.equals(other.name)) && (this.authority == null && other.authority == null || this.authority.equals(other.authority)) && (this.emailContact == null && other.emailContact == null || this.emailContact.equals(other.emailContact)) && (this.description == null && other.description == null || this.description.equals(other.description)) && (this.id == null && other.id == null || this.id.equals(other.id));
    }

    public static Comparator getAuthorityComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

