/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biomoby.client.CentralImpl;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyObjectDecomposition;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.NoSuccessException;
import org.biomoby.shared.PrimitiveTypes;
import org.biomoby.shared.data.MobyDataFloat;
import org.biomoby.shared.data.MobyDataInt;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataString;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MobyObjectDecompositionImpl
implements MobyObjectDecomposition {
    private static final String URL_OBJECT = "http://mobycentral.icapture.ubc.ca:8090/authority/metadata?lsid=";

    public final MobyDataObject[] getFlattenedPrims(String object) {
        ArrayList<MobyDataObject> list = new ArrayList<MobyDataObject>();
        if (this.isPrimitive(object)) {
            return new MobyDataObject[0];
        }
        String lsid = "urn:lsid:biomoby.org:objectclass:" + object;
        String rdf = this.getObjectRDF(lsid);
        if (rdf == null) {
            return null;
        }
        Document doc = this.getDOMDocument(rdf);
        Element root = doc.getDocumentElement();
        NodeList rdfsClassList = root.getElementsByTagName("rdfs:Class");
        for (int x = 0; x < rdfsClassList.getLength(); ++x) {
            int k;
            MobyDataObject[] recurseArray;
            MobyDataObject mdsi;
            String articleName;
            String localName;
            Node articleNode;
            Element child;
            int j;
            NodeList children;
            int i;
            Element _class = (Element)rdfsClassList.item(x);
            NodeList has = _class.getElementsByTagName("moby:has");
            NodeList hasa = _class.getElementsByTagName("moby:hasa");
            NodeList subClassOf = _class.getElementsByTagName("rdfs:subClassOf");
            for (i = 0; i < has.getLength(); ++i) {
                children = ((Element)has.item(i)).getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    if (!(children.item(j) instanceof Element)) continue;
                    child = (Element)children.item(j);
                    articleNode = child.getElementsByTagName("moby:articleName").item(0);
                    localName = child.getLocalName();
                    String string = articleName = articleNode == null ? "" : MobyObjectDecompositionImpl.getTextContent(articleNode);
                    if (this.isPrimitive(localName)) {
                        mdsi = this.createPrimitiveType(localName, articleName);
                        list.add(mdsi);
                        continue;
                    }
                    recurseArray = this.getFlattenedPrims(localName);
                    for (k = 0; k < recurseArray.length; ++k) {
                        list.add(recurseArray[k]);
                    }
                }
            }
            for (i = 0; i < hasa.getLength(); ++i) {
                children = ((Element)hasa.item(i)).getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    if (!(children.item(j) instanceof Element)) continue;
                    child = (Element)children.item(j);
                    articleNode = child.getElementsByTagName("moby:articleName").item(0);
                    localName = child.getLocalName();
                    String string = articleName = articleNode == null ? "" : MobyObjectDecompositionImpl.getTextContent(articleNode);
                    if (this.isPrimitive(localName)) {
                        mdsi = this.createPrimitiveType(localName, articleName);
                        list.add(mdsi);
                        continue;
                    }
                    recurseArray = this.getFlattenedPrims(localName);
                    for (k = 0; k < recurseArray.length; ++k) {
                        list.add(recurseArray[k]);
                    }
                }
            }
            for (i = 0; i < subClassOf.getLength(); ++i) {
                MobyDataObject mdsi2;
                String _object;
                Element subClass = (Element)subClassOf.item(i);
                if (subClass.hasAttributes()) {
                    _object = subClass.getAttribute("rdf:resource");
                    if (_object.indexOf("#") > 0) {
                        _object = _object.substring(_object.indexOf("#") + 1);
                    }
                    if (!this.isPrimitive(_object) || _object.equals("Object")) continue;
                    mdsi2 = new MobyDataObject(_object);
                    mdsi2.setDataType(new MobyDataType(_object));
                    list.add(mdsi2);
                    continue;
                }
                _object = ((Element)subClass.getElementsByTagName("rdfs:Class").item(0)).getAttribute("rdf:about");
                if (_object.indexOf("#") > 0) {
                    _object = _object.substring(_object.indexOf("#") + 1);
                }
                if (!this.isPrimitive(_object) || _object.equals("Object")) continue;
                mdsi2 = new MobyDataObject(_object);
                mdsi2.setDataType(new MobyDataType(_object));
                list.add(mdsi2);
            }
        }
        return this.convertArrayListToMoby(list);
    }

    public static String getTextContent(Node parent) {
        return MobyObjectDecompositionImpl.getTextContent(parent, true);
    }

    public static String getTextContent(Node parent, boolean includeChildrensText) {
        if (parent.hasChildNodes()) {
            Pattern nonWhitespacePattern = Pattern.compile("[^ \t\r\n]");
            StringBuffer textbuffer = new StringBuffer();
            for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node instanceof Text || node instanceof CDATASection) {
                    String value = node.getNodeValue();
                    if (!nonWhitespacePattern.matcher(value).find()) continue;
                    textbuffer.append(value);
                    continue;
                }
                textbuffer.append(MobyObjectDecompositionImpl.getTextContent(node, includeChildrensText));
            }
            return textbuffer.toString();
        }
        return "";
    }

    public final Map getObjectComposition(String name, String endpoint) throws MobyException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String parent = null;
        MobyRelationship[] relationships = null;
        StringBuffer has = null;
        StringBuffer hasa = null;
        MobyDataType data = null;
        try {
            CentralImpl central = new CentralImpl(endpoint);
            data = central.getDataType(name);
            parent = data.getParentNames().length == 1 ? data.getParentNames()[0] : null;
            relationships = data.getChildren();
        }
        catch (MobyException ex) {
            throw new MobyException("MobyObjectDecompositionImpl: No such object in the Moby Ontology. " + name + "\n" + ex);
        }
        catch (NoSuccessException ex) {
            throw new MobyException("MobyObjectDecompositionImpl: No such object in the Moby Ontology.");
        }
        if (parent == null) {
            map.put("isa", parent);
        } else {
            map.put("isa", new String[]{this.stripURN(parent)});
        }
        for (int x = 0; x < relationships.length; ++x) {
            MobyRelationship mr = relationships[x];
            if (mr.getRelationshipType() == 3) {
                if (has == null) {
                    has = new StringBuffer();
                }
                has.append(this.stripURN(mr.getDataTypeName()) + "," + mr.getName() + " ");
                continue;
            }
            if (mr.getRelationshipType() != 2) continue;
            if (hasa == null) {
                hasa = new StringBuffer();
            }
            hasa.append(this.stripURN(mr.getDataTypeName()) + "," + mr.getName() + " ");
        }
        if (has != null) {
            map.put("has", has.toString().split(" "));
        } else {
            map.put("has", null);
        }
        if (hasa != null) {
            map.put("hasa", hasa.toString().split(" "));
        } else {
            map.put("hasa", null);
        }
        return map;
    }

    public final boolean isPrimitive(String object) {
        for (int x = 0; x < PrimitiveTypes.PRIMS.length; ++x) {
            if (!PrimitiveTypes.PRIMS[x].equals(object)) continue;
            return true;
        }
        return false;
    }

    private final String getObjectRDF(String lsid) {
        URL url;
        try {
            url = new URL(URL_OBJECT + lsid);
        }
        catch (MalformedURLException e) {
            System.err.println("Error in getObjectRDF:1 - MalformedURLException.");
            return null;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (IOException e1) {
            System.err.println("Error in getObjectRDF:2 - IOException. \n- Can't read from URL");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String input;
            while ((input = in.readLine()) != null) {
                sb.append(input + System.getProperty("line.separator"));
            }
        }
        catch (IOException e2) {
            System.err.println("Error in getObjectRDF:3 - IOException.\n-Problems reading from URL");
            return null;
        }
        return sb.toString();
    }

    private final Document getDOMDocument(String rdfXML) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(rdfXML)));
            return doc;
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final MobyDataObject createPrimitiveType(String localName, String articleName) {
        if (localName.equalsIgnoreCase("Float")) {
            return new MobyDataFloat(articleName, 0.0);
        }
        if (localName.equalsIgnoreCase("String")) {
            return new MobyDataString(articleName, (CharSequence)"");
        }
        if (localName.equalsIgnoreCase("Integer")) {
            return new MobyDataInt(articleName, 0);
        }
        if (localName.equalsIgnoreCase("DateTime")) {
            MobyDataObject mdsi = new MobyDataObject(articleName);
            mdsi.setDataType(new MobyDataType(localName));
            return mdsi;
        }
        return null;
    }

    private final MobyDataObject[] convertArrayListToMoby(ArrayList list) {
        int size = list.size();
        MobyDataObject[] mdsi = new MobyDataObject[size];
        size = 0;
        Iterator x = list.iterator();
        while (x.hasNext()) {
            mdsi[size] = (MobyDataObject)x.next();
            ++size;
        }
        return mdsi;
    }

    private final String stripURN(String urn) {
        String lsid = "(^urn\\:lsid\\:biomoby\\.org\\:objectclass:)(\\S*$)";
        Pattern p = Pattern.compile("(^urn\\:lsid\\:biomoby\\.org\\:objectclass:)(\\S*$)");
        Matcher m = p.matcher(urn);
        if (m.matches()) {
            return m.group(2);
        }
        return urn;
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Object cannot be serialized");
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Object cannot be deserialized");
    }

    public static void main(String[] args) throws MobyException {
    }

    private final String arrayToString(Object array) {
        if (array == null) {
            return "[NULL]";
        }
        Object obj = null;
        if (array instanceof Hashtable) {
            array = ((Hashtable)array).entrySet().toArray();
        } else if (array instanceof HashSet) {
            array = ((HashSet)array).toArray();
        } else if (array instanceof Collection) {
            array = ((Collection)array).toArray();
        }
        int length = Array.getLength(array);
        int lastItem = length - 1;
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < length; ++i) {
            obj = Array.get(array, i);
            if (obj != null) {
                sb.append(obj);
            } else {
                sb.append("[NULL]");
            }
            if (i >= lastItem) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

