/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.util.Vector;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobyPrefixResolver
implements PrefixResolver {
    public static final String MOBY_XML_NAMESPACE = "http://www.biomoby.org/moby";
    public static final String MOBY_XML_NAMESPACE_INVALID = "http://www.biomoby.org/moby-s";
    public static final String MOBY_XML_PREFIX = "moby";
    public static final String MOBY_TRANSPORT_NAMESPACE = "http://biomoby.org/";
    public static final String MOBY_TRANSPORT_PREFIX = "mobyt";
    public static final String XSI_NAMESPACE1999 = "http://www.w3.org/1999/XMLSchema-instance";
    public static final String XSI_NAMESPACE2001 = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_PREFIX = "xsi";
    public static final String XSI1999_PREFIX = "xsi1999";
    public static final String XSI2001_PREFIX = "xsi2001";
    public static final String SOAP_ENC_NAMESPACE = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String SOAP_ENC_PREFIX = "soap-enc";
    public static final String WS_ADDRESSING_PREFIX = "wsa";
    public static final String WS_ADDRESSING_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/03/addressing";
    public static final String WSRP_PREFIX = "wsrp";
    public static final String WSRP_NAMESPACE = "http://docs.oasis-open.org/wsrf/rp-2";

    public String getBaseIdentifier() {
        return null;
    }

    public static String getAttr(Element e, String attrName) {
        String value = e.getAttributeNS(MOBY_XML_NAMESPACE, attrName);
        if (value == null || "".equals(value)) {
            value = e.getAttributeNS(MOBY_XML_NAMESPACE_INVALID, attrName);
        }
        if (value == null || "".equals(value)) {
            value = e.getAttributeNS(null, attrName);
        }
        return value;
    }

    public static Element getChildElement(Element e, String elementName) {
        NodeList list = MobyPrefixResolver.getChildElements(e, elementName);
        if (list.getLength() == 0) {
            return null;
        }
        return (Element)list.item(0);
    }

    public static NodeList getChildElements(Element e, String elementName) {
        if (elementName == null || e == null) {
            return null;
        }
        MobyNodeList matches = new MobyNodeList();
        NodeList children = e.getChildNodes();
        for (int j = 0; children != null && j < children.getLength(); ++j) {
            String uri;
            if (!(children.item(j) instanceof Element)) continue;
            Element child = (Element)children.item(j);
            if (!elementName.equals("*") && !elementName.equals(child.getLocalName()) || (uri = child.getNamespaceURI()) != null && uri.length() != 0 && !uri.equals(MOBY_XML_NAMESPACE) && !uri.equals(MOBY_XML_NAMESPACE_INVALID)) continue;
            matches.add(child);
        }
        return matches;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return "";
        }
        if (MOBY_XML_PREFIX.equals(prefix)) {
            return MOBY_XML_NAMESPACE;
        }
        if (MOBY_TRANSPORT_PREFIX.equals(prefix)) {
            return MOBY_TRANSPORT_NAMESPACE;
        }
        if (XSI_PREFIX.equals(prefix)) {
            return XSI_NAMESPACE1999;
        }
        if (XSI1999_PREFIX.equals(prefix)) {
            return XSI_NAMESPACE1999;
        }
        if (XSI2001_PREFIX.equals(prefix)) {
            return XSI_NAMESPACE2001;
        }
        if (SOAP_ENC_PREFIX.equals(prefix)) {
            return SOAP_ENC_NAMESPACE;
        }
        if (WS_ADDRESSING_PREFIX.equals(prefix)) {
            return WS_ADDRESSING_NAMESPACE;
        }
        if (WSRP_PREFIX.equals(prefix)) {
            return WSRP_NAMESPACE;
        }
        return "";
    }

    public String getNamespaceForPrefix(String prefix, Node context) {
        return this.getNamespaceForPrefix(prefix);
    }

    public boolean handlesNullPrefixes() {
        return false;
    }

    public static class MobyNodeList
    implements NodeList {
        private Vector nodes = new Vector();

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int index) {
            return (Node)this.nodes.elementAt(index);
        }

        public void add(Node n) {
            this.nodes.add(n);
        }
    }
}

