/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.util.Enumeration;
import java.util.Vector;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobyPrimaryDataSimple
extends MobyPrimaryData {
    protected Vector<MobyNamespace> namespaces = new Vector();
    protected MobyDataType dataType;

    public MobyPrimaryDataSimple() {
    }

    public MobyPrimaryDataSimple(String name) {
        super(name);
    }

    public MobyPrimaryDataSimple(Element elem) {
        super(elem.getAttribute("articleName"));
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node;
            NamedNodeMap map;
            String childName = children.item(i).getNodeName();
            if (childName.equals("objectType")) {
                if (children.item(i).getFirstChild() == null) continue;
                MobyDataType mdt = new MobyDataType(children.item(i).getFirstChild().getNodeValue());
                map = children.item(i).getAttributes();
                if (map != null && (node = map.getNamedItemNS(children.item(i).getNamespaceURI(), "lsid")) != null) {
                    mdt.setLSID(node.getNodeValue());
                }
                this.setDataType(mdt);
                continue;
            }
            if (!childName.equals("Namespace") || children.item(i).getFirstChild() == null) continue;
            MobyNamespace namespace = new MobyNamespace(children.item(i).getFirstChild().getNodeValue());
            map = children.item(i).getAttributes();
            if (map != null && (node = map.getNamedItemNS(children.item(i).getNamespaceURI(), "lsid")) != null) {
                namespace.setLSID(node.getNodeValue());
            }
            this.addNamespace(namespace);
        }
    }

    public MobyDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(MobyDataType value) {
        this.dataType = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobyNamespace[] getNamespaces() {
        Vector<MobyNamespace> vector = this.namespaces;
        synchronized (vector) {
            Object[] result = new MobyNamespace[this.namespaces.size()];
            this.namespaces.copyInto(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaces(MobyNamespace[] value) {
        Vector<MobyNamespace> vector = this.namespaces;
        synchronized (vector) {
            if (value == null) {
                this.namespaces.clear();
            } else {
                for (int i = 0; i < value.length; ++i) {
                    this.addNamespace(value[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespace(MobyNamespace value) {
        Vector<MobyNamespace> vector = this.namespaces;
        synchronized (vector) {
            if (!this.namespaces.contains(value)) {
                if (this.namespaces.size() == 1 && this.namespaces.elementAt(0).getName().length() == 0) {
                    this.namespaces.remove(0);
                }
                this.namespaces.addElement(value);
            }
        }
    }

    public void removeNamespace(String namespaceName) {
        this.removeNamespace(new MobyNamespace(namespaceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespace(MobyNamespace value) {
        Vector<MobyNamespace> vector = this.namespaces;
        synchronized (vector) {
            int index = this.namespaces.indexOf(value);
            if (index > -1) {
                this.namespaces.remove(index);
            }
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<Simple articleName=\"");
        buf.append(this.name);
        buf.append("\">\n");
        buf.append("<objectType>");
        if (this.dataType != null) {
            buf.append(this.dataType.getName());
        }
        buf.append("</objectType>\n");
        if (this.namespaces.size() > 0) {
            Enumeration<MobyNamespace> en = this.namespaces.elements();
            while (en.hasMoreElements()) {
                MobyNamespace ns = en.nextElement();
                if (ns == null) continue;
                buf.append("<Namespace>");
                buf.append(ns.getName());
                buf.append("</Namespace>");
            }
        }
        buf.append("</Simple>");
        buf.append("\n");
        return new String(buf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null && this.name.length() != 0) {
            buf.append("Name:    " + this.name + "\n");
        }
        if (this.id != null) {
            buf.append("ID:      " + this.id + "\n");
        }
        if (this.dataType != null) {
            buf.append("Data Type:\n" + this.dataType.format(1));
        }
        if (this.namespaces.size() > 0) {
            buf.append("Namespaces:\n");
            Enumeration<MobyNamespace> en = this.namespaces.elements();
            while (en.hasMoreElements()) {
                buf.append(en.nextElement().format(1));
                buf.append("\n");
            }
        }
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }
}

